/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.form;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.simpleinputwindow.base.ISimpleInputWindowCallout;
import jpiere.plugin.simpleinputwindow.base.ISimpleInputWindowCalloutFactory;
import jpiere.plugin.simpleinputwindow.form.JPiereSimpleInputWindow;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowDataBinder;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowGridView;
import jpiere.plugin.simpleinputwindow.form.SimpleInputWindowListModel;
import jpiere.plugin.simpleinputwindow.window.SimpleInputWindowProcessModelDialog;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.GridView;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Searchbox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.WButtonEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.HelpController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MLookup;
import org.compiere.model.PO;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.Window;
import org.zkoss.zul.impl.XulElement;

public class SimpleInputWindowGridRowRenderer
implements RowRenderer<Object[]>,
RowRendererExt,
RendererCtrl,
EventListener<Event> {
    public static final String GRID_ROW_INDEX_ATTR = "grid.row.index";
    private static final String CELL_DIV_STYLE = "height: 100%; cursor: pointer; ";
    private static final String CELL_DIV_STYLE_ALIGN_CENTER = "height: 100%; cursor: pointer; text-align:center; ";
    private static final String CELL_DIV_STYLE_ALIGN_RIGHT = "height: 100%; cursor: pointer; text-align:right; ";
    private static final int MAX_TEXT_LENGTH = 60;
    private GridTab gridTab;
    private int windowNo;
    private SimpleInputWindowDataBinder dataBinder;
    private Map<GridField, WEditor> editors = new LinkedHashMap<GridField, WEditor>();
    private Map<GridField, WEditor> readOnlyEditors = new LinkedHashMap<GridField, WEditor>();
    private RowListener rowListener;
    private Grid grid = null;
    private GridView gridView = null;
    private Row currentRow;
    private Object[] currentValues;
    private PO currentPO;
    private boolean editing = false;
    private int currentRowIndex = -1;
    private int currentColumnIndex = -1;
    private AbstractADWindowContent m_windowPanel;
    private ActionListener buttonListener;
    private SimpleInputWindowGridView simpleInputWindowGridView;
    private WEditor defaultFocusField = null;
    private CustomForm form;
    private JPiereSimpleInputWindow simpleInputWindow;
    private int lastColumnIndex = 0;
    private SimpleInputWindowListModel listModel;
    private HashMap<Integer, PO> dirtyModel;
    private HashMap<Integer, Integer> dirtyLineNo;
    private HashMap<String, WEditor> searchEditorMap = new HashMap();
    private GridField[] gridFields;
    NumberBox numberbox;
    Datebox datebox;
    Searchbox searchbox;
    Combobox combobox;
    Textbox textbox;
    private int minRowIndex = 0;
    private int maxRowIndex = 0;

    public SimpleInputWindowGridRowRenderer(JPiereSimpleInputWindow simpleInputWindow, SimpleInputWindowListModel listModel) {
        this.simpleInputWindow = simpleInputWindow;
        this.lastColumnIndex = simpleInputWindow.getFields().length - 1;
        this.windowNo = simpleInputWindow.getForm().getWindowNo();
        this.form = simpleInputWindow.getForm();
        this.listModel = listModel;
        this.dirtyModel = simpleInputWindow.getDirtyModel();
        this.dirtyLineNo = simpleInputWindow.getDirtyLineNo();
        this.dataBinder = new SimpleInputWindowDataBinder(simpleInputWindow, this, listModel);
        this.searchEditorMap = simpleInputWindow.getSearchEditorMap();
        this.gridFields = simpleInputWindow.getFields();
    }

    public SimpleInputWindowDataBinder getSimpleInputWindowDataBinder() {
        return this.dataBinder;
    }

    private WEditor getEditorCell(GridField gridField) {
        WEditor editor = this.editors.get(gridField);
        if (editor != null) {
            this.prepareFieldEditor(gridField, editor);
            editor.addValueChangeListener((ValueChangeListener)this.dataBinder);
            gridField.removePropertyChangeListener((PropertyChangeListener)editor);
            gridField.addPropertyChangeListener((PropertyChangeListener)editor);
        }
        return editor;
    }

    private void prepareFieldEditor(GridField gridField, WEditor editor) {
        if (editor instanceof WButtonEditor) {
            if (this.buttonListener != null) {
                ((WButtonEditor)editor).addActionListener(this.buttonListener);
            } else {
                Object window = SessionManager.getAppDesktop().findWindow(this.windowNo);
                if (window != null && window instanceof ADWindow) {
                    ADWindowContent windowPanel = ((ADWindow)window).getADWindowContent();
                    ((WButtonEditor)editor).addActionListener((ActionListener)windowPanel);
                }
            }
        }
        if (editor.getComponent() instanceof HtmlBasedComponent) {
            editor.fillHorizontal();
        }
    }

    public int getColumnIndex(GridField field) {
        GridField[] fields = this.gridView.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i] == field) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private Component createReadonlyCheckbox(Object value) {
        Checkbox checkBox = new Checkbox();
        if (value != null && "true".equalsIgnoreCase(value.toString())) {
            checkBox.setChecked(true);
        } else {
            checkBox.setChecked(false);
        }
        checkBox.setDisabled(true);
        return checkBox;
    }

    private String getDisplayText(Object value, GridField gridField, int rowIndex) {
        return this.getDisplayText(value, gridField, rowIndex, false);
    }

    private String getDisplayText(Object value, GridField gridField, int rowIndex, boolean isForceGetValue) {
        if (value == null) {
            return "";
        }
        if (rowIndex >= 0) {
            GridRowCtx gridRowCtx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
            if (!isForceGetValue && !gridField.isDisplayed((Properties)gridRowCtx, true)) {
                return "";
            }
        }
        if (gridField.isEncryptedField()) {
            return "********";
        }
        if (this.readOnlyEditors.get(gridField) != null) {
            WEditor editor = this.readOnlyEditors.get(gridField);
            return editor.getDisplayTextForGridView(value);
        }
        return value.toString();
    }

    private Component getDisplayComponent(int rowIndex, Object value, GridField gridField) {
        Component component;
        if (gridField.getDisplayType() == 20) {
            component = this.createReadonlyCheckbox(value);
        } else if (gridField.getDisplayType() == 28) {
            GridRowCtx gridRowCtx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
            WButtonEditor editor = new WButtonEditor(gridField, rowIndex);
            editor.setValue(this.gridTab.getValue(rowIndex, gridField.getColumnName()));
            editor.setReadWrite(gridField.isEditable((Properties)gridRowCtx, true, true));
            editor.getComponent().setAttribute(GRID_ROW_INDEX_ATTR, (Object)rowIndex);
            editor.addActionListener(this.buttonListener);
            component = editor.getComponent();
        } else {
            String text = this.getDisplayText(value, gridField, rowIndex);
            WEditor editor = this.getEditorCell(gridField);
            if (editor.getDisplayComponent() == null) {
                Label label = new Label();
                this.setLabelText(text, label);
                component = label;
            } else {
                component = editor.getDisplayComponent();
                if (component instanceof Html) {
                    ((Html)component).setContent(text);
                } else {
                    throw new UnsupportedOperationException("neet a componet has setvalue function");
                }
            }
        }
        return component;
    }

    private void setLabelText(String text, Label label) {
        String display = text;
        if (text != null && text.length() > 60) {
            display = String.valueOf(text.substring(0, 57)) + "...";
        }
        label.setValue(display);
        if (text != null && text.length() > 60) {
            label.setTooltiptext(text);
        }
    }

    public List<WEditor> getEditors() {
        ArrayList<WEditor> editorList = new ArrayList<WEditor>();
        if (!this.editors.isEmpty()) {
            editorList.addAll(this.editors.values());
        }
        return editorList;
    }

    public void stopEditing(boolean updateCellLabel) {
        if (!this.editing) {
            return;
        }
        this.editing = false;
        Row row = null;
        for (Map.Entry<GridField, WEditor> entry : this.editors.entrySet()) {
            Component component;
            if (entry.getValue().getComponent().getParent() == null) continue;
            Component child = entry.getValue().getComponent();
            Cell div = null;
            while (div == null && child != null) {
                Component parent = child.getParent();
                if (parent instanceof Cell && parent.getParent() instanceof Row) {
                    div = (Cell)parent;
                    continue;
                }
                child = parent;
            }
            Component component2 = component = div != null ? (Component)div.getAttribute("display.component") : null;
            if (updateCellLabel) {
                if (component instanceof Label) {
                    Label label = (Label)component;
                    label.getChildren().clear();
                    String text = this.getDisplayText(entry.getValue().getValue(), entry.getValue().getGridField(), -1);
                    this.setLabelText(text, label);
                } else if (component instanceof Checkbox) {
                    Checkbox checkBox = (Checkbox)component;
                    Object value = entry.getValue().getValue();
                    if (value != null && "true".equalsIgnoreCase(value.toString())) {
                        checkBox.setChecked(true);
                    } else {
                        checkBox.setChecked(false);
                    }
                } else if (component instanceof Html) {
                    ((Html)component).setContent(this.getDisplayText(entry.getValue().getValue(), entry.getValue().getGridField(), -1));
                }
            }
            if (row == null) {
                row = (Row)div.getParent();
            }
            entry.getValue().getComponent().detach();
            entry.getKey().removePropertyChangeListener((PropertyChangeListener)entry.getValue());
            entry.getValue().removeValuechangeListener((ValueChangeListener)this.dataBinder);
            if (component.getParent() == null || component.getParent() != div) {
                div.appendChild(component);
                continue;
            }
            if (component.isVisible()) continue;
            component.setVisible(true);
        }
        ((SimpleInputWindowListModel)this.grid.getModel()).setEditing(false);
    }

    public void render(Row row, Object[] data, int index) throws Exception {
        Object isActiveValue;
        int columnCount = 0;
        GridField[] gridPanelFields = null;
        if (this.simpleInputWindow != null) {
            gridPanelFields = this.simpleInputWindow.getFields();
            columnCount = gridPanelFields.length;
        }
        if (this.grid == null) {
            this.grid = (Grid)row.getParent().getParent();
        }
        if (this.rowListener == null) {
            this.rowListener = new RowListener((Grid)row.getParent().getParent());
        }
        this.currentValues = data;
        Grid grid = (Grid)row.getParent().getParent();
        Columns columns = grid.getColumns();
        int rowIndex = index;
        Cell cell = new Cell();
        cell.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        Checkbox selection = new Checkbox();
        selection.setAttribute(GRID_ROW_INDEX_ATTR, (Object)rowIndex);
        selection.setChecked(this.listModel.isSelected(rowIndex));
        cell.setStyle("border: none;");
        selection.addEventListener("onCheck", (EventListener)this);
        if (!selection.isChecked() && this.simpleInputWindowGridView.selectAll.isChecked()) {
            this.simpleInputWindowGridView.selectAll.setChecked(false);
        }
        cell.appendChild((Component)selection);
        row.appendChild((Component)cell);
        cell = new Cell();
        if (this.listModel.getPO(index).get_ID() == 0) {
            cell.appendChild((Component)new Label("+*" + new Integer(index + 1).toString()));
        } else if (this.dirtyModel.containsKey(this.listModel.getPO(index).get_ID())) {
            cell.appendChild((Component)new Label("*" + new Integer(index + 1).toString()));
        } else {
            cell.appendChild((Component)new Label(new Integer(index + 1).toString()));
        }
        cell.setStyle(CELL_DIV_STYLE_ALIGN_RIGHT);
        row.appendChild((Component)cell);
        Boolean isActive = null;
        int colIndex = -1;
        int i = 0;
        while (i < columnCount) {
            if (this.editors.get(gridPanelFields[i]) == null) {
                WEditor editor = WebEditorFactory.getEditor((GridField)gridPanelFields[i], (boolean)true);
                this.editors.put(gridPanelFields[i], editor);
                if (editor instanceof WButtonEditor) {
                    ((WButtonEditor)editor).addActionListener(this.buttonListener);
                }
                WEditor readOnlyEditor = WebEditorFactory.getEditor((GridField)gridPanelFields[i], (boolean)true);
                readOnlyEditor.setReadWrite(false);
                this.readOnlyEditors.put(gridPanelFields[i], readOnlyEditor);
                editor.getComponent().setWidgetOverride("fieldHeader", HelpController.escapeJavascriptContent((String)gridPanelFields[i].getHeader()));
                editor.getComponent().setWidgetOverride("fieldDescription", HelpController.escapeJavascriptContent((String)gridPanelFields[i].getDescription()));
                editor.getComponent().setWidgetOverride("fieldHelp", HelpController.escapeJavascriptContent((String)gridPanelFields[i].getHelp()));
                editor.getComponent().setWidgetListener("onFocus", "zWatch.fire('onFieldTooltip', this, null, this.fieldHeader(), this.fieldDescription(), this.fieldHelp());");
                if (this.defaultFocusField == null && gridPanelFields[i].isDefaultFocus()) {
                    this.defaultFocusField = editor;
                }
            }
            if ("IsActive".equals(gridPanelFields[i].getColumnName())) {
                isActive = Boolean.FALSE;
                if (this.currentValues[i] != null && "true".equalsIgnoreCase(this.currentValues[i].toString())) {
                    isActive = Boolean.TRUE;
                }
            }
            Cell div = new Cell();
            String divStyle = CELL_DIV_STYLE;
            Column column = (Column)columns.getChildren().get(++colIndex);
            if (column.isVisible()) {
                Component component = this.getDisplayComponent(rowIndex, this.currentValues[i], gridPanelFields[i]);
                div.appendChild(component);
                div.setAttribute("display.component", (Object)component);
                div.setId(String.valueOf(String.valueOf(row.getIndex())) + "_" + String.valueOf(i));
                if (20 == gridPanelFields[i].getDisplayType() || 32 == gridPanelFields[i].getDisplayType()) {
                    divStyle = CELL_DIV_STYLE_ALIGN_CENTER;
                } else if (DisplayType.isNumeric((int)gridPanelFields[i].getDisplayType())) {
                    divStyle = CELL_DIV_STYLE_ALIGN_RIGHT;
                }
                GridRowCtx ctx = new GridRowCtx(Env.getCtx(), this.gridTab, rowIndex);
                if (!gridPanelFields[i].isDisplayed((Properties)ctx, true)) {
                    div.removeChild(component);
                }
            }
            div.setStyle(divStyle);
            div.setWidth("100%");
            div.setAttribute("columnName", (Object)gridPanelFields[i].getColumnName());
            div.addEventListener("onClick", (EventListener)this.rowListener);
            row.appendChild((Component)div);
            ++i;
        }
        if (rowIndex == this.getCurrentRowIndex()) {
            this.setCurrentRow(row);
        }
        row.setStyle("cursor:pointer");
        row.addEventListener("onClick", (EventListener)this.rowListener);
        row.setTooltiptext("Row " + (rowIndex + 1));
        if (isActive == null && (isActiveValue = this.gridTab.getValue(rowIndex, "IsActive")) != null) {
            isActive = "true".equalsIgnoreCase(isActiveValue.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (isActive != null && !isActive.booleanValue()) {
            LayoutUtils.addSclass((String)"grid-inactive-row", (HtmlBasedComponent)row);
        }
        if (this.listModel.getPO(index).get_ID() == 0) {
            this.currentRow = row;
            this.currentRowIndex = index;
            this.currentPO = this.listModel.getPO(index);
            this.stopEditing(true);
            this.editCurrentRow();
        }
    }

    public void setCurrentRow(Row row) {
        Cell cell;
        if (this.currentRow != null && this.currentRow.getParent() != null && this.currentRow != row && (cell = (Cell)this.currentRow.getChildren().get(1)) != null) {
            cell.setSclass("row-indicator");
        }
        this.currentRowIndex = this.rowListener.getRowIndex();
        this.currentColumnIndex = this.rowListener.getColumnIndex();
        this.currentPO = this.listModel.getPO(this.currentRowIndex);
        List rowList = this.grid.getRows().getChildren();
        if (rowList.size() == 0) {
            this.currentRow = null;
            return;
        }
        this.currentRow = (Row)rowList.get(this.currentRowIndex);
        if (this.editing) {
            this.stopEditing(true);
            this.editCurrentRow();
        }
        String script = "jq('#" + this.currentRow.getUuid() + "').addClass('highlight').siblings().removeClass('highlight')";
        Boolean isActive = null;
        Object isActiveValue = this.gridTab.getValue(this.currentRowIndex, "IsActive");
        if (isActiveValue != null) {
            isActive = "true".equalsIgnoreCase(isActiveValue.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (isActive != null && !isActive.booleanValue()) {
            script = "jq('#" + row.getUuid() + "').addClass('grid-inactive-row').siblings().removeClass('highlight')";
        }
        Clients.response((AuResponse)new AuScript(script));
    }

    public Row getCurrentRow() {
        return this.currentRow;
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public int getCurrentColumnIndex() {
        return this.currentColumnIndex;
    }

    public boolean setFocus(Component Component2) {
        if (Component2 instanceof NumberBox) {
            this.numberbox = (NumberBox)Component2;
            this.numberbox.focus();
            this.numberbox.getDecimalbox().select();
            return true;
        }
        if (Component2 instanceof Datebox) {
            this.datebox = (Datebox)Component2;
            this.datebox.focus();
            this.datebox.select();
            return true;
        }
        if (Component2 instanceof Combobox) {
            this.combobox = (Combobox)Component2;
            this.combobox.focus();
            this.combobox.select();
            return true;
        }
        if (Component2 instanceof Textbox) {
            this.textbox = (Textbox)Component2;
            this.textbox.select();
            if (Component2.getParent() instanceof Cell) {
                ((Cell)Component2.getParent()).focus();
            }
            return true;
        }
        if (Component2 instanceof Searchbox) {
            this.searchbox = (Searchbox)Component2;
            this.searchbox.focus();
            this.searchbox.getTextbox().select();
            return true;
        }
        if (Component2.getParent() instanceof Cell) {
            ((Cell)Component2.getParent()).focus();
        }
        return false;
    }

    public void editCurrentRow() {
        if (this.currentRow != null && this.currentRow.getParent() != null && this.currentRow.isVisible() && this.grid != null && this.grid.isVisible() && this.grid.getParent() != null && this.grid.getParent().isVisible()) {
            GridField[] simpleInputFields = this.simpleInputWindow.getFields();
            int columnCount = simpleInputFields.length;
            Columns columns = this.grid.getColumns();
            int colIndex = 1;
            this.currentValues = (Object[])this.listModel.getElementAt(this.currentRowIndex);
            Object obj = null;
            PO po = this.listModel.getPO(this.currentRowIndex);
            int p = 0;
            while (p < po.get_ColumnCount()) {
                obj = po.get_Value(p);
                if (obj == null) {
                    Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (String)po.get_ColumnName(p), null);
                } else {
                    Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (String)po.get_ColumnName(p), (String)po.get_Value(p).toString());
                }
                ++p;
            }
            Env.setContext((Properties)Env.getCtx(), (int)this.gridTab.getGridWindow().getWindowNo(), (int)this.gridTab.getTabNo(), (String)"IsActive", (boolean)this.currentPO.get_ValueAsBoolean("IsActive"));
            if (this.currentPO.get_ColumnIndex("Processed") != -1) {
                Env.setContext((Properties)Env.getCtx(), (int)this.gridTab.getGridWindow().getWindowNo(), (int)this.gridTab.getTabNo(), (String)"Processed", (boolean)this.currentPO.get_ValueAsBoolean("Processed"));
            }
            if (this.currentPO.get_ColumnIndex("Processing") != -1) {
                Env.setContext((Properties)Env.getCtx(), (int)this.gridTab.getGridWindow().getWindowNo(), (int)this.gridTab.getTabNo(), (String)"Processing", (boolean)this.currentPO.get_ValueAsBoolean("Processing"));
            }
            Cell lineNoCell = (Cell)this.currentRow.getChildren().get(1);
            Label lineNoLabel = (Label)lineNoCell.getChildren().get(0);
            boolean isInserting = lineNoLabel.getValue().contains("+*");
            int i = 0;
            while (i < columnCount) {
                if (!simpleInputFields[i].isToolbarOnlyButton()) {
                    Column column;
                    ++colIndex;
                    if (this.editors.get(simpleInputFields[i]) == null) {
                        this.editors.put(simpleInputFields[i], WebEditorFactory.getEditor((GridField)simpleInputFields[i], (boolean)true));
                    }
                    if ((column = (Column)columns.getChildren().get(colIndex)).isVisible()) {
                        Properties ctx;
                        Cell div = (Cell)this.currentRow.getChildren().get(colIndex);
                        WEditor editor = this.getEditorCell(simpleInputFields[i]);
                        editor.setValue(this.currentValues[i]);
                        editor.getGridField().setValue(this.currentValues[i], isInserting);
                        editor.getComponent().addEventListener("onOK", (EventListener)this);
                        if (editor instanceof WTableDirEditor) {
                            ((WTableDirEditor)editor).getLookup().refresh();
                        } else if (editor instanceof WSearchEditor) {
                            String validated;
                            if (editor.getGridField().getVFormat() != null && editor.getGridField().getVFormat().indexOf(64) != -1) {
                                ((MLookup)editor.getGridField().getLookup()).getLookupInfo().ValidationCode = validated = Env.parseContext((Properties)Env.getCtx(), (int)editor.getGridField().getGridTab().getWindowNo(), (int)editor.getGridField().getGridTab().getTabNo(), (String)editor.getGridField().getVFormat(), (boolean)false);
                            } else if (editor.getGridField().getLookup().getValidation().indexOf(64) != -1) {
                                editor.getGridField().setVFormat(editor.getGridField().getLookup().getValidation());
                                ((MLookup)editor.getGridField().getLookup()).getLookupInfo().ValidationCode = validated = Env.parseContext((Properties)Env.getCtx(), (int)editor.getGridField().getGridTab().getWindowNo(), (int)editor.getGridField().getGridTab().getTabNo(), (String)editor.getGridField().getVFormat(), (boolean)false);
                            }
                        } else if (editor instanceof WButtonEditor) {
                            ((WButtonEditor)editor).setValue((Object)po.get_ID());
                        }
                        if (div.getChildren().isEmpty() || !(div.getChildren().get(0) instanceof Button)) {
                            div.getChildren().clear();
                        } else if (!div.getChildren().isEmpty()) {
                            ((Component)div.getChildren().get(0)).setVisible(false);
                        }
                        div.appendChild(editor.getComponent());
                        WEditorPopupMenu popupMenu = editor.getPopupMenu();
                        if (popupMenu != null) {
                            popupMenu.addMenuListener((ContextMenuListener)editor);
                            div.appendChild((Component)popupMenu);
                            popupMenu.addContextElement((XulElement)editor.getComponent());
                        }
                        if (!simpleInputFields[i].isDisplayed(ctx = simpleInputFields[i].getVO().ctx, true)) {
                            div.removeChild(editor.getComponent());
                        }
                        if (i == this.currentColumnIndex) {
                            this.setFocus((Component)div.getChildren().get(0));
                        }
                        editor.setReadWrite(simpleInputFields[i].isEditableGrid(true));
                    }
                }
                ++i;
            }
            this.editing = true;
            this.listModel.setEditing(true);
        }
    }

    public int getControls() {
        return 1;
    }

    public Component newCell(Row row) {
        return null;
    }

    public Row newRow(Grid grid) {
        return null;
    }

    public void doCatch(Throwable ex) throws Throwable {
    }

    public void doFinally() {
    }

    public void doTry() {
    }

    public void focusToFirstEditor() {
    }

    protected void focusToEditor(WEditor toFocus) {
    }

    public void focusToNextEditor(WEditor ref) {
        boolean found = false;
        for (WEditor editor : this.getEditors()) {
            if (editor == ref) {
                found = true;
                continue;
            }
            if (!found || !editor.isVisible() || !editor.isReadWrite()) continue;
            this.focusToEditor(editor);
            break;
        }
    }

    public void setGridPanel(GridView gridPanel) {
    }

    public void resetCursor() {
        this.currentRow = null;
        this.currentPO = null;
        this.editing = false;
        this.currentRowIndex = -1;
        this.currentColumnIndex = -1;
        this.rowListener.setColumnIndex(-1);
        this.rowListener.setRowIndex(-1);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setADWindowPanel(AbstractADWindowContent windowPanel, IADTabpanel adTabpanel) {
        if (this.m_windowPanel == windowPanel) {
            return;
        }
        this.m_windowPanel = windowPanel;
        this.buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WButtonEditor editor = (WButtonEditor)event.getSource();
                Integer rowIndex = (Integer)editor.getComponent().getAttribute(SimpleInputWindowGridRowRenderer.GRID_ROW_INDEX_ATTR);
                if (rowIndex != null) {
                    int newRowIndex = SimpleInputWindowGridRowRenderer.this.gridTab.navigate(rowIndex.intValue());
                    if (newRowIndex == rowIndex) {
                        SimpleInputWindowGridRowRenderer.this.m_windowPanel.actionPerformed(event);
                    }
                } else {
                    SimpleInputWindowGridRowRenderer.this.m_windowPanel.actionPerformed(event);
                }
            }
        };
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() instanceof Cell) {
            Cell cell = (Cell)event.getTarget();
            if (cell.getSclass() == null || cell.getSclass().indexOf("row-indicator-selected") < 0) {
                Events.sendEvent((Component)event.getTarget().getParent(), (Event)event);
            }
        } else if (event.getTarget() instanceof Checkbox) {
            Executions.getCurrent().setAttribute("gridView.onSelectRow", (Object)Boolean.TRUE);
            Checkbox checkBox = (Checkbox)event.getTarget();
            try {
                this.simpleInputWindowGridView.onEvent(new Event("onSelectRow", null, (Object)checkBox));
            }
            catch (Exception exception) {}
        } else if (event.getName().equals("onOK")) {
            List rowList = this.grid.getRows().getChildren();
            this.minRowIndex = this.grid.getActivePage() * this.grid.getPageSize();
            this.maxRowIndex = this.minRowIndex + this.grid.getPageSize();
            boolean isLastPage = this.maxRowIndex >= rowList.size();
            int n = this.maxRowIndex = this.maxRowIndex > rowList.size() ? rowList.size() : this.maxRowIndex;
            if (event.getTarget().getParent() instanceof Searchbox) {
                Searchbox searchBox = (Searchbox)event.getTarget().getParent();
                if (!searchBox.getText().equals("")) {
                    ++this.currentRowIndex;
                }
            } else {
                ++this.currentRowIndex;
            }
            if (this.maxRowIndex <= this.currentRowIndex) {
                if (isLastPage) {
                    Cell cell = null;
                    cell = event.getTarget().getParent() instanceof Cell ? (Cell)event.getTarget().getParent() : (Cell)event.getTarget().getParent().getParent();
                    String[] yx = cell.getId().split("_");
                    int ColumnIndex = Integer.parseInt(yx[1]);
                    GridField gField = this.simpleInputWindowGridView.getSimpleInputWindowGridTable().getField(ColumnIndex);
                    if (!(gField.isSameLine() && ColumnIndex != this.lastColumnIndex || this.gridTab.isReadOnly() || !this.gridTab.isInsertRecord())) {
                        boolean isOK = this.simpleInputWindow.saveData(false);
                        if (!isOK) {
                            --this.currentRowIndex;
                            event.stopPropagation();
                            return;
                        }
                        PO po = null;
                        List factoryList = Service.locator().list(IModelFactory.class).getServices();
                        for (IModelFactory factory : factoryList) {
                            po = factory.getPO(this.gridTab.getTableName(), 0, null);
                            if (po == null) continue;
                            GridField[] allFields = this.gridTab.getFields();
                            int i = 0;
                            while (i < allFields.length) {
                                Object defaultValue = allFields[i].getDefault();
                                if (defaultValue != null) {
                                    po.set_ValueNoCheck(allFields[i].getColumnName(), defaultValue);
                                }
                                ++i;
                            }
                            for (Map.Entry<String, WEditor> entry : this.searchEditorMap.entrySet()) {
                                if (entry.getValue().getValue() == null || po.get_ColumnIndex(entry.getKey()) == -1) continue;
                                Object value = entry.getValue().getValue();
                                if (entry.getKey().endsWith("_ID") && value instanceof String) {
                                    value = Integer.parseInt((String)value);
                                }
                                po.set_ValueNoCheck(entry.getKey(), value);
                            }
                            if (!this.simpleInputWindowGridView.getEditMode().equals("Search_Multi_Tab") || this.simpleInputWindowGridView.isVirtualColumn()) break;
                            po.set_ValueNoCheck(this.simpleInputWindowGridView.getTabFieldColumnName(), this.simpleInputWindowGridView.getTabFieldValue());
                            break;
                        }
                        this.listModel.setPO(po);
                        this.grid.setModel((ListModel)this.listModel);
                        this.grid.setFocus(true);
                        this.currentRow = (Row)rowList.get(this.currentRowIndex);
                        this.currentPO = this.listModel.getPO(this.currentRowIndex);
                        this.simpleInputWindow.setNewModel(po);
                        this.simpleInputWindow.setNewModelLineNo(this.currentRowIndex);
                        this.startInitializeCallout();
                        event.stopPropagation();
                        return;
                    }
                    --this.currentRowIndex;
                    event.stopPropagation();
                    return;
                }
                this.currentRowIndex = this.minRowIndex;
            }
            this.currentRow = (Row)rowList.get(this.currentRowIndex);
            this.currentPO = this.listModel.getPO(this.currentRowIndex);
            this.stopEditing(true);
            this.editCurrentRow();
            event.stopPropagation();
            String script = "jq('#" + this.currentRow.getUuid() + "').addClass('highlight').siblings().removeClass('highlight')";
            Boolean isActive = null;
            Object isActiveValue = this.gridTab.getValue(this.currentRowIndex, "IsActive");
            if (isActiveValue != null) {
                isActive = "true".equalsIgnoreCase(isActiveValue.toString()) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (isActive != null && !isActive.booleanValue()) {
                script = "jq('#" + this.currentRow.getUuid() + "').addClass('grid-inactive-row').siblings().removeClass('highlight')";
            }
            Clients.response((AuResponse)new AuScript(script));
            return;
        }
    }

    public void setGridView(GridView gridView) {
        this.gridView = gridView;
    }

    public void setGridTab(GridTab gridTab) {
        this.gridTab = gridTab;
    }

    public void setSimpleInputWindowGridView(SimpleInputWindowGridView simpleInputWindowGridView) {
        this.simpleInputWindowGridView = simpleInputWindowGridView;
    }

    public void createRecordProcessDialog() {
        if (this.buttonListener != null) {
            return;
        }
        this.buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                WButtonEditor editor = (WButtonEditor)event.getSource();
                if (!SimpleInputWindowGridRowRenderer.this.simpleInputWindow.saveData(false)) {
                    return;
                }
                String stringRecord_ID = editor.getDisplay();
                SimpleInputWindowProcessModelDialog dialog = new SimpleInputWindowProcessModelDialog(SimpleInputWindowGridRowRenderer.this.form.getWindowNo(), editor.getProcess_ID(), 0, Integer.parseInt(stringRecord_ID), false, SimpleInputWindowGridRowRenderer.this.simpleInputWindow);
                if (dialog.isValid()) {
                    dialog.setBorder("normal");
                    SimpleInputWindowGridRowRenderer.this.form.getParent().appendChild((Component)dialog);
                    LayoutUtils.openOverlappedWindow((Component)SimpleInputWindowGridRowRenderer.this.form.getParent(), (Window)dialog, (String)"middle_center");
                    dialog.focus();
                }
            }
        };
    }

    public void startInitializeCallout() {
        List factories = Service.locator().list(ISimpleInputWindowCalloutFactory.class).getServices();
        if (factories != null) {
            String calloutMessage = null;
            PO po = this.listModel.getPO(this.currentRowIndex);
            int i = 0;
            while (i < po.get_ColumnCount()) {
                for (ISimpleInputWindowCalloutFactory factory : factories) {
                    ISimpleInputWindowCallout callout = factory.getCallout(po.get_TableName(), po.get_ColumnName(i));
                    if (callout == null || (calloutMessage = callout.start(this.getSimpleInputWindowDataBinder(), this.currentRowIndex, po.get_ColumnName(i), po.get_Value(i), po.get_Value(i))) == null || calloutMessage.equals("")) continue;
                    FDialog.error((int)this.gridTab.getWindowNo(), (String)calloutMessage);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ GridTab access$1(SimpleInputWindowGridRowRenderer simpleInputWindowGridRowRenderer) {
        return simpleInputWindowGridRowRenderer.gridTab;
    }

    static /* synthetic */ AbstractADWindowContent access$2(SimpleInputWindowGridRowRenderer simpleInputWindowGridRowRenderer) {
        return simpleInputWindowGridRowRenderer.m_windowPanel;
    }

    static /* synthetic */ JPiereSimpleInputWindow access$3(SimpleInputWindowGridRowRenderer simpleInputWindowGridRowRenderer) {
        return simpleInputWindowGridRowRenderer.simpleInputWindow;
    }

    static /* synthetic */ CustomForm access$4(SimpleInputWindowGridRowRenderer simpleInputWindowGridRowRenderer) {
        return simpleInputWindowGridRowRenderer.form;
    }

    static class RowListener
    implements EventListener<Event> {
        private Grid _grid;
        private int rowIndex = 0;
        private int columnIndex = 0;

        public RowListener(Grid grid) {
            this._grid = grid;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void onEvent(Event event) throws Exception {
            Event evt;
            if (event.getTarget() instanceof Cell) {
                String[] yx = ((Cell)event.getTarget()).getId().split("_");
                this.rowIndex = Integer.valueOf(yx[0]);
                this.columnIndex = Integer.valueOf(yx[1]);
            }
            if ("onClick".equals(event.getName())) {
                if (Executions.getCurrent().getAttribute("gridView.onSelectRow") != null) {
                    return;
                }
                evt = new Event("onClick", (Component)this._grid, (Object)event.getTarget());
                Events.sendEvent((Component)this._grid, (Event)evt);
                evt.stopPropagation();
            } else if ("onDoubleClick".equals(event.getName())) {
                evt = new Event("onDoubleClick", (Component)this._grid, (Object)this._grid);
                Events.sendEvent((Component)this._grid, (Event)evt);
            } else if ("onOK".equals(event.getName())) {
                evt = new Event("onOK", (Component)this._grid, (Object)this._grid);
                Events.sendEvent((Component)this._grid, (Event)evt);
            }
        }
    }
}

