/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.simpleinputwindow.component;

import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Vbox;

public class SimpleInputWindowMessagebox
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8928526331932742124L;
    private static final String MESSAGE_PANEL_STYLE = "text-align:left; word-break: break-all; overflow: auto; max-height: 350pt; min-width: 230pt; max-width: 450pt;";
    private String msg = new String("");
    private String imgSrc = new String("");
    private Text lblMsg = new Text();
    private Button btnOk;
    private Button btnCancel;
    private Button btnYes;
    private Button btnNo;
    private Button btnAbort;
    private Button btnRetry;
    private Button btnIgnore;
    private Textbox txtInput = new Textbox();
    private Image img = new Image();
    private int returnValue;
    private Callback callback;
    private boolean isInput = false;
    private HtmlBasedComponent htmlLog;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 16;
    public static final int NO = 32;
    public static final int ABORT = 256;
    public static final int RETRY = 512;
    public static final int IGNORE = 1024;
    public static final int INPUT = 2048;
    public static final String QUESTION = "~./zul/img/msgbox/question-btn.png";
    public static final String EXCLAMATION = "~./zul/img/msgbox/warning-btn.png";
    public static final String INFORMATION = "~./zul/img/msgbox/info-btn.png";
    public static final String ERROR = "~./zul/img/msgbox/stop-btn.png";
    public static final String NONE = null;

    private void init() {
        this.setSclass("popup-dialog");
        Properties ctx = Env.getCtx();
        this.lblMsg.setEncode(false);
        this.lblMsg.setValue(this.msg);
        this.btnOk = ButtonFactory.createNamedButton((String)"Ok");
        this.btnOk.setId("btnOk");
        this.btnOk.addEventListener("onClick", (EventListener)this);
        this.btnCancel = ButtonFactory.createNamedButton((String)"Cancel");
        this.btnCancel.addEventListener("onClick", (EventListener)this);
        this.btnCancel.setId("btnCancel");
        String yesLabel = Util.cleanAmp((String)Msg.getMsg((Properties)ctx, (String)"Yes"));
        this.btnYes = ButtonFactory.createButton((String)(ButtonFactory.isWithText() ? yesLabel : null), (String)(ButtonFactory.isWithImage() ? (ButtonFactory.isWithText() ? ThemeManager.getThemeResource((String)"images/Ok16.png") : ThemeManager.getThemeResource((String)"images/Ok24.png")) : null), (String)(ButtonFactory.isWithText() ? null : yesLabel));
        this.btnYes.addEventListener("onClick", (EventListener)this);
        this.btnYes.setId("btnYes");
        String noLabel = Util.cleanAmp((String)Msg.getMsg((Properties)ctx, (String)"No"));
        this.btnNo = ButtonFactory.createButton((String)(ButtonFactory.isWithText() ? noLabel : null), (String)(ButtonFactory.isWithImage() ? (ButtonFactory.isWithText() ? ThemeManager.getThemeResource((String)"images/Cancel16.png") : ThemeManager.getThemeResource((String)"images/Cancel24.png")) : null), (String)(ButtonFactory.isWithText() ? null : noLabel));
        this.btnNo.addEventListener("onClick", (EventListener)this);
        this.btnNo.setId("btnNo");
        this.btnAbort = ButtonFactory.createButton((String)"Abort", null, null);
        this.btnAbort.addEventListener("onClick", (EventListener)this);
        this.btnAbort.setId("btnAbort");
        this.btnRetry = ButtonFactory.createButton((String)"Retry", null, null);
        this.btnRetry.addEventListener("onClick", (EventListener)this);
        this.btnRetry.setId("btnRetry");
        this.btnIgnore = ButtonFactory.createNamedButton((String)"Ignore");
        this.btnIgnore.addEventListener("onClick", (EventListener)this);
        this.btnIgnore.setId("btnIgnore");
        Panel pnlMessage = new Panel();
        pnlMessage.setStyle(MESSAGE_PANEL_STYLE);
        pnlMessage.appendChild((Component)this.lblMsg);
        Panel pnlInput = new Panel();
        pnlInput.setStyle(MESSAGE_PANEL_STYLE);
        pnlInput.appendChild((Component)this.txtInput);
        Vbox pnlText = new Vbox();
        pnlText.appendChild((Component)pnlMessage);
        pnlText.appendChild((Component)pnlInput);
        if (this.htmlLog != null) {
            pnlText.appendChild((Component)this.htmlLog);
        }
        Hbox pnlImage = new Hbox();
        this.img.setSrc(this.imgSrc);
        pnlImage.setWidth("72px");
        pnlImage.setAlign("center");
        pnlImage.setPack("center");
        pnlImage.appendChild((Component)this.img);
        Hbox north = new Hbox();
        north.setAlign("center");
        this.appendChild((Component)north);
        north.appendChild((Component)pnlImage);
        north.appendChild((Component)pnlText);
        north.setSclass("dialog-content");
        Hbox pnlButtons = new Hbox();
        pnlButtons.setAlign("center");
        pnlButtons.setPack("end");
        pnlButtons.appendChild((Component)this.btnOk);
        pnlButtons.appendChild((Component)this.btnCancel);
        pnlButtons.appendChild((Component)this.btnYes);
        pnlButtons.appendChild((Component)this.btnNo);
        pnlButtons.appendChild((Component)this.btnAbort);
        pnlButtons.appendChild((Component)this.btnRetry);
        pnlButtons.appendChild((Component)this.btnIgnore);
        pnlButtons.setWidth("100%");
        this.appendChild((Component)pnlButtons);
        pnlButtons.setSclass("dialog-footer");
        this.setBorder("normal");
        this.setContentStyle("background-color:#ffffff;");
        this.setPosition("left, top");
    }

    public int show(String message, String title, int buttons, String icon) {
        return this.show(message, title, buttons, icon, null);
    }

    public int show(String message, String title, int buttons, String icon, Callback<Integer> callback) {
        return this.show(message, title, buttons, icon, callback, false, null);
    }

    public int show(String message, String title, int buttons, String icon, Callback<?> callback, boolean modal, HtmlBasedComponent htmlLog) {
        this.msg = message;
        this.imgSrc = icon;
        this.callback = callback;
        this.htmlLog = htmlLog;
        this.init();
        this.btnOk.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnYes.setVisible(false);
        this.btnNo.setVisible(false);
        this.btnRetry.setVisible(false);
        this.btnAbort.setVisible(false);
        this.btnIgnore.setVisible(false);
        this.txtInput.setVisible(false);
        if ((buttons & 1) != 0) {
            this.btnOk.setVisible(true);
        }
        if ((buttons & 2) != 0) {
            this.btnCancel.setVisible(true);
        }
        if ((buttons & 0x10) != 0) {
            this.btnYes.setVisible(true);
        }
        if ((buttons & 0x20) != 0) {
            this.btnNo.setVisible(true);
        }
        if ((buttons & 0x200) != 0) {
            this.btnRetry.setVisible(true);
        }
        if ((buttons & 0x100) != 0) {
            this.btnAbort.setVisible(true);
        }
        if ((buttons & 0x400) != 0) {
            this.btnIgnore.setVisible(true);
        }
        if ((buttons & 0x800) != 0) {
            this.txtInput.setVisible(true);
            this.isInput = true;
        }
        this.setTitle(title);
        this.setPosition("center");
        this.setClosable(true);
        this.setAttribute("mode", modal ? "modal" : "highlighted");
        this.setSizable(true);
        this.setVisible(true);
        String id = "MessageBox_" + AdempiereIdGenerator.escapeId((String)title);
        Page page = AEnv.getDesktop().getFirstPage();
        Component fellow = page.getFellowIfAny(id);
        if (fellow != null) {
            int count = 0;
            String newId = null;
            while (fellow != null) {
                newId = String.valueOf(id) + "_" + ++count;
                fellow = page.getFellowIfAny(newId);
            }
            id = newId;
        }
        this.setId(id);
        AEnv.showCenterScreen((Window)this);
        return this.returnValue;
    }

    public static int showDialog(String message, String title, int buttons, String icon) {
        return SimpleInputWindowMessagebox.showDialog(message, title, buttons, icon, null);
    }

    public static int showDialog(String message, String title, int buttons, String icon, Callback<Integer> callback) {
        return SimpleInputWindowMessagebox.showDialog(message, title, buttons, icon, callback, false);
    }

    public static int showDialog(String message, String title, int buttons, String icon, Callback<?> callback, boolean modal) {
        SimpleInputWindowMessagebox msg = new SimpleInputWindowMessagebox();
        return msg.show(message, title, buttons, icon, callback, modal, null);
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        if (event.getTarget() == this.btnOk) {
            this.returnValue = 1;
        } else if (event.getTarget() == this.btnCancel) {
            this.returnValue = 2;
        } else if (event.getTarget() == this.btnYes) {
            this.returnValue = 16;
        } else if (event.getTarget() == this.btnNo) {
            this.returnValue = 32;
        } else if (event.getTarget() == this.btnAbort) {
            this.returnValue = 256;
        } else if (event.getTarget() == this.btnRetry) {
            this.returnValue = 512;
        } else if (event.getTarget() == this.btnIgnore) {
            this.returnValue = 1024;
        }
        this.detach();
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.callback != null && !this.isInput) {
            this.callback.onCallback((Object)this.returnValue);
        } else if (this.callback != null && this.isInput) {
            this.callback.onCallback((Object)this.txtInput.getText());
        }
    }
}

