/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Header;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.engine.adapter.Adapter;
import org.restlet.engine.adapter.HttpRequest;
import org.restlet.engine.adapter.HttpResponse;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class ServerAdapter
extends Adapter {
    public ServerAdapter(Context context) {
        super(context);
    }

    protected void addEntityHeaders(HttpResponse response) {
        Series<Header> responseHeaders = response.getHttpCall().getResponseHeaders();
        Representation entity = response.getEntity();
        HeaderUtils.addEntityHeaders(entity, responseHeaders);
    }

    protected void addResponseHeaders(HttpResponse response) {
        try {
            HeaderUtils.addGeneralHeaders(response, response.getHttpCall().getResponseHeaders());
            HeaderUtils.addResponseHeaders(response, response.getHttpCall().getResponseHeaders());
            if (response.getStatus() != null) {
                response.getHttpCall().setStatusCode(response.getStatus().getCode());
                response.getHttpCall().setReasonPhrase(response.getStatus().getReasonPhrase());
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Exception intercepted while adding the response headers", e);
            response.getHttpCall().setStatusCode(Status.SERVER_ERROR_INTERNAL.getCode());
            response.getHttpCall().setReasonPhrase(Status.SERVER_ERROR_INTERNAL.getReasonPhrase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(HttpResponse response) {
        try {
            if (response.getRequest().getMethod() != null && response.getRequest().getMethod().equals(Method.HEAD)) {
                this.addEntityHeaders(response);
                response.setEntity(null);
            } else if (Method.GET.equals(response.getRequest().getMethod()) && Status.SUCCESS_OK.equals(response.getStatus()) && !response.isEntityAvailable()) {
                this.addEntityHeaders(response);
                this.getLogger().warning("A response with a 200 (Ok) status should have an entity. Make sure that resource \"" + response.getRequest().getResourceRef() + "\" returns one or sets the status to 204 (No content).");
            } else if (response.getStatus().equals(Status.SUCCESS_NO_CONTENT)) {
                this.addEntityHeaders(response);
                if (response.isEntityAvailable()) {
                    this.getLogger().fine("Responses with a 204 (No content) status generally don't have an entity. Only adding entity headers for resource \"" + response.getRequest().getResourceRef() + "\".");
                    response.setEntity(null);
                }
            } else if (response.getStatus().equals(Status.SUCCESS_RESET_CONTENT)) {
                if (response.isEntityAvailable()) {
                    this.getLogger().warning("Responses with a 205 (Reset content) status can't have an entity. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + "\".");
                    response.setEntity(null);
                }
            } else if (response.getStatus().equals(Status.REDIRECTION_NOT_MODIFIED)) {
                if (response.getEntity() != null) {
                    HeaderUtils.addNotModifiedEntityHeaders(response.getEntity(), response.getHttpCall().getResponseHeaders());
                    response.setEntity(null);
                }
            } else if (response.getStatus().isInformational()) {
                if (response.isEntityAvailable()) {
                    this.getLogger().warning("Responses with an informational (1xx) status can't have an entity. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + "\".");
                    response.setEntity(null);
                }
            } else {
                this.addEntityHeaders(response);
                if (!response.isEntityAvailable()) {
                    if (response.getEntity() != null && response.getEntity().getSize() != 0L) {
                        this.getLogger().warning("A response with an unavailable and potentially non empty entity was returned. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + "\".");
                    }
                    response.setEntity(null);
                }
            }
            this.addResponseHeaders(response);
            response.getHttpCall().sendResponse(response);
        }
        catch (Throwable t) {
            if (response.getHttpCall().isConnectionBroken(t)) {
                this.getLogger().log(Level.INFO, "The connection was broken. It was probably closed by the client.", t);
            } else {
                this.getLogger().log(Level.SEVERE, "An exception occurred writing the response entity", t);
                response.getHttpCall().setStatusCode(Status.SERVER_ERROR_INTERNAL.getCode());
                response.getHttpCall().setReasonPhrase("An exception occurred writing the response entity");
                response.setEntity(null);
                try {
                    response.getHttpCall().sendResponse(response);
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to send error response", ioe);
                }
            }
        }
        finally {
            response.getHttpCall().complete();
            if (response.getOnSent() != null) {
                response.getOnSent().handle(response.getRequest(), response);
            }
        }
    }

    public HttpRequest toRequest(ServerCall httpCall) {
        HttpRequest result = new HttpRequest(this.getContext(), httpCall);
        result.getAttributes().put("org.restlet.http.headers", httpCall.getRequestHeaders());
        if (httpCall.getVersion() != null) {
            result.getAttributes().put("org.restlet.http.version", httpCall.getVersion());
        }
        if (httpCall.isConfidential()) {
            String sslSessionId;
            Integer keySize;
            String cipherSuite;
            List<Certificate> clientCertificates = httpCall.getCertificates();
            if (clientCertificates != null) {
                result.getClientInfo().setCertificates(clientCertificates);
            }
            if ((cipherSuite = httpCall.getCipherSuite()) != null) {
                result.getClientInfo().setCipherSuite(cipherSuite);
            }
            if ((keySize = httpCall.getSslKeySize()) != null) {
                result.getAttributes().put("org.restlet.https.keySize", keySize);
            }
            if ((sslSessionId = httpCall.getSslSessionId()) != null) {
                result.getAttributes().put("org.restlet.https.sslSessionId", sslSessionId);
            }
        }
        return result;
    }
}

