/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkforge.ckez.CKeditor;
import org.zkforge.ckez.FilebrowserController;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class CkezUploadExtension
implements AuExtension {
    private static final Logger logger = LoggerFactory.getLogger(CkezUploadExtension.class);
    private static final String nextURI = "~./ckez/html/fileupload-done.html.dsp";
    private ServletContext _ctx;

    public void init(DHtmlUpdateServlet servlet) throws ServletException {
        this._ctx = servlet.getServletContext();
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        String url;
        Session sess = Sessions.getCurrent((boolean)false);
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        String type = request.getParameter("Type");
        String dtid = request.getParameter("dtid");
        String uuid = request.getParameter("uuid");
        FileItem item = this.parseFileItem(request);
        if (item == null) {
            return;
        }
        Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            return;
        }
        CKeditor ckez = (CKeditor)desktop.getComponentByUuidIfAny(uuid);
        if (ckez == null) {
            return;
        }
        if ("Files".equals(type)) {
            url = ckez.getFilebrowserUploadUrl();
        } else if ("Images".equals(type)) {
            url = ckez.getFilebrowserImageUploadUrl();
        } else if ("Flash".equals(type)) {
            url = ckez.getFilebrowserFlashUploadUrl();
        } else {
            return;
        }
        url = FilebrowserController.getFolderUrl(url);
        String path = request.getContextPath() + url;
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("CKEditorFuncNum", request.getParameter("CKEditorFuncNum"));
        String serverPath = ckez.writeFileItem(path, desktop.getWebApp().getRealPath(url), item, type);
        String itemName = item.getName();
        attrs.put("path", serverPath.replace(itemName, URLEncoder.encode(itemName, "UTF-8").replace("+", "%20")));
        Servlets.forward((ServletContext)this._ctx, (ServletRequest)request, (ServletResponse)response, (String)nextURI, attrs, (int)3);
    }

    private FileItem parseFileItem(HttpServletRequest request) {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)factory);
            servletFileUpload.setHeaderEncoding("UTF-8");
            try {
                List fileItemsList = servletFileUpload.parseRequest(request);
                for (Object f : fileItemsList) {
                    FileItem item = (FileItem)f;
                    if (item.isFormField()) continue;
                    return item;
                }
            }
            catch (FileUploadException e) {
                logger.error("Upload failed", (Throwable)e);
            }
        }
        return null;
    }
}

