/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ALPNExtension;
import sun.security.ssl.EllipticCurvesExtension;
import sun.security.ssl.EllipticPointFormatsExtension;
import sun.security.ssl.ExtendedMasterSecretExtension;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.ServerNameExtension;
import sun.security.ssl.SignatureAlgorithmsExtension;
import sun.security.ssl.UnknownExtension;

final class HelloExtensions {
    private List<HelloExtension> extensions;
    private int encodedLength;

    HelloExtensions() {
        this.extensions = Collections.emptyList();
    }

    HelloExtensions(HandshakeInStream s) throws IOException {
        int extlen;
        int len;
        this.extensions = new ArrayList<HelloExtension>();
        this.encodedLength = len + 2;
        for (len = s.getInt16(); len > 0; len -= extlen + 4) {
            int type = s.getInt16();
            extlen = s.getInt16();
            ExtensionType extType = ExtensionType.get(type);
            Object extension = extType == ExtensionType.EXT_SERVER_NAME ? new ServerNameExtension(s, extlen) : (extType == ExtensionType.EXT_SIGNATURE_ALGORITHMS ? new SignatureAlgorithmsExtension(s, extlen) : (extType == ExtensionType.EXT_ELLIPTIC_CURVES ? new EllipticCurvesExtension(s, extlen) : (extType == ExtensionType.EXT_EC_POINT_FORMATS ? new EllipticPointFormatsExtension(s, extlen) : (extType == ExtensionType.EXT_RENEGOTIATION_INFO ? new RenegotiationInfoExtension(s, extlen) : (extType == ExtensionType.EXT_EXTENDED_MASTER_SECRET ? new ExtendedMasterSecretExtension(s, extlen) : (extType == ExtensionType.EXT_ALPN ? new ALPNExtension(s, extlen) : new UnknownExtension(s, extlen, extType)))))));
            this.extensions.add((HelloExtension)extension);
        }
        if (len != 0) {
            throw new SSLProtocolException("Error parsing extensions: extra data");
        }
    }

    List<HelloExtension> list() {
        return this.extensions;
    }

    void add(HelloExtension ext) {
        if (this.extensions.isEmpty()) {
            this.extensions = new ArrayList<HelloExtension>();
        }
        this.extensions.add(ext);
        this.encodedLength = -1;
    }

    HelloExtension get(ExtensionType type) {
        for (HelloExtension ext : this.extensions) {
            if (ext.type != type) continue;
            return ext;
        }
        return null;
    }

    int length() {
        if (this.encodedLength >= 0) {
            return this.encodedLength;
        }
        if (this.extensions.isEmpty()) {
            this.encodedLength = 0;
        } else {
            this.encodedLength = 2;
            for (HelloExtension ext : this.extensions) {
                this.encodedLength += ext.length();
            }
        }
        return this.encodedLength;
    }

    void send(HandshakeOutStream s) throws IOException {
        int length = this.length();
        if (length == 0) {
            return;
        }
        s.putInt16(length - 2);
        for (HelloExtension ext : this.extensions) {
            ext.send(s);
        }
    }

    void print(PrintStream s) throws IOException {
        for (HelloExtension ext : this.extensions) {
            s.println(ext.toString());
        }
    }
}

