/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.adempiere.pipo2.handler.GenericPOElementHandler;
import org.adempiere.pipo2.handler.PreferenceElementHandler;
import org.adempiere.pipo2.handler.TabElementHandler;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Window;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WindowElementHandler
extends AbstractElementHandler {
    private TabElementHandler tabHandler = new TabElementHandler();
    private PreferenceElementHandler preferenceHandler = new PreferenceElementHandler();
    private List<Integer> windows = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        List excludes = this.defaultExcludeList("AD_Window");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MWindow mWindow = (MWindow)this.findPO(ctx, element);
        if (mWindow == null) {
            mWindow = new MWindow(ctx.ctx, 0, this.getTrxName(ctx));
        } else if (this.windows.contains(mWindow.getAD_Window_ID())) {
            return;
        }
        PoFiller filler = new PoFiller(ctx, (PO)mWindow, element, (AbstractElementHandler)this);
        List notfounds = filler.autoFill(excludes);
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        element.recordId = mWindow.get_ID();
        if (!mWindow.is_new()) {
            if (!mWindow.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Window", 105);
        String action = null;
        if (!mWindow.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Window", (PO)mWindow);
            action = "Update";
        } else {
            action = "New";
        }
        if (mWindow.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mWindow.getName(), mWindow.get_ID(), action);
            this.windows.add(mWindow.getAD_Window_ID());
            element.recordId = mWindow.get_ID();
            element.requireRoleAccessUpdate = true;
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mWindow.getName(), mWindow.get_ID(), action);
        throw new POSaveFailedException("Failed to save Window " + mWindow.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        boolean createElement;
        PackOut packOut;
        int AD_Window_ID;
        block30: {
            Object handler;
            AD_Window_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Window_ID");
            if (ctx.packOut.isExported("AD_Window_ID|" + AD_Window_ID)) {
                return;
            }
            packOut = ctx.packOut;
            X_AD_Window m_Window = new X_AD_Window(ctx.ctx, AD_Window_ID, null);
            createElement = this.isPackOutElement(ctx, (PO)m_Window);
            if (m_Window.getAD_Color_ID() > 0) {
                handler = ctx.packOut.getHandler("AD_Color");
                if (handler == null) {
                    handler = new GenericPOElementHandler("AD_Color");
                }
                try {
                    handler.packOut(ctx.packOut, document, null, m_Window.getAD_Color_ID());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if (m_Window.getAD_Image_ID() > 0) {
                handler = ctx.packOut.getHandler("AD_Image");
                if (handler == null) {
                    handler = new GenericPOElementHandler("AD_Image");
                }
                try {
                    handler.packOut(ctx.packOut, document, null, m_Window.getAD_Image_ID());
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if (createElement) {
                this.verifyPackOutRequirement((PO)m_Window);
                AttributesImpl atts = new AttributesImpl();
                this.addTypeName(atts, "table");
                document.startElement("", "", "AD_Window", atts);
                this.createWindowBinding(ctx, document, m_Window);
                packOut.getCtx().ctx.put("Table_Name", "AD_Window");
                try {
                    new CommonTranslationHandler().packOut(packOut, document, null, m_Window.get_ID());
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.INFO)) break block30;
                    this.log.info(e.toString());
                }
            }
        }
        String sql = "SELECT AD_Tab_ID, AD_Table_ID FROM AD_TAB WHERE AD_WINDOW_ID = " + AD_Window_ID;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ElementHandler handler = packOut.getHandler("AD_Table");
                    handler.packOut(packOut, document, null, rs.getInt("AD_Table_ID"));
                    this.createTab(ctx, document, rs.getInt("AD_Tab_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                if (e instanceof SQLException) {
                    throw new DatabaseAccessException("Failed to export window.", (Throwable)e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to export window.", e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (createElement) {
            document.endElement("", "", "AD_Window");
        }
        sql = "SELECT AD_Preference_ID FROM AD_PREFERENCE WHERE AD_WINDOW_ID = ? AND AD_CLIENT_ID = ?";
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                pstmt.setInt(1, AD_Window_ID);
                pstmt.setInt(2, Env.getAD_Client_ID((Properties)ctx.ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createPreference(ctx, document, rs.getInt("AD_Preference_ID"));
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                if (e instanceof SQLException) {
                    throw new DatabaseAccessException("Failed to export window preference.", (Throwable)e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to export window preference.", e);
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
    }

    private void createPreference(PIPOContext ctx, TransformerHandler document, int AD_Preference_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Preference_ID", (int)AD_Preference_ID);
        this.preferenceHandler.create(ctx, document);
        ctx.ctx.remove("AD_Preference_ID");
    }

    private void createTab(PIPOContext ctx, TransformerHandler document, int AD_Tab_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Tab_ID", (int)AD_Tab_ID);
        this.tabHandler.create(ctx, document);
        ctx.ctx.remove("AD_Tab_ID");
    }

    private void createWindowBinding(PIPOContext ctx, TransformerHandler document, X_AD_Window m_Window) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Window);
        List excludes = this.defaultExcludeList("AD_Window");
        if (m_Window.getAD_Window_ID() <= 999999) {
            filler.add("AD_Window_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Window_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Window_ID");
    }
}

