/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.xel.zel;

import java.lang.reflect.Method;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.Path;
import org.zkoss.bind.impl.SimpleBindXelContext;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.tracker.impl.TrackerImpl;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.bind.xel.zel.DynamicPropertiedELResolver;
import org.zkoss.bind.xel.zel.ImplicitObjectELResolver;
import org.zkoss.bind.xel.zel.ListModelELResolver;
import org.zkoss.bind.xel.zel.PathELResolver;
import org.zkoss.bind.xel.zel.TreeModelELResolver;
import org.zkoss.bind.xel.zel.ValidationMessagesELResolver;
import org.zkoss.lang.Objects;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.zel.XelELResolver;
import org.zkoss.zel.CompositeELResolver;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.MethodNotFoundException;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zel.impl.parser.AstMethodParameters;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zk.ui.Component;

public class BindELResolver
extends XelELResolver {
    protected CompositeELResolver _resolver;
    protected PathELResolver _pathResolver;
    private ImplicitObjectELResolver _implicitResolver;

    public BindELResolver(XelContext ctx) {
        super(ctx);
        this.init();
    }

    protected void init() {
        this._resolver = new CompositeELResolver();
        if (this._pathResolver == null) {
            this._pathResolver = new PathELResolver();
            this._resolver.add((ELResolver)this._pathResolver);
        } else {
            this._resolver.add((ELResolver)this._pathResolver);
        }
        this._resolver.add((ELResolver)new ListModelELResolver());
        this._resolver.add((ELResolver)new TreeModelELResolver());
        this._resolver.add((ELResolver)new ValidationMessagesELResolver());
        this._resolver.add((ELResolver)this.getImplicitResolver());
        this._resolver.add((ELResolver)new DynamicPropertiedELResolver());
        this._resolver.add(this.getSuperELResolver());
    }

    protected ELResolver getSuperELResolver() {
        return super.getELResolver();
    }

    protected ELResolver getELResolver() {
        return this._resolver;
    }

    protected ImplicitObjectELResolver getImplicitResolver() {
        if (this._implicitResolver == null) {
            this._implicitResolver = new ImplicitObjectELResolver();
        }
        return this._implicitResolver;
    }

    public Object getValue(ELContext ctx, Object base, Object property) throws PropertyNotFoundException, ELException {
        ReferenceBinding rbinding;
        ELContext ec;
        Object value = null;
        if (base == null) {
            if (this._pathResolver == null) {
                this._pathResolver = new PathELResolver();
            }
            this._pathResolver.getValue(ctx, base, property);
            if (value == null && this._ctx instanceof SimpleBindXelContext) {
                SimpleBindXelContext bctxt = (SimpleBindXelContext)this._ctx;
                if ("self".equals(property)) {
                    value = bctxt.getSelf();
                }
                if (Objects.equals((Object)bctxt.getViewModelName(), (Object)property)) {
                    value = bctxt.getViewModel();
                }
            }
            if (value == null) {
                value = this.resolve(ctx, base, property);
            }
            if (value == null) {
                value = this.getImplicitResolver().getValue(ctx, base, property);
            }
            if (value == null) {
                value = super.getELResolver().getValue(ctx, base, property);
            }
            if (value != null) {
                ctx.setPropertyResolved(true);
            }
        } else {
            value = super.getValue(ctx, base, property);
        }
        BindELContext bctx = (ec = ((EvaluationContext)ctx).getELContext()) instanceof BindELContext ? (BindELContext)ec : (BindELContext)((EvaluationContext)ec).getELContext();
        Object ignoreRefVal = bctx.getAttribute("$IGNORE_REF_VALUE$");
        ReferenceBinding referenceBinding = rbinding = value instanceof ReferenceBinding ? (ReferenceBinding)value : null;
        if (rbinding != null) {
            if (Boolean.TRUE.equals(ignoreRefVal)) {
                return rbinding;
            }
            value = rbinding.getValue(bctx);
            Object invalidateRef = bctx.getAttribute("$INVALIDATE_REF_VALUE$");
            if ("true".equalsIgnoreCase(String.valueOf(invalidateRef))) {
                rbinding.invalidateCache();
            }
        }
        this.tieValue(ctx, base, property, rbinding != null ? rbinding : value, false);
        return value;
    }

    public Object invoke(ELContext ctx, Object base, Object method, Class[] paramTypes, Object[] params) throws MethodNotFoundException {
        AstMethodParameters mps;
        ReferenceBinding rbinding;
        Object value = super.invoke(ctx, base, method, paramTypes, params);
        ELContext ec = ((EvaluationContext)ctx).getELContext();
        BindELContext bctx = ec instanceof BindELContext ? (BindELContext)ec : (BindELContext)((EvaluationContext)ec).getELContext();
        Object ignoreRefVal = bctx.getAttribute("$IGNORE_REF_VALUE$");
        ReferenceBinding referenceBinding = rbinding = value instanceof ReferenceBinding ? (ReferenceBinding)value : null;
        if (rbinding != null) {
            if (Boolean.TRUE.equals(ignoreRefVal)) {
                return rbinding;
            }
            value = rbinding.getValue(bctx);
            Object invalidateRef = bctx.getAttribute("$INVALIDATE_REF_VALUE$");
            if ("true".equalsIgnoreCase(String.valueOf(invalidateRef))) {
                rbinding.invalidateCache();
            }
        }
        if ((mps = (AstMethodParameters)bctx.getContext(AstMethodParameters.class)) != null) {
            String result = BindELContext.toNodeString((Node)mps, new StringBuilder());
            Path newPath = new Path();
            newPath.add(String.valueOf(method) + result, String.valueOf(method) + result);
            bctx.putContext(Path.class, newPath);
        }
        this.tieValue(ctx, base, method, rbinding != null ? rbinding : value, false);
        return value;
    }

    public void setValue(ELContext ctx, Object base, Object property, Object value) throws PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base == null) {
            Object val = super.getValue(ctx, base, property);
            if (val instanceof ReferenceBinding) {
                ((ReferenceBinding)val).setValue((BindELContext)((EvaluationContext)ctx).getELContext(), value);
                return;
            }
        } else if (base instanceof ReferenceBinding) {
            base = ((ReferenceBinding)base).getValue((BindELContext)((EvaluationContext)ctx).getELContext());
        }
        super.setValue(ctx, base, property, value);
        this.tieValue(ctx, base, property, value, true);
    }

    private static Path getPathList(BindELContext ctx) {
        return (Path)ctx.getContext(Path.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEqualBeans(ELContext elCtx, Object base, String prop, Object value) {
        BindELContext ctx = (BindELContext)((EvaluationContext)elCtx).getELContext();
        BindContext bctx = (BindContext)ctx.getAttribute("$BINDCTX$");
        if (bctx.getAttribute("$SAVE_BASE$") != null) {
            return;
        }
        ctx.setAttribute("$SAVE_BASE$", Boolean.TRUE);
        try {
            Binder binder = bctx.getBinder();
            TrackerImpl tracker = (TrackerImpl)((BinderCtrl)((Object)binder)).getTracker();
            Set<Object> beans = tracker.getEqualBeans(base);
            beans.remove(base);
            for (Object candidate : beans) {
                super.setValue(elCtx, candidate, (Object)prop, value);
            }
        }
        finally {
            ctx.setAttribute("$SAVE_BASE$", null);
        }
    }

    protected void tieValue(ELContext elCtx, Object base, Object property, Object value, boolean allownotify) {
        ELContext ec = ((EvaluationContext)elCtx).getELContext();
        BindELContext ctx = ec instanceof BindELContext ? (BindELContext)ec : (BindELContext)((EvaluationContext)ec).getELContext();
        if (ctx.ignoreTracker()) {
            return;
        }
        Binding binding = ctx.getBinding();
        if (binding != null) {
            int nums = ctx.getContext(Integer.class) == null ? -1 : (Integer)ctx.getContext(Integer.class);
            Path path = BindELResolver.getPathList(ctx);
            String script = null;
            String propName = property == null ? null : property.toString();
            boolean isForm = base instanceof Form;
            String formFieldName = null;
            if (isForm) {
                script = path.getTrackFieldName();
                formFieldName = path.getAccessFieldName();
            } else {
                script = path.getTrackProperty();
            }
            Binder binder = binding.getBinder();
            BindContext bctx = (BindContext)ctx.getAttribute("$BINDCTX$");
            Component ctxcomp = bctx != null ? bctx.getComponent() : binding.getComponent();
            ((BinderCtrl)((Object)binder)).getTracker().tieValue(ctxcomp, base, script, propName, value, path.getTrackBasePath());
            if (base != null) {
                Method m;
                if (binding instanceof SaveBinding) {
                    if (nums == 0) {
                        this.saveEqualBeans(elCtx, base, propName, value);
                        if (allownotify) {
                            if (isForm) {
                                BindELContext.addNotifys(base, script, value, bctx);
                                if (!script.equals(formFieldName)) {
                                    BindELContext.addNotifys(base, formFieldName, value, bctx);
                                }
                                if (base instanceof Form) {
                                    BindELContext.addNotifys(((Form)base).getFormStatus(), ".", null, bctx);
                                }
                            } else {
                                m = (Method)ctx.getContext(Method.class);
                                BindELContext.addNotifys(m, base, propName, value, bctx);
                            }
                        }
                    }
                } else if (!(base instanceof Form) && binding instanceof LoadBinding && (m = (Method)ctx.getContext(Method.class)) != null) {
                    boolean prompt;
                    boolean bl = prompt = bctx != null && bctx.getCommandName() == null;
                    if (prompt) {
                        boolean skipAddingDependsOn;
                        String basePath = path.getTrackBasePath();
                        boolean bl2 = skipAddingDependsOn = basePath == null || basePath.length() == 0;
                        if (!(skipAddingDependsOn || binding instanceof LoadFormBindingImpl && ((LoadFormBindingImpl)binding).getSeriesLength() > path.size())) {
                            BindELContext.addDependsOnTrackings(m, basePath, path.getTrackFieldsList(), binding, bctx);
                        }
                    }
                }
                if (binding instanceof ReferenceBinding && nums == 0 && allownotify) {
                    m = (Method)ctx.getContext(Method.class);
                    BindELContext.addNotifys(m, base, propName, value, bctx);
                }
            }
        }
    }
}

