/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.Modifier;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.zkoss.bind.Form;
import org.zkoss.bind.annotation.Immutable;
import org.zkoss.bind.annotation.ImmutableFields;
import org.zkoss.bind.proxy.BeanProxyHandler;
import org.zkoss.bind.proxy.FormFieldCleaner;
import org.zkoss.bind.proxy.FormProxyHandler;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ListProxy;
import org.zkoss.bind.proxy.MapProxy;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyTargetHandler;
import org.zkoss.bind.proxy.SetProxy;
import org.zkoss.bind.proxy.ZKProxyTargetHandlers;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHelper {
    private static Map<Class<?>, Boolean> _ignoredClasses = new ConcurrentHashMap();
    private static List<ProxyTargetHandler> _proxyTargetHandlers;

    public static <T> T createProxyIfAny(T origin) {
        return ProxyHelper.createProxyIfAny(origin, null);
    }

    public static <T> T createProxyIfAny(T origin, Annotation[] annotations) {
        if (origin == null) {
            return null;
        }
        if (origin instanceof FormProxyObject) {
            return origin;
        }
        origin = ProxyHelper.getOriginObject(origin);
        boolean hasImmutableFields = false;
        if (annotations != null) {
            for (Annotation annot : annotations) {
                if (annot.annotationType().isAssignableFrom(Immutable.class)) {
                    return origin;
                }
                if (!annot.annotationType().isAssignableFrom(ImmutableFields.class)) continue;
                hasImmutableFields = true;
            }
        }
        if (ProxyHelper.isImmutable(origin)) {
            return origin;
        }
        ProxyFactory factory = new ProxyFactory();
        if (origin instanceof List) {
            return (T)new ListProxy((List)origin, annotations);
        }
        if (origin instanceof Set) {
            return (T)new SetProxy((Set)origin, annotations);
        }
        if (origin instanceof Map) {
            return (T)new MapProxy((Map)origin, annotations);
        }
        if (origin instanceof Collection) {
            return (T)new ListProxy((Collection)origin, annotations);
        }
        if (origin.getClass().isArray()) {
            throw new UnsupportedOperationException("Array cannot be a proxy object!");
        }
        factory.setFilter(BeanProxyHandler.BEAN_METHOD_FILTER);
        factory.setSuperclass(ProxyHelper.getTargetClassIfProxied(origin.getClass()));
        if (hasImmutableFields) {
            factory.setInterfaces(new Class[]{FormProxyObject.class, ImmutableFields.class});
        } else {
            factory.setInterfaces(new Class[]{FormProxyObject.class});
        }
        Class proxyClass = factory.createClass();
        T p1 = null;
        try {
            p1 = proxyClass.newInstance();
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e, (String)("Cannot create a proxy object:[" + origin.getClass() + "], an empty constructor is needed."));
        }
        ((Proxy)p1).setHandler(new BeanProxyHandler<T>(origin));
        return p1;
    }

    public static void addIgnoredProxyClass(Class<?> type) {
        _ignoredClasses.put(type, Boolean.TRUE);
    }

    public static boolean isImmutable(Object origin) {
        if (BindELContext.isImmutable(origin)) {
            return true;
        }
        return ProxyHelper.checkImmutable(origin.getClass());
    }

    private static <T> Class<? extends Object> getTargetClassIfProxied(Class<T> clazz) {
        if (ProxyFactory.isProxyClass(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T> T getOriginObject(T origin) {
        for (ProxyTargetHandler handlers : _proxyTargetHandlers) {
            if (handlers == null) continue;
            origin = handlers.getOriginObject(origin);
        }
        return origin;
    }

    private static boolean checkImmutable(Class<?> type) {
        if (_ignoredClasses.containsKey(type)) {
            return true;
        }
        if (Modifier.isFinal((int)type.getModifiers())) {
            _ignoredClasses.put(type, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static <T> T createFormProxy(T origin, Class<?> type) {
        return ProxyHelper.createFormProxy(origin, type, null);
    }

    public static <T> T createFormProxy(T origin, Class<?> type, Class[] interfaces) {
        if (origin instanceof Form) {
            return origin;
        }
        origin = ProxyHelper.getOriginObject(origin);
        ProxyFactory factory = new ProxyFactory();
        factory.setFilter(FormProxyHandler.FORM_METHOD_FILTER);
        if (origin instanceof FormProxyObject) {
            type = ((FormProxyObject)origin).getOriginObject().getClass();
        } else if (origin != null) {
            type = ProxyHelper.getTargetClassIfProxied(origin.getClass());
        }
        factory.setSuperclass(type);
        if (interfaces == null) {
            factory.setInterfaces(new Class[]{FormProxyObject.class, Form.class, FormFieldCleaner.class});
        } else {
            int len0 = interfaces.length;
            Class[] newArray = new Class[len0 + 3];
            System.arraycopy(interfaces, 0, newArray, 0, len0);
            newArray[len0] = FormProxyObject.class;
            newArray[len0 + 1] = Form.class;
            newArray[len0 + 2] = FormFieldCleaner.class;
            factory.setInterfaces(newArray);
        }
        Class proxyClass = factory.createClass();
        T p1 = null;
        try {
            p1 = proxyClass.newInstance();
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e, (String)("Cannot create a proxy object:[" + origin.getClass() + "], an empty constructor is needed."));
        }
        ((Proxy)p1).setHandler(new FormProxyHandler<T>(origin));
        return p1;
    }

    static void cacheSavePropertyBinding(ProxyNode node, String property, SavePropertyBinding savePropertyBinding) {
        while (node != null) {
            ProxyNode parent = node.getParent();
            if (parent == null) {
                node.getCachedSavePropertyBinding().add((Pair<String, SavePropertyBinding>)new Pair((Object)property, (Object)savePropertyBinding));
                break;
            }
            property = parent.getProperty() + property;
            node = parent;
        }
    }

    static void callOnDataChange(ProxyNode node, Object value) {
        while (node != null) {
            ProxyNode parent = node.getParent();
            if (parent == null && node.getOnDataChangeCallback() != null) {
                node.getOnDataChangeCallback().call(value);
                break;
            }
            node = parent;
        }
    }

    static void callOnDirtyChange(ProxyNode node) {
        while (node != null) {
            ProxyNode parent = node.getParent();
            if (parent == null && node.getOnDirtyChangeCallback() != null) {
                node.getOnDirtyChangeCallback().call((Object)true);
                break;
            }
            node = parent;
        }
    }

    static {
        List classes = Library.getProperties((String)"org.zkoss.bind.proxy.IgnoredProxyClasses");
        if (classes != null && classes.size() != 0) {
            for (String className : classes) {
                try {
                    ProxyHelper.addIgnoredProxyClass(Classes.forNameByThread((String)className.trim()));
                }
                catch (ClassNotFoundException ex) {
                    throw new SystemException("Failed to load class " + className);
                }
            }
        }
        _proxyTargetHandlers = new LinkedList<ProxyTargetHandler>(ZKProxyTargetHandlers.getSystemProxyTargetHandlers());
    }
}

