/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fitrecorder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class FitRecorder
implements ModelValidator {
    private HashMap<Integer, Writer> writersPerSession;
    private static CLogger log = CLogger.getCLogger(FitRecorder.class);
    private static ArrayList<String> dontLogTables = new ArrayList<String>(Arrays.asList("AD_ACCESSLOG", "AD_SESSION", "AD_ALERTPROCESSORLOG", "AD_CHANGELOG", "AD_DOCUMENT_ACTION_ACCESS", "AD_FORM_ACCESS", "AD_ISSUE", "AD_LDAPPROCESSORLOG", "AD_PACKAGE_IMP", "AD_PACKAGE_IMP_BACKUP", "AD_PACKAGE_IMP_DETAIL", "AD_PACKAGE_IMP_INST", "AD_PACKAGE_IMP_PROC", "AD_PINSTANCE", "AD_PINSTANCE_LOG", "AD_PINSTANCE_PARA", "AD_PROCESS_ACCESS", "AD_RECENTITEM", "AD_REPLICATION_LOG", "AD_SCHEDULERLOG", "AD_SESSION", "AD_WINDOW_ACCESS", "AD_WORKFLOW_ACCESS", "AD_WORKFLOWPROCESSORLOG", "CM_WEBACCESSLOG", "C_ACCTPROCESSORLOG", "K_INDEXLOG", "R_REQUESTPROCESSORLOG", "T_AGING", "T_ALTER_COLUMN", "T_DISTRIBUTIONRUNDETAIL", "T_INVENTORYVALUE", "T_INVOICEGL", "T_REPLENISH", "T_REPORT", "T_REPORTSTATEMENT", "T_SELECTION", "T_SELECTION2", "T_SPOOL", "T_TRANSACTION", "T_TRIALBALANCE"));
    private String ignoreTrx = null;

    public void initialize(ModelValidationEngine engine, MClient client) {
        block17: {
            this.writersPerSession = new HashMap();
            try {
                ResultSet rs;
                CPreparedStatement pstmt;
                String sql;
                block16: {
                    sql = "SELECT ta.TableName FROM AD_Table ta WHERE ta.IsActive='Y' AND ta.IsView='N' ORDER BY ta.TableName";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, null);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                engine.addModelChange(rs.getString(1), (ModelValidator)this);
                            }
                        }
                        catch (Exception e) {
                            if (log.isLoggable(Level.INFO)) {
                                log.info(e.getLocalizedMessage());
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            pstmt = null;
                            rs = null;
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        pstmt = null;
                        rs = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    pstmt = null;
                    rs = null;
                }
                sql = "SELECT ta.TableName FROM AD_Table ta INNER JOIN AD_Column cl ON (ta.AD_Table_ID = cl.AD_Table_ID) WHERE ta.IsActive='Y' AND ta.IsView='N' AND cl.AD_Element_ID=287 ORDER BY ta.TableName";
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            engine.addDocValidate(rs.getString(1), (ModelValidator)this);
                        }
                    }
                    catch (Exception e) {
                        if (log.isLoggable(Level.INFO)) {
                            log.info(e.getLocalizedMessage());
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        pstmt = null;
                        rs = null;
                    }
                }
                finally {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    pstmt = null;
                    rs = null;
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.INFO)) break block17;
                log.info(e.getLocalizedMessage());
            }
        }
    }

    public int getAD_Client_ID() {
        return 0;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String modelChange(PO po, int type) throws Exception {
        try {
            MColumn[] columns;
            Object value;
            String colName2;
            MTable table;
            if (type == 4) {
                if (po instanceof MSession) {
                    this.loginFixture(po);
                }
                if (dontLogTables.contains(po.get_TableName().toUpperCase())) {
                    return null;
                }
                if (po.get_TrxName().startsWith("SvrProcess_")) {
                    return null;
                }
                if (po.get_TrxName().startsWith("WFP_")) {
                    return null;
                }
                this.writeFile("\n");
                this.writeFile("\n");
                this.writeFile("CREATE RECORD");
                this.writeFile("\n");
                this.writeFile("!");
                this.writeFile("|Create Record||");
                this.writeFile("\n");
                this.writeFile("|*Table*|");
                this.writeFile(String.valueOf(po.get_TableName()) + "|");
                table = MTable.get((Properties)Env.getCtx(), (int)po.get_Table_ID());
                MColumn[] mColumnArray = table.getColumns(false);
                int n = mColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MColumn column = mColumnArray[n2];
                    colName2 = column.getColumnName();
                    if (!(colName2.equals("Created") || colName2.equals("CreatedBy") || colName2.equals("Updated") || colName2.equals("UpdatedBy") || colName2.equals("AD_Client_ID") || colName2.equals(String.valueOf(table.getTableName()) + "_ID") || colName2.equals(PO.getUUIDColumnName((String)table.getTableName())) || column.getAD_Reference_ID() == 28 || po.isActive() && colName2.equals("IsActive") || (value = po.get_ValueAsString(colName2)) == null || ((String)value).length() <= 0)) {
                        this.writeFile("\n");
                        this.writeFile("|" + colName2 + "|");
                        if (DisplayType.isLookup((int)column.getAD_Reference_ID()) && 17 != column.getAD_Reference_ID()) {
                            this.writeFile(String.valueOf(this.resolveValue(po, table, column)) + "|");
                        } else {
                            this.writeFile(String.valueOf(value) + "|");
                        }
                    }
                    ++n2;
                }
                this.writeFile("\n");
                this.writeFile("|*Save*|");
                this.writeFile("\n");
            }
            if (type == 5) {
                String value2;
                if (po instanceof MPInstance) {
                    MProcess pro = MProcess.get((Properties)Env.getCtx(), (int)po.get_ValueAsInt("AD_Process_ID"));
                    MPInstance pint = (MPInstance)po;
                    this.writeFile("\n");
                    this.writeFile("\n");
                    this.writeFile("RUN PROCESS");
                    this.writeFile("\n");
                    this.writeFile("!");
                    this.writeFile("|Run Process|");
                    this.writeFile("\n");
                    this.writeFile("|*ProcessValue*|");
                    this.writeFile(String.valueOf(pro.getValue()) + "|");
                    MPInstancePara[] iparas = pint.getParameters();
                    value = pro.getParameters();
                    int colName2 = ((MProcessPara[])value).length;
                    int n = 0;
                    while (n < colName2) {
                        MProcessPara para = value[n];
                        MPInstancePara ipara = null;
                        MPInstancePara[] mPInstanceParaArray = iparas;
                        int n3 = iparas.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MPInstancePara iparat = mPInstanceParaArray[n4];
                            if (iparat.getParameterName().equals(para.getColumnName())) {
                                ipara = iparat;
                                break;
                            }
                            ++n4;
                        }
                        if (ipara != null) {
                            value2 = null;
                            String valueTo = null;
                            if (DisplayType.isDate((int)para.getAD_Reference_ID())) {
                                if (ipara.getP_Date() != null) {
                                    value2 = ipara.getP_Date().toString();
                                }
                                if (para.isRange() && ipara.getP_Date_To() != null) {
                                    valueTo = ipara.getP_Date_To().toString();
                                }
                            } else if (DisplayType.isNumeric((int)para.getAD_Reference_ID())) {
                                if (ipara.getP_Number() != null) {
                                    value2 = ipara.getP_Number().toString();
                                }
                                if (para.isRange() && ipara.getP_Number_To() != null) {
                                    valueTo = ipara.getP_Number_To().toString();
                                }
                            } else if (DisplayType.isLookup((int)para.getAD_Reference_ID()) && 17 != para.getAD_Reference_ID()) {
                                if (ipara.get_Value("P_Number") != null) {
                                    value2 = this.resolveValuePara(ipara.getP_Number(), para);
                                }
                                if (para.isRange() && ipara.get_Value("P_Number_To") != null) {
                                    valueTo = this.resolveValuePara(ipara.getP_Number_To(), para);
                                }
                            } else {
                                if (ipara.getP_String() != null) {
                                    value2 = ipara.getP_String();
                                }
                                if (para.isRange() && ipara.getP_String_To() != null) {
                                    valueTo = ipara.getP_String_To();
                                }
                            }
                            if (value2 != null) {
                                this.writeFile("\n");
                                this.writeFile("|" + para.getColumnName() + "|");
                                this.writeFile(String.valueOf(value2) + "|");
                            }
                            if (para.isRange() && valueTo != null) {
                                this.writeFile("\n");
                                this.writeFile("|" + para.getColumnName() + "_2|");
                                this.writeFile(String.valueOf(valueTo) + "|");
                            }
                        }
                        ++n;
                    }
                    this.writeFile("\n");
                    this.writeFile("|*Run*|");
                    this.writeFile("\n");
                } else if (po instanceof MSession) {
                    MSession session = (MSession)po;
                    if (session.isProcessed()) {
                        this.closefile();
                    }
                } else {
                    if (dontLogTables.contains(po.get_TableName().toUpperCase())) {
                        return null;
                    }
                    if (po.get_TrxName().startsWith("SvrProcess_")) {
                        return null;
                    }
                    if (po.get_TrxName().startsWith("WFP_")) {
                        return null;
                    }
                    table = MTable.get((Properties)Env.getCtx(), (int)po.get_Table_ID());
                    columns = table.getColumns(true);
                    StringBuilder where = new StringBuilder();
                    StringBuilder set = new StringBuilder();
                    boolean key = false;
                    int i = 0;
                    while (i < columns.length) {
                        MColumn column = columns[i];
                        String colName3 = column.getColumnName();
                        value2 = null;
                        value2 = DisplayType.isLookup((int)column.getAD_Reference_ID()) && 17 != column.getAD_Reference_ID() ? this.resolveValue(po, table, column) : po.get_ValueAsString(colName3);
                        if (column.isAllowLogging()) {
                            if (column.isKey()) {
                                if (!key) {
                                    where.append("| *Where* | ");
                                    where.append(String.valueOf(colName3) + " = " + value2 + " | ");
                                    key = true;
                                } else {
                                    where.append(" | " + colName3 + " | ");
                                    where.append(String.valueOf(value2) + " | ");
                                }
                            }
                            if (!(!po.is_ValueChanged(colName3) || colName3.equals("Created") || colName3.equals("CreatedBy") || colName3.equals("Updated") || colName3.equals("UpdatedBy") || colName3.equals("AD_Client_ID") || colName3.equals(String.valueOf(table.getTableName()) + "_ID") || colName3.equals(PO.getUUIDColumnName((String)table.getTableName())) || column.getAD_Reference_ID() == 28 || po.isActive() && colName3.equals("IsActive") || value2 == null || value2.length() <= 0)) {
                                set.append("\n");
                                set.append("| " + colName3 + " | ");
                                set.append(String.valueOf(value2) + "|");
                            }
                        }
                        ++i;
                    }
                    if (where.length() > 0 && set.length() > 0) {
                        this.writeFile("\n");
                        this.writeFile("\n");
                        this.writeFile("UPDATE RECORD");
                        this.writeFile("\n");
                        this.writeFile("!");
                        this.writeFile("| Update Record |");
                        this.writeFile("\n");
                        this.writeFile("| *Table* |  ");
                        this.writeFile(String.valueOf(po.get_TableName()) + "  |");
                        this.writeFile("\n");
                        this.writeFile(where.toString());
                        this.writeFile("\n");
                        this.writeFile("| *Update*  |");
                        this.writeFile(set.toString());
                    }
                }
            }
            if (type == 6) {
                if (dontLogTables.contains(po.get_TableName().toUpperCase())) {
                    return null;
                }
                if (po.get_TrxName().startsWith("SvrProcess_")) {
                    return null;
                }
                if (po.get_TrxName().startsWith("WFP_")) {
                    return null;
                }
                this.writeFile("\n");
                this.writeFile("\n");
                this.writeFile("DELETE RECORD");
                this.writeFile("\n");
                this.writeFile("!");
                this.writeFile("| Delete Record |");
                this.writeFile("\n");
                this.writeFile("| *Table* |  ");
                this.writeFile(String.valueOf(po.get_TableName()) + "  |");
                this.writeFile("\n");
                table = MTable.get((Properties)Env.getCtx(), (int)po.get_Table_ID());
                columns = table.getColumns(true);
                boolean key = false;
                int i = 0;
                while (i < columns.length) {
                    MColumn column = columns[i];
                    colName2 = column.getColumnName();
                    value = null;
                    value = DisplayType.isLookup((int)column.getAD_Reference_ID()) && 17 != column.getAD_Reference_ID() ? this.resolveValue(po, table, column) : po.get_ValueAsString(colName2);
                    if (column.isAllowLogging() && column.isKey()) {
                        if (!key) {
                            this.writeFile("| *Where* | ");
                            this.writeFile(String.valueOf(colName2) + " = " + (String)value + " | ");
                            key = true;
                        } else {
                            this.writeFile(" | " + colName2 + " | ");
                            this.writeFile(String.valueOf(value) + " | ");
                        }
                    }
                    ++i;
                }
                this.writeFile("\n");
                this.writeFile("| *Delete*  |");
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.INFO)) {
                log.info(e.getLocalizedMessage());
            }
            return e.getLocalizedMessage();
        }
        return null;
    }

    private String resolveValuePara(BigDecimal p_Number, MProcessPara para) {
        Integer idO;
        String value = null;
        String foreignTable = para.getReferenceTableName();
        String foreignColName = null;
        if (!"AD_Language".equals(foreignTable) && !"AD_EntityType".equals(foreignTable)) {
            MTable fTable = MTable.get((Properties)Env.getCtx(), (String)foreignTable);
            if (!("AD_Org".equals(foreignTable) || "AD_User".equals(foreignTable) || "AD_Ref_List".equals(foreignTable) || fTable.getColumn("Value") == null)) {
                foreignColName = "Value";
            } else if (fTable.getColumn("Name") != null) {
                foreignColName = "Name";
            } else if (fTable.getColumn("DocumentNo") != null) {
                foreignColName = "DocumentNo";
            }
        }
        if ((idO = Integer.valueOf(p_Number.intValue())) != null && foreignColName != null) {
            int id = idO;
            StringBuilder select = new StringBuilder("SELECT ").append(foreignColName).append(" FROM ").append(foreignTable).append(" WHERE ").append(foreignTable).append("_ID=?");
            String foreignValue = DB.getSQLValueStringEx(null, (String)select.toString(), (Object[])new Object[]{id});
            value = "@Ref=" + foreignTable + "[" + foreignColName + "='" + foreignValue + "']." + foreignTable + "_ID";
        } else {
            value = p_Number.toString();
        }
        return value;
    }

    private String resolveValue(PO po, MTable table, MColumn column) {
        Object idO;
        String value = null;
        String foreignTable = column.getReferenceTableName();
        String foreignColName = null;
        if (!"AD_Language".equals(foreignTable) && !"AD_EntityType".equals(foreignTable)) {
            MTable fTable = MTable.get((Properties)Env.getCtx(), (String)foreignTable);
            if (!("AD_Org".equals(foreignTable) || "AD_User".equals(foreignTable) || "AD_Ref_List".equals(foreignTable) || fTable.getColumn("Value") == null)) {
                foreignColName = "Value";
            } else if (fTable.getColumn("Name") != null) {
                foreignColName = "Name";
            } else if (fTable.getColumn("DocumentNo") != null) {
                foreignColName = "DocumentNo";
            }
        }
        if ((idO = po.get_Value(column.getColumnName())) != null && foreignColName != null) {
            int id = (Integer)idO;
            StringBuilder select = new StringBuilder("SELECT ").append(foreignColName).append(" FROM ").append(foreignTable).append(" WHERE ").append(foreignTable).append("_ID=?");
            String foreignValue = DB.getSQLValueStringEx(null, (String)select.toString(), (Object[])new Object[]{id});
            value = "@Ref=" + foreignTable + "[" + foreignColName + "='" + foreignValue + "']." + foreignTable + "_ID";
        } else {
            value = po.get_ValueAsString(column.getColumnName());
        }
        return value;
    }

    public String docValidate(PO po, int timing) {
        block6: {
            block7: {
                if (timing != 1 && timing != 2 && timing != 3 && timing != 4 && timing != 5 && timing != 6 && timing != 7 && timing != 15) break block6;
                if (!po.get_TrxName().equals(this.ignoreTrx)) break block7;
                return null;
            }
            try {
                this.ignoreTrx = po.get_TrxName();
                String action = po.get_ValueAsString("DocAction");
                if (timing == 15) {
                    action = "PO";
                }
                this.writeFile("\n");
                this.writeFile("\n");
                if (action.equals("CO")) {
                    String processValue = DB.getSQLValueString((String)po.get_TrxName(), (String)"SELECT p.Value FROM AD_Process p JOIN AD_Workflow w ON (p.AD_Workflow_ID=w.AD_Workflow_ID) WHERE w.AD_Table_ID=?", (int)po.get_Table_ID());
                    this.writeFile("RUN PROCESS");
                    this.writeFile("\n");
                    this.writeFile("!");
                    this.writeFile("|Run Process|");
                    this.writeFile("\n");
                    this.writeFile("|*ProcessValue*|");
                    this.writeFile(String.valueOf(processValue) + "|");
                    this.writeFile("\n");
                    this.writeFile("|*RecordID*|");
                    this.writeFile(String.valueOf(this.resolveValueDoc(po.get_ID(), po.get_TableName())) + "|");
                    this.writeFile("\n");
                    this.writeFile("|*DocAction*|");
                    this.writeFile(String.valueOf(action) + "|");
                    this.writeFile("\n");
                    this.writeFile("|*Run*|");
                } else {
                    this.writeFile("SET DOC ACTION");
                    this.writeFile("\n");
                    this.writeFile("!");
                    this.writeFile("|Set DocAction|");
                    this.writeFile("\n");
                    this.writeFile("|*Table*|");
                    this.writeFile(String.valueOf(po.get_TableName()) + "|");
                    this.writeFile("\n");
                    this.writeFile("|" + po.get_TableName() + "_ID|");
                    this.writeFile(String.valueOf(this.resolveValueDoc(po.get_ID(), po.get_TableName())) + "|");
                    this.writeFile("\n");
                    this.writeFile("|DocAction|");
                    this.writeFile(String.valueOf(action) + "|");
                    this.writeFile("\n");
                    this.writeFile("|*Save*|");
                }
                this.writeFile("\n");
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.INFO)) break block6;
                log.info(e.getLocalizedMessage());
            }
        }
        return null;
    }

    private String resolveValueDoc(int id, String tableName) {
        String value = null;
        String foreignTable = tableName;
        String foreignColName = null;
        if (!"AD_Language".equals(foreignTable) && !"AD_EntityType".equals(foreignTable)) {
            MTable fTable = MTable.get((Properties)Env.getCtx(), (String)foreignTable);
            if (!("AD_Org".equals(foreignTable) || "AD_User".equals(foreignTable) || "AD_Ref_List".equals(foreignTable) || fTable.getColumn("Value") == null)) {
                foreignColName = "Value";
            } else if (fTable.getColumn("Name") != null) {
                foreignColName = "Name";
            } else if (fTable.getColumn("DocumentNo") != null) {
                foreignColName = "DocumentNo";
            }
        }
        if (id > 0 && foreignColName != null) {
            StringBuilder select = new StringBuilder("SELECT ").append(foreignColName).append(" FROM ").append(foreignTable).append(" WHERE ").append(foreignTable).append("_ID=?");
            String foreignValue = DB.getSQLValueStringEx(null, (String)select.toString(), (Object[])new Object[]{id});
            value = "@Ref=" + foreignTable + "[" + foreignColName + "='" + foreignValue + "']." + foreignTable + "_ID";
        } else {
            value = String.valueOf(id);
        }
        return value;
    }

    public String loginFixture(PO po) {
        String msg = null;
        String preference = Env.getPreference((Properties)Env.getCtx(), (int)0, (String)"FitRecorder", (boolean)false);
        if (preference.equals("Y")) {
            int session_ID = po.get_ID();
            int user_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_User_ID");
            int org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Org_ID");
            MUser user = new MUser(Env.getCtx(), user_ID, null);
            String name = String.valueOf(Ini.getAdempiereHome()) + "/log/fit_test_" + session_ID + user.getName() + ".txt";
            try {
                File file = new File(name);
                FileOutputStream fos = new FileOutputStream(file, true);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
                Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (int)session_ID);
                this.writersPerSession.put(session_ID, writer);
                this.writeFile("\n");
                this.writeFile("\n");
                this.writeFile("LOGIN");
                this.writeFile("\n");
                this.writeFile("!");
                this.writeFile("|Login|");
                this.writeFile("\n");
                this.writeFile("|User|");
                if (MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false)) {
                    this.writeFile(String.valueOf(user.getEMail()) + "|");
                } else if (user.getLDAPUser() != null) {
                    this.writeFile(String.valueOf(user.getLDAPUser()) + "|");
                } else {
                    this.writeFile(String.valueOf(user.getName()) + "|");
                }
                this.writeFile("\n");
                this.writeFile("|Password|");
                this.writeFile("                                |");
                this.writeFile("\n");
                this.writeFile("|AD_Client_ID|");
                MClient client = MClient.get((Properties)Env.getCtx(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Client_ID"));
                this.writeFile("@Ref=AD_Client[Name='" + client.getName() + "'].AD_Client_ID|");
                this.writeFile("\n");
                this.writeFile("|AD_Org_ID|");
                String orgName = DB.getSQLValueString(null, (String)"SELECT Name FROM AD_Org WHERE AD_Org_ID=?", (int)org_ID);
                this.writeFile("@Ref=AD_Org[Name='" + orgName + "'].AD_Org_ID|");
                this.writeFile("\n");
                this.writeFile("|AD_Role_ID|");
                this.writeFile("@Ref=AD_Role[Name='" + Env.getContext((Properties)Env.getCtx(), (String)"#AD_Role_Name") + "'].AD_Role_ID|");
                this.writeFile("\n");
                int warehouseid = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#M_Warehouse_ID");
                if (warehouseid > 0) {
                    MWarehouse warehouse = MWarehouse.get((Properties)Env.getCtx(), (int)warehouseid);
                    this.writeFile("|M_Warehouse_ID|");
                    this.writeFile("@Ref=M_Warehouse[Name='" + warehouse.getName() + "'].M_Warehouse_ID|");
                    this.writeFile("\n");
                }
                this.writeFile("|*Login*|");
                this.writeFile("\n");
            }
            catch (Exception e) {
                return e.getLocalizedMessage();
            }
        }
        return msg;
    }

    public void writeFile(String msg) {
        int session_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        Writer writer = this.writersPerSession.get(session_ID);
        if (writer != null) {
            try {
                writer.append(msg);
                writer.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closefile() {
        int Session_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        Writer writer = this.writersPerSession.get(Session_ID);
        if (writer != null) {
            try {
                writer.close();
                this.writersPerSession.remove(Session_ID);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

