/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.plugin.utils.AbstractActivator;
import org.adempiere.plugin.utils.Version;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MSession;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Version2PackActivator
extends AbstractActivator {
    protected static final CLogger logger = CLogger.getCLogger((String)Version2PackActivator.class.getName());

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + this.getVersion() + " starting...");
        }
        this.serviceTracker = new ServiceTracker(context, IDictionaryService.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + this.getVersion() + " ready.");
        }
    }

    @Override
    public String getName() {
        return this.context.getBundle().getSymbolicName();
    }

    public String getVersion() {
        String version = (String)this.context.getBundle().getHeaders().get("Bundle-Version");
        String[] components = version.split("[.]");
        StringBuilder versionBuilder = new StringBuilder(components[0]);
        if (components.length >= 3) {
            versionBuilder.append(".").append(components[1]).append(".").append(components[2]);
        } else if (components.length == 2) {
            versionBuilder.append(".").append(components[1]).append(".0");
        } else {
            versionBuilder.append(".0.0");
        }
        return versionBuilder.toString();
    }

    public String getDescription() {
        return this.getName();
    }

    private void installPackage() {
        String bundleVersionPart = this.getVersion();
        String installedVersionPart = null;
        String where = "Name=? AND PK_Status = 'Completed successfully'";
        Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null);
        q.setParameters(new Object[]{this.getName()});
        List pkgs = q.list();
        if (pkgs != null && !pkgs.isEmpty()) {
            for (X_AD_Package_Imp pkg : pkgs) {
                Version packageVersion;
                String packageVersionPart = pkg.getPK_Version();
                String[] part = packageVersionPart.split("[.]");
                if (installedVersionPart == null) {
                    if (part.length > 3) {
                        installedVersionPart = String.valueOf(part[0]) + "." + part[1] + "." + part[2];
                        continue;
                    }
                    installedVersionPart = packageVersionPart;
                    continue;
                }
                Version installedVersion = new Version(installedVersionPart);
                if (part.length > 3) {
                    packageVersionPart = String.valueOf(part[0]) + "." + part[1] + "." + part[2];
                }
                if ((packageVersion = new Version(packageVersionPart)).compareTo(installedVersion) <= 0) continue;
                installedVersionPart = packageVersionPart;
            }
        }
        this.packIn(installedVersionPart, bundleVersionPart);
        this.afterPackIn();
    }

    /*
     * Unable to fully structure code
     */
    protected void packIn(String installedVersionPart, String bundleVersionPart) {
        block7: {
            list = new ArrayList<TwoPackEntry>();
            urls = this.context.getBundle().findEntries("/META-INF", "2Pack_*.zip", false);
            bundleVersion = new Version(bundleVersionPart);
            if (Util.isEmpty((String)installedVersionPart)) ** GOTO lbl21
            installedVersion = new Version(installedVersionPart);
            while (urls.hasMoreElements()) {
                u = (URL)urls.nextElement();
                version = this.extractVersionString(u);
                packageVersion = new Version(version);
                if (packageVersion.compareTo(bundleVersion) > 0 || packageVersion.compareTo(installedVersion) <= 0) continue;
                list.add(new TwoPackEntry(u, version));
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                u = (URL)urls.nextElement();
                version = this.extractVersionString(u);
                packageVersion = new Version(version);
                if (packageVersion.compareTo(bundleVersion) > 0) continue;
                list.add(new TwoPackEntry(u, version));
lbl21:
                // 3 sources

                ** while (urls.hasMoreElements())
            }
        }
        Collections.sort(list, new Comparator<TwoPackEntry>(){

            @Override
            public int compare(TwoPackEntry o1, TwoPackEntry o2) {
                return new Version(o1.version).compareTo(new Version(o2.version));
            }
        });
        try {
            if (this.getDBLock()) {
                MSession.get((Properties)Env.getCtx(), (boolean)true);
                for (TwoPackEntry entry : list) {
                    if (!this.packIn(TwoPackEntry.access$2(entry))) break;
                }
                this.releaseLock();
            } else {
                Version2PackActivator.logger.log(Level.SEVERE, "Could not acquire the DB lock to install:" + this.getName());
            }
        }
        catch (AdempiereSystemError e) {
            e.printStackTrace();
        }
    }

    private String extractVersionString(URL u) {
        String p = u.getPath();
        int upos = p.lastIndexOf("_");
        int dpos = p.lastIndexOf(".");
        String v = p.substring(upos + 1, dpos);
        return v;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean packIn(URL packout) {
        FileOutputStream zipstream;
        block17: {
            if (packout == null) return true;
            if (this.service == null) return true;
            String path = packout.getPath();
            String suffix = "_" + path.substring(path.lastIndexOf("2Pack_"));
            System.out.println("Installing " + this.getName() + " " + path + " ...");
            zipstream = null;
            try {
                InputStream stream = packout.openStream();
                File zipfile = File.createTempFile(String.valueOf(this.getName()) + "_", suffix);
                zipstream = new FileOutputStream(zipfile);
                byte[] buffer = new byte[1024];
                while (true) {
                    int read;
                    if ((read = stream.read(buffer)) == -1) {
                        if (this.merge(zipfile, this.extractVersionString(packout))) break block17;
                        if (zipstream == null) return false;
                        break;
                    }
                    zipstream.write(buffer, 0, read);
                }
            }
            catch (Throwable e) {
                try {
                    logger.log(Level.SEVERE, "Pack in failed.", e);
                    return false;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (zipstream != null) {
                        try {
                            zipstream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                zipstream.close();
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        if (zipstream != null) {
            try {
                zipstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println(String.valueOf(this.getName()) + " " + packout.getPath() + " installed");
        return true;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected void setContext(BundleContext context) {
        this.context = context;
    }

    public void stop(BundleContext context) throws Exception {
        this.stop();
        this.serviceTracker.close();
        this.context = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(context.getBundle().getSymbolicName()) + " " + (String)context.getBundle().getHeaders().get("Bundle-Version") + " stopped.");
        }
    }

    protected void afterPackIn() {
    }

    protected void start() {
    }

    protected void stop() {
    }

    public IDictionaryService addingService(ServiceReference<IDictionaryService> reference) {
        this.service = (IDictionaryService)this.context.getService(reference);
        if (Adempiere.getThreadPoolExecutor() != null) {
            Adempiere.getThreadPoolExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(Version2PackActivator.class.getClassLoader());
                        Version2PackActivator.this.setupPackInContext();
                        Version2PackActivator.this.installPackage();
                    }
                    finally {
                        ServerContext.dispose();
                        Version2PackActivator.this.service = null;
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
            });
        } else {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                public void stateChange(ServerStateChangeEvent event) {
                    if (event.getEventType() == 0 && Version2PackActivator.this.service != null) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(Version2PackActivator.class.getClassLoader());
                            Version2PackActivator.this.setupPackInContext();
                            Version2PackActivator.this.installPackage();
                        }
                        finally {
                            ServerContext.dispose();
                            Version2PackActivator.this.service = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                    }
                }
            });
        }
        return null;
    }

    public void modifiedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    public void removedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    protected void setupPackInContext() {
        Properties serverContext = new Properties();
        serverContext.setProperty("#AD_Client_ID", "0");
        ServerContext.setCurrentInstance((Properties)serverContext);
    }

    private static class TwoPackEntry {
        private URL url;
        private String version;

        private TwoPackEntry(URL url, String version) {
            this.url = url;
            this.version = version;
        }

        static /* synthetic */ URL access$2(TwoPackEntry twoPackEntry) {
            return twoPackEntry.url;
        }
    }
}

