/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.io.FileFilter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.plugin.utils.AbstractActivator;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PackInApplicationActivator
extends AbstractActivator {
    protected static final CLogger logger = CLogger.getCLogger((String)PackInApplicationActivator.class.getName());
    private List<File> filesToProcess = new ArrayList<File>();
    private File currentFile;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " starting...");
        }
        this.serviceTracker = new ServiceTracker(context, IDictionaryService.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " ready.");
        }
    }

    protected void start() {
    }

    protected void stop() {
    }

    public void stop(BundleContext context) throws Exception {
        this.stop();
        this.serviceTracker.close();
        this.context = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(context.getBundle().getSymbolicName()) + " " + (String)context.getBundle().getHeaders().get("Bundle-Version") + " stopped.");
        }
    }

    public IDictionaryService addingService(ServiceReference<IDictionaryService> reference) {
        this.service = (IDictionaryService)this.context.getService(reference);
        if (Adempiere.getThreadPoolExecutor() != null) {
            Adempiere.getThreadPoolExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    int timeout = MSysConfig.getIntValue((String)"AUTOMATIC_PACKIN_INITIAL_DELAY", (int)120) * 1000;
                    String folders = MSysConfig.getValue((String)"AUTOMATIC_PACKIN_FOLDERS");
                    PackInApplicationActivator.this.automaticPackin(timeout, folders, true);
                }
            });
        } else {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                public void stateChange(ServerStateChangeEvent event) {
                    if (event.getEventType() == 0 && PackInApplicationActivator.this.service != null) {
                        int timeout = MSysConfig.getIntValue((String)"AUTOMATIC_PACKIN_INITIAL_DELAY", (int)120) * 1000;
                        String folders = MSysConfig.getValue((String)"AUTOMATIC_PACKIN_FOLDERS");
                        PackInApplicationActivator.this.automaticPackin(timeout, folders, true);
                    }
                }
            });
        }
        return null;
    }

    public void automaticPackin(int timeout, final String folders, boolean fromService) {
        if (fromService) {
            final Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(PackInApplicationActivator.class.getClassLoader());
                        PackInApplicationActivator.this.setupPackInContext();
                        PackInApplicationActivator.this.installPackages(folders);
                    }
                    finally {
                        ServerContext.dispose();
                        PackInApplicationActivator.this.service = null;
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                    t.cancel();
                }
            }, timeout);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(PackInApplicationActivator.class.getClassLoader());
                this.setupPackInContext();
                this.installPackages(folders);
            }
            finally {
                ServerContext.dispose();
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    private void installPackages(String folders) {
        block13: {
            if (Util.isEmpty((String)folders, (boolean)true)) {
                this.setSummary(Level.INFO, "Not specified folders for automatic packin");
                return;
            }
            File[] fileArray = this.getFilesToProcess(folders);
            if (fileArray.length <= 0) {
                this.setSummary(Level.INFO, "No zip files to process");
                return;
            }
            try {
                if (this.getDBLock()) {
                    if (Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID") <= 0) {
                        MSession.get((Properties)Env.getCtx(), (boolean)true);
                    }
                    File[] fileArray2 = fileArray;
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File zipFile;
                        this.currentFile = zipFile = fileArray2[n2];
                        if (!this.packIn(zipFile)) {
                            this.addLog(Level.SEVERE, "Failed application of " + zipFile);
                            break block13;
                        }
                        this.addLog(Level.INFO, "Successful application of " + zipFile);
                        this.filesToProcess.remove(zipFile);
                        ++n2;
                    }
                    break block13;
                }
                this.addLog(Level.SEVERE, "Could not acquire the DB lock to automatically install the packins");
                return;
            }
            catch (AdempiereSystemError e) {
                e.printStackTrace();
                this.addLog(Level.SEVERE, e.getLocalizedMessage());
            }
            finally {
                this.releaseLock();
            }
        }
        if (this.filesToProcess.size() > 0) {
            StringBuilder pending = new StringBuilder("The following packages were not applied: ");
            for (File file : this.filesToProcess) {
                pending.append("\n").append(file.getName());
            }
            this.addLog(Level.WARNING, pending.toString());
        }
    }

    private boolean packIn(File packinFile) {
        if (packinFile != null) {
            int[] clientIDs;
            String fileName = packinFile.getName();
            logger.warning("Installing " + fileName + " ...");
            String[] parts = fileName.split("_");
            String clientValue = parts[1];
            boolean allClients = clientValue.startsWith("ALL-CLIENTS");
            if (allClients) {
                int[] seedClientIDs = new int[]{};
                String seedClientValue = "";
                if (clientValue.startsWith("ALL-CLIENTS-") && (seedClientIDs = this.getClientIDs(seedClientValue = clientValue.split("-")[2])).length == 0) {
                    logger.log(Level.SEVERE, "Seed client does not exist: " + seedClientValue);
                    return false;
                }
                int[] allClientIDs = new Query(Env.getCtx(), "AD_Client", "AD_Client_ID>0 AND Value!=?", null).setOnlyActiveRecords(true).setParameters(new Object[]{seedClientValue}).setOrderBy("AD_Client_ID").getIDs();
                int shift = 0;
                if (seedClientIDs.length > 0) {
                    shift = 1;
                }
                clientIDs = new int[allClientIDs.length + shift];
                if (seedClientIDs.length > 0) {
                    clientIDs[0] = seedClientIDs[0];
                }
                int i = 0;
                while (i < allClientIDs.length) {
                    clientIDs[i + shift] = allClientIDs[i];
                    ++i;
                }
            } else {
                clientIDs = this.getClientIDs(clientValue);
                if (clientIDs.length == 0) {
                    logger.log(Level.SEVERE, "Client does not exist: " + clientValue);
                    return false;
                }
            }
            int[] nArray = clientIDs;
            int n = clientIDs.length;
            int seedClientValue = 0;
            while (seedClientValue < n) {
                int clientID = nArray[seedClientValue];
                MClient client = MClient.get((Properties)Env.getCtx(), (int)clientID);
                if (allClients) {
                    String message = "Installing " + fileName + " in client " + client.getValue() + "/" + client.getName();
                    this.statusUpdate(message);
                }
                Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)client.getAD_Client_ID());
                try {
                    if (this.service != null ? !this.merge(packinFile, null) : !this.directMerge(packinFile, null)) {
                        return false;
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Pack in failed.", e);
                    return false;
                }
                finally {
                    Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)0);
                }
                logger.warning(String.valueOf(packinFile.getPath()) + " installed");
                ++seedClientValue;
            }
            if (allClients) {
                X_AD_Package_Imp_Proc pimpr = new X_AD_Package_Imp_Proc(Env.getCtx(), 0, null);
                pimpr.setName(fileName);
                pimpr.setDateProcessed(new Timestamp(System.currentTimeMillis()));
                pimpr.setP_Msg("This ALL-CLIENT 2Pack was applied successfully in all tenants");
                pimpr.setAD_Package_Source_Type("File");
                pimpr.saveEx();
                X_AD_Package_Imp pimp = new X_AD_Package_Imp(Env.getCtx(), 0, null);
                pimp.setAD_Package_Imp_Proc_ID(pimpr.getAD_Package_Imp_Proc_ID());
                pimp.setName(fileName);
                pimp.setPK_Status("Completed successfully");
                pimp.setDescription("This ALL-CLIENT 2Pack was applied successfully in all tenants");
                pimp.setProcessed(true);
                pimp.saveEx();
            }
        }
        return true;
    }

    private File[] getFilesToProcess(String folders) {
        String[] filePaths = null;
        filePaths = folders.indexOf(";") > 0 ? folders.split("[;]") : new String[]{folders};
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            File toProcess = new File(filePath.trim());
            if (!toProcess.exists()) {
                this.addLog(Level.SEVERE, String.valueOf(filePath) + " does not exist");
            } else {
                this.processFilePath(toProcess);
            }
            ++n2;
        }
        this.verifyInstalledPackages();
        File[] fileArray = this.filesToProcess.toArray(new File[this.filesToProcess.size()]);
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        return fileArray;
    }

    /*
     * Unable to fully structure code
     */
    private void processFilePath(File toProcess) {
        if (!toProcess.isFile() || !toProcess.canRead()) ** GOTO lbl8
        if (toProcess.getName().toLowerCase().endsWith(".zip")) {
            this.filesToProcess.add(toProcess);
        } else {
            PackInApplicationActivator.logger.log(Level.SEVERE, String.valueOf(toProcess.getName()) + " is not a valid .zip file");
            return;
lbl8:
            // 1 sources

            if (toProcess.isDirectory() && toProcess.canRead()) {
                filter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().toUpperCase().endsWith(".ZIP") || file.isDirectory();
                    }
                };
                found = false;
                var7_4 = toProcess.listFiles(filter);
                var6_5 = var7_4.length;
                var5_6 = 0;
                while (var5_6 < var6_5) {
                    fileToProcess = var7_4[var5_6];
                    if (!found) {
                        PackInApplicationActivator.logger.info("*** Creating list from folder " + toProcess.toString());
                        found = true;
                    }
                    if (fileToProcess.isDirectory()) {
                        this.processFilePath(fileToProcess);
                    } else if (fileToProcess.canRead()) {
                        this.filesToProcess.add(fileToProcess);
                    } else {
                        this.addLog(Level.SEVERE, String.valueOf(fileToProcess.getName()) + " not readable");
                    }
                    ++var5_6;
                }
                if (!found) {
                    PackInApplicationActivator.logger.log(Level.FINE, String.valueOf(toProcess.getName()) + " does not have .zip files or subfolders");
                    return;
                }
            } else {
                this.addLog(Level.SEVERE, String.valueOf(toProcess.getName()) + " not a file or folder or not readable");
            }
        }
    }

    private void verifyInstalledPackages() {
        Iterator<File> iterator = this.filesToProcess.iterator();
        while (iterator.hasNext()) {
            this.currentFile = iterator.next();
            if (!this.installedPackage(null)) continue;
            logger.log(Level.INFO, String.valueOf(this.currentFile.getName()) + " already installed. Removing it from the list...");
            iterator.remove();
        }
    }

    private int[] getClientIDs(String clientValue) {
        String where = "Value = ?";
        Query q = new Query(Env.getCtx(), "AD_Client", where, null).setParameters(new Object[]{clientValue}).setOnlyActiveRecords(true);
        return q.getIDs();
    }

    public void modifiedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    public void removedService(ServiceReference<IDictionaryService> reference, IDictionaryService service) {
    }

    @Override
    public String getName() {
        if (this.currentFile != null) {
            return this.currentFile.getName();
        }
        return "";
    }

    protected void setupPackInContext() {
        Properties serverContext = new Properties();
        serverContext.setProperty("#AD_Client_ID", "0");
        ServerContext.setCurrentInstance((Properties)serverContext);
    }
}

