/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IDictionaryService;
import org.adempiere.base.Service;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractActivator
implements BundleActivator,
ServiceTrackerCustomizer<IDictionaryService, IDictionaryService> {
    protected static final CLogger logger = CLogger.getCLogger((String)AbstractActivator.class.getName());
    protected BundleContext context;
    protected ServiceTracker<IDictionaryService, IDictionaryService> serviceTracker;
    protected IDictionaryService service;
    private String trxName = "";
    private ProcessInfo m_processInfo = null;
    private IProcessUI m_processUI = null;

    protected boolean merge(File zipfile, String version) throws Exception {
        boolean success = false;
        if (!this.installedPackage(version)) {
            this.service.merge(this.context, zipfile);
            success = true;
        } else {
            logger.log(Level.SEVERE, "The file was previously installed: " + zipfile.getName());
        }
        return success;
    }

    protected boolean directMerge(File zipfile, String version) throws Exception {
        boolean success = false;
        if (!this.installedPackage(version)) {
            List list = Service.locator().list(IDictionaryService.class).getServices();
            if (list != null) {
                IDictionaryService ids = (IDictionaryService)list.get(0);
                ids.merge(null, zipfile);
                success = true;
                if (ids.getAD_Package_Imp_Proc() != null) {
                    MClient client = MClient.get((Properties)Env.getCtx());
                    this.addLog(Level.INFO, String.valueOf(this.getName()) + " in " + client.getValue() + " -> " + ids.getAD_Package_Imp_Proc().getP_Msg());
                }
            } else {
                this.addLog(Level.SEVERE, "Could not find an IDictionaryService to process the zip files");
            }
        } else {
            this.addLog(Level.SEVERE, "The file was previously installed: " + zipfile.getName());
            success = true;
        }
        return success;
    }

    protected boolean installedPackage(String version) {
        StringBuilder where = new StringBuilder("AD_Client_ID=? AND Name=? AND PK_Status='Completed successfully'");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Env.getAD_Client_ID((Properties)Env.getCtx()));
        params.add(this.getName());
        if (version != null) {
            where.append(" AND PK_Version LIKE ?");
            params.add(String.valueOf(version) + "%");
        }
        Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null).setParameters(params);
        return q.match();
    }

    public abstract String getName();

    public boolean getDBLock() throws AdempiereSystemError {
        int timeout = MSysConfig.getIntValue((String)"AUTOMATIC_PACKIN_TIMEOUT", (int)120);
        int maxAttempts = MSysConfig.getIntValue((String)"AUTOMATIC_PACKIN_RETRIES", (int)5);
        boolean lockAcquired = false;
        while (maxAttempts > 0 && !lockAcquired) {
            --maxAttempts;
            if (!this.getDBLock(timeout)) continue;
            lockAcquired = true;
        }
        return lockAcquired;
    }

    public void releaseLock() {
        Trx.get((String)this.trxName, (boolean)false).close();
    }

    private boolean getDBLock(int timeout) throws AdempiereSystemError {
        return DB.getDatabase().forUpdate(this.getLockPO(), timeout);
    }

    private PO getLockPO() throws AdempiereSystemError {
        MSysConfig sysconfig = (MSysConfig)new Query(Env.getCtx(), "AD_SysConfig", "Name=? AND AD_Client_ID=0", null).setParameters(new Object[]{"AUTOMATIC_PACKIN_PROCESSING"}).firstOnly();
        if (sysconfig == null) {
            throw new AdempiereSystemError("AUTOMATIC_PACKIN_PROCESSING SysConfig does not exist");
        }
        this.trxName = Trx.createTrxName((String)"ActSysTrx");
        Trx.get((String)this.trxName, (boolean)true).setDisplayName(String.valueOf(this.getClass().getName()) + "_getLockPO");
        sysconfig.set_TrxName(this.trxName);
        return sysconfig;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.m_processInfo = processInfo;
    }

    public void setProcessUI(IProcessUI processUI) {
        this.m_processUI = processUI;
    }

    protected void statusUpdate(String message) {
        logger.warning(message);
        if (this.m_processUI != null) {
            this.m_processUI.statusUpdate(message);
        }
    }

    public void addLog(Level level, String msg) {
        logger.log(level, msg);
        if (this.m_processInfo != null) {
            this.m_processInfo.addLog(0, null, null, msg.replaceAll("\\n", "<br>"));
        }
    }

    public void setSummary(Level level, String msg) {
        logger.log(level, msg);
        if (this.m_processInfo != null) {
            this.m_processInfo.setSummary(msg);
        }
    }
}

