/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpChannelOverHTTP2
extends HttpChannel
implements Closeable {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHTTP2.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private boolean _expect100Continue;
    private boolean _delayedUntilContent;

    public HttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
        super(connector, configuration, endPoint, (HttpTransport)transport);
    }

    protected IStream getStream() {
        return this.getHttpTransport().getStream();
    }

    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    public void setIdleTimeout(long timeoutMs) {
        this.getStream().setIdleTimeout(timeoutMs);
    }

    public long getIdleTimeout() {
        return this.getStream().getIdleTimeout();
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            String authority;
            MetaData.Request request = (MetaData.Request)frame.getMetaData();
            HttpFields fields = request.getFields();
            if (!fields.contains(HttpHeader.HOST) && (authority = request.getURI().getAuthority()) != null) {
                fields.put("host", authority);
            }
            this._expect100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            HttpFields response = this.getResponse().getHttpFields();
            if (this.getHttpConfiguration().getSendServerVersion()) {
                response.add(SERVER_VERSION);
            }
            if (this.getHttpConfiguration().getSendXPoweredBy()) {
                response.add(POWERED_BY);
            }
            this.onRequest(request);
            boolean endStream = frame.isEndStream();
            if (endStream) {
                this.onContentComplete();
                this.onRequestComplete();
            }
            boolean bl = this._delayedUntilContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && !endStream && !this._expect100Continue;
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 Request #{}/{}, delayed={}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), this._delayedUntilContent, System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), fields});
            }
            return this._delayedUntilContent ? null : this;
        }
        catch (BadMessageException x) {
            this.onBadMessage(x.getCode(), x.getReason());
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(500, null);
            return null;
        }
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this.onRequest(request);
            this.getRequest().setAttribute("org.eclipse.jetty.pushed", (Object)Boolean.TRUE);
            this.onContentComplete();
            this.onRequestComplete();
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 PUSH Request #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), request.getFields()});
            }
            return this;
        }
        catch (BadMessageException x) {
            this.onBadMessage(x.getCode(), x.getReason());
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(500, null);
            return null;
        }
    }

    public HttpTransportOverHTTP2 getHttpTransport() {
        return (HttpTransportOverHTTP2)super.getHttpTransport();
    }

    public void recycle() {
        this._expect100Continue = false;
        this._delayedUntilContent = false;
        super.recycle();
        this.getHttpTransport().recycle();
    }

    protected void commit(MetaData.Response info) {
        super.commit(info);
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Commit Response #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), info.getHttpVersion(), info.getStatus(), info.getReason(), System.lineSeparator(), info.getFields()});
        }
    }

    public Runnable onRequestContent(DataFrame frame, final Callback callback) {
        IStream stream = this.getStream();
        if (stream.isReset()) {
            this.consumeInput();
            callback.succeeded();
            return null;
        }
        final ByteBufferPool byteBufferPool = this.getByteBufferPool();
        ByteBuffer original = frame.getData();
        int length = original.remaining();
        final ByteBuffer copy = byteBufferPool.acquire(length, original.isDirect());
        BufferUtil.clearToFill((ByteBuffer)copy);
        copy.put(original);
        BufferUtil.flipToFlush((ByteBuffer)copy, (int)0);
        boolean handle = this.onContent(new HttpInput.Content(copy){

            public Invocable.InvocationType getInvocationType() {
                return callback.getInvocationType();
            }

            public void succeeded() {
                byteBufferPool.release(copy);
                callback.succeeded();
            }

            public void failed(Throwable x) {
                byteBufferPool.release(copy);
                callback.failed(x);
            }
        });
        boolean endStream = frame.isEndStream();
        if (endStream) {
            boolean handle_content = this.onContentComplete();
            boolean handle_request = this.onRequestComplete();
            handle |= handle_content | handle_request;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: {} bytes of {} content, handle: {}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), length, endStream ? "last" : "some", handle});
        }
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        return handle || wasDelayed ? this : null;
    }

    public Runnable onRequestTrailers(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getFields();
        if (trailers.size() > 0) {
            this.onTrailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Request #{}/{}, trailers:{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        boolean handle = this.onRequestComplete();
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        return handle || wasDelayed ? this : null;
    }

    public boolean isRequestIdle() {
        return this.getState().isIdle();
    }

    public boolean onStreamTimeout(Throwable failure, Consumer<Runnable> consumer) {
        boolean result = false;
        if (this.isRequestIdle()) {
            this.consumeInput();
            result = true;
        }
        this.getHttpTransport().onStreamTimeout(failure);
        if (this.getRequest().getHttpInput().onIdleTimeout(failure)) {
            consumer.accept(this::handleWithContext);
        }
        return result;
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        this.getHttpTransport().onStreamFailure(failure);
        boolean handle = this.getRequest().getHttpInput().failed(failure);
        this.consumeInput();
        return new FailureTask(failure, callback, handle);
    }

    protected void consumeInput() {
        this.getRequest().getHttpInput().consumeAll();
    }

    private void handleWithContext() {
        ContextHandler context = this.getState().getContextHandler();
        if (context != null) {
            context.handle(this.getRequest(), (Runnable)((Object)this));
        } else {
            this.handle();
        }
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    @Override
    public void close() {
        this.abort(new IOException("Unexpected close"));
    }

    public String toString() {
        IStream stream = this.getStream();
        long streamId = -1L;
        if (stream != null) {
            streamId = stream.getId();
        }
        return String.format("%s#%d", super.toString(), this.getStream() == null ? -1L : streamId);
    }

    private class FailureTask
    implements Runnable {
        private final Throwable failure;
        private final Callback callback;
        private final boolean handle;

        public FailureTask(Throwable failure, Callback callback, boolean handle) {
            this.failure = failure;
            this.callback = callback;
            this.handle = handle;
        }

        @Override
        public void run() {
            try {
                if (this.handle) {
                    HttpChannelOverHTTP2.this.handleWithContext();
                } else {
                    HttpChannelOverHTTP2.this.getState().asyncError(this.failure);
                }
                this.callback.succeeded();
            }
            catch (Throwable x) {
                this.callback.failed(x);
            }
        }
    }
}

