/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.process.ServerProcessCtl;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class Scheduler
extends AdempiereServer {
    protected StringBuffer m_summary = new StringBuffer();
    protected Trx m_trx = null;
    protected int AD_Scheduler_ID;
    private static CCache<Integer, MScheduler> s_cache = new CCache("AD_Scheduler", 10, 60, true);

    public Scheduler(MScheduler model) {
        super((AdempiereProcessor)model, 30);
        this.AD_Scheduler_ID = model.getAD_Scheduler_ID();
    }

    @Override
    protected void doWork() {
        block11: {
            MOrgInfo schedorg;
            this.m_summary = new StringBuffer(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).toString()).append(" - ");
            MClient schedclient = MClient.get((Properties)this.getCtx(), (int)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Client_ID", (int)schedclient.getAD_Client_ID());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Language", (String)schedclient.getAD_Language());
            Env.setContext((Properties)this.getCtx(), (String)"#AD_Org_ID", (int)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
            if (Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get((Properties)this.getCtx(), (int)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
                Env.setContext((Properties)this.getCtx(), (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
            }
            Env.setContext((Properties)this.getCtx(), (String)"#AD_User_ID", (int)this.getAD_User_ID());
            Env.setContext((Properties)this.getCtx(), (String)"#SalesRep_ID", (int)this.getAD_User_ID());
            MUser scheduser = MUser.get((Properties)this.getCtx(), (int)this.getAD_User_ID());
            MRole[] schedroles = scheduser.getRoles(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
            if (schedroles != null && schedroles.length > 0) {
                Env.setContext((Properties)this.getCtx(), (String)"#AD_Role_ID", (int)schedroles[0].getAD_Role_ID());
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
            Env.setContext((Properties)this.getCtx(), (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
            MProcess process = new MProcess(this.getCtx(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Process_ID(), null);
            try {
                try {
                    this.m_trx = Trx.get((String)Trx.createTrxName((String)"Scheduler"), (boolean)true);
                    this.m_trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_" + this.getModel().getName() + "_doWork");
                    this.m_summary.append(this.runProcess(process));
                    this.m_trx.commit(true);
                }
                catch (Throwable e) {
                    if (this.m_trx != null) {
                        this.m_trx.rollback();
                    }
                    this.log.log(Level.WARNING, process.toString(), e);
                    this.m_summary.append(e.toString());
                    if (this.m_trx != null) {
                        this.m_trx.close();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (this.m_trx != null) {
                    this.m_trx.close();
                }
                throw throwable;
            }
            if (this.m_trx != null) {
                this.m_trx.close();
            }
        }
        int no = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).deleteLog();
        this.m_summary.append(" Logs deleted=").append(no);
        MSchedulerLog pLog = new MSchedulerLog(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID), this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed((Timestamp)new Timestamp(this.p_startWork)));
        pLog.saveEx();
    }

    protected String runProcess(MProcess process) throws Exception {
        Integer[] userIDs;
        int supervisor;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(process.toString());
        }
        boolean isReport = process.isReport() || process.getAD_ReportView_ID() > 0 || process.getJasperReport() != null || process.getAD_PrintFormat_ID() > 0;
        String schedulerName = Env.parseContext((Properties)this.getCtx(), (int)-1, (String)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getName(), (boolean)false, (boolean)true);
        int AD_Table_ID = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Table_ID();
        int Record_ID = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getRecord_ID();
        MPInstance pInstance = new MPInstance(process, Record_ID);
        this.fillParameter(pInstance);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_Client_ID(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        pi.setIsBatch(true);
        pi.setPrintPreview(true);
        MUser from = new MUser(this.getCtx(), pi.getAD_User_ID().intValue(), null);
        pi.setTransactionName(this.m_trx != null ? this.m_trx.getTrxName() : null);
        ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.m_trx);
        if (pi.isError() && (supervisor = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getSupervisor_ID()) > 0) {
            MUser user = new MUser(this.getCtx(), supervisor, null);
            boolean email = user.isNotificationEMail();
            boolean notice = user.isNotificationNote();
            if (email || notice) {
                ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
            }
            if (email) {
                MClient client = MClient.get((Properties)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getCtx(), (int)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID());
                client.sendEMail(from, user, schedulerName, String.valueOf(pi.getSummary()) + " " + pi.getLogInfo(), null);
            }
            if (notice) {
                int AD_Message_ID = 442;
                MNote note = new MNote(this.getCtx(), AD_Message_ID, supervisor, null);
                note.setClientOrg(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
                note.setTextMsg(String.valueOf(schedulerName) + "\n" + pi.getSummary());
                note.setRecord(282, pi.getAD_PInstance_ID());
                note.saveEx();
                String log = pi.getLogInfo(true);
                if (log != null && log.trim().length() > 0) {
                    MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), null);
                    attachment.setClientOrg(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
                    attachment.setTextMsg(schedulerName);
                    attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                    attachment.saveEx();
                }
            }
        }
        if ((userIDs = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getRecipientAD_User_IDs()).length > 0) {
            ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
            ArrayList<File> fileList = new ArrayList<File>();
            if (isReport) {
                fileList.add(pi.getPDFReport());
            }
            if (pi.isExport() && pi.getExportFile() != null) {
                fileList.add(pi.getExportFile());
            }
            int i = 0;
            while (i < userIDs.length) {
                MUser user = new MUser(this.getCtx(), userIDs[i].intValue(), null);
                boolean email = user.isNotificationEMail();
                boolean notice = user.isNotificationNote();
                if (notice) {
                    int AD_Message_ID = 441;
                    if (isReport) {
                        AD_Message_ID = 884;
                    }
                    MNote note = new MNote(this.getCtx(), AD_Message_ID, userIDs[i].intValue(), null);
                    note.setClientOrg(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
                    if (isReport) {
                        note.setTextMsg(schedulerName);
                        note.setDescription(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getDescription());
                        note.setRecord(AD_Table_ID, Record_ID);
                    } else {
                        note.setTextMsg(String.valueOf(schedulerName) + "\n" + pi.getSummary());
                        note.setRecord(282, pi.getAD_PInstance_ID());
                    }
                    if (note.save()) {
                        String log;
                        MAttachment attachment = null;
                        if (fileList != null && !fileList.isEmpty()) {
                            attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), null);
                            attachment.setClientOrg(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
                            attachment.setTextMsg(schedulerName);
                            for (File entry : fileList) {
                                attachment.addEntry(entry);
                            }
                        }
                        if ((log = pi.getLogInfo(true)) != null && log.trim().length() > 0) {
                            if (attachment == null) {
                                attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), null);
                                attachment.setClientOrg(Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Org_ID());
                                attachment.setTextMsg(schedulerName);
                            }
                            attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                            attachment.saveEx();
                        }
                        if (attachment != null) {
                            attachment.saveEx();
                        }
                    }
                }
                if (email) {
                    MMailText mailTemplate = new MMailText(this.getCtx(), Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getR_MailText_ID(), null);
                    String mailContent = "";
                    if (mailTemplate.is_new()) {
                        mailContent = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getDescription();
                    } else {
                        mailTemplate.setUser(user);
                        mailTemplate.setLanguage(Env.getContext((Properties)this.getCtx(), (String)"#AD_Language"));
                        mailContent = mailTemplate.getMailText(true);
                        schedulerName = mailTemplate.getMailHeader();
                    }
                    MClient client = MClient.get((Properties)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getCtx(), (int)Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getAD_Client_ID());
                    if (fileList != null && !fileList.isEmpty()) {
                        client.sendEMailAttachments(from, user, schedulerName, mailContent, fileList);
                    } else {
                        client.sendEMail(from, user, schedulerName, String.valueOf(mailContent) + "\n" + pi.getSummary() + " " + pi.getLogInfo(), null);
                    }
                }
                ++i;
            }
            for (File file : fileList) {
                if (!file.exists() || file.delete()) continue;
                file.deleteOnExit();
            }
        }
        return pi.getSummary();
    }

    protected int getAD_User_ID() {
        int AD_User_ID = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getSupervisor_ID() > 0 ? Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getSupervisor_ID() : (Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getCreatedBy() > 0 ? Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getCreatedBy() : (Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getUpdatedBy() > 0 ? Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getUpdatedBy() : 100));
        return AD_User_ID;
    }

    protected void fillParameter(MPInstance pInstance) {
        MSchedulerPara[] sParams = Scheduler.get(this.getCtx(), this.AD_Scheduler_ID).getParameters(false);
        MPInstancePara[] iParams = pInstance.getParameters();
        int pi = 0;
        while (pi < iParams.length) {
            MPInstancePara iPara = iParams[pi];
            int np = 0;
            while (np < sParams.length) {
                MSchedulerPara sPara = sParams[np];
                if (iPara.getParameterName().equals(sPara.getColumnName())) {
                    Object toValue;
                    String paraDesc = sPara.getDescription();
                    if (paraDesc != null && paraDesc.trim().length() > 0) {
                        iPara.setInfo(sPara.getDescription());
                    }
                    String variable = sPara.getParameterDefault();
                    String toVariable = sPara.getParameterToDefault();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable);
                    }
                    Object value = this.parseVariable(sPara, variable);
                    Object object = toValue = toVariable != null ? this.parseVariable(sPara, toVariable) : null;
                    if (value == null && toValue == null) {
                        if (!this.log.isLoggable(Level.FINE)) break;
                        this.log.fine(String.valueOf(sPara.getColumnName()) + " - empty");
                        break;
                    }
                    try {
                        String info;
                        if (DisplayType.isNumeric((int)sPara.getDisplayType()) || DisplayType.isID((int)sPara.getDisplayType())) {
                            DecimalFormat decimalFormat = DisplayType.getNumberFormat((int)sPara.getDisplayType());
                            BigDecimal bd = this.toBigDecimal(value);
                            iPara.setP_Number(bd);
                            if (toValue != null) {
                                bd = this.toBigDecimal(toValue);
                                iPara.setP_Number_To(bd);
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                info = decimalFormat.format(iPara.getP_Number());
                                if (iPara.getP_Number_To() != null) {
                                    info = String.valueOf(info) + " - " + decimalFormat.format(iPara.getP_Number_To());
                                }
                                iPara.setInfo(info);
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + bd + "=)");
                            }
                        } else if (DisplayType.isDate((int)sPara.getDisplayType())) {
                            SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)sPara.getDisplayType());
                            Timestamp ts = this.toTimestamp(value);
                            iPara.setP_Date(ts);
                            if (toValue != null) {
                                ts = this.toTimestamp(toValue);
                                iPara.setP_Date_To(ts);
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                info = dateFormat.format(iPara.getP_Date());
                                if (iPara.getP_Date_To() != null) {
                                    info = String.valueOf(info) + " - " + dateFormat.format(iPara.getP_Date_To());
                                }
                                iPara.setInfo(info);
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + ts + "=)");
                            }
                        } else {
                            iPara.setP_String(value.toString());
                            if (toValue != null) {
                                iPara.setP_String_To(toValue.toString());
                            }
                            if (Util.isEmpty((String)paraDesc)) {
                                String info2 = iPara.getP_String();
                                if (iPara.getP_String_To() != null) {
                                    info2 = String.valueOf(info2) + " - " + iPara.getP_String_To();
                                }
                                iPara.setInfo(info2);
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(String.valueOf(sPara.getColumnName()) + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                            }
                        }
                        if (iPara.save()) break;
                        this.log.warning("Not Saved - " + sPara.getColumnName());
                    }
                    catch (Exception e) {
                        this.log.warning(String.valueOf(sPara.getColumnName()) + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                    }
                    break;
                }
                ++np;
            }
            ++pi;
        }
    }

    private Timestamp toTimestamp(Object value) {
        Timestamp ts = null;
        ts = value instanceof Timestamp ? (Timestamp)value : Timestamp.valueOf(value.toString());
        return ts;
    }

    private BigDecimal toBigDecimal(Object value) {
        BigDecimal bd = null;
        bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
        return bd;
    }

    private Object parseVariable(MSchedulerPara sPara, String variable) {
        Object value = variable;
        if (variable == null || variable != null && variable.length() == 0) {
            value = null;
        } else if (variable.startsWith("@SQL=")) {
            String defStr;
            block29: {
                defStr = "";
                String sql = variable.substring(5);
                sql = Env.parseContext((Properties)this.getCtx(), (int)0, (String)sql, (boolean)false, (boolean)false);
                if (sql.equals("")) {
                    this.log.log(Level.WARNING, "(" + sPara.getColumnName() + ") - Default SQL variable parse failed: " + variable);
                } else {
                    CPreparedStatement stmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            stmt = DB.prepareStatement((String)sql, null);
                            rs = stmt.executeQuery();
                            if (rs.next()) {
                                defStr = rs.getString(1);
                            } else if (this.log.isLoggable(Level.INFO)) {
                                this.log.log(Level.INFO, "(" + sPara.getColumnName() + ") - no Result: " + sql);
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.WARNING, "(" + sPara.getColumnName() + ") " + sql, (Throwable)e);
                            DB.close((ResultSet)rs, (Statement)stmt);
                            rs = null;
                            stmt = null;
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                }
            }
            if (!Util.isEmpty((String)defStr)) {
                value = defStr;
            }
        } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
            int index = variable.indexOf(64);
            String columnName = variable.substring(index + 1);
            if ((index = columnName.indexOf(64)) == -1) {
                this.log.warning(String.valueOf(sPara.getColumnName()) + " - cannot evaluate=" + variable);
                return null;
            }
            String tail = index < columnName.length() - 1 ? columnName.substring(index + 1) : null;
            columnName = columnName.substring(0, index);
            String env = Env.getContext((Properties)this.getCtx(), (String)columnName);
            if (env == null || env.length() == 0) {
                env = Env.getContext((Properties)this.getCtx(), (String)columnName);
            }
            if (env.length() == 0) {
                this.log.warning(String.valueOf(sPara.getColumnName()) + " - not in environment =" + columnName + "(" + variable + ")");
                return null;
            }
            value = env;
            if (tail != null && columnName.equals("#Date") && ((tail = tail.trim()).startsWith("-") || tail.startsWith("+"))) {
                boolean negate = tail.startsWith("-");
                int type = 5;
                if ((tail = tail.substring(1)).endsWith("d")) {
                    tail = tail.substring(0, tail.length() - 1);
                } else if (tail.endsWith("m")) {
                    type = 2;
                    tail = tail.substring(0, tail.length() - 1);
                } else if (tail.endsWith("y")) {
                    type = 1;
                    tail = tail.substring(0, tail.length() - 1);
                }
                int toApply = 0;
                try {
                    toApply = Integer.parseInt(tail);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (toApply > 0) {
                    if (negate) {
                        toApply *= -1;
                    }
                    Timestamp ts = this.toTimestamp(value);
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(ts.getTime());
                    cal.add(type, toApply);
                    value = new Timestamp(cal.getTimeInMillis());
                }
            }
        }
        return value;
    }

    @Override
    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    protected static MScheduler get(Properties ctx, int AD_Scheduler_ID) {
        Integer key = new Integer(AD_Scheduler_ID);
        MScheduler retValue = (MScheduler)s_cache.get((Object)key);
        if (retValue == null) {
            retValue = new MScheduler(ctx, AD_Scheduler_ID, null);
            if (AD_Scheduler_ID == 0) {
                String trxName = null;
                retValue.load(trxName);
            }
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }
}

