/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.EMailAuthenticator;

public class EMailProcessor {
    protected String m_host = null;
    protected String m_user = null;
    protected String m_pass = null;
    protected Session m_session = null;
    protected Store m_store = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    protected static final int ERROR = 0;
    protected static final int REQUEST = 1;
    protected static final int WORKFLOW = 2;
    protected static final int DELIVERY = 9;

    public EMailProcessor(MClient client) {
        this(client.getSMTPHost(), client.getRequestUser(), client.getRequestUserPW());
    }

    public EMailProcessor(String host, String user, String password) {
        this.m_host = host;
        this.m_user = user;
        this.m_pass = password;
    }

    public int processMessages() {
        int processed = 0;
        try {
            this.getSession();
            this.getStore();
            processed = this.processInBox();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processInBox", (Throwable)e);
        }
        try {
            if (this.m_store.isConnected()) {
                this.m_store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_store = null;
        return processed;
    }

    protected Session getSession() throws Exception {
        if (this.m_session != null) {
            return this.m_session;
        }
        Properties props = System.getProperties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", this.m_host);
        props.put("mail.smtp.auth", "true");
        EMailAuthenticator auth = new EMailAuthenticator(this.m_user, this.m_pass);
        this.m_session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        this.m_session.setDebug(CLogMgt.isLevelFinest());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getSession - " + this.m_session);
        }
        return this.m_session;
    }

    protected Store getStore() throws Exception {
        if (this.m_store != null) {
            return this.m_store;
        }
        if (this.getSession() == null) {
            throw new IllegalStateException("No Session");
        }
        this.m_store = this.m_session.getStore("imap");
        this.m_store.connect();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getStore - " + this.m_store);
        }
        return this.m_store;
    }

    protected int processInBox() throws Exception {
        Folder requestFolder;
        Folder folder = this.m_store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default folder");
        }
        Folder inbox = folder.getFolder("INBOX");
        if (!inbox.exists()) {
            throw new IllegalStateException("No Inbox");
        }
        inbox.open(2);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("processInBox - " + inbox.getName() + "; Messages Total=" + inbox.getMessageCount() + "; New=" + inbox.getNewMessageCount());
        }
        if (!(requestFolder = folder.getFolder("CRequest")).exists() && !requestFolder.create(1)) {
            throw new IllegalStateException("Cannot create Request Folder");
        }
        requestFolder.open(2);
        Folder workflowFolder = folder.getFolder("CWorkflow");
        if (!workflowFolder.exists() && !workflowFolder.create(1)) {
            throw new IllegalStateException("Cannot create Workflow Folder");
        }
        workflowFolder.open(2);
        Folder errorFolder = folder.getFolder("AdempiereError");
        if (!errorFolder.exists() && !errorFolder.create(1)) {
            throw new IllegalStateException("Cannot create Error Folder");
        }
        errorFolder.open(2);
        Message[] messages = inbox.getMessages();
        int noProcessed = 0;
        int noError = 0;
        int i = 0;
        while (i < messages.length) {
            Message msg = messages[i];
            int result = this.processMessage(msg);
            if (result == 1) {
                msg.setFlag(Flags.Flag.SEEN, true);
                msg.setFlag(Flags.Flag.ANSWERED, true);
                requestFolder.appendMessages(new Message[]{msg});
            } else if (result == 2) {
                msg.setFlag(Flags.Flag.SEEN, true);
                msg.setFlag(Flags.Flag.ANSWERED, true);
                workflowFolder.appendMessages(new Message[]{msg});
            } else if (result == 9) {
                msg.setFlag(Flags.Flag.SEEN, true);
                msg.setFlag(Flags.Flag.ANSWERED, true);
            } else {
                errorFolder.appendMessages(new Message[]{msg});
                ++noError;
            }
            ++noProcessed;
            ++i;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("processInBox - Total=" + noProcessed + " - Errors=" + noError);
        }
        errorFolder.close(false);
        requestFolder.close(false);
        workflowFolder.close(false);
        inbox.close(true);
        return noProcessed;
    }

    protected int processMessage(Message msg) throws Exception {
        this.dumpEnvelope(msg);
        this.dumpBody((Part)msg);
        EMailProcessor.printOut(":::::::::::::::");
        EMailProcessor.printOut(this.getSubject(msg));
        EMailProcessor.printOut(":::::::::::::::");
        EMailProcessor.printOut(this.getMessage((Part)msg));
        EMailProcessor.printOut(":::::::::::::::");
        String delivery = this.getDeliveryReport((Part)msg);
        EMailProcessor.printOut(delivery);
        EMailProcessor.printOut(":::::::::::::::");
        return 0;
    }

    protected String getSubject(Message msg) {
        try {
            String str = msg.getSubject();
            if (str != null) {
                return str.trim();
            }
        }
        catch (MessagingException e) {
            this.log.log(Level.SEVERE, "getSubject", (Throwable)e);
        }
        return "";
    }

    protected String getMessage(Part msg) {
        StringBuilder sb = new StringBuilder();
        try {
            if (msg.isMimeType("text/plain")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("text/*")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("message/rfc822")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("multipart/alternative")) {
                String plainText = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    BodyPart part = mp.getBodyPart(i);
                    Object content = part.getContent();
                    if (content != null && content.toString().trim().length() != 0) {
                        if (part.isMimeType("text/plain")) {
                            plainText = content.toString();
                        } else {
                            otherStuff = content.toString();
                        }
                    }
                    ++i;
                }
                if (plainText != null) {
                    sb.append(plainText);
                } else if (otherStuff != null) {
                    sb.append(otherStuff);
                }
            } else if (msg.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    String str = this.getMessage((Part)mp.getBodyPart(i));
                    if (str.length() > 0) {
                        if (sb.length() > 0) {
                            sb.append("\n-----\n");
                        }
                        sb.append(str);
                    }
                    ++i;
                }
            } else {
                Object o = msg.getContent();
                if (o instanceof String) {
                    sb.append(o);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getMessage", (Throwable)e);
        }
        return sb.toString().trim();
    }

    protected String getDeliveryReport(Part msg) {
        try {
            if (msg.isMimeType("multipart/report")) {
                String deliveryMessage = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    BodyPart part = mp.getBodyPart(i);
                    Object content = part.getContent();
                    if (content != null) {
                        if (part.isMimeType("message/*")) {
                            deliveryMessage = this.getDeliveredReportDetail((Part)part);
                        } else {
                            otherStuff = content.toString().trim();
                        }
                    }
                    ++i;
                }
                if (deliveryMessage != null) {
                    return deliveryMessage;
                }
                return otherStuff;
            }
            if (msg.isMimeType("message/*")) {
                return this.getDeliveredReportDetail(msg);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getDeliveryReport", (Throwable)e);
        }
        return null;
    }

    protected String getDeliveredReportDetail(Part part) throws Exception {
        String finalRecipient;
        int atIndex;
        Object content = part.getContent();
        if (content == null) {
            return null;
        }
        String deliveryMessage = null;
        if (content instanceof InputStream) {
            int c;
            StringBuilder sb = new StringBuilder();
            InputStream is = (InputStream)content;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            is.close();
            deliveryMessage = sb.toString().trim();
        } else {
            deliveryMessage = content.toString().trim();
        }
        if (deliveryMessage == null) {
            return null;
        }
        int index = deliveryMessage.indexOf("Final-Recipient:");
        if (index != -1 && (atIndex = (finalRecipient = deliveryMessage.substring(index)).indexOf(64)) != -1) {
            index = finalRecipient.lastIndexOf(32, atIndex);
            if (index != -1) {
                finalRecipient = finalRecipient.substring(index + 1);
            }
            if ((atIndex = finalRecipient.indexOf(64)) != -1) {
                index = finalRecipient.indexOf(32, atIndex);
            }
            if (index != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            if ((index = finalRecipient.indexOf(10)) != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            return finalRecipient.trim();
        }
        return deliveryMessage;
    }

    protected void dumpEnvelope(Message m) throws Exception {
        int i;
        StringBuilder sb1;
        int j;
        EMailProcessor.printOut("-----------------------------------------------------------------");
        Address[] a = m.getFrom();
        if (a != null) {
            j = 0;
            while (j < a.length) {
                EMailProcessor.printOut("FROM: " + a[j].toString());
                ++j;
            }
        }
        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
            j = 0;
            while (j < a.length) {
                EMailProcessor.printOut("TO: " + a[j].toString());
                ++j;
            }
        }
        EMailProcessor.printOut("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        EMailProcessor.printOut("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        Flags flags = m.getFlags();
        StringBuilder sb = new StringBuilder();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        int i2 = 0;
        while (i2 < sf.length) {
            block26: {
                String s;
                block21: {
                    Flags.Flag f;
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block20: {
                                        f = sf[i2];
                                        if (f != Flags.Flag.ANSWERED) break block20;
                                        s = "\\Answered";
                                        break block21;
                                    }
                                    if (f != Flags.Flag.DELETED) break block22;
                                    s = "\\Deleted";
                                    break block21;
                                }
                                if (f != Flags.Flag.DRAFT) break block23;
                                s = "\\Draft";
                                break block21;
                            }
                            if (f != Flags.Flag.FLAGGED) break block24;
                            s = "\\Flagged";
                            break block21;
                        }
                        if (f != Flags.Flag.RECENT) break block25;
                        s = "\\Recent";
                        break block21;
                    }
                    if (f != Flags.Flag.SEEN) break block26;
                    s = "\\Seen";
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(s);
            }
            ++i2;
        }
        String[] uf = flags.getUserFlags();
        int i3 = 0;
        while (i3 < uf.length) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i3]);
            ++i3;
        }
        EMailProcessor.printOut("FLAGS: " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            sb1 = new StringBuilder("X-Mailer: ");
            i = 0;
            while (i < hdrs.length) {
                sb1.append(hdrs[i]).append("  ");
                ++i;
            }
            EMailProcessor.printOut(sb1.toString());
        } else {
            EMailProcessor.printOut("X-Mailer NOT available");
        }
        hdrs = m.getHeader("Message-ID");
        if (hdrs != null) {
            sb1 = new StringBuilder("Message-ID: ");
            i = 0;
            while (i < hdrs.length) {
                sb1.append(hdrs[i]).append("  ");
                ++i;
            }
            EMailProcessor.printOut(sb1.toString());
        } else {
            EMailProcessor.printOut("Message-ID NOT available");
        }
        EMailProcessor.printOut("ALL HEADERs:");
        Enumeration en = m.getAllHeaders();
        while (en.hasMoreElements()) {
            Header hdr = (Header)en.nextElement();
            EMailProcessor.printOut("  " + hdr.getName() + " = " + hdr.getValue());
        }
        EMailProcessor.printOut("-----------------------------------------------------------------");
    }

    protected void dumpBody(Part p) throws Exception {
        EMailProcessor.printOut("=================================================================");
        EMailProcessor.printOut("CONTENT-TYPE: " + p.getContentType());
        if (p.isMimeType("text/plain")) {
            EMailProcessor.printOut("Plain text ---------------------------");
            System.out.println((String)p.getContent());
        } else if (p.getContentType().toUpperCase().startsWith("TEXT")) {
            EMailProcessor.printOut("Other text ---------------------------");
            System.out.println((String)p.getContent());
        } else if (p.isMimeType("multipart/*")) {
            EMailProcessor.printOut("Multipart ---------------------------");
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            int i = 0;
            while (i < count) {
                this.dumpBody((Part)mp.getBodyPart(i));
                ++i;
            }
        } else if (p.isMimeType("message/rfc822")) {
            EMailProcessor.printOut("Nested ---------------------------");
            this.dumpBody((Part)p.getContent());
        } else {
            Object o = p.getContent();
            if (o instanceof String) {
                EMailProcessor.printOut("This is a string ---------------------------");
                System.out.println((String)o);
            } else if (o instanceof InputStream) {
                int c;
                EMailProcessor.printOut("This is just an input stream ---------------------------");
                InputStream is = (InputStream)o;
                while ((c = is.read()) != -1) {
                    System.out.write(c);
                }
                is.close();
            } else {
                EMailProcessor.printOut("This is an unknown type ---------------------------");
                EMailProcessor.printOut(o.toString());
            }
        }
        EMailProcessor.printOut("=================================================================");
    }

    protected static void printOut(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment((boolean)true);
        EMailProcessor m = new EMailProcessor("admin", "test", "testadempiere");
        m.processMessages();
    }
}

