/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.ServerContext;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MSchedule;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public abstract class AdempiereServer
implements Runnable {
    protected volatile AdempiereProcessor p_model;
    private int m_initialNap = 0;
    protected long m_sleepMS = 0L;
    private volatile boolean m_sleeping = true;
    protected long m_start = 0L;
    protected int p_runCount = 0;
    protected long p_startWork = 0L;
    private long m_runLastMS = 0L;
    private long m_runTotalMS = 0L;
    private long m_nextWork = 0L;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    protected static volatile MSystem p_system = null;
    protected MClient p_client = null;

    protected AdempiereServer(AdempiereProcessor model, int initialNap) {
        long now;
        this.p_model = model;
        if (p_system == null) {
            p_system = MSystem.get((Properties)model.getCtx());
        }
        this.p_client = MClient.get((Properties)model.getCtx(), (int)model.getAD_Client_ID());
        this.m_initialNap = initialNap;
        Timestamp dateNextRun = this.getDateNextRun(true);
        if (dateNextRun != null) {
            this.m_nextWork = dateNextRun.getTime();
        }
        if (this.m_nextWork > (now = System.currentTimeMillis())) {
            this.m_sleepMS = this.m_nextWork - now;
        }
    }

    public Properties getCtx() {
        return Env.getCtx();
    }

    public void recalculateSleepMS() {
        if (this.p_model instanceof PO) {
            PO po = (PO)this.p_model;
            po.load(null);
        }
        this.m_sleepMS = 0L;
        this.m_nextWork = 0L;
        Timestamp dateNextRun = this.getDateNextRun(true);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.m_nextWork = dateNextRun != null ? dateNextRun.getTime() : MSchedule.getNextRunMS((long)now.getTime(), (String)this.p_model.getScheduleType(), (String)this.p_model.getFrequencyType(), (int)this.p_model.getFrequency(), (String)this.p_model.getCronPattern());
        if (this.m_nextWork > now.getTime()) {
            this.m_sleepMS = this.m_nextWork - now.getTime();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(" Next run: " + new Timestamp(this.m_nextWork) + " sleep " + this.m_sleepMS);
        }
        this.p_model.setDateNextRun(new Timestamp(this.m_nextWork));
        this.p_model.saveEx();
    }

    public long getSleepMS() {
        return this.m_sleepMS;
    }

    public long getInitialNap() {
        return this.m_initialNap;
    }

    public void runNow() {
        Properties context = new Properties();
        MClient schedclient = MClient.get((Properties)this.getCtx(), (int)this.p_model.getAD_Client_ID());
        Env.setContext((Properties)context, (String)"#AD_Client_ID", (int)schedclient.getAD_Client_ID());
        Env.setContext((Properties)context, (String)"#AD_Language", (String)schedclient.getAD_Language());
        if (this.p_model instanceof PO) {
            int AD_User_ID;
            PO po = (PO)this.p_model;
            if (po.get_ColumnIndex("AD_Org_ID") >= 0) {
                Env.setContext((Properties)context, (String)"#AD_Org_ID", (int)po.get_ValueAsInt("AD_Org_ID"));
                MOrgInfo schedorg = (MOrgInfo)new Query(context, "AD_OrgInfo", "AD_Org_ID=?", null).setParameters(new Object[]{po.get_ValueAsInt("AD_Org_ID")}).first();
                if (schedorg != null && schedorg.getM_Warehouse_ID() > 0) {
                    Env.setContext((Properties)context, (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
                }
            }
            if ((AD_User_ID = this.getAD_User_ID(po)) > 0) {
                Env.setContext((Properties)context, (String)"#AD_User_ID", (int)AD_User_ID);
                Env.setContext((Properties)context, (String)"#SalesRep_ID", (int)AD_User_ID);
                MUser scheduser = new MUser(context, AD_User_ID, null);
                MRole[] schedroles = scheduser.getRoles(po.get_ValueAsInt("AD_Org_ID"));
                if (schedroles != null && schedroles.length > 0) {
                    Env.setContext((Properties)context, (String)"#AD_Role_ID", (int)schedroles[0].getAD_Role_ID());
                }
            }
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext((Properties)context, (String)"#Date", (String)(String.valueOf(dateFormat4Timestamp.format(ts)) + " 00:00:00"));
        Properties prevContext = ServerContext.getCurrentInstance();
        try {
            ServerContext.setCurrentInstance((Properties)context);
            this.m_sleeping = false;
            this.doRunNow();
        }
        finally {
            ServerContext.dispose();
            ServerContext.setCurrentInstance((Properties)prevContext);
            this.m_sleeping = true;
        }
    }

    private int getAD_User_ID(PO po) {
        int AD_User_ID = -1;
        AD_User_ID = po.get_ValueAsInt("Supervisor_ID") > 0 ? po.get_ValueAsInt("Supervisor_ID") : (po.get_ValueAsInt("CreatedBy") > 0 ? po.get_ValueAsInt("CreatedBy") : (po.get_ValueAsInt("UpdatedBy") > 0 ? po.get_ValueAsInt("UpdatedBy") : 100));
        return AD_User_ID;
    }

    public void doRunNow() {
        this.p_startWork = System.currentTimeMillis();
        this.doWork();
        long now = System.currentTimeMillis();
        ++this.p_runCount;
        this.m_runLastMS = now - this.p_startWork;
        this.m_runTotalMS += this.m_runLastMS;
        this.p_model.setDateLastRun(new Timestamp(now));
        this.p_model.saveEx();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.getStatistics());
        }
    }

    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        String newThreadName = this.getName();
        boolean renamed = false;
        if (!oldThreadName.equals(newThreadName)) {
            try {
                currentThread.setName(newThreadName);
                renamed = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        Properties context = new Properties();
        Env.setContext((Properties)context, (String)"#AD_Client_ID", (int)this.p_model.getAD_Client_ID());
        if (this.p_model instanceof PO) {
            PO po = (PO)this.p_model;
            if (po.get_ColumnIndex("AD_Org_ID") >= 0) {
                Env.setContext((Properties)context, (String)"#AD_Org_ID", (int)po.get_ValueAsInt("AD_Org_ID"));
            }
            if (po.get_ColumnIndex("AD_User_ID") >= 0) {
                Env.setContext((Properties)context, (String)"#AD_User_ID", (int)po.get_ValueAsInt("AD_User_ID"));
            }
        }
        try {
            ServerContext.setCurrentInstance((Properties)context);
            this.m_sleeping = false;
            this.doRun();
        }
        finally {
            this.m_sleeping = true;
            ServerContext.dispose();
            if (renamed) {
                currentThread.setName(oldThreadName);
            }
        }
    }

    protected void doRun() {
        AdempiereProcessor2 ap;
        if (this.m_start == 0L) {
            this.m_start = System.currentTimeMillis();
        }
        this.p_startWork = System.currentTimeMillis();
        this.doWork();
        long now = System.currentTimeMillis();
        ++this.p_runCount;
        this.m_runLastMS = now - this.p_startWork;
        this.m_runTotalMS += this.m_runLastMS;
        Timestamp lastRun = new Timestamp(now);
        if (this.p_model instanceof AdempiereProcessor2 && (ap = (AdempiereProcessor2)this.p_model).isIgnoreProcessingTime()) {
            lastRun = new Timestamp(this.p_startWork);
        }
        this.m_nextWork = MSchedule.getNextRunMS((long)lastRun.getTime(), (String)this.p_model.getScheduleType(), (String)this.p_model.getFrequencyType(), (int)this.p_model.getFrequency(), (String)this.p_model.getCronPattern());
        this.m_sleepMS = this.m_nextWork - now;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(" Next run: " + new Timestamp(this.m_nextWork) + " sleep " + this.m_sleepMS);
        }
        this.p_model.setDateLastRun(lastRun);
        this.p_model.setDateNextRun(new Timestamp(this.m_nextWork));
        this.p_model.saveEx();
    }

    public String getStatistics() {
        return "Run #" + this.p_runCount + " - Last=" + TimeUtil.formatElapsed((long)this.m_runLastMS) + " - Total=" + TimeUtil.formatElapsed((long)this.m_runTotalMS) + " - Next " + TimeUtil.formatElapsed((long)(this.m_nextWork - System.currentTimeMillis()));
    }

    protected abstract void doWork();

    public abstract String getServerInfo();

    public String getServerID() {
        return this.p_model.getServerID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        return this.p_model.getDateNextRun(requery);
    }

    public Timestamp getDateLastRun() {
        return this.p_model.getDateLastRun();
    }

    public String getDescription() {
        return this.p_model.getDescription();
    }

    public AdempiereProcessor getModel() {
        return this.p_model;
    }

    public boolean isSleeping() {
        return this.m_sleeping;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("Sleeping=").append(this.m_sleeping).append(",Last=").append(this.getDateLastRun());
        if (this.m_sleeping) {
            sb.append(",Next=").append(this.getDateNextRun(false));
        }
        return sb.toString();
    }

    public int getSecondsAlive() {
        if (this.m_start == 0L) {
            return 0;
        }
        long now = System.currentTimeMillis();
        long ms = (now - this.m_start) / 1000L;
        return (int)ms;
    }

    public Timestamp getStartTime() {
        if (this.m_start == 0L) {
            return null;
        }
        return new Timestamp(this.m_start);
    }

    public AdempiereProcessorLog[] getLogs() {
        return this.p_model.getLogs();
    }

    protected boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public String getName() {
        return this.p_model.getName();
    }

    public static boolean isOKtoRunOnIP(AdempiereProcessor model) {
        if (model instanceof AdempiereProcessor2) {
            int AD_Schedule_ID = ((AdempiereProcessor2)model).getAD_Schedule_ID();
            MSchedule schedule = MSchedule.get((Properties)Env.getCtx(), (int)AD_Schedule_ID);
            if (!schedule.isOKtoRunOnIP()) {
                return false;
            }
        }
        return true;
    }
}

