/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.web.server;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.restlet.security.SecretVerifier;

public class BasicVerifier
extends SecretVerifier {
    private static final CLogger log = CLogger.getCLogger(BasicVerifier.class);

    public int verify(String identity, char[] password) throws IllegalArgumentException {
        if (identity.startsWith("AD_Session_ID#")) {
            String sessionId = identity.substring("AD_Session_ID#".length());
            int AD_Session_ID = 0;
            try {
                AD_Session_ID = Integer.parseInt(sessionId);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Invalid session token: " + identity);
                return -1;
            }
            MSession session = new MSession(Env.getCtx(), AD_Session_ID, null);
            if (session.getAD_Session_ID() != AD_Session_ID) {
                log.log(Level.WARNING, "Session not exists in database: " + identity);
                return -1;
            }
            if (session.isProcessed()) {
                log.log(Level.WARNING, "Session have logout: " + identity);
                return -1;
            }
            if (!session.isActive()) {
                log.log(Level.WARNING, "Session isActive=false: " + identity);
                return -1;
            }
            if (!session.getWebSession().equals(new String(password))) {
                log.log(Level.WARNING, "Session token doesn't match. identity=" + identity + ", token=" + new String(password));
            }
            return 4;
        }
        Login login = new Login(new Properties());
        KeyNamePair[] roles = login.getRoles(identity, new String(password));
        return roles != null && roles.length > 0 ? 4 : -1;
    }
}

