/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MPhysicalWarehouse;
import jpiere.base.plugin.webui.apps.form.JPiereCreateFromShipment;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.form.WCreateFromWindow;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelListener;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLocator;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.MWarehouse;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

public class JPiereCreateFromShipmentUI
extends JPiereCreateFromShipment
implements EventListener<Event>,
ValueChangeListener {
    private WCreateFromWindow window;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    protected Label bPartnerLabel = new Label();
    protected WEditor bPartnerField;
    protected Label orderLabel = new Label();
    protected Listbox orderField = ListboxFactory.newDropdownListbox();
    protected Checkbox sameWarehouseCb = new Checkbox();
    protected Checkbox shipFromScheduledShipLocatorCb = new Checkbox();
    protected Checkbox selectPhysicalWarehouseCb = new Checkbox();
    protected Label locatorLabel = new Label();
    protected WSearchEditor locatorField = null;
    protected Label upcLabel = new Label();
    protected WStringEditor upcField = new WStringEditor();
    private boolean m_actionActive = false;

    public JPiereCreateFromShipmentUI(GridTab tab) {
        super(tab);
        this.log.info(this.getGridTab().toString());
        this.window = new WCreateFromWindow((CreateFrom)this, this.getGridTab().getWindowNo());
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.zkInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
            throw new AdempiereException(e.getMessage());
        }
        this.window.setStyle("width:50%");
        AEnv.showWindow((Window)this.window);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.window.setTitle(this.getTitle());
        this.sameWarehouseCb.setSelected(true);
        this.sameWarehouseCb.addActionListener((EventListener)this);
        this.shipFromScheduledShipLocatorCb.setSelected(true);
        this.shipFromScheduledShipLocatorCb.addActionListener((EventListener)this);
        boolean checkSelectPhyWH = MSysConfig.getBooleanValue((String)"JP_CREATE_FROM_SHIP_SELECT_PHYHW_CHECK", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        this.selectPhysicalWarehouseCb.setSelected(checkSelectPhyWH);
        this.isSelectPhysicalWarehouse = checkSelectPhyWH;
        this.selectPhysicalWarehouseCb.addActionListener((EventListener)this);
        int AD_Column_ID = MColumn.getColumn_ID((String)"M_InOutLine", (String)"M_Locator_ID");
        MLookup lookupLocator = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.locatorField = new WSearchEditor("M_Locator_ID", true, false, true, (Lookup)lookupLocator);
        this.Doc_PhysicalWarehouse_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"JP_PhysicalWarehouse_ID");
        if (this.Doc_PhysicalWarehouse_ID == 0) {
            MLocator locator;
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"M_Warehouse_ID"));
            if (wh != null && (locator = wh.getDefaultLocator()) != null) {
                this.locatorField.setValue((Object)locator.getM_Locator_ID());
                this.shipLocator_ID = locator.getM_Locator_ID();
            }
        } else {
            MPhysicalWarehouse phyWH = MPhysicalWarehouse.get(Env.getCtx(), this.Doc_PhysicalWarehouse_ID);
            MLocator locator = phyWH.getDefaultLocator(MWarehouse.get((Properties)Env.getCtx(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"M_Warehouse_ID")));
            if (locator != null) {
                this.locatorField.setValue((Object)locator.getM_Locator_ID());
                this.shipLocator_ID = locator.getM_Locator_ID();
            }
        }
        this.locatorField.addValueChangeListener((ValueChangeListener)this);
        this.initBPartner(false);
        this.bPartnerField.addValueChangeListener((ValueChangeListener)this);
        this.locatorLabel.setMandatory(true);
        this.upcField = new WStringEditor("UPC", false, false, true, 10, 30, null, null);
        this.upcField.getComponent().addEventListener("onChange", (EventListener)this);
        return true;
    }

    protected void zkInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.orderLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)true));
        this.locatorLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ShipLocator"));
        this.sameWarehouseCb.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_FromSameWarehouseOnly", (boolean)true));
        this.sameWarehouseCb.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_FromSameWarehouseOnly", (boolean)true));
        this.shipFromScheduledShipLocatorCb.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ShipFromScheduledShipLocator", (boolean)true));
        this.selectPhysicalWarehouseCb.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SelectByPhyWH", (boolean)true));
        this.upcLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"UPC", (boolean)false));
        Vlayout vlayout = new Vlayout();
        vlayout.setVflex("1");
        vlayout.setWidth("98%");
        Panel parameterPanel = this.window.getParameterPanel();
        parameterPanel.appendChild((Component)vlayout);
        Grid parameterStdLayout = GridFactory.newGridLayout();
        vlayout.appendChild((Component)parameterStdLayout);
        Rows rows = parameterStdLayout.newRows();
        Row row = rows.newRow();
        row.appendCellChild(this.bPartnerLabel.rightAlign(), 2);
        if (this.bPartnerField != null) {
            row.appendCellChild(this.bPartnerField.getComponent(), 10);
            this.bPartnerField.fillHorizontal();
        }
        row = rows.newRow();
        row.appendCellChild((Component)new Space(), 2);
        row.appendCellChild((Component)this.sameWarehouseCb, 3);
        row.appendCellChild((Component)new Space());
        row.appendCellChild(this.orderLabel.rightAlign(), 2);
        row.appendCellChild((Component)this.orderField, 4);
        this.orderField.setHflex("1");
        row = rows.newRow();
        row.appendCellChild((Component)new Space(), 2);
        row.appendCellChild((Component)this.shipFromScheduledShipLocatorCb, 3);
        this.isShipFromScheduledShipLocator = this.shipFromScheduledShipLocatorCb.isSelected();
        row.appendCellChild((Component)new Space());
        row.appendCellChild(this.locatorLabel.rightAlign(), 2);
        row.appendCellChild((Component)this.locatorField.getComponent(), 4);
        this.locatorField.fillHorizontal();
        row = rows.newRow();
        row.appendCellChild((Component)new Space(), 2);
        row.appendCellChild((Component)this.selectPhysicalWarehouseCb, 3);
        this.isSelectPhysicalWarehouse = this.selectPhysicalWarehouseCb.isSelected();
        if (this.Doc_PhysicalWarehouse_ID == 0) {
            this.selectPhysicalWarehouseCb.setVisible(false);
        }
        row.appendCellChild((Component)new Space());
        row.appendCellChild(this.upcLabel.rightAlign(), 2);
        row.appendCellChild((Component)this.upcField.getComponent(), 4);
        this.upcField.fillHorizontal();
    }

    public void onEvent(Event e) throws Exception {
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        if (e.getTarget().equals(this.orderField)) {
            KeyNamePair pp = this.orderField.getSelectedItem().toKeyNamePair();
            if (pp != null && pp.getKey() != 0) {
                int C_Order_ID = pp.getKey();
                this.loadOrder(C_Order_ID, false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
            }
        } else if (e.getTarget().equals(this.sameWarehouseCb)) {
            this.initBPOrderDetails((Integer)this.bPartnerField.getValue(), false);
        } else if (e.getTarget().equals(this.shipFromScheduledShipLocatorCb)) {
            this.isShipFromScheduledShipLocator = this.shipFromScheduledShipLocatorCb.isSelected();
        } else if (e.getTarget().equals(this.selectPhysicalWarehouseCb)) {
            this.isSelectPhysicalWarehouse = this.selectPhysicalWarehouseCb.isSelected();
            ListItem selectedListItem = this.orderField.getSelectedItem();
            int C_Order_ID = (Integer)selectedListItem.getValue();
            if (C_Order_ID > 0) {
                this.loadOrder(C_Order_ID, false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
            } else if (C_Order_ID <= 0) {
                this.orderField.setSelectedIndex(0);
            }
            this.orderField.addActionListener((EventListener)this);
        } else if (e.getTarget().equals(this.upcField.getComponent())) {
            this.checkProductUsingUPC();
        }
        this.m_actionActive = false;
    }

    private void checkProductUsingUPC() {
        String upc = this.upcField.getDisplay();
        ListModelTable model = this.window.getWListbox().getModel();
        List products = MProduct.getByUPC((Properties)Env.getCtx(), (String)upc, null);
        for (MProduct product : products) {
            int row = this.findProductRow(product.get_ID());
            if (row < 0) continue;
            BigDecimal qty = (BigDecimal)model.getValueAt(row, 2);
            model.setValueAt((Object)qty, row, 2);
            model.setValueAt((Object)Boolean.TRUE, row, 0);
            model.updateComponent(row, row);
        }
        this.upcField.setValue((Object)"");
    }

    private int findProductRow(int M_Product_ID) {
        ListModelTable model = this.window.getWListbox().getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            KeyNamePair kp = (KeyNamePair)model.getValueAt(i, 5);
            if (kp.getKey() == M_Product_ID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void valueChange(ValueChangeEvent e) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            int C_BPartner_ID = 0;
            if (e.getNewValue() != null) {
                C_BPartner_ID = (Integer)e.getNewValue();
            }
            this.initBPOrderDetails(C_BPartner_ID, true);
        } else if (e.getPropertyName().equals("M_Locator_ID")) {
            this.shipLocator_ID = e.getNewValue() != null ? (Integer)e.getNewValue() : 0;
        }
        this.window.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bPartnerField = new WSearchEditor("C_BPartner_ID", true, true, true, (Lookup)lookup);
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        this.bPartnerField.setValue((Object)new Integer(C_BPartner_ID));
        this.initBPOrderDetails(C_BPartner_ID, forInvoice);
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        }
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener((EventListener)this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList list = this.loadOrderData(C_BPartner_ID, forInvoice, this.sameWarehouseCb.isSelected());
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_Order_ID");
        int i = 0;
        for (KeyNamePair knp : list) {
            ++i;
            this.orderField.addItem(knp);
            if (knp.getKey() != C_Order_ID || C_Order_ID <= 0) continue;
            this.orderField.setSelectedIndex(i);
            this.loadOrder(C_Order_ID, false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
        }
        if (C_Order_ID <= 0) {
            this.orderField.setSelectedIndex(0);
        }
        this.orderField.addActionListener((EventListener)this);
    }

    protected void loadOrder(int C_Order_ID, boolean forInvoice, int M_Locator_ID) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, forInvoice, M_Locator_ID));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.window.getWListbox().clear();
        this.window.getWListbox().getModel().removeTableModelListener((WTableModelListener)this.window);
        ListModelTable model = new ListModelTable(data);
        model.addTableModelListener((WTableModelListener)this.window);
        this.window.getWListbox().setData(model, this.getOISColumnNames());
        this.configureMiniTable((IMiniTable)this.window.getWListbox());
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

