/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public abstract class JPiereCreateFromRMAOrder
extends CreateFrom {
    protected MDocType m_DocType = null;
    protected boolean isSOTrx = true;

    public JPiereCreateFromRMAOrder(GridTab mTab) {
        super(mTab);
        Integer C_DocType_ID = (Integer)mTab.getField("C_DocType_ID").getValue();
        this.m_DocType = MDocType.get((Properties)Env.getCtx(), (int)C_DocType_ID);
        this.isSOTrx = this.m_DocType.isSOTrx();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_RMA_ID", (boolean)this.isSOTrx)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected Vector<Vector<Object>> getRMAData() {
        Vector<Vector<Object>> data;
        block9: {
            int M_InOut_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridTab().getWindowNo(), (String)"InOut_ID");
            int M_RMA_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridTab().getWindowNo(), (String)"M_RMA_ID");
            data = new Vector<Vector<Object>>();
            StringBuilder sqlStmt = new StringBuilder();
            Language loginLang = Env.getLoginLanguage((Properties)Env.getCtx());
            String loginLangString = Env.getAD_Language((Properties)Env.getCtx());
            Boolean isBaseLang = loginLang.isBaseLanguage();
            sqlStmt.append("SELECT iol.M_InOutLine_ID, iol.Line, ");
            sqlStmt.append("COALESCE(p.Name, c.Name) AS ProductName, ");
            sqlStmt.append("iol.QtyEntered, ");
            if (isBaseLang.booleanValue()) {
                sqlStmt.append("uom.Name, ");
            } else {
                sqlStmt.append("uomt.Name, ");
            }
            sqlStmt.append("iol.movementQty, ");
            sqlStmt.append("CASE WHEN iol.M_AttributeSetInstance_ID IS NOT NULL THEN (SELECT SerNo FROM M_AttributeSetInstance asi WHERE asi.M_AttributeSetInstance_ID=iol.M_AttributeSetInstance_ID) END as ASI ");
            sqlStmt.append("FROM M_InOutLine iol ");
            sqlStmt.append("LEFT JOIN M_Product p ON p.M_Product_ID = iol.M_Product_ID ");
            sqlStmt.append("LEFT JOIN C_Charge c ON c.C_Charge_ID = iol.C_Charge_ID ");
            sqlStmt.append("LEFT JOIN C_UOM uom ON uom.C_UOM_ID = iol.C_UOM_ID ");
            if (!isBaseLang.booleanValue()) {
                sqlStmt.append("LEFT JOIN C_UOM_Trl uomt ON uom.C_UOM_ID = uomt.C_UOM_ID AND uomt.AD_Language = '" + loginLangString + "'");
            }
            sqlStmt.append("WHERE M_InOut_ID=? ");
            sqlStmt.append("AND iol.M_InOutLine_ID NOT IN (SELECT rmal.M_InOutLine_ID FROM M_RMALine rmal WHERE rmal.M_RMA_ID=?) ORDER BY iol.Line");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt.toString(), null);
                    pstmt.setInt(1, M_InOut_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        BigDecimal qtyEntered = rs.getBigDecimal(4);
                        BigDecimal movementQty = rs.getBigDecimal(6);
                        line.add(new Boolean(false));
                        line.add(movementQty);
                        KeyNamePair lineKNPair = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(lineKNPair);
                        line.add(rs.getString(3));
                        line.add(rs.getString(7));
                        line.add(qtyEntered);
                        line.add(rs.getString(5));
                        line.add(movementQty);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, false);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, BigDecimal.class, true);
        miniTable.autoSize();
    }

    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        int M_RMA_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridTab().getWindowNo(), (String)"M_RMA_ID");
        MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, trxName);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                BigDecimal d = (BigDecimal)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int inOutLineId = pp.getKey();
                MRMALine rmaLine = new MRMALine(rma.getCtx(), 0, rma.get_TrxName());
                rmaLine.setM_RMA_ID(M_RMA_ID);
                rmaLine.setM_InOutLine_ID(inOutLineId);
                rmaLine.setQty(d);
                rmaLine.setAD_Org_ID(rma.getAD_Org_ID());
                if (!rmaLine.save()) {
                    String val;
                    String msg = null;
                    ValueNamePair err = CLogger.retrieveError();
                    String string = val = err != null ? Msg.translate((Properties)Env.getCtx(), (String)err.getValue()) : "";
                    if (err != null) {
                        msg = String.valueOf(val != null ? String.valueOf(val) + ": " : "") + err.getName();
                    }
                    throw new IllegalStateException(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Could_Not_Create_RMA_Line")) + " " + msg);
                }
            }
            ++i;
        }
        rma.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(8);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ReturnQty"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Line"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"SerNo"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyEntered"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty"));
        return columnNames;
    }
}

