/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import jpiere.base.plugin.webui.apps.form.JPiereCreateFromInvoice;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.form.WCreateFromWindow;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Space;

public class JPiereCreateFromInvoiceUI
extends JPiereCreateFromInvoice
implements EventListener<Event>,
ValueChangeListener {
    private WCreateFromWindow window;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    protected Label bPartnerLabel = new Label();
    protected WEditor bPartnerField;
    protected Label orderLabel = new Label();
    protected Listbox orderField = ListboxFactory.newDropdownListbox();
    protected Label shipmentLabel = new Label();
    protected Listbox shipmentField = ListboxFactory.newDropdownListbox();
    protected Label rmaLabel = new Label();
    protected Listbox rmaField = ListboxFactory.newDropdownListbox();
    private boolean m_actionActive = false;

    public JPiereCreateFromInvoiceUI(GridTab tab) {
        super(tab);
        this.log.info(this.getGridTab().toString());
        this.window = new WCreateFromWindow((CreateFrom)this, this.getGridTab().getWindowNo());
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.zkInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        this.window.setStyle("width:50%");
        AEnv.showWindow((Window)this.window);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.window.setTitle(this.getTitle());
        Integer docTypeId = (Integer)this.getGridTab().getValue("C_DocTypeTarget_ID");
        MDocType docType = MDocType.get((Properties)Env.getCtx(), (int)docTypeId);
        if (!"APC".equals(docType.getDocBaseType())) {
            this.rmaLabel.setVisible(false);
            this.rmaField.setVisible(false);
        }
        this.initBPartner(true);
        this.bPartnerField.addValueChangeListener((ValueChangeListener)this);
        return true;
    }

    protected void zkInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.orderLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)this.isSOTrx));
        this.shipmentLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"M_InOut_ID", (boolean)this.isSOTrx));
        this.rmaLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_RMA_ID"));
        Borderlayout parameterLayout = new Borderlayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)parameterLayout, (String)"110px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)parameterLayout, (String)"100%");
        Panel parameterPanel = this.window.getParameterPanel();
        parameterPanel.appendChild((Component)parameterLayout);
        Grid parameterStdLayout = GridFactory.newGridLayout();
        Panel parameterStdPanel = new Panel();
        parameterStdPanel.appendChild((Component)parameterStdLayout);
        Center center = new Center();
        parameterLayout.appendChild((Component)center);
        center.appendChild((Component)parameterStdPanel);
        Rows rows = parameterStdLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.bPartnerLabel.rightAlign());
        if (this.bPartnerField != null) {
            row.appendChild(this.bPartnerField.getComponent());
        }
        row.appendChild(this.orderLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.orderField, (String)"1");
        row.appendChild((Component)this.orderField);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)new Space());
        row.appendChild(this.shipmentLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.shipmentField, (String)"1");
        row.appendChild((Component)this.shipmentField);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)new Space());
        row.appendChild(this.rmaLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.rmaField, (String)"1");
        row.appendChild((Component)this.rmaField);
    }

    public void onEvent(Event e) throws Exception {
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        if (e.getTarget().equals(this.orderField)) {
            ListItem li = this.orderField.getSelectedItem();
            int C_Order_ID = 0;
            if (li != null && li.getValue() != null) {
                C_Order_ID = (Integer)li.getValue();
            }
            this.rmaField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, true);
        } else if (e.getTarget().equals(this.shipmentField)) {
            ListItem li = this.shipmentField.getSelectedItem();
            int M_InOut_ID = 0;
            if (li != null && li.getValue() != null) {
                M_InOut_ID = (Integer)li.getValue();
            }
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.loadShipment(M_InOut_ID);
        } else if (e.getTarget().equals(this.rmaField)) {
            ListItem li = this.rmaField.getSelectedItem();
            int M_RMA_ID = 0;
            if (li != null && li.getValue() != null) {
                M_RMA_ID = (Integer)li.getValue();
            }
            this.orderField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadRMA(M_RMA_ID);
        }
        this.m_actionActive = false;
    }

    public void valueChange(ValueChangeEvent e) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            int C_BPartner_ID = (Integer)e.getNewValue();
            this.initBPOrderDetails(C_BPartner_ID, true);
        }
        this.window.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bPartnerField = new WSearchEditor("C_BPartner_ID", true, false, true, (Lookup)lookup);
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        this.bPartnerField.setValue((Object)new Integer(C_BPartner_ID));
        this.initBPOrderDetails(C_BPartner_ID, forInvoice);
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        }
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener((EventListener)this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList list = this.loadOrderData(C_BPartner_ID, forInvoice, false);
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_Order_ID");
        int i = 0;
        for (KeyNamePair knp : list) {
            ++i;
            this.orderField.addItem(knp);
            if (knp.getKey() != C_Order_ID || C_Order_ID <= 0) continue;
            this.orderField.setSelectedIndex(i);
            this.loadOrder(C_Order_ID, true);
        }
        this.orderField.addActionListener((EventListener)this);
        this.initBPDetails(C_BPartner_ID);
    }

    public void initBPDetails(int C_BPartner_ID) {
        this.initBPShipmentDetails(C_BPartner_ID);
        this.initBPRMADetails(C_BPartner_ID);
    }

    private void initBPShipmentDetails(int C_BPartner_ID) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("C_BPartner_ID" + C_BPartner_ID);
        }
        this.shipmentField.removeActionListener((EventListener)this);
        this.shipmentField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.shipmentField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadShipmentData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.shipmentField.addItem(knp);
        }
        this.shipmentField.setSelectedIndex(0);
        this.shipmentField.addActionListener((EventListener)this);
    }

    private void initBPRMADetails(int C_BPartner_ID) {
        this.rmaField.removeActionListener((EventListener)this);
        this.rmaField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.rmaField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadRMAData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.rmaField.addItem(knp);
        }
        this.rmaField.setSelectedIndex(0);
        this.rmaField.addActionListener((EventListener)this);
    }

    protected void loadOrder(int C_Order_ID, boolean forInvoice) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, forInvoice));
    }

    protected void loadRMA(int M_RMA_ID) {
        this.loadTableOIS(this.getRMAData(M_RMA_ID));
    }

    protected void loadShipment(int M_InOut_ID) {
        this.loadTableOIS(this.getShipmentData(M_InOut_ID));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.window.getWListbox().clear();
        this.window.getWListbox().getModel().removeTableModelListener((WTableModelListener)this.window);
        ListModelTable model = new ListModelTable(data);
        model.addTableModelListener((WTableModelListener)this.window);
        this.window.getWListbox().setData(model, this.getOISColumnNames());
        this.configureMiniTable((IMiniTable)this.window.getWListbox());
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

