/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WAppsAction;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankAccount;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.A;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Center;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;

public class JPARInvoiceAllocation
implements IFormController,
EventListener<Event>,
ValueChangeListener,
WTableModelListener {
    private CustomForm form = new CustomForm();
    private static CLogger log = CLogger.getCLogger(JPARInvoiceAllocation.class);
    private boolean m_calculating = false;
    private static final String SELECT_DESELECT_ALL = "SelectAll";
    private int Invoice_Org_ID = 0;
    private int Invoice_Currency_ID = 0;
    private int Invoice_BP_ID = 0;
    private int JP_Corporation_ID = 0;
    private Timestamp DateInvoiedFrom = null;
    private Timestamp DateInvoiedTo = null;
    private int Payment_Org_ID = 0;
    private int Payment_BP_ID = 0;
    private int Payment_DocType_ID = 0;
    private int Payment_BankAccount_ID = 0;
    private int Payment_Currency_ID = 0;
    private BigDecimal Payment_PayAmt = Env.ZERO;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();
    private DecimalFormat format = DisplayType.getNumberFormat((int)12, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private int m_noInvoices = 0;
    private BigDecimal totalInv = Env.ZERO;
    private BigDecimal totalPay = Env.ZERO;
    private BigDecimal totalDiff = Env.ZERO;
    private Timestamp allocDate = null;
    private Borderlayout mainLayout = new Borderlayout();
    private Panel southPanel = new Panel();
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Label DateInvoiceFrom_Label = new Label();
    private WDateEditor DateInvoiceFrom_Editor = new WDateEditor("DateInvoiceFrom", true, false, true, "");
    private WDateEditor DateInvoiceTo_Editor = new WDateEditor("DateInvoiceTo", true, false, true, "");
    private Label Invoice_Org_Label = new Label();
    private WSearchEditor Invoice_Org_Editor;
    private Label Invoice_Currency_Label = new Label();
    private WSearchEditor Invoice_Currency_Editor = null;
    private Label Invoice_BP_Label = new Label();
    private WSearchEditor Invoice_BP_Editor = null;
    private Label Corportion_Label = new Label();
    private WTableDirEditor Corportion_Editor = null;
    private Label Payment_Org_Label = new Label();
    private WSearchEditor Payment_Org_Editor;
    private Label Payment_DocType_Label = new Label();
    private WTableDirEditor Payment_DocType_Editor = null;
    private Label Payment_Date_Label = new Label();
    private WDateEditor Payment_Date_Editor = new WDateEditor("Payment_Date", true, false, true, "");
    private Label Payment_Account_Label = new Label();
    private WTableDirEditor Payment_Account_Editor = null;
    private Label Payment_BP_Label = new Label();
    private WSearchEditor Payment_BP_Editor = null;
    private Label Payment_Currency_Label = new Label();
    private WTableDirEditor Payment_Currency_Editor = null;
    private Label PayAmt_Label = new Label();
    private WNumberEditor PayAmt_Editor = new WNumberEditor();
    private Borderlayout infoPanel = new Borderlayout();
    private Panel invoicePanel = new Panel();
    private Borderlayout invoiceLayout = new Borderlayout();
    private Label invoiceLabel = new Label();
    private Label invoiceInfo = new Label();
    private WListbox invoiceTable = ListboxFactory.newDataTable();
    private Panel allocationPanel = new Panel();
    private Grid allocationLayout = GridFactory.newGridLayout();
    private Label differenceLabel = new Label();
    private Label allocCurrencyLabel = new Label();
    private Textbox differenceField = new Textbox();
    private Button allocateButton = new Button();
    private Button refreshButton = new Button();
    private Button selectAllButton = new Button();
    private Hlayout statusBar = new Hlayout();
    private int i_Select = 0;
    private int i_DateInvoiced = 1;
    private int i_DocumentNo = 2;
    private int i_GrandTotal = 3;
    private int i_OpenAmt = 4;
    private int i_Discount = 5;
    private int i_WriteOff = 6;
    private int i_AppliedAmt = 7;
    private int i_OverUnderAmt = 8;
    private int i_AD_Org_ID = 9;
    private int i_C_BPartner_ID = 10;

    public JPARInvoiceAllocation() throws IOException {
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"IsSOTrx", (String)"Y");
        try {
            this.dynInit();
            this.zkInit();
            this.calculate(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    public ADForm getForm() {
        return this.form;
    }

    public void dynInit() throws Exception {
        this.Invoice_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"C_Currency_ID", (int)this.Invoice_Currency_ID);
        if (log.isLoggable(Level.INFO)) {
            log.info("Currency=" + this.Invoice_Currency_ID);
        }
        this.Invoice_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
        Timestamp dateLogin = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        long dateLoginLong = dateLogin.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dateLoginLong);
        calendar.set(5, 1);
        calendar.add(5, -1);
        this.DateInvoiceTo_Editor.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        this.DateInvoiceTo_Editor.addValueChangeListener((ValueChangeListener)this);
        this.DateInvoiedTo = new Timestamp(calendar.getTimeInMillis());
        calendar.add(5, 1);
        calendar.add(2, -1);
        this.DateInvoiceFrom_Editor.setValue((Object)new Timestamp(calendar.getTimeInMillis()));
        this.DateInvoiceFrom_Editor.addValueChangeListener((ValueChangeListener)this);
        this.DateInvoiedFrom = new Timestamp(calendar.getTimeInMillis());
        int AD_Column_ID = 0;
        AD_Column_ID = MColumn.getColumn_ID((String)"C_Invoice", (String)"AD_Org_ID");
        MLookup lookupOrg = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)30);
        this.Invoice_Org_Editor = new WSearchEditor("Invoice_Org_ID", true, false, true, (Lookup)lookupOrg);
        this.Invoice_Org_Editor.setValue((Object)Env.getAD_Org_ID((Properties)Env.getCtx()));
        this.Invoice_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
        this.Invoice_Org_Editor.addValueChangeListener((ValueChangeListener)this);
        this.Payment_Org_Editor = new WSearchEditor("Payment_Org_ID", true, false, true, (Lookup)lookupOrg);
        this.Payment_Org_Editor.setValue((Object)Env.getAD_Org_ID((Properties)Env.getCtx()));
        this.Payment_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
        this.Payment_Org_Editor.addValueChangeListener((ValueChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID((String)"C_Invoice", (String)"C_BPartner_ID");
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)AD_Column_ID, (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"C_BPartner_ID", (int)1000018, (boolean)false, (String)"");
        this.Invoice_BP_Editor = new WSearchEditor("Invoice_BPartner_ID", true, false, true, (Lookup)lookupBP);
        this.Invoice_BP_Editor.addValueChangeListener((ValueChangeListener)this);
        this.Payment_BP_Editor = new WSearchEditor("Payment_BPartner_ID", true, false, true, (Lookup)lookupBP);
        this.Payment_BP_Editor.addValueChangeListener((ValueChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID((String)"C_BPartner", (String)"JP_Corporation_ID");
        if (AD_Column_ID > 0) {
            MLookup lookupCorp = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"JP_Corporation_ID", (int)0, (boolean)false, (String)"JP_Corporation.JP_Corporation_ID = (SELECT JP_Corporation_ID FROM C_BPartner WHERE C_BPartner_ID = @C_BPartner_ID@)");
            this.Corportion_Editor = new WTableDirEditor("JP_Corporation_ID", false, false, true, (Lookup)lookupCorp);
            this.Corportion_Editor.addValueChangeListener((ValueChangeListener)this);
        }
        AD_Column_ID = MColumn.getColumn_ID((String)"C_Payment", (String)"C_DocType_ID");
        MLookup lookupDocType = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"C_DocType_ID", (int)0, (boolean)false, (String)"C_DocType.DocBaseType = 'ARR' AND C_DocType.IsSOTrx = 'Y'");
        this.Payment_DocType_Editor = new WTableDirEditor("Payment_DocType_ID", true, false, true, (Lookup)lookupDocType);
        this.Payment_DocType_Editor.addValueChangeListener((ValueChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID((String)"C_Payment", (String)"C_BankAccount_ID");
        MLookup lookupAcount = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"C_BankAccount_ID", (int)0, (boolean)false, (String)"C_BankAccount.AD_Org_ID = @AD_Org_ID@ AND C_BankAccount.C_Currency_ID=@C_Currency_ID@");
        this.Payment_Account_Editor = new WTableDirEditor("Payment_BankAccount_ID", true, false, true, (Lookup)lookupAcount);
        this.Payment_Account_Editor.addValueChangeListener((ValueChangeListener)this);
        this.Payment_Date_Editor.setValue((Object)Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.allocDate = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        this.Payment_Date_Editor.addValueChangeListener((ValueChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID((String)"C_Invoice", (String)"C_Currency_ID");
        MLookup lookupCur = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)AD_Column_ID, (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"C_Currency_ID", (int)1000033, (boolean)false, (String)"");
        this.Invoice_Currency_Editor = new WSearchEditor("Invoice_Currency_ID", true, false, true, (Lookup)lookupCur);
        this.Invoice_Currency_Editor.setValue((Object)new Integer(this.Invoice_Currency_ID));
        this.Invoice_Currency_Editor.addValueChangeListener((ValueChangeListener)this);
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"C_Currency_ID", (int)this.Invoice_Currency_ID);
        this.Payment_Currency_Editor = new WTableDirEditor("Payment_Currency_ID", true, true, true, (Lookup)lookupCur);
        this.Payment_Currency_Editor.setValue((Object)new Integer(this.Invoice_Currency_ID));
        this.PayAmt_Editor = new WNumberEditor("Payment_PayAmt", true, false, true, 12, "payAmt");
        this.PayAmt_Editor.setValue((Object)Env.ZERO);
        this.PayAmt_Editor.addValueChangeListener((ValueChangeListener)this);
        this.statusBar.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"PaymentAllocation")));
        this.statusBar.setVflex("min");
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, (String)"99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, (String)"100%");
        North north = new North();
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setStyle("border: none");
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.parameterLayout, (String)"90%");
        Rows parameterLayoutRows = this.parameterLayout.newRows();
        Row row = parameterLayoutRows.newRow();
        Groupbox invoiceSearchGB = new Groupbox();
        row.appendCellChild((Component)invoiceSearchGB, 8);
        invoiceSearchGB.appendChild((Component)new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SearchConditionForInvoice")));
        Grid invoiceSearch = new Grid();
        invoiceSearch.setStyle("background-color: #E9F0FF");
        invoiceSearch.setStyle("border: none");
        invoiceSearchGB.appendChild((Component)invoiceSearch);
        Rows rows = invoiceSearch.newRows();
        row = rows.newRow();
        this.DateInvoiceFrom_Label.setText(Msg.getElement((Properties)Env.getCtx(), (String)"DateInvoiced"));
        row.appendCellChild(this.DateInvoiceFrom_Label.rightAlign(), 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.DateInvoiceFrom_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.DateInvoiceFrom_Editor.getComponent(), 1);
        row.setStyle("background-color: #ffffff");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.DateInvoiceTo_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.DateInvoiceTo_Editor.getComponent(), 1);
        row.setStyle("background-color: #ffffff");
        this.Invoice_Org_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        row.appendCellChild(this.Invoice_Org_Label.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Invoice_Org_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Invoice_Org_Editor.getComponent(), 1);
        row.appendCellChild((Component)new Space(), 1);
        this.Invoice_Currency_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        row.appendCellChild(this.Invoice_Currency_Label.rightAlign(), 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Invoice_Currency_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Invoice_Currency_Editor.getComponent(), 1);
        row.appendCellChild((Component)new Space(), 1);
        row.setStyle("background-color: #ffffff");
        row = rows.newRow();
        this.Invoice_BP_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        row.appendCellChild(this.Invoice_BP_Label.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Invoice_BP_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Invoice_BP_Editor.getComponent(), 2);
        this.Corportion_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"JP_Corporation_ID"));
        row.appendCellChild(this.Corportion_Label.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Corportion_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Corportion_Editor.getComponent(), 2);
        row.setStyle("background-color: #ffffff");
        row = parameterLayoutRows.newRow();
        Groupbox paymentGB = new Groupbox();
        row.appendCellChild((Component)paymentGB, 8);
        paymentGB.appendChild((Component)new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CreatePaymentInfo")));
        Grid paymentCondition = new Grid();
        paymentCondition.setStyle("border: none");
        paymentGB.appendChild((Component)paymentCondition);
        rows = paymentCondition.newRows();
        row = rows.newRow();
        this.Payment_Org_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        row.appendCellChild(this.Payment_Org_Label.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Payment_Org_Editor.getComponent(), (String)"true");
        this.Payment_Org_Editor.setMandatory(true);
        row.appendCellChild((Component)this.Payment_Org_Editor.getComponent(), 1);
        this.Payment_DocType_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        row.appendCellChild(this.Payment_DocType_Label.rightAlign(), 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Payment_DocType_Editor.getComponent(), (String)"true");
        this.Payment_DocType_Editor.setMandatory(true);
        row.appendCellChild((Component)this.Payment_DocType_Editor.getComponent(), 1);
        this.Payment_Date_Label.setText(Msg.getElement((Properties)Env.getCtx(), (String)"DateTrx"));
        row.appendCellChild(this.Payment_Date_Label.rightAlign(), 1);
        row.appendCellChild((Component)this.Payment_Date_Editor.getComponent());
        row.setStyle("background-color: #ffffff");
        row = rows.newRow();
        this.Payment_Account_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        row.appendCellChild(this.Payment_Account_Label.rightAlign(), 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Payment_Account_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Payment_Account_Editor.getComponent(), 2);
        row.setStyle("background-color: #ffffff");
        this.Payment_BP_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        row.appendCellChild(this.Payment_BP_Label.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Payment_BP_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Payment_BP_Editor.getComponent(), 2);
        row.setStyle("background-color: #ffffff");
        row = rows.newRow();
        this.Payment_Currency_Label.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        row.appendCellChild(this.Payment_Currency_Label.rightAlign(), 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.Payment_Currency_Editor.getComponent(), (String)"true");
        row.appendCellChild((Component)this.Payment_Currency_Editor.getComponent(), 1);
        this.PayAmt_Label.setText(Msg.getElement((Properties)Env.getCtx(), (String)"DepositAmt", (boolean)true));
        row.appendCellChild(this.PayAmt_Label.rightAlign());
        row.appendCellChild((Component)this.PayAmt_Editor.getComponent());
        row.setStyle("background-color: #ffffff");
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.infoPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.infoPanel, (String)"1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.infoPanel, (String)"1");
        this.infoPanel.setStyle("border: none");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.infoPanel, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.infoPanel, (String)"100%");
        north = new North();
        this.infoPanel.appendChild((Component)north);
        north.setStyle("border: none");
        north.setHeight("100%");
        north.appendChild((Component)this.invoicePanel);
        this.invoicePanel.appendChild((Component)this.invoiceLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoicePanel, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.invoicePanel, (String)"100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.invoicePanel, (String)"1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invoicePanel, (String)"1");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoiceLayout, (String)"100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.invoiceLayout, (String)"100%");
        this.invoiceLayout.setStyle("border: none");
        this.invoiceInfo.setText(".");
        north = new North();
        north.setStyle("border: none");
        this.invoiceLayout.appendChild((Component)north);
        this.invoiceLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
        north.appendChild((Component)this.invoiceLabel);
        center = new Center();
        this.invoiceLayout.appendChild((Component)center);
        center.appendChild((Component)this.invoiceTable);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoiceTable, (String)"99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.invoiceTable, (String)"99%");
        center.setStyle("border: none");
        this.invoiceTable.setStyle("overflow-y: visible");
        South south = new South();
        south.setStyle("border: none");
        this.invoiceLayout.appendChild((Component)south);
        south.appendChild(this.invoiceInfo.rightAlign());
        south = new South();
        this.mainLayout.appendChild((Component)south);
        south.setStyle("border: none");
        south.appendChild((Component)this.southPanel);
        this.southPanel.appendChild((Component)new Separator());
        this.southPanel.appendChild((Component)this.statusBar);
        this.southPanel.appendChild((Component)this.allocationPanel);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.allocationLayout, (String)"min");
        rows = this.allocationLayout.newRows();
        row = rows.newRow();
        WAppsAction selectAllAction = new WAppsAction(SELECT_DESELECT_ALL, null, null);
        this.selectAllButton = selectAllAction.getButton();
        this.selectAllButton.setAttribute(SELECT_DESELECT_ALL, (Object)Boolean.FALSE);
        this.selectAllButton.addActionListener((EventListener)this);
        row.appendCellChild((Component)this.selectAllButton);
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        row.appendCellChild(this.differenceLabel.rightAlign());
        row.appendCellChild(this.allocCurrencyLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.differenceField, (String)"true");
        this.differenceField.setText("0");
        this.differenceField.setReadonly(true);
        this.differenceField.setStyle("text-align: right");
        row.appendCellChild((Component)this.differenceField);
        this.allocateButton.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Process")));
        this.allocateButton.addActionListener((EventListener)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.allocateButton, (String)"true");
        row.appendCellChild((Component)this.allocateButton);
        this.refreshButton.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
        this.refreshButton.addActionListener((EventListener)this);
        this.refreshButton.setAutodisable("self");
        row.appendCellChild((Component)this.refreshButton);
    }

    public Vector<Vector<Object>> getInvoiceData(Object date, IMiniTable invoiceTable) {
        Vector<Vector<Object>> data;
        block19: {
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, i.GrandTotal, invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID), invoiceDiscount(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.MultiplierAP ,org.Name, bp.Name ");
            sql.append("FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) INNER JOIN AD_Org org ON (i.AD_Org_ID = org.AD_Org_ID)");
            sql.append(" LEFT OUTER JOIN C_BPartner bp on( i.C_BPartner_ID = bp.C_BPartner_ID) ");
            sql.append("WHERE i.IsPaid='N' AND i.Processed='Y'");
            if (this.JP_Corporation_ID == 0) {
                sql.append(" AND i.C_BPartner_ID=?");
            } else {
                sql.append(" AND bp.JP_Corporation_ID=?");
            }
            sql.append(" AND i.C_Currency_ID=?");
            if (this.Invoice_Org_ID != 0) {
                sql.append(" AND i.AD_Org_ID=?");
            }
            if (this.DateInvoiedFrom != null) {
                sql.append(" AND i.DateInvoiced >= ?");
            }
            if (this.DateInvoiedTo != null) {
                sql.append(" AND i.DateInvoiced <= ?");
            }
            sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
            if (log.isLoggable(Level.FINE)) {
                log.fine("InvSQL=" + sql.toString());
            }
            sql = new StringBuilder(MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "i", true, false));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int i = 0;
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setTimestamp(++i, (Timestamp)date);
                    if (this.JP_Corporation_ID == 0) {
                        pstmt.setInt(++i, this.Invoice_BP_ID);
                    } else {
                        pstmt.setInt(++i, this.JP_Corporation_ID);
                    }
                    pstmt.setInt(++i, this.Invoice_Currency_ID);
                    if (this.Invoice_Org_ID != 0) {
                        pstmt.setInt(++i, this.Invoice_Org_ID);
                    }
                    if (this.DateInvoiedFrom != null) {
                        pstmt.setTimestamp(++i, this.DateInvoiedFrom);
                    }
                    if (this.DateInvoiedTo != null) {
                        pstmt.setTimestamp(++i, this.DateInvoiedTo);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(new Boolean(false));
                        line.add(rs.getTimestamp(1));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                        line.add(pp);
                        line.add(rs.getBigDecimal(6));
                        BigDecimal open = rs.getBigDecimal(7);
                        if (open == null) {
                            open = Env.ZERO;
                        }
                        line.add(open);
                        BigDecimal discount = rs.getBigDecimal(8);
                        if (discount == null) {
                            discount = Env.ZERO;
                        }
                        line.add(discount);
                        line.add(Env.ZERO);
                        line.add(Env.ZERO);
                        line.add(open);
                        line.add(rs.getString(10));
                        line.add(rs.getString(11));
                        if (Env.ZERO.compareTo(open) == 0) continue;
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        return data;
    }

    public Vector<String> getInvoiceColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"DateInvoiced"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"GrandTotal"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"WriteOff"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OverUnderAmt"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable) {
        int i = 0;
        invoiceTable.setColumnClass(i++, Boolean.class, false);
        invoiceTable.setColumnClass(i++, Timestamp.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.autoSize();
    }

    public void checkBPartner() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("BPartner=" + this.Invoice_BP_ID + ", Cur=" + this.Invoice_Currency_ID);
        }
        if (this.Invoice_BP_ID == 0 || this.Invoice_Currency_ID == 0) {
            return;
        }
        Integer key = new Integer(this.Invoice_BP_ID);
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MInvoice.setIsPaid((Properties)Env.getCtx(), (int)JPARInvoiceAllocation.this.Invoice_BP_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
    }

    public String calculateInvoice(IMiniTable invoice) {
        this.totalInv = Env.ZERO;
        int rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i, this.i_DateInvoiced);
                this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_AppliedAmt);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
                }
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    private void setAllocateButton() {
        if (this.totalDiff.signum() == 0) {
            this.allocateButton.setEnabled(true);
        } else {
            this.allocateButton.setEnabled(false);
        }
    }

    private void loadBPartner() {
        this.checkBPartner();
        Vector<Vector<Object>> data = this.getInvoiceData(this.Payment_Date_Editor.getValue(), (IMiniTable)this.invoiceTable);
        Vector<String> columnNames = this.getInvoiceColumnNames();
        this.invoiceTable.clear();
        this.invoiceTable.getModel().removeTableModelListener((WTableModelListener)this);
        ListModelTable modelI = new ListModelTable(data);
        modelI.addTableModelListener((WTableModelListener)this);
        this.invoiceTable.setData(modelI, columnNames);
        this.setInvoiceColumnClass((IMiniTable)this.invoiceTable);
        this.calculate(true);
        this.statusBar.getChildren().clear();
    }

    public void calculate(boolean isUpdatePayAmt) {
        this.invoiceInfo.setText(this.calculateInvoice((IMiniTable)this.invoiceTable));
        if (isUpdatePayAmt) {
            this.Payment_PayAmt = this.totalInv;
            this.PayAmt_Editor.setValue((Object)this.Payment_PayAmt);
        }
        if (this.allocDate != null) {
            this.Payment_Date_Editor.setValue((Object)this.allocDate);
        }
        this.allocCurrencyLabel.setText(this.Payment_Currency_Editor.getDisplay());
        this.totalDiff = this.Payment_PayAmt.subtract(this.totalInv);
        this.differenceField.setText(this.format.format(this.totalDiff));
        this.setAllocateButton();
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable invoice, boolean isAutoWriteOff) {
        String msg = "";
        if (this.m_calculating) {
            return msg;
        }
        this.m_calculating = true;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        }
        boolean selected = (Boolean)invoice.getValueAt(row, 0);
        BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_OpenAmt);
        BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_Discount);
        BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_WriteOff);
        BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_AppliedAmt);
        BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_OverUnderAmt);
        int openSign = open.signum();
        if (col == this.i_Select) {
            if (selected) {
                applied = open;
                applied = applied.subtract(discount);
                writeOff = Env.ZERO;
                overUnder = Env.ZERO;
                this.totalDiff = Env.ZERO;
                if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                    applied = this.totalDiff;
                }
                if (isAutoWriteOff) {
                    writeOff = open.subtract(applied.add(discount));
                } else {
                    overUnder = open.subtract(applied.add(discount));
                }
            } else {
                writeOff = Env.ZERO;
                applied = Env.ZERO;
                overUnder = Env.ZERO;
            }
        }
        if (selected && col != 0) {
            if (discount.signum() == -openSign) {
                discount = discount.negate();
            }
            if (writeOff.signum() == -openSign) {
                writeOff = writeOff.negate();
            }
            if (applied.signum() == -openSign) {
                applied = applied.negate();
            }
            if (discount.abs().compareTo(open.abs()) > 0) {
                discount = open;
            }
            if (writeOff.abs().compareTo(open.abs()) > 0) {
                writeOff = open;
            }
            BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
            BigDecimal difference = newTotal.subtract(open);
            BigDecimal diffWOD = writeOff.add(discount).subtract(open);
            if (diffWOD.signum() == open.signum()) {
                if (col == 5) {
                    writeOff = writeOff.subtract(diffWOD);
                } else {
                    discount = discount.subtract(diffWOD);
                }
                difference = difference.subtract(diffWOD);
            }
            if (col == 7) {
                overUnder = overUnder.subtract(difference);
            } else {
                applied = applied.subtract(difference);
            }
        }
        if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
            msg = "AllocationWriteOffWarn";
        }
        invoice.setValueAt((Object)discount, row, this.i_Discount);
        invoice.setValueAt((Object)writeOff, row, this.i_WriteOff);
        invoice.setValueAt((Object)applied, row, this.i_AppliedAmt);
        invoice.setValueAt((Object)overUnder, row, this.i_OverUnderAmt);
        this.m_calculating = false;
        return msg;
    }

    public void valueChange(ValueChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(name) + "=" + value);
        }
        if (name.equals("Invoice_Org_ID")) {
            Label label;
            int n = this.Invoice_Org_ID = value != null ? (Integer)value : 0;
            if (this.Invoice_BP_ID > 0 && this.Invoice_Currency_ID > 0) {
                this.loadBPartner();
            } else if (this.Invoice_BP_ID > 0) {
                this.statusBar.getChildren().clear();
                label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            } else {
                this.statusBar.getChildren().clear();
                label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            }
            if (this.Invoice_Org_ID != 0 && this.Payment_Org_ID == 0) {
                this.Payment_Org_ID = this.Invoice_Org_ID;
                this.Payment_Org_Editor.setValue(value);
                Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Org_ID", (int)this.Payment_Org_ID);
                MLookup mLookup = (MLookup)this.Payment_Account_Editor.getLookup();
                this.Payment_Account_Editor.setValue(null);
                this.Payment_BankAccount_ID = 0;
                mLookup.refresh();
            }
        } else if (name.equals("Payment_Org_ID")) {
            this.Payment_Org_ID = value != null ? (Integer)value : 0;
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Org_ID", (int)this.Payment_Org_ID);
            MLookup mLookup = (MLookup)this.Payment_Account_Editor.getLookup();
            this.Payment_Account_Editor.setValue(null);
            this.Payment_BankAccount_ID = 0;
            mLookup.refresh();
        } else if (e.getSource().equals(this.Invoice_BP_Editor)) {
            this.Invoice_BP_ID = value != null ? (Integer)value : 0;
            this.Payment_BP_Editor.setValue(value);
            this.Payment_BP_ID = this.Invoice_BP_ID;
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"C_BPartner_ID", (int)this.Invoice_BP_ID);
            MLookup mLookup = (MLookup)this.Corportion_Editor.getLookup();
            this.Corportion_Editor.setValue(null);
            this.JP_Corporation_ID = 0;
            mLookup.refresh();
            if (this.Invoice_BP_ID > 0 && this.Invoice_Currency_ID > 0) {
                this.loadBPartner();
            } else if (this.Invoice_BP_ID > 0) {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            } else {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            }
        } else if (e.getSource().equals(this.Payment_BP_Editor)) {
            this.Payment_BP_ID = value != null ? (Integer)value : 0;
            this.Payment_BP_ID = (Integer)value;
        } else if (name.equals("JP_Corporation_ID")) {
            int n = this.JP_Corporation_ID = value != null ? (Integer)value : 0;
            if (this.Invoice_BP_ID > 0 && this.Invoice_Currency_ID > 0) {
                this.loadBPartner();
            } else if (this.Invoice_BP_ID > 0) {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            } else {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            }
        } else if (name.equals("Invoice_Currency_ID")) {
            this.Invoice_Currency_ID = value != null ? (Integer)value : 0;
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"C_Currency_ID", (int)this.Invoice_Currency_ID);
            this.Payment_Currency_Editor.setValue(null);
            MLookup mLookup = (MLookup)this.Payment_Account_Editor.getLookup();
            this.Payment_Account_Editor.setValue(null);
            this.Payment_BankAccount_ID = 0;
            mLookup.refresh();
            if (this.Invoice_BP_ID > 0 && this.Invoice_Currency_ID > 0) {
                this.loadBPartner();
            } else if (this.Invoice_BP_ID > 0) {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            } else {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            }
        } else if (name.equals("Payment_Date")) {
            this.allocDate = value != null ? (Timestamp)value : null;
        } else if (name.equals("Payment_PayAmt")) {
            this.Payment_PayAmt = value != null ? (BigDecimal)value : Env.ZERO;
            this.calculate(false);
        } else if (name.equals("Payment_BankAccount_ID")) {
            this.Payment_BankAccount_ID = value != null ? (Integer)value : 0;
            this.Payment_Currency_ID = MBankAccount.get((Properties)Env.getCtx(), (int)this.Payment_BankAccount_ID).getC_Currency_ID();
            this.Payment_Currency_Editor.setValue((Object)this.Payment_Currency_ID);
        } else if (name.equals("Payment_DocType_ID")) {
            this.Payment_DocType_ID = value != null ? (Integer)value : 0;
        } else if (name.equals("DateInvoiceFrom")) {
            Timestamp timestamp = this.DateInvoiedFrom = value != null ? (Timestamp)value : null;
            if (this.Invoice_BP_ID > 0 && this.Invoice_Currency_ID > 0) {
                this.loadBPartner();
            } else if (this.Invoice_BP_ID > 0) {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            } else {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            }
        } else if (name.equals("DateInvoiceTo")) {
            Timestamp timestamp = this.DateInvoiedFrom = value != null ? (Timestamp)value : null;
            if (this.Invoice_BP_ID > 0 && this.Invoice_Currency_ID > 0) {
                this.loadBPartner();
            } else if (this.Invoice_BP_ID > 0) {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_Currency_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            } else {
                this.statusBar.getChildren().clear();
                Label label = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                label.setStyle("color: #ff0000");
                this.statusBar.appendChild((Component)label);
            }
        }
    }

    public void tableChanged(WTableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate(true);
            return;
        }
        int row = e.getFirstRow();
        int col = e.getColumn();
        if (row < 0) {
            return;
        }
        boolean isInvoice = e.getModel().equals(this.invoiceTable.getModel());
        this.writeOff(row, col, isInvoice, (IMiniTable)this.invoiceTable, false);
        ListModelTable model = this.invoiceTable.getModel();
        model.updateComponent(row);
        this.calculate(true);
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget().equals(this.allocateButton)) {
            if (this.Payment_Org_ID == 0) {
                throw new AdempiereException(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Payment_ID", (boolean)true)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory") + Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID"));
            }
            if (this.Payment_DocType_ID == 0) {
                throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_DocType_ID"));
            }
            if (this.allocDate == null) {
                throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"DateTrx"));
            }
            if (this.Payment_BankAccount_ID == 0) {
                throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
            }
            if (this.Payment_BP_ID == 0) {
                throw new AdempiereException(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
            }
            if (this.Invoice_Currency_ID != this.Payment_Currency_ID) {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_DifferentCurrency"));
            }
            this.allocateButton.setEnabled(false);
            MAllocationHdr allocation = this.saveData();
            this.loadBPartner();
            this.allocateButton.setEnabled(true);
            if (allocation != null) {
                A link = new A(allocation.getDocumentNo());
                link.setAttribute("Record_ID", (Object)allocation.get_ID());
                link.setAttribute("AD_Table_ID", (Object)allocation.get_Table_ID());
                link.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        Component comp = event.getTarget();
                        Integer Record_ID = (Integer)comp.getAttribute("Record_ID");
                        Integer AD_Table_ID = (Integer)comp.getAttribute("AD_Table_ID");
                        if (Record_ID != null && Record_ID > 0 && AD_Table_ID != null && AD_Table_ID > 0) {
                            AEnv.zoom((int)AD_Table_ID, (int)Record_ID);
                        }
                    }
                });
                this.statusBar.appendChild((Component)link);
            }
        } else if (e.getTarget().equals(this.refreshButton)) {
            this.loadBPartner();
        } else if (e.getTarget().getId().equals(SELECT_DESELECT_ALL)) {
            ListModelTable model = this.invoiceTable.getModel();
            int rows = model.getSize();
            Button selectAllBtn = (Button)e.getTarget();
            Boolean selectAll = (Boolean)selectAllBtn.getAttribute(SELECT_DESELECT_ALL);
            if (selectAll == null) {
                selectAll = Boolean.FALSE;
            }
            selectAll = selectAll == false;
            int i = 0;
            while (i < rows) {
                model.setValueAt((Object)selectAll, i, 0);
                ++i;
            }
            this.invoiceTable.setModel((ListModel)model);
            selectAllBtn.setAttribute(SELECT_DESELECT_ALL, (Object)selectAll);
        }
    }

    private MAllocationHdr saveData() {
        if (this.Payment_Org_ID > 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Org_ID", (int)this.Payment_Org_ID);
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Org_ID", (String)"");
        }
        try {
            MAllocationHdr[] allocation = new MAllocationHdr[1];
            Trx.run((TrxRunnable)new TrxRunnable(){

                public void run(String trxName) {
                    JPARInvoiceAllocation.this.statusBar.getChildren().clear();
                    MPayment m_payment = JPARInvoiceAllocation.this.creatpayment(trxName);
                    allocation[0] = JPARInvoiceAllocation.this.saveData(JPARInvoiceAllocation.this.form.getWindowNo(), JPARInvoiceAllocation.this.Payment_Date_Editor.getValue(), m_payment, (IMiniTable)JPARInvoiceAllocation.this.invoiceTable, trxName);
                }
            });
            return allocation[0];
        }
        catch (Exception e) {
            FDialog.error((int)this.form.getWindowNo(), (Component)this.form, (String)"Error", (String)e.getLocalizedMessage());
            return null;
        }
    }

    private MPayment creatpayment(String trxName) {
        if (this.Payment_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        MPayment payment = new MPayment(Env.getCtx(), 0, trxName);
        payment.setAD_Org_ID(this.Payment_Org_ID);
        payment.setC_DocType_ID(this.Payment_DocType_ID);
        payment.setC_Currency_ID(this.Payment_Currency_ID);
        payment.setIsReceipt(true);
        payment.setC_BankAccount_ID(this.Payment_BankAccount_ID);
        payment.setC_BPartner_ID(this.Payment_BP_ID);
        payment.setPayAmt(this.Payment_PayAmt);
        payment.processIt("CO");
        return payment;
    }

    public MAllocationHdr saveData(int m_WindowNo, Object date, MPayment payment, IMiniTable invoice, String trxName) {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices == 0) {
            return null;
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = this.Payment_Org_ID;
        int C_BPartner_ID = this.Payment_BP_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)date;
        int C_Currency_ID = this.Invoice_Currency_ID;
        int C_Payment_ID = payment.get_ID();
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        }
        int iRows = invoice.getRowCount();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(AD_Org_ID);
        alloc.saveEx();
        BigDecimal availablePaymentAmt = this.Payment_PayAmt;
        int i = 0;
        while (i < iRows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                pp = (KeyNamePair)invoice.getValueAt(i, this.i_DocumentNo);
                C_Invoice_ID = pp.getKey();
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i, this.i_Discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i, this.i_WriteOff);
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i, this.i_AppliedAmt);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i, this.i_OverUnderAmt)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(".. with payment #, Amt=" + availablePaymentAmt);
                }
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Invoice #" + i + " - AppliedAmt=" + AppliedAmt);
                }
                MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                aLine.saveEx();
                DiscountAmt = Env.ZERO;
                WriteOffAmt = Env.ZERO;
                availablePaymentAmt = availablePaymentAmt.subtract(AppliedAmt);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Allocation Amount=" + AppliedAmt + " - Payment=" + availablePaymentAmt);
                }
            }
            ++i;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Payment=" + C_Payment_ID + ", Amount=" + this.Payment_PayAmt);
        }
        if (availablePaymentAmt.signum() != 0) {
            log.log(Level.SEVERE, "Allocation not balanced -- out by " + availablePaymentAmt);
        }
        if (alloc.get_ID() != 0) {
            if (!alloc.processIt("CO")) {
                throw new AdempiereException("Cannot complete allocation: " + alloc.getProcessMsg());
            }
            alloc.saveEx();
        }
        i = 0;
        while (i < iRows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                pp = (KeyNamePair)invoice.getValueAt(i, this.i_DocumentNo);
                C_Invoice_ID = pp.getKey();
                BigDecimal open = DB.getSQLValueBD((String)trxName, (String)sql, (int)C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate((String)sql, (String)trxName);
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Invoice #" + i + " is paid - updated=" + no);
                    }
                } else if (log.isLoggable(Level.CONFIG)) {
                    log.config("Invoice #" + i + " is not paid - " + open);
                }
            }
            ++i;
        }
        return alloc;
    }
}

