/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractChargeAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractProductAcct;
import org.adempiere.exceptions.AverageCostingZeroQtyException;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.ProductCost;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class Doc_MatchInvJP
extends Doc {
    private MInvoiceLine m_invoiceLine = null;
    private MInOutLine m_receiptLine = null;
    private ProductCost m_pc = null;
    private MMatchInv m_matchInv;
    private MContractAcct m_contractAcct = null;

    public Doc_MatchInvJP(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MMatchInv.class, rs, "MXI", trxName);
    }

    protected String loadDocumentDetails() {
        MContractContent content;
        int JP_Contract_Acct_ID;
        this.setC_Currency_ID(-2);
        this.m_matchInv = (MMatchInv)this.getPO();
        this.setDateDoc(this.m_matchInv.getDateTrx());
        this.setQty(this.m_matchInv.getQty());
        int C_InvoiceLine_ID = this.m_matchInv.getC_InvoiceLine_ID();
        this.m_invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        int C_BPartner_ID = this.m_invoiceLine.getParent().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        int M_InOutLine_ID = this.m_matchInv.getM_InOutLine_ID();
        this.m_receiptLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, this.getTrxName());
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.m_matchInv.getM_AttributeSetInstance_ID(), this.getTrxName());
        this.m_pc.setQty(this.getQty());
        int JP_ContractContent_ID = this.m_invoiceLine.getParent().get_ValueAsInt("JP_ContractContent_ID");
        if (JP_ContractContent_ID > 0 && (JP_Contract_Acct_ID = (content = MContractContent.get(this.getCtx(), JP_ContractContent_ID)).getJP_Contract_Acct_ID()) > 0) {
            this.m_contractAcct = MContractAcct.get(this.getCtx(), JP_Contract_Acct_ID);
        }
        return null;
    }

    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        BigDecimal credit;
        BigDecimal debit;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_receiptLine.getMovementQty().signum() == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
            }
            return facts;
        }
        Fact fact = new Fact((Doc)this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        boolean isInterOrg = this.isInterOrg(as);
        BigDecimal multiplier = this.getQty().divide(this.m_receiptLine.getMovementQty(), 12, 4).abs();
        FactLine dr = fact.createLine(null, this.getAccount(51, as), as.getC_Currency_ID(), Env.ONE, null);
        if (dr == null) {
            this.p_Error = "No Product Costs";
            return null;
        }
        dr.setQty(this.getQty());
        BigDecimal temp = dr.getAcctBalance();
        if (this.m_matchInv.getReversal_ID() > 0) {
            if (!dr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                this.p_Error = "Failed to create reversal entry";
                return null;
            }
        } else {
            BigDecimal effMultiplier = multiplier;
            if (this.getQty().signum() < 0) {
                effMultiplier = effMultiplier.negate();
            }
            if (!dr.updateReverseLine(319, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), effMultiplier)) {
                this.p_Error = "Mat.Receipt not posted yet";
                return null;
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("CR - Amt(" + temp + "->" + dr.getAcctBalance() + ") - " + dr.toString());
        }
        MAccount expense = this.m_pc.getAccount(10, as);
        if (this.m_pc.isService()) {
            expense = this.m_pc.getAccount(2, as);
        }
        BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
        multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, 4).abs();
        if (multiplier.compareTo(Env.ONE) != 0) {
            LineNetAmt = LineNetAmt.multiply(multiplier);
        }
        if (this.m_pc.isService()) {
            LineNetAmt = dr.getAcctBalance();
        }
        FactLine cr = null;
        if (as.isAccrual()) {
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            if (cr == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                }
                cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, Env.ONE);
                cr.setAmtAcctCr(BigDecimal.ZERO);
                cr.setAmtSourceCr(BigDecimal.ZERO);
            }
            temp = cr.getAcctBalance();
            if (this.m_matchInv.getReversal_ID() > 0) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                cr.setQty(this.getQty().negate());
                BigDecimal effMultiplier = multiplier;
                if (this.getQty().signum() < 0) {
                    effMultiplier = effMultiplier.negate();
                }
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    cr.setAccount(as, this.getInvoiceExpenseAccount(as));
                }
                if (!cr.updateReverseLine(318, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), effMultiplier)) {
                    this.p_Error = "Invoice not posted yet";
                    return null;
                }
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    cr.setAccount(as, expense);
                }
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DR - Amt(" + temp + "->" + cr.getAcctBalance() + ") - " + cr.toString());
            }
        } else {
            MInvoice invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)LineNetAmt, (int)invoice.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
            }
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            if (this.m_matchInv.getReversal_ID() > 0) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                cr.setQty(this.getQty().multiply(multiplier).negate());
            }
        }
        if (this.m_matchInv.getReversal_ID() == 0) {
            cr.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
            cr.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
            cr.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
            cr.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
            cr.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
            cr.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
            cr.setUser1_ID(this.m_invoiceLine.getUser1_ID());
            cr.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        } else {
            this.updateFactLine(cr);
        }
        if (dr.getC_Currency_ID() != cr.getC_Currency_ID()) {
            this.setIsMultiCurrency(true);
        }
        MAccount acct_db = dr.getAccount();
        MAccount acct_cr = cr.getAccount();
        if (!as.isPostIfClearingEqual() && acct_db.equals((Object)acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0) {
            fact.remove(dr);
            fact.remove(cr);
        }
        BigDecimal ipv = cr.getAcctBalance().add(dr.getAcctBalance()).negate();
        this.processInvoicePriceVariance(as, fact, ipv);
        String error = this.createMatchInvCostDetail(as);
        if (error != null && error.trim().length() > 0) {
            this.p_Error = error;
            return null;
        }
        facts.add(fact);
        return facts;
    }

    protected void processInvoicePriceVariance(MAcctSchema as, Fact fact, BigDecimal ipv) {
        boolean zeroQty;
        block24: {
            if (ipv.signum() == 0) {
                return;
            }
            FactLine pv = null;
            pv = this.m_pc.isService() ? fact.createLine(null, this.m_pc.getAccount(2, as), as.getC_Currency_ID(), ipv) : fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv);
            this.updateFactLine(pv);
            MMatchInv matchInv = (MMatchInv)this.getPO();
            Trx trx = Trx.get((String)this.getTrxName(), (boolean)false);
            Savepoint savepoint = null;
            zeroQty = false;
            try {
                try {
                    savepoint = trx.setSavepoint(null);
                    if (!MCostDetail.createMatchInvoice((MAcctSchema)as, (int)this.m_invoiceLine.getAD_Org_ID(), (int)this.m_invoiceLine.getM_Product_ID(), (int)this.m_invoiceLine.getM_AttributeSetInstance_ID(), (int)matchInv.getM_MatchInv_ID(), (int)0, (BigDecimal)ipv, (BigDecimal)BigDecimal.ZERO, (String)"Invoice Price Variance", (String)this.getTrxName())) {
                        throw new RuntimeException("Failed to create cost detail record.");
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
                catch (AverageCostingZeroQtyException e) {
                    zeroQty = true;
                    try {
                        trx.rollback(savepoint);
                        savepoint = null;
                    }
                    catch (SQLException e1) {
                        throw new RuntimeException(e1.getLocalizedMessage(), e1);
                    }
                    if (savepoint != null) {
                        try {
                            trx.releaseSavepoint(savepoint);
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (savepoint != null) {
                    try {
                        trx.releaseSavepoint(savepoint);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (savepoint != null) {
                try {
                    trx.releaseSavepoint(savepoint);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        String costingMethod = this.m_pc.getProduct().getCostingMethod(as);
        MAccount account = this.m_pc.getAccount(3, as);
        if (this.m_pc.isService()) {
            account = this.m_pc.getAccount(2, as);
        }
        if ("A".equals(costingMethod)) {
            if (zeroQty) {
                account = this.m_pc.getAccount(23, as);
            }
            FactLine line = fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv.negate());
            this.updateFactLine(line);
            line = fact.createLine(null, account, as.getC_Currency_ID(), ipv);
            this.updateFactLine(line);
        } else if ("I".equals(costingMethod) && !zeroQty) {
            FactLine line = fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv.negate());
            this.updateFactLine(line);
            line = fact.createLine(null, account, as.getC_Currency_ID(), ipv);
            this.updateFactLine(line);
        }
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        return this.m_receiptLine != null && this.m_invoiceLine != null && this.m_receiptLine.getAD_Org_ID() != this.m_invoiceLine.getAD_Org_ID();
    }

    private String createMatchInvCostDetail(MAcctSchema as) {
        if (this.m_invoiceLine != null && this.m_invoiceLine.get_ID() > 0 && this.m_receiptLine != null && this.m_receiptLine.get_ID() > 0) {
            MOrderLandedCostAllocation[] allocations;
            MMatchInv matchInv = (MMatchInv)this.getPO();
            BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
            BigDecimal multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, 4).abs();
            if (multiplier.compareTo(Env.ONE) != 0) {
                LineNetAmt = LineNetAmt.multiply(multiplier);
            }
            MMatchInv[] mInv = MMatchInv.getInvoiceLine((Properties)this.getCtx(), (int)this.m_invoiceLine.getC_InvoiceLine_ID(), (String)this.getTrxName());
            BigDecimal tQty = Env.ZERO;
            BigDecimal tAmt = Env.ZERO;
            int i = 0;
            while (i < mInv.length) {
                if (mInv[i].isPosted() && mInv[i].getM_MatchInv_ID() != this.get_ID() && mInv[i].getM_AttributeSetInstance_ID() == matchInv.getM_AttributeSetInstance_ID()) {
                    tQty = tQty.add(mInv[i].getQty());
                    multiplier = mInv[i].getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, 4).abs();
                    tAmt = tAmt.add(this.m_invoiceLine.getLineNetAmt().multiply(multiplier));
                }
                ++i;
            }
            tAmt = tAmt.add(LineNetAmt);
            MInvoice invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID() && (tAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)tAmt, (int)invoice.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID())) == null) {
                return "AP Invoice not convertible - " + as.getName();
            }
            MInOut receipt = this.m_receiptLine.getParent();
            tQty = receipt.getMovementType().equals("V-") ? tQty.add(this.getQty().negate()) : tQty.add(this.getQty());
            if (!MCostDetail.createInvoice((MAcctSchema)as, (int)this.getAD_Org_ID(), (int)this.getM_Product_ID(), (int)matchInv.getM_AttributeSetInstance_ID(), (int)this.m_invoiceLine.getC_InvoiceLine_ID(), (int)0, (BigDecimal)tAmt, (BigDecimal)tQty, (String)this.getDescription(), (String)this.getTrxName())) {
                return "Failed to create cost detail record";
            }
            LinkedHashMap<Integer, BigDecimal> landedCostMap = new LinkedHashMap<Integer, BigDecimal>();
            I_C_OrderLine orderLine = this.m_receiptLine.getC_OrderLine();
            if (orderLine == null) {
                return "";
            }
            int C_OrderLine_ID = orderLine.getC_OrderLine_ID();
            MOrderLandedCostAllocation[] mOrderLandedCostAllocationArray = allocations = MOrderLandedCostAllocation.getOfOrderLine((int)C_OrderLine_ID, (String)this.getTrxName());
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                int elementId;
                BigDecimal elementAmt;
                MOrderLandedCostAllocation allocation = mOrderLandedCostAllocationArray[n2];
                BigDecimal totalAmt = allocation.getAmt();
                BigDecimal totalQty = allocation.getQty();
                BigDecimal amt = totalAmt.multiply(tQty).divide(totalQty, 12, 4);
                if (orderLine.getC_Currency_ID() != as.getC_Currency_ID()) {
                    I_C_Order order = orderLine.getC_Order();
                    Timestamp dateAcct = order.getDateAcct();
                    BigDecimal rate = MConversionRate.getRate((int)order.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)dateAcct, (int)order.getC_ConversionType_ID(), (int)order.getAD_Client_ID(), (int)order.getAD_Org_ID());
                    if (rate == null) {
                        this.p_Error = "Purchase Order not convertible - " + as.getName();
                        return null;
                    }
                    if ((amt = amt.multiply(rate)).scale() > as.getCostingPrecision()) {
                        amt = amt.setScale(as.getCostingPrecision(), 4);
                    }
                }
                elementAmt = (elementAmt = (BigDecimal)landedCostMap.get(elementId = allocation.getC_OrderLandedCost().getM_CostElement_ID())) == null ? amt : elementAmt.add(amt);
                landedCostMap.put(elementId, elementAmt);
                ++n2;
            }
            for (Integer elementId : landedCostMap.keySet()) {
                BigDecimal amt = (BigDecimal)landedCostMap.get(elementId);
                if (MCostDetail.createShipment((MAcctSchema)as, (int)this.getAD_Org_ID(), (int)this.getM_Product_ID(), (int)matchInv.getM_AttributeSetInstance_ID(), (int)this.m_receiptLine.getM_InOutLine_ID(), (int)elementId, (BigDecimal)amt, (BigDecimal)tQty, (String)this.getDescription(), (boolean)false, (String)this.getTrxName())) continue;
                return "Failed to create cost detail record";
            }
        }
        return "";
    }

    protected void updateFactLine(FactLine factLine) {
        factLine.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
        factLine.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
        factLine.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
        factLine.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
        factLine.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
        factLine.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
        factLine.setUser1_ID(this.m_invoiceLine.getUser1_ID());
        factLine.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        factLine.setM_Product_ID(this.m_invoiceLine.getM_Product_ID());
        factLine.setQty(this.getQty());
    }

    private MAccount getInvoiceExpenseAccount(MAcctSchema as) {
        MInvoiceLine line = this.m_invoiceLine;
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = this.m_contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return MCharge.getAccount((int)line.getC_Charge_ID(), (MAcctSchema)as);
        }
        if (line.getM_Product_ID() > 0) {
            if (line.getM_Product().getProductType().equals("I")) {
                return this.m_pc.getAccount(10, as);
            }
            MContractProductAcct contractProductAcct = this.m_contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_Expense_Acct());
            }
            return this.m_pc.getAccount(2, as);
        }
        return this.m_pc.getAccount(2, as);
    }
}

