/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractBPAcct;
import jpiere.base.plugin.org.adempiere.model.MContractChargeAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractProductAcct;
import jpiere.base.plugin.org.adempiere.model.MContractTaxAcct;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Doc_Invoice;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MTax;
import org.compiere.util.Env;

public class Doc_InvoiceJP
extends Doc_Invoice {
    public Doc_InvoiceJP(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, rs, trxName);
    }

    protected String loadDocumentDetails() {
        return super.loadDocumentDetails();
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        if (!as.isAccrual()) {
            return super.createFacts(as);
        }
        MInvoice invoice = (MInvoice)this.getPO();
        int JP_ContractContent_ID = invoice.get_ValueAsInt("JP_ContractContent_ID");
        if (JP_ContractContent_ID == 0) {
            return this.createFacts_Standaed(as);
        }
        MContractContent contractContent = MContractContent.get(this.getCtx(), JP_ContractContent_ID);
        if (contractContent.getJP_Contract_Acct_ID() == 0) {
            return this.createFacts_Standaed(as);
        }
        MContractAcct contractAcct = MContractAcct.get(Env.getCtx(), contractContent.getJP_Contract_Acct_ID());
        if (!contractAcct.isPostingContractAcctJP()) {
            return this.createFacts_Standaed(as);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact((Doc)this, as, "A");
        if (this.getDocumentType().equals("ARI") || this.getDocumentType().equals("ARF")) {
            this.postARI(as, contractAcct, fact);
        } else if (this.getDocumentType().equals("ARC")) {
            this.postARC(as, contractAcct, fact);
        } else if (this.getDocumentType().equals("API")) {
            this.postAPI(as, contractAcct, fact);
        } else if (this.getDocumentType().equals("APC")) {
            this.postAPC(as, contractAcct, fact);
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    private ArrayList<Fact> createFacts_Standaed(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact((Doc)this, as, "A");
        if (!as.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("ARI") || this.getDocumentType().equals("ARF")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                MCharge charge;
                amt = this.p_lines[i].getAmtSource();
                int C_Charge_ID = this.p_lines[i].getPO().get_ValueAsInt("C_Charge_ID");
                if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                    amt = (BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxBaseAmt");
                }
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), null, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i2 = 0;
            while (i2 < fLines.length) {
                if (fLines[i2] != null) {
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i2;
            }
            int receivables_ID = this.getValidCombination_ID(1, as);
            int receivablesServices_ID = this.getValidCombination_ID(4, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else if (this.getDocumentType().equals("ARC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), amt, null);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt, null)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                MCharge charge;
                amt = this.p_lines[i].getAmtSource();
                int C_Charge_ID = this.p_lines[i].getPO().get_ValueAsInt("C_Charge_ID");
                if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                    amt = (BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxBaseAmt");
                }
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), amt, null);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i3 = 0;
            while (i3 < fLines.length) {
                if (fLines[i3] != null) {
                    fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), true);
                    fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i3;
            }
            int receivables_ID = this.getValidCombination_ID(1, as);
            int receivablesServices_ID = this.getValidCombination_ID(4, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)receivables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)receivablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
        } else if (this.getDocumentType().equals("API")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MCharge charge;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    int C_Charge_ID = this.p_lines[i].getPO().get_ValueAsInt("C_Charge_ID");
                    if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                        amt = (BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxBaseAmt");
                    }
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice((MAcctSchema)as, (int)line.getAD_Org_ID(), (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (int)line.get_ID(), (int)0, (BigDecimal)line.getAmtSource(), (BigDecimal)line.getQty(), (String)line.getDescription(), (String)this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i4 = 0;
            while (i4 < fLines.length) {
                if (fLines[i4] != null) {
                    fLines[i4].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i4].setLocationFromOrg(fLines[i4].getAD_Org_ID(), false);
                }
                ++i4;
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)payables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            this.updateProductPO(as);
        } else if (this.getDocumentType().equals("APC")) {
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, this.getAmount(2));
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), null, this.m_taxes[i].getAmount());
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, false);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MCharge charge;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    int C_Charge_ID = this.p_lines[i].getPO().get_ValueAsInt("C_Charge_ID");
                    if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                        amt = (BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxBaseAmt");
                    }
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), dAmt, null);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice((MAcctSchema)as, (int)line.getAD_Org_ID(), (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (int)line.get_ID(), (int)0, (BigDecimal)line.getAmtSource().negate(), (BigDecimal)line.getQty(), (String)line.getDescription(), (String)this.getTrxName());
                    }
                }
                ++i;
            }
            FactLine[] fLines = fact.getLines();
            int i5 = 0;
            while (i5 < fLines.length) {
                if (fLines[i5] != null) {
                    fLines[i5].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i5].setLocationFromOrg(fLines[i5].getAD_Org_ID(), false);
                }
                ++i5;
            }
            int payables_ID = this.getValidCombination_ID(2, as);
            int payablesServices_ID = this.getValidCombination_ID(3, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)payables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get((Properties)this.getCtx(), (int)payablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    private void postARI(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        BigDecimal amt = Env.ZERO;
        int i = 0;
        while (i < this.m_taxes.length) {
            amt = this.m_taxes[i].getAmount();
            if (amt != null && amt.signum() != 0) {
                FactLine tl = null;
                tl = fact.createLine(null, this.getInvoiceTaxDueAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), null, amt);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            BigDecimal discount;
            amt = this.p_lines[i].getAmtSource();
            BigDecimal dAmt = null;
            if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                amt = amt.add(discount);
                dAmt = discount;
                fact.createLine(this.p_lines[i], this.getInvoiceTDiscountGrantAccount(this.p_lines[i], contractAcct, as), this.getC_Currency_ID(), dAmt, null);
            }
            fact.createLine(this.p_lines[i], this.getInvoiceRevenueAccount(this.p_lines[i], contractAcct, as), this.getC_Currency_ID(), null, amt);
            ++i;
        }
        FactLine[] fLines = fact.getLines();
        int i2 = 0;
        while (i2 < fLines.length) {
            if (fLines[i2] != null) {
                fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
            }
            ++i2;
        }
        BigDecimal grossAmt = this.getAmount(0);
        if (grossAmt.signum() != 0) {
            fact.createLine(null, this.getReceivableAccount(contractAcct, as), this.getC_Currency_ID(), grossAmt, null);
        }
    }

    private void postARC(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        BigDecimal amt = Env.ZERO;
        int i = 0;
        while (i < this.m_taxes.length) {
            amt = this.m_taxes[i].getAmount();
            if (amt != null && amt.signum() != 0) {
                FactLine tl = null;
                tl = fact.createLine(null, this.getInvoiceTaxDueAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), amt, null);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            BigDecimal discount;
            amt = this.p_lines[i].getAmtSource();
            BigDecimal dAmt = null;
            if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                amt = amt.add(discount);
                dAmt = discount;
                fact.createLine(this.p_lines[i], this.getInvoiceTDiscountGrantAccount(this.p_lines[i], contractAcct, as), this.getC_Currency_ID(), null, dAmt);
            }
            fact.createLine(this.p_lines[i], this.getInvoiceRevenueAccount(this.p_lines[i], contractAcct, as), this.getC_Currency_ID(), amt, null);
            ++i;
        }
        FactLine[] fLines = fact.getLines();
        int i2 = 0;
        while (i2 < fLines.length) {
            if (fLines[i2] != null) {
                fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
            }
            ++i2;
        }
        BigDecimal grossAmt = this.getAmount(0);
        if (grossAmt.signum() != 0) {
            fact.createLine(null, this.getReceivableAccount(contractAcct, as), this.getC_Currency_ID(), null, grossAmt);
        }
    }

    private void postAPI(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        BigDecimal grossAmt = this.getAmount(0);
        BigDecimal serviceAmt = Env.ZERO;
        int i = 0;
        while (i < this.m_taxes.length) {
            FactLine tl = fact.createLine(null, this.getInvoiceTaxCreditAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
            if (tl != null) {
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            boolean landedCost = this.landedCost(as, fact, line, true);
            if (landedCost && as.isExplicitCostAdjustment()) {
                fact.createLine(line, this.getInvoiceExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                FactLine fl = fact.createLine(line, this.getInvoiceExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), null, line.getAmtSource());
                String desc = line.getDescription();
                desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                fl.setDescription(desc);
            }
            if (!landedCost) {
                BigDecimal discount;
                MAccount expense = this.getInvoiceExpenseAccount(line, contractAcct, as);
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    MAccount tradeDiscountReceived = this.getInvoiceTDiscountRecAccount(line, contractAcct, as);
                    fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                if (!line.isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                    MCostDetail.createInvoice((MAcctSchema)as, (int)line.getAD_Org_ID(), (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (int)line.get_ID(), (int)0, (BigDecimal)line.getAmtSource(), (BigDecimal)line.getQty(), (String)line.getDescription(), (String)this.getTrxName());
                }
            }
            ++i;
        }
        FactLine[] fLines = fact.getLines();
        int i2 = 0;
        while (i2 < fLines.length) {
            if (fLines[i2] != null) {
                fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), false);
            }
            ++i2;
        }
        grossAmt = this.getAmount(0);
        if (grossAmt.signum() != 0) {
            fact.createLine(null, this.getPayableAccount(contractAcct, as), this.getC_Currency_ID(), null, grossAmt);
        }
        this.updateProductPO(as);
    }

    private void postAPC(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        BigDecimal grossAmt = this.getAmount(0);
        BigDecimal serviceAmt = Env.ZERO;
        int i = 0;
        while (i < this.m_taxes.length) {
            FactLine tl = fact.createLine(null, this.getInvoiceTaxCreditAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), null, this.m_taxes[i].getAmount());
            if (tl != null) {
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            boolean landedCost = this.landedCost(as, fact, line, false);
            if (landedCost && as.isExplicitCostAdjustment()) {
                fact.createLine(line, this.getInvoiceExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), null, line.getAmtSource());
                FactLine fl = fact.createLine(line, this.getInvoiceExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                String desc = line.getDescription();
                desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                fl.setDescription(desc);
            }
            if (!landedCost) {
                BigDecimal discount;
                MAccount expense = this.getInvoiceExpenseAccount(line, contractAcct, as);
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    MAccount tradeDiscountReceived = this.getInvoiceTDiscountRecAccount(line, contractAcct, as);
                    fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                if (!line.isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                    MCostDetail.createInvoice((MAcctSchema)as, (int)line.getAD_Org_ID(), (int)line.getM_Product_ID(), (int)line.getM_AttributeSetInstance_ID(), (int)line.get_ID(), (int)0, (BigDecimal)line.getAmtSource().negate(), (BigDecimal)line.getQty(), (String)line.getDescription(), (String)this.getTrxName());
                }
            }
            ++i;
        }
        FactLine[] fLines = fact.getLines();
        int i2 = 0;
        while (i2 < fLines.length) {
            if (fLines[i2] != null) {
                fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), false);
            }
            ++i2;
        }
        grossAmt = this.getAmount(0);
        if (grossAmt.signum() != 0) {
            fact.createLine(null, this.getPayableAccount(contractAcct, as), this.getC_Currency_ID(), grossAmt, null);
        }
    }

    private MAccount getInvoiceRevenueAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MInvoiceLine line = (MInvoiceLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return docLine.getAccount(1, as);
        }
        if (line.getM_Product_ID() > 0) {
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_Revenue_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_Revenue_Acct());
            }
            return docLine.getAccount(1, as);
        }
        return docLine.getAccount(1, as);
    }

    private MAccount getInvoiceExpenseAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MInvoiceLine line = (MInvoiceLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return docLine.getAccount(2, as);
        }
        if (line.getM_Product_ID() > 0) {
            if (docLine.isItem()) {
                return docLine.getAccount(10, as);
            }
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_Expense_Acct());
            }
            return docLine.getAccount(2, as);
        }
        return docLine.getAccount(2, as);
    }

    private MAccount getInvoiceTDiscountGrantAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MInvoiceLine line = (MInvoiceLine)docLine.getPO();
        MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
        if (contractProductAcct != null && contractProductAcct.getP_TradeDiscountGrant_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_TradeDiscountGrant_Acct());
        }
        return docLine.getAccount(8, as);
    }

    private MAccount getInvoiceTDiscountRecAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MInvoiceLine line = (MInvoiceLine)docLine.getPO();
        MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
        if (contractProductAcct != null && contractProductAcct.getP_TradeDiscountRec_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_TradeDiscountRec_Acct());
        }
        return docLine.getAccount(7, as);
    }

    private MAccount getReceivableAccount(MContractAcct contractAcct, MAcctSchema as) {
        MContractBPAcct bpAcct = contractAcct.getContractBPAcct(as.getC_AcctSchema_ID(), false);
        if (bpAcct != null && bpAcct.getC_Receivable_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)bpAcct.getC_Receivable_Acct());
        }
        return MAccount.get((Properties)this.getCtx(), (int)this.getValidCombination_ID(1, as));
    }

    private MAccount getPayableAccount(MContractAcct contractAcct, MAcctSchema as) {
        MContractBPAcct bpAcct = contractAcct.getContractBPAcct(as.getC_AcctSchema_ID(), false);
        if (bpAcct != null && bpAcct.getV_Liability_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)bpAcct.getV_Liability_Acct());
        }
        return MAccount.get((Properties)this.getCtx(), (int)this.getValidCombination_ID(2, as));
    }

    private MAccount getInvoiceTaxDueAccount(DocTax doc_Tax, MContractAcct contractAcct, MAcctSchema as) {
        MContractTaxAcct taxAcct = contractAcct.getContracTaxAcct(doc_Tax.getC_Tax_ID(), as.getC_AcctSchema_ID(), false);
        if (taxAcct != null && taxAcct.getT_Due_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getT_Due_Acct());
        }
        return doc_Tax.getAccount(0, as);
    }

    private MAccount getInvoiceTaxCreditAccount(DocTax doc_Tax, MContractAcct contractAcct, MAcctSchema as) {
        MContractTaxAcct taxAcct = contractAcct.getContracTaxAcct(doc_Tax.getC_Tax_ID(), as.getC_AcctSchema_ID(), false);
        MTax tax = MTax.get((Properties)this.getCtx(), (int)doc_Tax.getC_Tax_ID());
        if (tax.isSalesTax()) {
            if (taxAcct != null && taxAcct.getT_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getT_Expense_Acct());
            }
            return doc_Tax.getAccount(2, as);
        }
        if (taxAcct != null && taxAcct.getT_Credit_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getT_Credit_Acct());
        }
        return doc_Tax.getAccount(1, as);
    }
}

