/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.compiere.acct.DocLine_BankStatementJP;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_BankStatementJP
extends Doc {
    protected int m_C_BankAccount_ID = 0;
    private DocTax[] m_taxes = null;

    public Doc_BankStatementJP(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MBankStatement.class, rs, "CMB", trxName);
    }

    protected String loadDocumentDetails() {
        MBankStatement bs = (MBankStatement)this.getPO();
        this.setDateDoc(bs.getStatementDate());
        this.setDateAcct(bs.getDateAcct());
        this.m_C_BankAccount_ID = bs.getC_BankAccount_ID();
        this.setAmount(0, bs.getStatementDifference());
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.m_C_BankAccount_ID);
        this.setC_Currency_ID(ba.getC_Currency_ID());
        this.p_lines = this.loadLines(bs);
        this.m_taxes = this.loadTaxes();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    protected DocLine[] loadLines(MBankStatement bs) {
        ArrayList<DocLine_BankStatementJP> list = new ArrayList<DocLine_BankStatementJP>();
        MBankStatementLine[] lines = bs.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            DocLine_BankStatementJP docLine = new DocLine_BankStatementJP(line, this);
            list.add(docLine);
            ++i;
        }
        DocLine[] dls = new DocLine_BankStatementJP[list.size()];
        list.toArray(dls);
        return dls;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT bst.C_Tax_ID, t.Name, t.Rate, bst.TaxBaseAmt, bst.TaxAmt, t.IsSalesTax,bst.C_BankStatementLine_ID FROM C_Tax t, JP_BankStatementTax bst WHERE t.C_Tax_ID=bst.C_Tax_ID AND bst.C_BankStatement_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                block4: while (rs.next()) {
                    int C_Tax_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    BigDecimal rate = rs.getBigDecimal(3);
                    BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                    BigDecimal amount = rs.getBigDecimal(5);
                    boolean salesTax = "Y".equals(rs.getString(6));
                    int C_BankStatementLine_ID = rs.getInt(7);
                    DocTax docTax = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                    list.add(docTax);
                    int i = 0;
                    while (i < this.p_lines.length) {
                        DocLine_BankStatementJP docLine = (DocLine_BankStatementJP)this.p_lines[i];
                        if (docLine.get_ID() == C_BankStatementLine_ID) {
                            docLine.setDocTax(docTax);
                            docLine.setTaxBaseAmt(taxBaseAmt);
                            continue block4;
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        int i = 0;
        while (i < this.p_lines.length) {
            BigDecimal lineBalance = ((DocLine_BankStatementJP)this.p_lines[i]).getStmtAmt();
            retValue = retValue.subtract(lineBalance);
            sb.append("-").append(lineBalance);
            ++i;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        }
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact((Doc)this, as, "A");
        FactLine fl = null;
        int AD_Org_ID = this.getBank_Org_ID();
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine_BankStatementJP line = (DocLine_BankStatementJP)this.p_lines[i];
            int C_BPartner_ID = line.getC_BPartner_ID();
            MAccount acct_bank_asset = this.getAccount(40, as);
            MAccount acct_bank_in_transit = this.getAccount(11, as);
            if (!as.isPostIfClearingEqual() && acct_bank_asset.equals((Object)acct_bank_in_transit)) {
                BigDecimal amt_stmt_minus_trx = line.getStmtAmt().subtract(line.getTrxAmt());
                if (amt_stmt_minus_trx.compareTo(Env.ZERO) != 0) {
                    fl = fact.createLine((DocLine)line, this.getAccount(40, as), line.getC_Currency_ID(), amt_stmt_minus_trx);
                    if (fl != null && AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    }
                    if (fl != null && C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                }
            } else {
                fl = fact.createLine((DocLine)line, this.getAccount(40, as), line.getC_Currency_ID(), line.getStmtAmt());
                if (fl != null && AD_Org_ID != 0) {
                    fl.setAD_Org_ID(AD_Org_ID);
                }
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                if ((fl = fact.createLine((DocLine)line, this.getAccount(11, as), line.getC_Currency_ID(), line.getTrxAmt().negate())) != null) {
                    if (C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                    if (AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    } else {
                        fl.setAD_Org_ID(line.getAD_Org_ID(true));
                    }
                }
            }
            if (line.getChargeAmt().compareTo(Env.ZERO) > 0) {
                if (line.getDocTax() == null) {
                    fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getChargeAmt());
                } else {
                    fl = fact.createLine(null, line.getDocTax().getAccount(0, as), this.getC_Currency_ID(), null, line.getDocTax().getAmount());
                    fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getTaxBaseAmt());
                }
            } else if (line.getDocTax() == null) {
                fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getChargeAmt().negate(), null);
            } else {
                fl = fact.createLine(null, line.getDocTax().getAccount(1, as), this.getC_Currency_ID(), line.getDocTax().getAmount(), null);
                fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getTaxBaseAmt(), null);
            }
            if (fl != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            if ((fl = line.getInterestAmt().signum() < 0 ? fact.createLine((DocLine)line, this.getAccount(42, as), this.getAccount(42, as), line.getC_Currency_ID(), line.getInterestAmt().negate()) : fact.createLine((DocLine)line, this.getAccount(41, as), this.getAccount(41, as), line.getC_Currency_ID(), line.getInterestAmt().negate())) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            ++i;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    protected int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }
}

