/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractBPAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.util.JPiereInvoiceUtil;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OpenAmtInvoiceListPointOfTime
extends SvrProcess {
    private int p_AD_PInstance_ID = 0;
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private Timestamp p_JP_PointOfTime = null;
    private int p_C_BPartner_ID = 0;
    private int p_JP_Corporation_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private MAcctSchema m_MAcctSchema = null;
    private int p_Account_ID = 0;
    private boolean p_IsSOTrx = false;

    protected void prepare() {
        this.p_AD_PInstance_ID = this.getAD_PInstance_ID();
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_PointOfTime")) {
                    this.p_JP_PointOfTime = para[i].getParameterAsTimestamp();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_Corporation_ID")) {
                    this.p_JP_Corporation_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("Account_ID")) {
                    this.p_Account_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsSOTrx")) {
                    this.p_IsSOTrx = para[i].getParameterAsString().equals("Y");
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_MAcctSchema = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
    }

    protected String doIt() throws Exception {
        block60: {
            ArrayList<OpemAmtInvoice> list;
            block58: {
                block56: {
                    list = new ArrayList<OpemAmtInvoice>();
                    StringBuilder sql1 = new StringBuilder("SELECT dt.DocBaseType,bp.JP_Corporation_ID,vc.Account_ID,i.* FROM C_Invoice i  INNER JOIN C_DocType dt ON (dt.C_DocType_ID = i.C_DocTypeTarget_ID) INNER JOIN C_BPartner bp ON (bp.C_BPartner_ID = i.C_BPartner_ID)");
                    if (this.p_IsSOTrx) {
                        sql1.append(" INNER JOIN C_BP_Customer_Acct bpca ON (bp.C_BPartner_ID = bpca.C_BPartner_ID AND bpca.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc ON (bpca.c_receivable_Acct = vc.C_ValidCombination_ID)");
                    } else {
                        sql1.append(" INNER JOIN C_BP_Vendor_Acct bpva ON (bp.C_BPartner_ID = bpva.C_BPartner_ID AND bpva.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc ON (bpva.V_Liability_Acct = vc.C_ValidCombination_ID)");
                    }
                    sql1.append(" WHERE i.IsPaid='N' AND i.AD_Client_ID = ?  AND i.DocStatus IN ('CO','CL','VO','RE')  AND i.DateAcct <= ? AND i.IsSOTrx = ?");
                    if (this.p_AD_Org_ID > 0) {
                        sql1.append(" AND i.AD_Org_ID= ? ");
                    }
                    if (this.p_C_BPartner_ID > 0) {
                        sql1.append(" AND i.C_BPartner_ID= ? ");
                    }
                    if (this.p_JP_Corporation_ID > 0) {
                        sql1.append(" AND bp.JP_Corporation_ID= ? ");
                    }
                    CPreparedStatement pstmt1 = null;
                    ResultSet rs1 = null;
                    try {
                        try {
                            pstmt1 = DB.prepareStatement((String)sql1.toString(), (String)this.get_TrxName());
                            pstmt1.setInt(1, this.p_C_AcctSchema_ID);
                            pstmt1.setInt(2, this.p_AD_Client_ID);
                            pstmt1.setTimestamp(3, this.p_JP_PointOfTime);
                            pstmt1.setString(4, this.p_IsSOTrx ? "Y" : "N");
                            int i = 4;
                            if (this.p_AD_Org_ID > 0) {
                                pstmt1.setInt(++i, this.p_AD_Org_ID);
                            }
                            if (this.p_C_BPartner_ID > 0) {
                                pstmt1.setInt(++i, this.p_C_BPartner_ID);
                            }
                            if (this.p_JP_Corporation_ID > 0) {
                                pstmt1.setInt(++i, this.p_JP_Corporation_ID);
                            }
                            rs1 = pstmt1.executeQuery();
                            MInvoice invoice = null;
                            int account_ID = 0;
                            MContractContent contractContent = null;
                            MContractAcct contractAcct = null;
                            MAccount acct = null;
                            while (rs1.next()) {
                                invoice = new MInvoice(this.getCtx(), rs1, this.get_TrxName());
                                account_ID = rs1.getInt(3);
                                if (invoice.get_ValueAsInt("JP_ContractContent_ID") > 0) {
                                    contractContent = MContractContent.get(this.getCtx(), invoice.get_ValueAsInt("JP_ContractContent_ID"));
                                    contractAcct = MContractAcct.get(this.getCtx(), contractContent.getJP_Contract_Acct_ID());
                                    if (contractAcct.isPostingContractAcctJP()) {
                                        if (this.p_IsSOTrx) {
                                            acct = this.getReceivableAccount(contractAcct, this.p_C_AcctSchema_ID);
                                            if (acct != null) {
                                                account_ID = acct.getAccount().getC_ElementValue_ID();
                                            }
                                        } else {
                                            acct = this.getPayableAccount(contractAcct, this.p_C_AcctSchema_ID);
                                            if (acct != null) {
                                                account_ID = acct.getAccount().getC_ElementValue_ID();
                                            }
                                        }
                                    }
                                }
                                if (this.p_Account_ID != 0 && account_ID != this.p_Account_ID) continue;
                                list.add(new OpemAmtInvoice(invoice, rs1.getString(1), rs1.getInt(2), account_ID));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql1.toString(), (Throwable)e);
                            DB.close(rs1, (Statement)pstmt1);
                            rs1 = null;
                            pstmt1 = null;
                            break block56;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs1, pstmt1);
                        rs1 = null;
                        pstmt1 = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs1, (Statement)pstmt1);
                    rs1 = null;
                    pstmt1 = null;
                }
                StringBuilder sql2 = new StringBuilder("SELECT DISTINCT  dt.DocBaseType,bp.JP_Corporation_ID ,vc.Account_ID ,i.*  FROM C_Invoice i  INNER JOIN C_AllocationLIne al ON (i.C_Invoice_ID = al.C_Invoice_ID) INNER JOIN C_AllocationHdr a ON (al.C_AllocationHdr_ID = a.C_AllocationHdr_ID) INNER JOIN C_DocType dt ON (dt.C_DocType_ID = i.C_DocTypeTarget_ID) INNER JOIN C_BPartner bp ON (bp.C_BPartner_ID = i.C_BPartner_ID)");
                if (this.p_IsSOTrx) {
                    sql2.append(" INNER JOIN C_BP_Customer_Acct bpca ON (bp.C_BPartner_ID = bpca.C_BPartner_ID AND bpca.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc ON (bpca.c_receivable_Acct = vc.C_ValidCombination_ID)");
                } else {
                    sql2.append(" INNER JOIN C_BP_Vendor_Acct bpva ON (bp.C_BPartner_ID = bpva.C_BPartner_ID AND bpva.C_AcctSchema_ID = ?) INNER JOIN C_ValidCombination vc ON (bpva.V_Liability_Acct = vc.C_ValidCombination_ID)");
                }
                sql2.append(" WHERE i.IsPaid='Y' AND i.AD_Client_ID = ?  AND i.DocStatus IN ('CO','CL','VO','RE')  AND i.DateAcct <= ? AND a.DateAcct > ? AND i.IsSOTrx = ?");
                if (this.p_AD_Org_ID > 0) {
                    sql2.append(" AND i.AD_Org_ID= ? ");
                }
                if (this.p_C_BPartner_ID > 0) {
                    sql2.append(" AND i.C_BPartner_ID= ? ");
                }
                if (this.p_JP_Corporation_ID > 0) {
                    sql2.append(" AND bp.JP_Corporation_ID= ? ");
                }
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                try {
                    try {
                        pstmt2 = DB.prepareStatement((String)sql2.toString(), (String)this.get_TrxName());
                        pstmt2.setInt(1, this.p_C_AcctSchema_ID);
                        pstmt2.setInt(2, this.p_AD_Client_ID);
                        pstmt2.setTimestamp(3, this.p_JP_PointOfTime);
                        pstmt2.setTimestamp(4, this.p_JP_PointOfTime);
                        pstmt2.setString(5, this.p_IsSOTrx ? "Y" : "N");
                        int i = 5;
                        if (this.p_AD_Org_ID > 0) {
                            pstmt2.setInt(++i, this.p_AD_Org_ID);
                        }
                        if (this.p_C_BPartner_ID > 0) {
                            pstmt2.setInt(++i, this.p_C_BPartner_ID);
                        }
                        if (this.p_JP_Corporation_ID > 0) {
                            pstmt2.setInt(++i, this.p_JP_Corporation_ID);
                        }
                        rs2 = pstmt2.executeQuery();
                        OpemAmtInvoice openAmnInv = null;
                        MInvoice invoice2 = null;
                        int account_ID2 = 0;
                        MContractContent contractContent2 = null;
                        MContractAcct contractAcct2 = null;
                        MAccount acct2 = null;
                        while (rs2.next()) {
                            invoice2 = new MInvoice(this.getCtx(), rs2, this.get_TrxName());
                            account_ID2 = rs2.getInt(3);
                            if (invoice2.get_ValueAsInt("JP_ContractContent_ID") > 0) {
                                contractContent2 = MContractContent.get(this.getCtx(), invoice2.get_ValueAsInt("JP_ContractContent_ID"));
                                contractAcct2 = MContractAcct.get(this.getCtx(), contractContent2.getJP_Contract_Acct_ID());
                                if (contractAcct2.isPostingContractAcctJP()) {
                                    if (this.p_IsSOTrx) {
                                        acct2 = this.getReceivableAccount(contractAcct2, this.p_C_AcctSchema_ID);
                                        if (acct2 != null) {
                                            account_ID2 = acct2.getAccount().getC_ElementValue_ID();
                                        }
                                    } else {
                                        acct2 = this.getPayableAccount(contractAcct2, this.p_C_AcctSchema_ID);
                                        if (acct2 != null) {
                                            account_ID2 = acct2.getAccount().getC_ElementValue_ID();
                                        }
                                    }
                                }
                            }
                            if (this.p_Account_ID != 0 && account_ID2 != this.p_Account_ID || (openAmnInv = new OpemAmtInvoice(invoice2, rs2.getString(1), rs2.getInt(2), account_ID2)).getJP_OpenAmtPointOfTime().compareTo(Env.ZERO) == 0) continue;
                            list.add(openAmnInv);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql2.toString(), (Throwable)e);
                        DB.close(rs2, (Statement)pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        break block58;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs2, (Statement)pstmt2);
                rs2 = null;
                pstmt2 = null;
            }
            StringBuilder sql3 = new StringBuilder("INSERT INTO T_OpenInvPointOfTimeJP(AD_Pinstance_ID, C_Invoice_ID, C_Order_ID, AD_Client_ID, AD_Org_ID, AD_OrgTrx_ID, C_BPartner_ID, JP_Corporation_ID, C_Currency_ID, SalesRep_ID, C_PaymentTerm_ID, C_AcctSchema_ID, Account_ID, C_Doctype_ID, DocBasetype, Documentno, POReference, PaymentRule, DocStatus, DateInvoiced, DateAcct, IsPaid, IsSOTrx, Grandtotal, OpenAmt, JP_OpenAmtPointOfTime, JP_CurrencyTo_ID, JP_ExchangedGrandtotal, JP_ExchangedOpenAmt, JP_ExchangedOpenAmtPOT, Rate, JP_PointOfTime)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,   ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,   ?, ?)");
            CPreparedStatement pstmt3 = null;
            Object rs3 = null;
            try {
                try {
                    pstmt3 = DB.prepareStatement((String)sql3.toString(), (String)this.get_TrxName());
                    for (OpemAmtInvoice openAmtInv : list) {
                        pstmt3.setInt(1, this.p_AD_PInstance_ID);
                        pstmt3.setInt(2, openAmtInv.getInvoice().getC_Invoice_ID());
                        if (openAmtInv.getInvoice().getC_Order_ID() > 0) {
                            pstmt3.setInt(3, openAmtInv.getInvoice().getC_Order_ID());
                        } else {
                            pstmt3.setNull(3, 4);
                        }
                        pstmt3.setInt(4, this.p_AD_Client_ID);
                        pstmt3.setInt(5, openAmtInv.getInvoice().getAD_Org_ID());
                        if (openAmtInv.getInvoice().getAD_OrgTrx_ID() > 0) {
                            pstmt3.setInt(6, openAmtInv.getInvoice().getAD_OrgTrx_ID());
                        } else {
                            pstmt3.setNull(6, 4);
                        }
                        pstmt3.setInt(7, openAmtInv.getInvoice().getC_BPartner_ID());
                        if (openAmtInv.getJP_Corporation_ID() > 0) {
                            pstmt3.setInt(8, openAmtInv.getJP_Corporation_ID());
                        } else {
                            pstmt3.setNull(8, 4);
                        }
                        pstmt3.setInt(9, openAmtInv.getInvoice().getC_Currency_ID());
                        if (openAmtInv.getInvoice().getSalesRep_ID() > 0) {
                            pstmt3.setInt(10, openAmtInv.getInvoice().getSalesRep_ID());
                        } else {
                            pstmt3.setNull(10, 4);
                        }
                        pstmt3.setInt(11, openAmtInv.getInvoice().getC_PaymentTerm_ID());
                        pstmt3.setInt(12, this.p_C_AcctSchema_ID);
                        pstmt3.setInt(13, openAmtInv.getAccount_ID());
                        pstmt3.setInt(14, openAmtInv.getInvoice().getC_DocTypeTarget_ID());
                        pstmt3.setString(15, openAmtInv.getDocBaseType());
                        pstmt3.setString(16, openAmtInv.getInvoice().getDocumentNo());
                        pstmt3.setString(17, openAmtInv.getInvoice().getPOReference());
                        pstmt3.setString(18, openAmtInv.getInvoice().getPaymentRule());
                        pstmt3.setString(19, openAmtInv.getInvoice().getDocStatus());
                        pstmt3.setTimestamp(20, openAmtInv.getInvoice().getDateInvoiced());
                        pstmt3.setTimestamp(21, openAmtInv.getInvoice().getDateAcct());
                        pstmt3.setString(22, openAmtInv.getInvoice().isPaid() ? "Y" : "N");
                        pstmt3.setString(23, openAmtInv.getInvoice().isSOTrx() ? "Y" : "N");
                        if (openAmtInv.getInvoice().isCreditMemo()) {
                            pstmt3.setBigDecimal(24, openAmtInv.getInvoice().getGrandTotal().negate());
                        } else {
                            pstmt3.setBigDecimal(24, openAmtInv.getInvoice().getGrandTotal());
                        }
                        pstmt3.setBigDecimal(25, openAmtInv.getOpenAmt());
                        pstmt3.setBigDecimal(26, openAmtInv.getJP_OpenAmtPointOfTime());
                        pstmt3.setInt(27, this.m_MAcctSchema.getC_Currency_ID());
                        if (openAmtInv.getInvoice().isCreditMemo()) {
                            pstmt3.setBigDecimal(28, openAmtInv.getJP_ExchangedGrandTotal().negate());
                        } else {
                            pstmt3.setBigDecimal(28, openAmtInv.getJP_ExchangedGrandTotal());
                        }
                        pstmt3.setBigDecimal(29, openAmtInv.getJP_ExchangedOpenAmt());
                        pstmt3.setBigDecimal(30, openAmtInv.getJP_ExchangedOpenAmtPOT());
                        pstmt3.setBigDecimal(31, openAmtInv.getRate());
                        pstmt3.setTimestamp(32, this.p_JP_PointOfTime);
                        pstmt3.executeUpdate();
                    }
                }
                catch (Exception exception) {
                    DB.close(rs3, pstmt3);
                    rs3 = null;
                    pstmt3 = null;
                    break block60;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs3, pstmt3);
                rs3 = null;
                pstmt3 = null;
                throw throwable;
            }
            DB.close(rs3, (Statement)pstmt3);
            rs3 = null;
            pstmt3 = null;
        }
        return "OK";
    }

    private MAccount getReceivableAccount(MContractAcct contractAcct, int C_AcctSchema_ID) {
        MContractBPAcct bpAcct = contractAcct.getContractBPAcct(C_AcctSchema_ID, false);
        if (bpAcct != null && bpAcct.getC_Receivable_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)bpAcct.getC_Receivable_Acct());
        }
        return null;
    }

    private MAccount getPayableAccount(MContractAcct contractAcct, int C_AcctSchema_ID) {
        MContractBPAcct bpAcct = contractAcct.getContractBPAcct(C_AcctSchema_ID, false);
        if (bpAcct != null && bpAcct.getV_Liability_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)bpAcct.getV_Liability_Acct());
        }
        return null;
    }

    private class OpemAmtInvoice {
        private MInvoice invoice = null;
        private String DocBaseType = null;
        private int JP_Corporation_ID = 0;
        private int Account_ID = 0;
        private BigDecimal OpenAmt = Env.ZERO;
        private BigDecimal JP_OpenAmtPointOfTime = Env.ZERO;
        private BigDecimal JP_ExchangedGrandTotal = Env.ZERO;
        private BigDecimal JP_ExchangedOpenAmt = Env.ZERO;
        private BigDecimal JP_ExchangedOpenAmtPOT = Env.ZERO;
        private BigDecimal Rate = Env.ONE;

        public OpemAmtInvoice(MInvoice invoice, String DocBaseType, int JP_Corporation_ID, int Account_ID) {
            this.invoice = invoice;
            this.DocBaseType = DocBaseType;
            this.JP_Corporation_ID = JP_Corporation_ID;
            this.Account_ID = Account_ID;
            this.OpenAmt = invoice.getOpenAmt(true, null);
            this.JP_OpenAmtPointOfTime = JPiereInvoiceUtil.getOpenAmtPointOfTime(OpenAmtInvoiceListPointOfTime.this.getCtx(), invoice, OpenAmtInvoiceListPointOfTime.this.p_JP_PointOfTime, true, OpenAmtInvoiceListPointOfTime.this.get_TrxName());
            if (invoice.getC_Currency_ID() == OpenAmtInvoiceListPointOfTime.this.m_MAcctSchema.getC_Currency_ID()) {
                this.JP_ExchangedGrandTotal = invoice.getGrandTotal();
                this.JP_ExchangedOpenAmt = this.OpenAmt;
                this.JP_ExchangedOpenAmtPOT = this.JP_OpenAmtPointOfTime;
            } else {
                this.JP_ExchangedGrandTotal = MConversionRate.convert((Properties)OpenAmtInvoiceListPointOfTime.this.getCtx(), (BigDecimal)invoice.getGrandTotal(), (int)invoice.getC_Currency_ID(), (int)OpenAmtInvoiceListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                this.JP_ExchangedOpenAmt = MConversionRate.convert((Properties)OpenAmtInvoiceListPointOfTime.this.getCtx(), (BigDecimal)this.OpenAmt, (int)invoice.getC_Currency_ID(), (int)OpenAmtInvoiceListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                this.JP_ExchangedOpenAmtPOT = MConversionRate.convert((Properties)OpenAmtInvoiceListPointOfTime.this.getCtx(), (BigDecimal)this.JP_OpenAmtPointOfTime, (int)invoice.getC_Currency_ID(), (int)OpenAmtInvoiceListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
                this.Rate = MConversionRate.getRate((int)invoice.getC_Currency_ID(), (int)OpenAmtInvoiceListPointOfTime.this.m_MAcctSchema.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
            }
        }

        public MInvoice getInvoice() {
            return this.invoice;
        }

        public String getDocBaseType() {
            return this.DocBaseType;
        }

        public int getJP_Corporation_ID() {
            return this.JP_Corporation_ID;
        }

        public int getAccount_ID() {
            return this.Account_ID;
        }

        public BigDecimal getOpenAmt() {
            return this.OpenAmt;
        }

        public BigDecimal getJP_OpenAmtPointOfTime() {
            return this.JP_OpenAmtPointOfTime;
        }

        public BigDecimal getJP_ExchangedGrandTotal() {
            return this.JP_ExchangedGrandTotal;
        }

        public BigDecimal getJP_ExchangedOpenAmt() {
            return this.JP_ExchangedOpenAmt;
        }

        public BigDecimal getJP_ExchangedOpenAmtPOT() {
            return this.JP_ExchangedOpenAmtPOT;
        }

        public BigDecimal getRate() {
            return this.Rate;
        }
    }
}

