/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_WarehouseJP;
import jpiere.base.plugin.util.JPiereLocationUtil;
import jpiere.base.plugin.util.JPiereValidCombinationUtil;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_M_Warehouse_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportWarehouse
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE I_WarehouseJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_WarehouseJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.reverseLookupM_Warehouse_ID();
        this.reverseLookupAD_Org_ID();
        this.reverseLookupC_AcctSchema_ID();
        this.reverseLookupC_Location_ID();
        this.reverseLookupLocationAD_Org_ID();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_WarehouseJP WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY Value ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String preValue = "";
                MWarehouse warehouse = null;
                while (rs.next()) {
                    X_I_WarehouseJP imp = new X_I_WarehouseJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getM_Warehouse_ID() != 0) {
                        isNew = false;
                        warehouse = new MWarehouse(this.getCtx(), imp.getM_Warehouse_ID(), this.get_TrxName());
                    } else if (preValue.equals(imp.getValue())) {
                        isNew = false;
                    } else {
                        preValue = imp.getValue();
                    }
                    if (isNew) {
                        warehouse = new MWarehouse(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewWarehouse(imp, warehouse)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else if (this.updateWarehouse(imp, warehouse)) {
                        ++successUpdateNum;
                    } else {
                        ++failureUpdateNum;
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_WarehouseJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private void reverseLookupM_Warehouse_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Value");
        sql = new StringBuilder("UPDATE I_WarehouseJP i ").append("SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.M_Warehouse_ID IS NULL AND i.Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_WarehouseJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_WarehouseJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_AcctSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_WarehouseJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_WarehouseJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_Location_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Location_Label");
        sql = new StringBuilder("UPDATE I_WarehouseJP i ").append("SET C_Location_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_Location_Label= p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_Location_ID IS NULL AND JP_Location_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
    }

    private void reverseLookupLocationAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LocationOrg_Value");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_LocationOrg_Value");
        sql = new StringBuilder("UPDATE I_WarehouseJP i ").append("SET JP_LocationOrg_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_LocationOrg_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.JP_LocationOrg_ID IS NULL AND i.JP_LocationOrg_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_LocationOrg_Value");
        sql = new StringBuilder("UPDATE I_WarehouseJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_LocationOrg_ID = 0 AND JP_LocationOrg_Value IS NOT NULL AND JP_LocationOrg_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no + ":" + sql);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void setMWarehouseAcct(MWarehouse wh, X_I_WarehouseJP impWarehouse) {
        block10: {
            int C_ValidCombination_ID = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), impWarehouse.getC_AcctSchema_ID(), impWarehouse.getJP_W_Differences_Value(), this.get_TrxName());
            if (C_ValidCombination_ID == -1) {
                return;
            }
            impWarehouse.setW_Differences_Acct(C_ValidCombination_ID);
            String WhereClause = " C_AcctSchema_ID=" + impWarehouse.getC_AcctSchema_ID() + " AND M_Warehouse_ID=" + wh.getM_Warehouse_ID() + " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx());
            StringBuilder sql = new StringBuilder("SELECT * FROM M_Warehouse_Acct WHERE " + WhereClause);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        X_M_Warehouse_Acct acct = new X_M_Warehouse_Acct(this.getCtx(), rs, this.get_TrxName());
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impWarehouse, (PO)acct, 30);
                        if (acct.getW_Differences_Acct() != C_ValidCombination_ID) {
                            acct.setW_Differences_Acct(C_ValidCombination_ID);
                            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"W_Differences_Acct");
                            if (Util.isEmpty((String)impWarehouse.getI_ErrorMsg())) {
                                impWarehouse.setI_ErrorMsg(msg);
                            } else {
                                impWarehouse.setI_ErrorMsg(String.valueOf(impWarehouse.getI_ErrorMsg()) + " / " + msg);
                            }
                        }
                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impWarehouse, (PO)acct, 40);
                        acct.saveEx(this.get_TrxName());
                        this.commitEx();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private boolean createNewWarehouse(X_I_WarehouseJP impWarehouse, MWarehouse newWarehouse) {
        if (impWarehouse.getAD_Org_ID() <= 0) {
            impWarehouse.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value"));
            impWarehouse.setI_IsImported(false);
            impWarehouse.setProcessed(false);
            impWarehouse.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)impWarehouse.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            impWarehouse.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impWarehouse.setI_IsImported(false);
            impWarehouse.setProcessed(false);
            impWarehouse.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)impWarehouse.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            impWarehouse.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impWarehouse.setI_IsImported(false);
            impWarehouse.setProcessed(false);
            impWarehouse.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impWarehouse, (PO)newWarehouse, 30);
        newWarehouse.setAD_Org_ID(impWarehouse.getAD_Org_ID());
        newWarehouse.setValue(impWarehouse.getValue());
        newWarehouse.setName(impWarehouse.getName());
        if (!Util.isEmpty((String)impWarehouse.getDescription())) {
            newWarehouse.setDescription(impWarehouse.getDescription());
        }
        newWarehouse.setIsInTransit(impWarehouse.isInTransit());
        newWarehouse.setIsDisallowNegativeInv(impWarehouse.isDisallowNegativeInv());
        if (!Util.isEmpty((String)impWarehouse.getSeparator())) {
            newWarehouse.setSeparator(impWarehouse.getSeparator());
        }
        if (!Util.isEmpty((String)impWarehouse.getReplenishmentClass())) {
            newWarehouse.setReplenishmentClass(impWarehouse.getReplenishmentClass());
        }
        if (impWarehouse.getC_Location_ID() > 0) {
            newWarehouse.setC_Location_ID(impWarehouse.getC_Location_ID());
        } else {
            int C_Location_ID = JPiereLocationUtil.searchLocationByLabel(this.getCtx(), impWarehouse.getJP_Location_Label(), this.get_TrxName());
            if (C_Location_ID <= 0) {
                C_Location_ID = JPiereLocationUtil.createLocation(this.getCtx(), impWarehouse.getJP_LocationOrg_ID(), impWarehouse.getJP_Location_Label(), impWarehouse.getComments(), impWarehouse.getCountryCode(), impWarehouse.getPostal(), impWarehouse.getPostal_Add(), impWarehouse.getJP_Region_Name(), impWarehouse.getRegionName(), impWarehouse.getJP_City_Name(), impWarehouse.getCity(), impWarehouse.getAddress1(), impWarehouse.getAddress2(), impWarehouse.getAddress3(), impWarehouse.getAddress4(), impWarehouse.getAddress5(), this.get_TrxName());
            }
            newWarehouse.setC_Location_ID(C_Location_ID);
            impWarehouse.setC_Location_ID(C_Location_ID);
        }
        newWarehouse.setIsActive(impWarehouse.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impWarehouse, (PO)newWarehouse, 40);
        try {
            newWarehouse.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impWarehouse.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " : " + e.toString());
            impWarehouse.setI_IsImported(false);
            impWarehouse.setProcessed(false);
            impWarehouse.saveEx(this.get_TrxName());
            return false;
        }
        impWarehouse.setM_Warehouse_ID(newWarehouse.getM_Warehouse_ID());
        if (!Util.isEmpty((String)impWarehouse.getJP_W_Differences_Value()) && impWarehouse.getC_AcctSchema_ID() > 0) {
            this.setMWarehouseAcct(newWarehouse, impWarehouse);
        }
        if (Util.isEmpty((String)impWarehouse.getI_ErrorMsg())) {
            impWarehouse.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        } else {
            impWarehouse.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord")) + " / " + impWarehouse.getI_ErrorMsg());
        }
        impWarehouse.setI_IsImported(true);
        impWarehouse.setProcessed(true);
        impWarehouse.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateWarehouse(X_I_WarehouseJP impWarehouse, MWarehouse updateWarehouse) {
        if (Util.isEmpty((String)impWarehouse.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            impWarehouse.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impWarehouse.setI_IsImported(false);
            impWarehouse.setProcessed(false);
            impWarehouse.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impWarehouse, (PO)updateWarehouse, 30);
        if (!Util.isEmpty((String)impWarehouse.getName())) {
            updateWarehouse.setName(impWarehouse.getName());
        }
        if (!Util.isEmpty((String)impWarehouse.getDescription())) {
            updateWarehouse.setDescription(impWarehouse.getDescription());
        }
        updateWarehouse.setIsInTransit(impWarehouse.isInTransit());
        updateWarehouse.setIsDisallowNegativeInv(impWarehouse.isDisallowNegativeInv());
        if (!Util.isEmpty((String)impWarehouse.getSeparator())) {
            updateWarehouse.setSeparator(impWarehouse.getSeparator());
        }
        if (!Util.isEmpty((String)impWarehouse.getReplenishmentClass())) {
            updateWarehouse.setReplenishmentClass(impWarehouse.getReplenishmentClass());
        }
        if (impWarehouse.getC_Location_ID() > 0) {
            updateWarehouse.setC_Location_ID(impWarehouse.getC_Location_ID());
        }
        updateWarehouse.setIsActive(impWarehouse.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impWarehouse, (PO)updateWarehouse, 40);
        try {
            updateWarehouse.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impWarehouse.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Warehouse_ID") + " :  " + e.toString());
            impWarehouse.setI_IsImported(false);
            impWarehouse.setProcessed(false);
            impWarehouse.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)impWarehouse.getJP_W_Differences_Value()) && impWarehouse.getC_AcctSchema_ID() > 0) {
            this.setMWarehouseAcct(updateWarehouse, impWarehouse);
        }
        if (Util.isEmpty((String)impWarehouse.getI_ErrorMsg())) {
            impWarehouse.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        } else {
            impWarehouse.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + " / " + impWarehouse.getI_ErrorMsg());
        }
        impWarehouse.setI_IsImported(true);
        impWarehouse.setProcessed(true);
        impWarehouse.saveEx(this.get_TrxName());
        return true;
    }
}

