/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_ProductCategoryJP;
import jpiere.base.plugin.util.JPiereValidCombinationUtil;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MProductCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_M_Product_Category_Acct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportProductCategory
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private IProcessUI processMonitor = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE I_ProductCategoryJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_ProductCategoryJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.reverseLookupM_Product_Category_ID();
        this.reverseLookupAD_Org_ID();
        this.reverseLookupJP_ProductCategoryL1_ID();
        this.reverseLookupA_Asset_Group_ID();
        this.reverseLookupAD_PrintColor_ID();
        this.reverseLookupC_AcctSchema_ID();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        sql = new StringBuilder("SELECT * FROM I_ProductCategoryJP WHERE I_IsImported='N'").append(clientCheck);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_I_ProductCategoryJP imp = new X_I_ProductCategoryJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getM_Product_Category_ID() != 0) {
                        isNew = false;
                    }
                    if (isNew) {
                        MProductCategory newProductCategory = new MProductCategory(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewProductCategory(imp, newProductCategory)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else {
                        MProductCategory updateProductCategory = new MProductCategory(this.getCtx(), imp.getM_Product_Category_ID(), this.get_TrxName());
                        if (this.updateProductCategory(imp, updateProductCategory)) {
                            ++successUpdateNum;
                        } else {
                            ++failureUpdateNum;
                        }
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(records) + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    private void setProductCategoryAcct(MProductCategory pc, X_I_ProductCategoryJP imp) {
        int P_LandedCostClearing_Acct;
        int P_AverageCostVariance_Acct;
        int P_RateVariance_Acct;
        int P_TradeDiscountGrant_Acct;
        int P_TradeDiscountRec_Acct;
        int P_InvoicePriceVariance_Acct;
        int P_PurchasePriceVariance_Acct;
        int P_Revenue_Acct;
        int P_COGS_Acct;
        int P_InventoryClearing_Acct;
        int P_CostAdjustment_Acct;
        int P_Expense_Acct;
        String msg;
        int P_Asset_Acct;
        X_M_Product_Category_Acct acct;
        block61: {
            acct = null;
            String WhereClause = " C_AcctSchema_ID=" + imp.getC_AcctSchema_ID() + " AND M_Product_Category_ID=" + pc.getM_Product_Category_ID() + " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx());
            StringBuilder sql = new StringBuilder("SELECT * FROM M_Product_Category_Acct WHERE " + WhereClause);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        acct = new X_M_Product_Category_Acct(this.getCtx(), rs, this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block61;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (acct == null) {
            return;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)acct, 30);
        if (!Util.isEmpty((String)imp.getCostingMethod())) {
            acct.setCostingMethod(imp.getCostingMethod());
        }
        if (!Util.isEmpty((String)imp.getCostingLevel())) {
            acct.setCostingLevel(imp.getCostingLevel());
        }
        if (!Util.isEmpty((String)imp.getJP_P_Asset_Acct_Value()) && (P_Asset_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_P_Asset_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setP_Asset_Acct(P_Asset_Acct);
            if (acct.getP_Asset_Acct() != P_Asset_Acct) {
                acct.setP_Asset_Acct(P_Asset_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_Asset_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_P_Expense_Acct_Value()) && (P_Expense_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_P_Expense_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setP_Expense_Acct(P_Expense_Acct);
            if (acct.getP_Expense_Acct() != P_Expense_Acct) {
                acct.setP_Expense_Acct(P_Expense_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_Expense_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_CostAdjustment_Value()) && (P_CostAdjustment_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_CostAdjustment_Value(), this.get_TrxName())) > 0) {
            imp.setP_CostAdjustment_Acct(P_CostAdjustment_Acct);
            if (acct.getP_CostAdjustment_Acct() != P_CostAdjustment_Acct) {
                acct.setP_CostAdjustment_Acct(P_CostAdjustment_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_CostAdjustment_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_InventoryClearing_Value()) && (P_InventoryClearing_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_InventoryClearing_Value(), this.get_TrxName())) > 0) {
            imp.setP_InventoryClearing_Acct(P_InventoryClearing_Acct);
            if (acct.getP_InventoryClearing_Acct() != P_InventoryClearing_Acct) {
                acct.setP_InventoryClearing_Acct(P_InventoryClearing_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_InventoryClearing_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_COGS_Acct_Value()) && (P_COGS_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_COGS_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setP_COGS_Acct(P_COGS_Acct);
            if (acct.getP_COGS_Acct() != P_COGS_Acct) {
                acct.setP_COGS_Acct(P_COGS_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_COGS_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_P_Revenue_Acct_Value()) && (P_Revenue_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_P_Revenue_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setP_Revenue_Acct(P_Revenue_Acct);
            if (acct.getP_Revenue_Acct() != P_Revenue_Acct) {
                acct.setP_Revenue_Acct(P_Revenue_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_Revenue_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_PO_PriceVariance_Value()) && (P_PurchasePriceVariance_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_PO_PriceVariance_Value(), this.get_TrxName())) > 0) {
            imp.setP_PurchasePriceVariance_Acct(P_PurchasePriceVariance_Acct);
            if (acct.getP_PurchasePriceVariance_Acct() != P_PurchasePriceVariance_Acct) {
                acct.setP_PurchasePriceVariance_Acct(P_PurchasePriceVariance_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_PurchasePriceVariance_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_InvoicePriceVariance_Value()) && (P_InvoicePriceVariance_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_InvoicePriceVariance_Value(), this.get_TrxName())) > 0) {
            imp.setP_InvoicePriceVariance_Acct(P_InvoicePriceVariance_Acct);
            if (acct.getP_InvoicePriceVariance_Acct() != P_InvoicePriceVariance_Acct) {
                acct.setP_InvoicePriceVariance_Acct(P_InvoicePriceVariance_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_InvoicePriceVariance_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_P_TradeDiscountRec_Value()) && (P_TradeDiscountRec_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_P_TradeDiscountRec_Value(), this.get_TrxName())) > 0) {
            imp.setP_TradeDiscountRec_Acct(P_TradeDiscountRec_Acct);
            if (acct.getP_TradeDiscountRec_Acct() != P_TradeDiscountRec_Acct) {
                acct.setP_TradeDiscountRec_Acct(P_TradeDiscountRec_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_TradeDiscountRec_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_P_TradeDiscountGrant_Value()) && (P_TradeDiscountGrant_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_P_TradeDiscountGrant_Value(), this.get_TrxName())) > 0) {
            imp.setP_TradeDiscountGrant_Acct(P_TradeDiscountGrant_Acct);
            if (acct.getP_TradeDiscountGrant_Acct() != P_TradeDiscountGrant_Acct) {
                acct.setP_TradeDiscountGrant_Acct(P_TradeDiscountGrant_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_TradeDiscountGrant_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_RateVariance_Acct_Value()) && (P_RateVariance_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_RateVariance_Acct_Value(), this.get_TrxName())) > 0) {
            imp.setP_RateVariance_Acct(P_RateVariance_Acct);
            if (acct.getP_RateVariance_Acct() != P_RateVariance_Acct) {
                acct.setP_RateVariance_Acct(P_RateVariance_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_RateVariance_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_AverageCostVariance_Value()) && (P_AverageCostVariance_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_AverageCostVariance_Value(), this.get_TrxName())) > 0) {
            imp.setP_AverageCostVariance_Acct(P_AverageCostVariance_Acct);
            if (acct.getP_AverageCostVariance_Acct() != P_AverageCostVariance_Acct) {
                acct.setP_AverageCostVariance_Acct(P_AverageCostVariance_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_AverageCostVariance_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        if (!Util.isEmpty((String)imp.getJP_LandedCostClearing_Value()) && (P_LandedCostClearing_Acct = JPiereValidCombinationUtil.searchCreateValidCombination(this.getCtx(), imp.getC_AcctSchema_ID(), imp.getJP_LandedCostClearing_Value(), this.get_TrxName())) > 0) {
            imp.setP_LandedCostClearing_Acct(P_LandedCostClearing_Acct);
            if (acct.getP_LandedCostClearing_Acct() != P_LandedCostClearing_Acct) {
                acct.setP_LandedCostClearing_Acct(P_LandedCostClearing_Acct);
                msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + ": " + Msg.getElement((Properties)this.getCtx(), (String)"P_LandedCostClearing_Acct");
                if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
                    imp.setI_ErrorMsg(msg);
                } else {
                    imp.setI_ErrorMsg(String.valueOf(imp.getI_ErrorMsg()) + " / " + msg);
                }
            }
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)acct, 40);
        acct.saveEx(this.get_TrxName());
    }

    public String getImportTableName() {
        return "I_ProductCategoryJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private void reverseLookupM_Product_Category_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Value");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP i ").append("SET M_Product_Category_ID=(SELECT M_Product_Category_ID FROM M_Product_Category p").append(" WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.M_Product_Category_ID IS NULL AND i.Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
    }

    private void reverseLookupAD_Org_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N'  ) ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupJP_ProductCategoryL1_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProductCategoryL1_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProductCategoryL1_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProductCategoryL1_Value");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP i ").append("SET JP_ProductCategoryL1_ID=(SELECT JP_ProductCategoryL1_ID FROM JP_ProductCategoryL1 p").append(" WHERE i.JP_ProductCategoryL1_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_ProductCategoryL1_ID IS NULL AND i.JP_ProductCategoryL1_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ProductCategoryL1_Value");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE JP_ProductCategoryL1_ID IS NULL AND JP_ProductCategoryL1_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupA_Asset_Group_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"A_Asset_Group_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"A_Asset_Group_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Asset_Group_Name");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP i ").append("SET A_Asset_Group_ID=(SELECT A_Asset_Group_ID FROM A_Asset_Group p").append(" WHERE i.JP_Asset_Group_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.A_Asset_Group_ID IS NULL AND i.JP_Asset_Group_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Asset_Group_Name");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE A_Asset_Group_ID IS NULL AND JP_Asset_Group_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupAD_PrintColor_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_PrintColor_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_PrintColor_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_PrintColor_Name");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP i ").append("SET AD_PrintColor_ID=(SELECT AD_PrintColor_ID FROM AD_PrintColor p").append(" WHERE i.JP_PrintColor_Name=p.Name AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) ) ").append(" WHERE i.AD_PrintColor_ID IS NULL AND i.JP_PrintColor_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PrintColor_Name");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE AD_PrintColor_ID IS NULL AND JP_PrintColor_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private void reverseLookupC_AcctSchema_ID() throws Exception {
        StringBuilder sql = new StringBuilder();
        String msg = new String();
        int no = 0;
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID") + " - " + Msg.getMsg((Properties)this.getCtx(), (String)"MatchFrom") + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP i ").append("SET C_AcctSchema_ID=(SELECT C_AcctSchema_ID FROM C_AcctSchema p").append(" WHERE i.JP_AcctSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_AcctSchema_Name");
        sql = new StringBuilder("UPDATE I_ProductCategoryJP ").append("SET I_ErrorMsg='" + msg + "'").append(" WHERE C_AcctSchema_ID IS NULL AND JP_AcctSchema_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(msg) + "=" + no);
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg + " : " + sql);
        }
        if (no > 0) {
            this.commitEx();
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + msg);
        }
    }

    private boolean createNewProductCategory(X_I_ProductCategoryJP impProductCategory, MProductCategory newProductCategory) {
        if (Util.isEmpty((String)impProductCategory.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            impProductCategory.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impProductCategory.setI_IsImported(false);
            impProductCategory.setProcessed(false);
            impProductCategory.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)impProductCategory.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            impProductCategory.setI_ErrorMsg(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            impProductCategory.setI_IsImported(false);
            impProductCategory.setProcessed(false);
            impProductCategory.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impProductCategory, (PO)newProductCategory, 30);
        newProductCategory.setAD_Org_ID(impProductCategory.getAD_Org_ID());
        newProductCategory.setValue(impProductCategory.getValue());
        newProductCategory.setName(impProductCategory.getName());
        if (!Util.isEmpty((String)impProductCategory.getDescription())) {
            newProductCategory.setDescription(impProductCategory.getDescription());
        }
        newProductCategory.setIsDefault(impProductCategory.isDefault());
        newProductCategory.setIsSelfService(impProductCategory.isSelfService());
        if (impProductCategory.getJP_ProductCategoryL1_ID() > 0) {
            newProductCategory.set_ValueNoCheck("JP_ProductCategoryL1_ID", (Object)impProductCategory.getJP_ProductCategoryL1_ID());
        }
        newProductCategory.setMMPolicy(impProductCategory.getMMPolicy());
        if (impProductCategory.getPlannedMargin() != null) {
            newProductCategory.setPlannedMargin(impProductCategory.getPlannedMargin());
        }
        if (impProductCategory.getA_Asset_Group_ID() > 0) {
            newProductCategory.setA_Asset_Group_ID(impProductCategory.getA_Asset_Group_ID());
        }
        if (impProductCategory.getAD_PrintColor_ID() > 0) {
            newProductCategory.setAD_PrintColor_ID(impProductCategory.getAD_PrintColor_ID());
        }
        newProductCategory.setIsActive(impProductCategory.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impProductCategory, (PO)newProductCategory, 40);
        try {
            newProductCategory.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            impProductCategory.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID"));
            impProductCategory.setI_IsImported(false);
            impProductCategory.setProcessed(false);
            impProductCategory.saveEx(this.get_TrxName());
            return false;
        }
        impProductCategory.setM_Product_Category_ID(newProductCategory.getM_Product_Category_ID());
        if (!Util.isEmpty((String)impProductCategory.getJP_AcctSchema_Name()) && impProductCategory.getC_AcctSchema_ID() > 0) {
            this.setProductCategoryAcct(newProductCategory, impProductCategory);
        }
        if (Util.isEmpty((String)impProductCategory.getI_ErrorMsg())) {
            impProductCategory.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        } else {
            impProductCategory.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord")) + "  &  " + impProductCategory.getI_ErrorMsg());
        }
        impProductCategory.setI_IsImported(true);
        impProductCategory.setProcessed(true);
        impProductCategory.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateProductCategory(X_I_ProductCategoryJP imp, MProductCategory updateProductCategory) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)updateProductCategory, 30);
        updateProductCategory.setAD_Org_ID(imp.getAD_Org_ID());
        updateProductCategory.setName(imp.getName());
        if (!Util.isEmpty((String)imp.getDescription())) {
            updateProductCategory.setValue(imp.getDescription());
        }
        updateProductCategory.setIsDefault(imp.isDefault());
        updateProductCategory.setIsSelfService(imp.isSelfService());
        if (imp.getJP_ProductCategoryL1_ID() > 0) {
            updateProductCategory.set_ValueNoCheck("JP_ProductCategoryL1_ID", (Object)imp.getJP_ProductCategoryL1_ID());
        }
        updateProductCategory.setMMPolicy(imp.getMMPolicy());
        if (imp.getPlannedMargin() != null) {
            updateProductCategory.setPlannedMargin(imp.getPlannedMargin());
        }
        if (imp.getA_Asset_Group_ID() > 0) {
            updateProductCategory.setA_Asset_Group_ID(imp.getA_Asset_Group_ID());
        }
        if (imp.getAD_PrintColor_ID() > 0) {
            updateProductCategory.setAD_PrintColor_ID(imp.getAD_PrintColor_ID());
        }
        updateProductCategory.setIsActive(imp.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)imp, (PO)updateProductCategory, 40);
        try {
            updateProductCategory.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID") + " :  " + e.toString());
            imp.setI_IsImported(false);
            imp.setProcessed(false);
            imp.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)imp.getJP_AcctSchema_Name()) && imp.getC_AcctSchema_ID() > 0) {
            this.setProductCategoryAcct(updateProductCategory, imp);
        }
        if (Util.isEmpty((String)imp.getI_ErrorMsg())) {
            imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        } else {
            imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Update")) + "  &  " + imp.getI_ErrorMsg());
        }
        imp.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        imp.setI_IsImported(true);
        imp.setProcessed(true);
        imp.saveEx(this.get_TrxName());
        return true;
    }
}

