/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_InvoiceJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportInvoice
extends SvrProcess
implements ImportProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_DeleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String p_DocAction = "PR";
    private Timestamp p_DateValue = null;
    private String message = null;
    private String p_JP_ImportSalesRepIdentifier = "VA";
    private String p_JP_ImportUserIdentifier = "NA";
    private IProcessUI processMonitor = null;
    private boolean p_IsHistoricalDataMigration = false;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("DocAction")) {
                this.p_DocAction = (String)para[i].getParameter();
            } else if (name.equals("JP_ImportSalesRepIdentifier")) {
                this.p_JP_ImportSalesRepIdentifier = para[i].getParameterAsString();
            } else if (name.equals("JP_ImportUserIdentifier")) {
                this.p_JP_ImportUserIdentifier = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.p_DateValue == null) {
            this.p_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        if (this.p_DeleteOldImported) {
            sql = new StringBuilder("DELETE I_InvoiceJP ").append("WHERE I_IsImported='Y' ").append(this.getWhereClause());
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y' ").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Invoice_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_DocType_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"SalesRep_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupSalesRep_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_PriceList_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentTerm_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_PaymentTerm_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Project_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Project_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Campaign_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Campaign_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Activity_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Activity_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User1_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupUser1_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User2_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupUser2_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_Product_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Charge_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Charge_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_UOM_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_UOM_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Tax_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Tax_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Project_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_Project_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Campaign_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_Campaign_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Activity_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_Activity_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_User1_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_User1_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"User2_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Line_User2_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CreateNew")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        sql = new StringBuilder("SELECT * FROM I_InvoiceJP ").append("WHERE I_IsImported='N'").append(this.getWhereClause()).append(" ORDER BY DateInvoiced, C_BPartner_ID, C_BPartner_Location_ID, DocumentNo, I_InvoiceJP_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int skipNum = 0;
        int errorNum = 0;
        int successNum = 0;
        int successCreateDocHeader = 0;
        int successCreateDocLine = 0;
        int failureCreateDocHeader = 0;
        int failureCreateDocLine = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String skipRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfSkipRecords");
        String errorRecords = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfUnexpectedErrorRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String createHeader = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateHeader");
        String createLine = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateLine");
        String detail = Msg.getMsg((Properties)this.getCtx(), (String)"JP_DetailLog");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                int lastC_BPartner_ID = 0;
                int lastC_BPartner_Location_ID = 0;
                String lastDocumentNo = "";
                MInvoice invoice = null;
                MInvoiceLine line = null;
                X_I_InvoiceJP imp = null;
                int lineNo = 0;
                boolean isCreateHeader = true;
                while (rs.next()) {
                    ++recordsNum;
                    imp = new X_I_InvoiceJP(this.getCtx(), rs, this.get_TrxName());
                    if (imp.getC_Invoice_ID() > 0) {
                        ++skipNum;
                        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"AlreadyExists");
                        imp.setI_ErrorMsg(msg);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    String cmpDocumentNo = imp.getDocumentNo();
                    if (cmpDocumentNo == null) {
                        cmpDocumentNo = "";
                    }
                    isCreateHeader = true;
                    if (lastC_BPartner_ID != imp.getC_BPartner_ID() || lastC_BPartner_Location_ID != imp.getC_BPartner_Location_ID() || !lastDocumentNo.equals(cmpDocumentNo)) {
                        if (invoice != null) {
                            if (!Util.isEmpty((String)this.p_DocAction) && !invoice.processIt(this.p_DocAction)) {
                                this.rollback();
                                this.message = "Invoice Process Failed: " + invoice.getProcessMsg();
                                invoice = null;
                                imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message);
                                imp.saveEx(this.get_TrxName());
                                this.commitEx();
                            }
                            if (invoice != null) {
                                invoice.saveEx(this.get_TrxName());
                                invoice = null;
                                this.commitEx();
                            }
                        }
                        lastC_BPartner_ID = imp.getC_BPartner_ID();
                        lastC_BPartner_Location_ID = imp.getC_BPartner_Location_ID();
                        lastDocumentNo = imp.getDocumentNo();
                        if (lastDocumentNo == null) {
                            lastDocumentNo = "";
                        }
                    } else {
                        isCreateHeader = false;
                    }
                    if (isCreateHeader) {
                        invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                        lineNo = 0;
                        if (this.createInvoiceHeader(imp, invoice)) {
                            ++successCreateDocHeader;
                        } else {
                            this.rollback();
                            invoice = null;
                            ++failureCreateDocHeader;
                            ++errorNum;
                            imp.setI_ErrorMsg(this.message);
                            imp.setI_IsImported(false);
                            imp.setProcessed(false);
                            imp.saveEx(this.get_TrxName());
                            this.commitEx();
                            continue;
                        }
                    }
                    if (invoice == null) {
                        this.rollback();
                        ++errorNum;
                        String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_UnexpectedError");
                        imp.setI_ErrorMsg(msg);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    imp.setC_Invoice_ID(invoice.getC_Invoice_ID());
                    line = new MInvoiceLine(invoice);
                    if (this.addInvoiceLine(imp, invoice, line, lineNo += 10)) {
                        ++successCreateDocLine;
                        ++successNum;
                    } else {
                        this.rollback();
                        invoice = null;
                        ++failureCreateDocLine;
                        ++errorNum;
                        imp.setI_ErrorMsg(this.message);
                        imp.setI_IsImported(false);
                        imp.setProcessed(false);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                        continue;
                    }
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]");
                }
                if (invoice != null) {
                    if (this.p_IsHistoricalDataMigration) {
                        invoice.setDocStatus("CL");
                        invoice.setDocAction("--");
                        invoice.setProcessed(true);
                        invoice.setPosted(true);
                    } else if (!Util.isEmpty((String)this.p_DocAction) && !invoice.processIt(this.p_DocAction)) {
                        this.rollback();
                        this.message = "Invoice Process Failed: " + invoice.getProcessMsg();
                        invoice = null;
                        imp.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message);
                        imp.saveEx(this.get_TrxName());
                        this.commitEx();
                    }
                    if (invoice != null) {
                        invoice.saveEx(this.get_TrxName());
                        invoice = null;
                        this.commitEx();
                    }
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.message = String.valueOf(records) + " : " + recordsNum + " = " + skipRecords + " : " + skipNum + " + " + errorRecords + " : " + errorNum + " + " + success + " : " + successNum + "   [" + detail + " --> " + createHeader + "( " + success + " : " + successCreateDocHeader + "  /  " + failure + " : " + failureCreateDocHeader + " ) + " + createLine + " ( " + success + " : " + successCreateDocLine + "  /  " + failure + " : " + failureCreateDocLine + " ) ]";
        return this.message;
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        return msgreturn.toString();
    }

    public String getImportTableName() {
        return "I_InvoiceJP";
    }

    private boolean reverseLookupC_Invoice_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_Invoice_ID=(SELECT MAX(C_Invoice_ID) FROM C_Invoice p").append(" WHERE i.DocumentNo=p.DocumentNo AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.DocumentNo IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_DocType_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.JP_DocType_Name").append(" AND d.DocBaseType='API' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND JP_DocType_Name IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.JP_DocType_Name").append(" AND d.DocBaseType='ARI' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND JP_DocType_Name IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.JP_DocType_Name").append(" AND d.DocBaseType IN ('API','ARI','APC','ARC') AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND JP_DocType_Name IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_DocType_Name");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_DocType_ID IS NULL AND JP_DocType_Name IS NOT NULL  ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        if (no > 0) {
            return false;
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='API' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType='ARI' AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y'").append(" AND d.DocBaseType IN('API','ARI') AND o.AD_Client_ID=d.AD_Client_ID) ").append("WHERE C_DocType_ID IS NULL AND IsSOTrx IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null") + Msg.getElement((Properties)this.getCtx(), (String)"C_DocType_ID");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_DocType_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o SET IsSOTrx='Y' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='ARI' AND o.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o SET IsSOTrx='N' ").append("WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='API' AND o.AD_Client_ID=d.AD_Client_ID)").append(" AND C_DocType_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupSalesRep_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportSalesRepIdentifier) || this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportSalesRepIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail IS NULL l AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name  AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND i.JP_SalesRep_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y'  ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupM_PriceList_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.Name=o.JP_PriceList_Name AND o.AD_Client_ID=p.AD_Client_ID) ").append(" WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_Currency_ID=(SELECT C_Currency_ID FROM M_PriceList p ").append(" WHERE p.M_PriceList_ID=o.M_PriceList_ID ) ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y'").append(" AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p ").append(" WHERE p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_PriceList_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Project_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_Project_ID=(SELECT C_Project_ID FROM C_Project p").append(" WHERE i.JP_Project_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Project_ID IS NULL AND i.JP_Project_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Project_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Project_ID IS NULL AND JP_Project_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_Project_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET JP_Line_Project_ID=(SELECT C_Project_ID FROM C_Project p").append(" WHERE i.JP_Line_Project_Value=p.Value AND  (i.AD_Client_ID=p.AD_Client_ID or p.AD_Client_ID = 0) ) ").append("WHERE i.JP_Line_Project_ID IS NULL AND i.JP_Line_Project_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Project_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_Project_ID IS NULL AND JP_Line_Project_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Campaign_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_Campaign_ID=(SELECT C_Campaign_ID FROM C_Campaign p").append(" WHERE i.JP_Campaign_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Campaign_ID IS NULL AND i.JP_Campaign_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Campaign_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Campaign_ID IS NULL AND JP_Campaign_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_Campaign_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET JP_Line_Campaign_ID=(SELECT C_Campaign_ID FROM C_Campaign p").append(" WHERE i.JP_Line_Campaign_Value=p.Value AND  (i.AD_Client_ID=p.AD_Client_ID or p.AD_Client_ID = 0) ) ").append("WHERE i.JP_Line_Campaign_ID IS NULL AND i.JP_Line_Campaign_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Campaign_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_Campaign_ID IS NULL AND JP_Line_Campaign_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Activity_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_Activity_ID=(SELECT C_Activity_ID FROM C_Activity p").append(" WHERE i.JP_Activity_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_Activity_ID IS NULL AND i.JP_Activity_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Activity_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_Activity_ID IS NULL AND JP_Activity_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_Activity_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET JP_Line_Activity_ID=(SELECT C_Activity_ID FROM C_Activity p").append(" WHERE i.JP_Line_Activity_Value=p.Value AND  (i.AD_Client_ID=p.AD_Client_ID or p.AD_Client_ID = 0) ) ").append("WHERE i.JP_Line_Activity_ID IS NULL AND i.JP_Line_Activity_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_Activity_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_Activity_ID IS NULL AND JP_Line_Activity_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_OrgTrx_ID IS NULL AND JP_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET JP_Line_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Line_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N' ) ").append(" WHERE i.JP_Line_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Line_OrgTrx_ID IS NULL AND JP_Line_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupUser1_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET User1_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_UserElement1_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.User1_ID IS NULL AND i.JP_UserElement1_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_UserElement1_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE User1_ID IS NULL AND JP_UserElement1_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_User1_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET JP_Line_User1_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_Line_UserElement1_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.JP_Line_User1_ID IS NULL AND i.JP_Line_UserElement1_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_UserElement1_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_User1_ID IS NULL AND JP_Line_UserElement1_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupUser2_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET User2_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_UserElement2_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.User2_ID IS NULL AND i.JP_UserElement2_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_UserElement2_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE User2_ID IS NULL AND JP_UserElement2_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Line_User2_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET JP_Line_User2_ID=(SELECT C_ElementValue_ID FROM C_ElementValue p").append(" WHERE i.JP_Line_UserElement2_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.JP_Line_User2_ID IS NULL AND i.JP_Line_UserElement2_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Line_UserElement2_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Line_User2_ID IS NULL AND JP_Line_UserElement2_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_PaymentTerm_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p").append(" WHERE o.JP_PaymentTerm_Value=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND JP_PaymentTerm_Value IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p").append(" WHERE p.IsDefault='Y' AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE C_PaymentTerm_ID IS NULL AND o.JP_PaymentTerm_Value IS NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentTerm_ID");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_PaymentTerm_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.JP_BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.JP_BPartner_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_BPartner_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BPartner_Location_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location p").append(" WHERE i.JP_BPartner_Location_Name=p.Name AND i.C_BPartner_ID=p.C_BPartner_ID) ").append("WHERE i.C_BPartner_Location_ID IS NULL AND i.JP_BPartner_Location_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_BPartner_Location_ID=(SELECT max(C_BPartner_Location_ID) FROM C_BPartner_Location p").append(" WHERE i.C_BPartner_ID=p.C_BPartner_ID AND i.Phone = p.phone) ").append(" WHERE i.C_BPartner_Location_ID IS NULL AND i.JP_BPartner_Location_Name IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Location_Name");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_BPartner_Location_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_User_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        if (this.p_JP_ImportUserIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_EMail IS NULL AND i.AD_User_ID IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name  AND i.JP_User_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL AND i.JP_User_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.JP_User_Name=p.Name  AND i.JP_User_EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )").append(" AND i.C_BPartner_ID = p.C_BPartner_ID )").append(" WHERE i.JP_User_Value IS NOT NULL AND i.JP_User_Name IS NOT NULL AND i.JP_User_EMail IS NULL AND i.AD_User_ID IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportUserIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        try {
            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupM_Product_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p").append(" WHERE o.JP_Product_Value=p.Value AND o.AD_Client_ID=p.AD_Client_ID) ").append("WHERE M_Product_ID IS NULL AND JP_Product_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"M_Product_ID");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE M_Product_ID IS NULL AND JP_Product_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Charge_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge c").append(" WHERE o.JP_Charge_Name=c.Name AND o.AD_Client_ID=c.AD_Client_ID) ").append("WHERE C_Charge_ID IS NULL AND JP_Charge_Name IS NOT NULL AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Charge_Name");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Charge_ID IS NULL AND JP_Charge_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_UOM_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP i ").append("SET C_UOM_ID=(SELECT C_UOM_ID FROM C_UOM p").append(" WHERE i.X12DE355=p.X12DE355 AND (i.AD_Client_ID=p.AD_Client_ID OR p.AD_Client_ID = 0) ) ").append("WHERE X12DE355 IS NOT NULL").append(" AND I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"X12DE355");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE X12DE355 IS NOT NULL AND C_UOM_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Tax_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_InvoiceJP o ").append("SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t").append(" WHERE o.TaxIndicator=t.TaxIndicator AND o.AD_Client_ID=t.AD_Client_ID) ").append("WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"TaxIndicator");
        sql = new StringBuilder("UPDATE I_InvoiceJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean createInvoiceHeader(X_I_InvoiceJP impInvoice, MInvoice invoice) {
        MUser[] users;
        MBPartnerLocation[] locations;
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impInvoice, (PO)invoice, 30);
        PO.copyValues((PO)impInvoice, (PO)invoice);
        invoice.setC_Invoice_ID(0);
        invoice.setClientOrg(impInvoice.getAD_Client_ID(), impInvoice.getAD_Org_ID());
        invoice.setC_DocTypeTarget_ID(impInvoice.getC_DocType_ID());
        invoice.setIsSOTrx(impInvoice.isSOTrx());
        if (impInvoice.getDateInvoiced() == null) {
            impInvoice.setDateInvoiced(this.p_DateValue);
            invoice.setDateInvoiced(this.p_DateValue);
        }
        if (impInvoice.getDateAcct() == null) {
            impInvoice.setDateAcct(this.p_DateValue);
            invoice.setDateAcct(this.p_DateValue);
        }
        MBPartner bp = null;
        if (impInvoice.getC_BPartner_ID() <= 0) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
            return false;
        }
        bp = MBPartner.get((Properties)this.getCtx(), (int)impInvoice.getC_BPartner_ID());
        if (impInvoice.getC_BPartner_Location_ID() <= 0 && (locations = bp.getLocations(false)) != null && locations.length == 1) {
            impInvoice.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
            invoice.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
        }
        if (impInvoice.getAD_User_ID() <= 0 && (users = MUser.getOfBPartner((Properties)this.getCtx(), (int)impInvoice.getC_BPartner_ID(), (String)this.get_TrxName())) != null && users.length == 1) {
            impInvoice.setAD_User_ID(users[0].getAD_User_ID());
            invoice.setAD_User_ID(users[0].getAD_User_ID());
        }
        if (impInvoice.getM_PriceList_ID() == 0 && bp.getM_PriceList_ID() != 0) {
            impInvoice.setM_PriceList_ID(bp.getM_PriceList_ID());
            invoice.setM_PriceList_ID(bp.getM_PriceList_ID());
        }
        if (Util.isEmpty((String)impInvoice.getPaymentRule())) {
            if (Util.isEmpty((String)bp.getPaymentRule())) {
                impInvoice.setPaymentRule("P");
                invoice.setPaymentRule("P");
            } else {
                impInvoice.setPaymentRule(bp.getPaymentRule());
                invoice.setPaymentRule(bp.getPaymentRule());
            }
        }
        if (impInvoice.getC_PaymentTerm_ID() == 0 && bp.getC_PaymentTerm_ID() != 0) {
            impInvoice.setC_PaymentTerm_ID(bp.getC_PaymentTerm_ID());
            invoice.setC_PaymentTerm_ID(bp.getC_PaymentTerm_ID());
        }
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impInvoice, (PO)invoice, 40);
        try {
            invoice.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_Invoice_ID") + " : " + e.toString();
            return false;
        }
        impInvoice.setC_Invoice_ID(invoice.getC_Invoice_ID());
        return true;
    }

    private boolean addInvoiceLine(X_I_InvoiceJP impInvoice, MInvoice invoice, MInvoiceLine line, int lineNo) {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impInvoice, (PO)line, 30);
        PO.copyValues((PO)impInvoice, (PO)line);
        line.setC_Invoice_ID(invoice.getC_Invoice_ID());
        if (impInvoice.getLine() == 0) {
            line.setLine(lineNo);
        } else {
            line.setLine(impInvoice.getLine());
        }
        if (!Util.isEmpty((String)impInvoice.getLineDescription())) {
            line.setDescription(impInvoice.getLineDescription());
        }
        if (line.getQtyEntered().compareTo(Env.ZERO) == 0 && line.getQtyInvoiced().compareTo(Env.ZERO) != 0) {
            line.setQtyEntered(line.getQtyInvoiced());
        } else if (line.getQtyEntered().compareTo(Env.ZERO) != 0 && line.getQtyInvoiced().compareTo(Env.ZERO) == 0) {
            line.setQtyInvoiced(line.getQtyEntered());
        }
        if (impInvoice.getJP_Line_OrgTrx_ID() > 0) {
            line.setAD_OrgTrx_ID(impInvoice.getJP_Line_OrgTrx_ID());
        } else {
            line.setAD_OrgTrx_ID(0);
        }
        if (impInvoice.getJP_Line_Project_ID() > 0) {
            line.setC_Project_ID(impInvoice.getJP_Line_Project_ID());
        } else {
            line.setC_Project_ID(0);
        }
        if (impInvoice.getJP_Line_Activity_ID() > 0) {
            line.setC_Activity_ID(impInvoice.getJP_Line_Activity_ID());
        } else {
            line.setC_Activity_ID(0);
        }
        if (impInvoice.getJP_Line_Campaign_ID() > 0) {
            line.setC_Campaign_ID(impInvoice.getJP_Line_Campaign_ID());
        } else {
            line.setC_Campaign_ID(0);
        }
        if (impInvoice.getJP_Line_User1_ID() > 0) {
            line.setUser1_ID(impInvoice.getJP_Line_User1_ID());
        } else {
            line.setUser1_ID(0);
        }
        if (impInvoice.getJP_Line_User2_ID() > 0) {
            line.setUser2_ID(impInvoice.getJP_Line_User2_ID());
        } else {
            line.setUser2_ID(0);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impInvoice, (PO)line, 40);
        try {
            line.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_InvoiceLine_ID") + " : " + e.toString();
            return false;
        }
        impInvoice.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
        impInvoice.setI_IsImported(true);
        impInvoice.setProcessed(true);
        impInvoice.saveEx(this.get_TrxName());
        return true;
    }
}

