/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_BPartnerJP;
import jpiere.base.plugin.util.JPiereLocationUtil;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MColumn;
import org.compiere.model.MContactInterest;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportBPartner
extends SvrProcess
implements ImportProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private Timestamp m_DateValue = null;
    private String p_JP_ImportSalesRepIdentifier = "VA";
    private String p_JP_ImportUserIdentifier = "NA";
    private int p_I_BPartnerJP_ID = 0;
    private IProcessUI processMonitor = null;
    private String message = null;
    private long startTime = System.currentTimeMillis();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("JP_ImportSalesRepIdentifier")) {
                this.p_JP_ImportSalesRepIdentifier = para[i].getParameterAsString();
            } else if (name.equals("JP_ImportUserIdentifier")) {
                this.p_JP_ImportUserIdentifier = para[i].getParameterAsString();
            } else if (name.equals("I_BPartnerJP_ID")) {
                this.p_I_BPartnerJP_ID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
        this.p_AD_Client_ID = this.getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuilder("DELETE I_BPartnerJP ").append("WHERE I_IsImported='Y' AND Processed='Y' ").append(clientCheck);
            try {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Corporation_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Corporation_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BP_Group_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BP_Group_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"SalesRep_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupSalesRep_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_InvoiceSchedule_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_InvoiceSchedule_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentTerm_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_PaymentTerm_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_PaymentTerm_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupPO_PaymentTerm_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BillSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_BillSchema_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_BillSchemaPO_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_BillSchemaPO_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_PriceList_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_PriceList_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupPO_PriceList_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_DiscountSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupM_DiscountSchema_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"PO_DiscountSchema_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupPO_DiscountSchema_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Dunning_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Dunning_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Default1099Box_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupDefault1099Box_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Greeting_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Greeting_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_User_Greeting_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_User_Greeting_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_SalesRegion_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_SalesRegion_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"R_InterestArea_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupR_InterestArea_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Invoice_PrintFormat_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupInvoice_PrintFormat_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Register")) + " & " + Msg.getMsg((Properties)this.getCtx(), (String)"Update") + " " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(msg);
        }
        sql = new StringBuilder("SELECT * FROM I_BPartnerJP WHERE I_IsImported='N' OR Processed='N' ").append(clientCheck);
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        sql.append(" ORDER BY Value, ContactName, EMail ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                if (this.p_I_BPartnerJP_ID > 0) {
                    pstmt.setInt(1, this.p_I_BPartnerJP_ID);
                }
                rs = pstmt.executeQuery();
                String preValue = "";
                MBPartner bpartner = null;
                while (rs.next()) {
                    X_I_BPartnerJP imp = new X_I_BPartnerJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getC_BPartner_ID() != 0) {
                        isNew = false;
                        bpartner = new MBPartner(this.getCtx(), imp.getC_BPartner_ID(), this.get_TrxName());
                    } else if (preValue.equals(imp.getValue())) {
                        isNew = false;
                    } else {
                        preValue = imp.getValue();
                    }
                    if (isNew) {
                        bpartner = new MBPartner(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewBPartner(imp, bpartner)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else if (this.updateBPartner(imp, bpartner)) {
                        ++successUpdateNum;
                    } else {
                        ++failureUpdateNum;
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        long endTime = System.currentTimeMillis();
        long time = endTime - this.startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeFormatted = formatter.format(time);
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "  " + timeFormatted + "  " + records + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
        return msgreturn.toString();
    }

    public String getImportTableName() {
        return "I_BPartner";
    }

    private boolean reverseLookupC_BPartner_ID() throws Exception {
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                Object[] objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_Corporation_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET JP_Corporation_ID=(SELECT JP_Corporation_ID FROM JP_Corporation p").append(" WHERE i.JP_CorporationValue=p.Value AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_CorporationValue IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_CorporationValue");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_CorporationValue IS NOT NULL AND JP_Corporation_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_BP_Group_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET GroupValue=(SELECT MAX(Value) FROM C_BP_Group g WHERE g.IsDefault='Y'").append(" AND g.AD_Client_ID=i.AD_Client_ID) ");
        sql.append("WHERE GroupValue IS NULL AND C_BP_Group_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        sql = new StringBuilder("UPDATE I_BPartnerJP i ").append(" SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group g").append(" WHERE i.GroupValue=g.Value AND g.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE C_BP_Group_ID IS NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"GroupValue");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE GroupValue IS NOT NULL AND C_BP_Group_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupSalesRep_ID() throws Exception {
        Object[] objs;
        if (Util.isEmpty((String)this.p_JP_ImportSalesRepIdentifier) || this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        int no = 0;
        if (this.p_JP_ImportSalesRepIdentifier.equals("EM")) {
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("NA")) {
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VA")) {
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VE")) {
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            if (this.p_I_BPartnerJP_ID > 0) {
                sql.append(" AND I_BPartnerJP_ID=? ");
            }
            try {
                if (this.p_I_BPartnerJP_ID > 0) {
                    objs = new Object[]{this.p_I_BPartnerJP_ID};
                    no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
                } else {
                    no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND p.EMail IS NULL  AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VN")) {
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportSalesRepIdentifier.equals("VZ")) {
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name  AND i.JP_SalesRep_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y') ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            if (this.p_I_BPartnerJP_ID > 0) {
                sql.append(" AND I_BPartnerJP_ID=? ");
            }
            try {
                if (this.p_I_BPartnerJP_ID > 0) {
                    objs = new Object[]{this.p_I_BPartnerJP_ID};
                    no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
                } else {
                    no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
                return false;
            }
            sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET SalesRep_ID=(SELECT MAX(AD_User_ID) FROM AD_User p INNER JOIN C_BPartner bp ON (p.C_BPartner_ID = bp.C_BPartner_ID) ").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND p.EMail IS NULL AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND bp.IsSalesRep='Y' ) ").append(" WHERE i.JP_SalesRep_Value IS NOT NULL AND i.JP_SalesRep_Name IS NOT NULL AND i.JP_SalesRep_EMail IS NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportSalesRepIdentifier.equals("ZZ")) {
                return true;
            }
            return true;
        }
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupC_InvoiceSchedule_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_InvoiceSchedule_ID=(SELECT C_InvoiceSchedule_ID FROM C_InvoiceSchedule p").append(" WHERE i.JP_InvoiceSchedule_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_InvoiceSchedule_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_InvoiceSchedule_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_InvoiceSchedule_Name IS NOT NULL AND C_InvoiceSchedule_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_PaymentTerm_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p").append(" WHERE i.JP_PaymentTerm_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_PaymentTerm_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_PaymentTerm_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_PaymentTerm_Value IS NOT NULL AND C_PaymentTerm_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupPO_PaymentTerm_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET PO_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p").append(" WHERE i.JP_PO_PaymentTerm_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_PO_PaymentTerm_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_PaymentTerm_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_PO_PaymentTerm_Value IS NOT NULL AND PO_PaymentTerm_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_BillSchema_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET JP_BillSchema_ID=(SELECT JP_BillSchema_ID FROM JP_BillSchema p").append(" WHERE i.JP_BillSchema_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_BillSchema_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BillSchema_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_BillSchema_Value IS NOT NULL AND JP_BillSchema_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_BillSchemaPO_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET JP_BillSchemaPO_ID=(SELECT JP_BillSchema_ID FROM JP_BillSchema p").append(" WHERE i.JP_BillSchemaPO_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_BillSchemaPO_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_BillSchemaPO_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_BillSchemaPO_Value IS NOT NULL AND JP_BillSchemaPO_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_PriceList_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET M_PriceList_ID=(SELECT M_PriceList_ID FROM M_PriceList p").append(" WHERE i.JP_PriceList_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_PriceList_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_PriceList_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_PriceList_Name IS NOT NULL AND M_PriceList_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupPO_PriceList_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET PO_PriceList_ID=(SELECT M_PriceList_ID FROM M_PriceList p").append(" WHERE i.JP_PO_PriceList_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_PO_PriceList_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_PriceList_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_PO_PriceList_Name IS NOT NULL AND PO_PriceList_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupM_DiscountSchema_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET M_DiscountSchema_ID=(SELECT M_DiscountSchema_ID FROM M_DiscountSchema p").append(" WHERE i.JP_DiscountSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_DiscountSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_DiscountSchema_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_DiscountSchema_Name IS NOT NULL AND M_DiscountSchema_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupPO_DiscountSchema_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET PO_DiscountSchema_ID=(SELECT M_DiscountSchema_ID FROM M_DiscountSchema p").append(" WHERE i.JP_PO_DiscountSchema_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_PO_DiscountSchema_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_PO_DiscountSchema_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_PO_DiscountSchema_Name IS NOT NULL AND PO_DiscountSchema_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Dunning_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_Dunning_ID=(SELECT C_Dunning_ID FROM C_Dunning p").append(" WHERE i.JP_Dunning_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_Dunning_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Dunning_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Dunning_Name IS NOT NULL AND C_Dunning_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupDefault1099Box_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET Default1099Box_ID=(SELECT C_1099Box_ID FROM C_1099Box p").append(" WHERE i.JP_Default1099Box_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_Default1099Box_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Default1099Box_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Default1099Box_Value IS NOT NULL AND Default1099Box_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Greeting_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting p").append(" WHERE i.JP_Greeting_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_Greeting_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Greeting_Name");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Greeting_Name IS NOT NULL AND C_Greeting_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupJP_User_Greeting_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET JP_User_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting p").append(" WHERE i.BPContactGreeting=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.BPContactGreeting IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"BPContactGreeting");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE BPContactGreeting IS NOT NULL AND JP_User_Greeting_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Location_ID() throws Exception {
        boolean no = false;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_Location_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_Location_Label=p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_Location_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                Object[] objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupC_SalesRegion_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET C_SalesRegion_ID=(SELECT C_SalesRegion_ID FROM C_SalesRegion p").append(" WHERE i.JP_SalesRegion_Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_SalesRegion_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_SalesRegion_Value");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_SalesRegion_Value IS NOT NULL AND C_SalesRegion_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_User_ID() throws Exception {
        Object[] objs;
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals("ZZ")) {
            return true;
        }
        StringBuilder sql = null;
        boolean no = false;
        if (!Util.isEmpty((String)this.p_JP_ImportUserIdentifier)) {
            if (this.p_JP_ImportUserIdentifier.equals("EM")) {
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND i.C_BPartner_ID = p.C_BPartner_ID ) ").append(" WHERE i.EMail IS NOT NULL AND i.AD_User_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            } else if (this.p_JP_ImportUserIdentifier.equals("NA")) {
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.ContactName=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )  AND i.C_BPartner_ID = p.C_BPartner_ID ) ").append(" WHERE i.ContactName IS NOT NULL AND i.AD_User_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            } else if (this.p_JP_ImportUserIdentifier.equals("VA")) {
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )  AND i.C_BPartner_ID = p.C_BPartner_ID ) ").append(" WHERE i.AD_User_ID IS NULL AND i.JP_User_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            } else if (this.p_JP_ImportUserIdentifier.equals("VE")) {
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.EMail = p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND i.C_BPartner_ID = p.C_BPartner_ID  ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL  AND i.EMai IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
                if (this.p_I_BPartnerJP_ID > 0) {
                    sql.append(" AND I_BPartnerJP_ID=? ");
                }
                try {
                    if (this.p_I_BPartnerJP_ID > 0) {
                        objs = new Object[]{this.p_I_BPartnerJP_ID};
                        DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
                    } else {
                        DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
                }
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND p.EMail IS NULL AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) AND i.C_BPartner_ID = p.C_BPartner_ID  ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL AND i.EMai IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            } else if (this.p_JP_ImportUserIdentifier.equals("VN")) {
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.ContactName = p.Name AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )  AND i.C_BPartner_ID = p.C_BPartner_ID ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL AND i.ContactName IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            } else if (this.p_JP_ImportUserIdentifier.equals("VZ")) {
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.ContactName = p.Name AND i.EMail = p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )  AND i.C_BPartner_ID = p.C_BPartner_ID  ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL AND i.ContactName IS NOT NULL AND i.EMail IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
                if (this.p_I_BPartnerJP_ID > 0) {
                    sql.append(" AND I_BPartnerJP_ID=? ");
                }
                try {
                    if (this.p_I_BPartnerJP_ID > 0) {
                        objs = new Object[]{this.p_I_BPartnerJP_ID};
                        DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
                    } else {
                        DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
                }
                sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.JP_User_Value=p.Value AND i.ContactName = p.Name AND p.EMail IS NULL AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 )  AND i.C_BPartner_ID = p.C_BPartner_ID  ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL AND i.ContactName IS NOT NULL AND i.EMail IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
                if (this.p_I_BPartnerJP_ID > 0) {
                    sql.append(" AND I_BPartnerJP_ID=? ");
                }
            } else {
                if (this.p_JP_ImportUserIdentifier.equals("ZZ")) {
                    return true;
                }
                return true;
            }
        }
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupR_InterestArea_ID() throws Exception {
        Object[] objs;
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea p").append(" WHERE i.InterestAreaName=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.InterestAreaName IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"InterestAreaName");
        sql = new StringBuilder("UPDATE I_BPartnerJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE InterestAreaName IS NOT NULL AND R_InterestArea_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                objs = new Object[]{this.p_I_BPartnerJP_ID};
                no = DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupInvoice_PrintFormat_ID() throws Exception {
        boolean no = false;
        StringBuilder sql = new StringBuilder("UPDATE I_BPartnerJP i ").append("SET Invoice_PrintFormat_ID=(SELECT AD_PrintFormat_ID FROM AD_PrintFormat p").append(" WHERE i.JP_Invoice_PrintFormat_Name=p.Name AND (p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID= 0) )").append(" WHERE i.JP_Invoice_PrintFormat_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        if (this.p_I_BPartnerJP_ID > 0) {
            sql.append(" AND I_BPartnerJP_ID=? ");
        }
        try {
            if (this.p_I_BPartnerJP_ID > 0) {
                Object[] objs = new Object[]{this.p_I_BPartnerJP_ID};
                DB.executeUpdateEx((String)sql.toString(), (Object[])objs, (String)this.get_TrxName());
            } else {
                DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean createNewBPartner(X_I_BPartnerJP importBPartner, MBPartner newBPartner) throws Exception {
        if (Util.isEmpty((String)importBPartner.getValue())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Value")};
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importBPartner.setI_IsImported(false);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)importBPartner.getName())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"Name")};
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importBPartner.setI_IsImported(false);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            return false;
        }
        if (importBPartner.getC_BP_Group_ID() == 0) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_BP_Group_ID")};
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importBPartner.setI_IsImported(false);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)newBPartner, 30);
        PO.copyValues((PO)importBPartner, (PO)newBPartner);
        newBPartner.setIsActive(importBPartner.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)newBPartner, 40);
        try {
            newBPartner.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + " -> " + e.toString());
            importBPartner.setI_IsImported(false);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            return false;
        }
        importBPartner.setC_BPartner_ID(newBPartner.getC_BPartner_ID());
        if (!Util.isEmpty((String)importBPartner.getJP_BPartner_Location_Name()) || !Util.isEmpty((String)importBPartner.getJP_Location_Label())) {
            int C_BPartner_Location_ID = this.createBPartnerLocation(importBPartner);
            if (C_BPartner_Location_ID == 0) {
                String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID");
                if (Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
                    importBPartner.setI_ErrorMsg(msg);
                } else {
                    importBPartner.setI_ErrorMsg(String.valueOf(importBPartner.getI_ErrorMsg()) + " : " + msg);
                }
                importBPartner.setI_IsImported(true);
                importBPartner.setProcessed(false);
                importBPartner.saveEx(this.get_TrxName());
                return false;
            }
            importBPartner.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        }
        if (importBPartner.getAD_User_ID() > 0) {
            this.updateUser(importBPartner, newBPartner.getC_BPartner_ID());
        } else if (!Util.isEmpty((String)importBPartner.getContactName())) {
            int AD_User_ID = this.createNewUser(importBPartner, newBPartner.getC_BPartner_ID());
            if (AD_User_ID == 0) {
                String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
                if (Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
                    importBPartner.setI_ErrorMsg(msg);
                } else {
                    importBPartner.setI_ErrorMsg(String.valueOf(importBPartner.getI_ErrorMsg()) + " : " + msg);
                }
            } else {
                importBPartner.setAD_User_ID(AD_User_ID);
            }
        }
        if (!Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
            importBPartner.setI_IsImported(true);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            return false;
        }
        StringBuilder msg = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        importBPartner.setI_ErrorMsg(msg.toString());
        importBPartner.setI_IsImported(true);
        importBPartner.setProcessed(true);
        importBPartner.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateBPartner(X_I_BPartnerJP importBPartner, MBPartner updateBPartner) throws Exception {
        String msg;
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)updateBPartner, 30);
        MTable C_BPartner_Table = MTable.get((Properties)this.getCtx(), (int)291, (String)this.get_TrxName());
        MColumn[] C_BPartner_Columns = C_BPartner_Table.getColumns(true);
        MTable I_BPartnerJP_Table = MTable.get((Properties)this.getCtx(), (int)X_I_BPartnerJP.Table_ID, (String)this.get_TrxName());
        MColumn[] I_BPartnerJP_Columns = I_BPartnerJP_Table.getColumns(true);
        MColumn i_Column = null;
        int i = 0;
        while (i < C_BPartner_Columns.length) {
            i_Column = C_BPartner_Columns[i];
            if (!(i_Column.isVirtualColumn() || i_Column.isKey() || i_Column.isUUIDColumn() || i_Column.getColumnName().equals("IsActive") || i_Column.getColumnName().equals("AD_Client_ID") || i_Column.getColumnName().equals("Value") || i_Column.getColumnName().equals("Processing") || i_Column.getColumnName().equals("Created") || i_Column.getColumnName().equals("CreatedBy") || i_Column.getColumnName().equals("Updated") || i_Column.getColumnName().equals("UpdatedBy"))) {
                MColumn j_Column = null;
                Object importValue = null;
                int j = 0;
                while (j < I_BPartnerJP_Columns.length) {
                    j_Column = I_BPartnerJP_Columns[j];
                    if (i_Column.getColumnName().equals(j_Column.getColumnName())) {
                        importValue = importBPartner.get_Value(j_Column.getColumnName());
                        if (importValue == null) break;
                        if (importValue instanceof BigDecimal) {
                            BigDecimal bigDecimal_Value = (BigDecimal)importValue;
                            if (bigDecimal_Value.compareTo(Env.ZERO) == 0) {
                                break;
                            }
                        } else {
                            Integer p_key;
                            if (j_Column.getAD_Reference_ID() == 10) {
                                String string_Value = (String)importValue;
                                if (Util.isEmpty((String)string_Value)) break;
                                updateBPartner.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                                break;
                            }
                            if (j_Column.getColumnName().endsWith("_ID") && (p_key = (Integer)importValue) <= 0) break;
                        }
                        if (importValue == null) break;
                        try {
                            updateBPartner.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                            break;
                        }
                        catch (Exception e) {
                            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " Column = " + i_Column.getColumnName() + " & " + "Value = " + importValue.toString() + " -> " + e.toString());
                            importBPartner.setI_IsImported(false);
                            importBPartner.setProcessed(false);
                            importBPartner.saveEx(this.get_TrxName());
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        updateBPartner.setIsActive(importBPartner.isI_IsActiveJP());
        if (importBPartner.getC_BPartner_ID() == 0) {
            importBPartner.setC_BPartner_ID(updateBPartner.getC_BPartner_ID());
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)updateBPartner, 40);
        try {
            updateBPartner.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID") + " -> " + e.toString());
            importBPartner.setI_IsImported(false);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)importBPartner.getJP_BPartner_Location_Name())) {
            MBPartnerLocation bpLocation = this.getMBPartnerLocation(importBPartner.getC_BPartner_ID(), importBPartner.getJP_BPartner_Location_Name());
            if (bpLocation == null) {
                int C_BPartner_Location_ID = this.createBPartnerLocation(importBPartner);
                if (C_BPartner_Location_ID == 0) {
                    msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID");
                    if (Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
                        importBPartner.setI_ErrorMsg(msg);
                    } else {
                        importBPartner.setI_ErrorMsg(String.valueOf(importBPartner.getI_ErrorMsg()) + " : " + msg);
                    }
                    importBPartner.setI_IsImported(false);
                    importBPartner.setProcessed(false);
                    importBPartner.saveEx(this.get_TrxName());
                    return false;
                }
                importBPartner.setC_BPartner_Location_ID(C_BPartner_Location_ID);
            } else {
                this.updateBPartnerLocation(importBPartner, bpLocation);
            }
        }
        if (importBPartner.getAD_User_ID() > 0) {
            this.updateUser(importBPartner, updateBPartner.getC_BPartner_ID());
        } else if (!Util.isEmpty((String)importBPartner.getContactName())) {
            MUser user = this.getMUser(importBPartner);
            if (user == null) {
                int AD_User_ID = this.createNewUser(importBPartner, updateBPartner.getC_BPartner_ID());
                if (AD_User_ID == 0) {
                    msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CouldNotCreate")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
                    if (Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
                        importBPartner.setI_ErrorMsg(msg);
                    } else {
                        importBPartner.setI_ErrorMsg(String.valueOf(importBPartner.getI_ErrorMsg()) + " : " + msg);
                    }
                } else {
                    importBPartner.setAD_User_ID(AD_User_ID);
                }
            } else {
                this.updateUser(importBPartner, updateBPartner.getC_BPartner_ID());
            }
        }
        if (!Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
            importBPartner.setI_IsImported(false);
            importBPartner.setProcessed(false);
            importBPartner.saveEx(this.get_TrxName());
            this.commitEx();
            return false;
        }
        StringBuilder msg2 = new StringBuilder(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        importBPartner.setI_ErrorMsg(msg2.toString());
        importBPartner.setI_IsImported(true);
        importBPartner.setProcessed(true);
        importBPartner.saveEx(this.get_TrxName());
        this.commitEx();
        return true;
    }

    private int createBPartnerLocation(X_I_BPartnerJP importBPartner) throws Exception {
        MBPartnerLocation newBPartnerLocation = new MBPartnerLocation(this.getCtx(), 0, this.get_TrxName());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)newBPartnerLocation, 30);
        PO.copyValues((PO)importBPartner, (PO)newBPartnerLocation);
        newBPartnerLocation.setC_BPartner_ID(importBPartner.getC_BPartner_ID());
        if (!Util.isEmpty((String)importBPartner.getJP_BPartner_Location_Name())) {
            newBPartnerLocation.setName(importBPartner.getJP_BPartner_Location_Name());
        }
        newBPartnerLocation.setIsActive(importBPartner.isI_IsActiveJP());
        if (importBPartner.getC_Location_ID() > 0) {
            newBPartnerLocation.setC_Location_ID(importBPartner.getC_Location_ID());
        } else {
            int C_Location_ID = JPiereLocationUtil.searchLocationByLabel(this.getCtx(), importBPartner.getJP_Location_Label(), this.get_TrxName());
            if (C_Location_ID == 0) {
                C_Location_ID = JPiereLocationUtil.createLocation(this.getCtx(), 0, importBPartner.getJP_Location_Label(), importBPartner.getComments(), importBPartner.getCountryCode(), importBPartner.getPostal(), importBPartner.getPostal_Add(), importBPartner.getJP_Region_Name(), importBPartner.getRegionName(), importBPartner.getJP_City_Name(), importBPartner.getCity(), importBPartner.getAddress1(), importBPartner.getAddress2(), importBPartner.getAddress3(), importBPartner.getAddress4(), importBPartner.getAddress5(), this.get_TrxName());
            }
            newBPartnerLocation.setC_Location_ID(C_Location_ID);
            importBPartner.setC_Location_ID(C_Location_ID);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)newBPartnerLocation, 40);
        newBPartnerLocation.saveEx(this.get_TrxName());
        importBPartner.setC_BPartner_Location_ID(newBPartnerLocation.getC_BPartner_Location_ID());
        return newBPartnerLocation.getC_BPartner_Location_ID();
    }

    private void updateBPartnerLocation(X_I_BPartnerJP importBPartner, MBPartnerLocation updateBPartnerLocation) throws Exception {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)updateBPartnerLocation, 30);
        MTable C_BPartner_Location_Table = MTable.get((Properties)this.getCtx(), (int)293, (String)this.get_TrxName());
        MColumn[] C_BPartner_Location_Columns = C_BPartner_Location_Table.getColumns(true);
        MTable I_BPartnerJP_Table = MTable.get((Properties)this.getCtx(), (int)X_I_BPartnerJP.Table_ID, (String)this.get_TrxName());
        MColumn[] I_BPartnerJP_Columns = I_BPartnerJP_Table.getColumns(true);
        MColumn i_Column = null;
        int i = 0;
        while (i < C_BPartner_Location_Columns.length) {
            i_Column = C_BPartner_Location_Columns[i];
            if (!(i_Column.isVirtualColumn() || i_Column.isKey() || i_Column.isUUIDColumn() || i_Column.getColumnName().equals("IsActive") || i_Column.getColumnName().equals("AD_Client_ID") || i_Column.getColumnName().equals("Value") || i_Column.getColumnName().equals("Name") || i_Column.getColumnName().equals("Processing") || i_Column.getColumnName().equals("Created") || i_Column.getColumnName().equals("CreatedBy") || i_Column.getColumnName().equals("Updated") || i_Column.getColumnName().equals("UpdatedBy"))) {
                MColumn j_Column = null;
                Object importValue = null;
                int j = 0;
                while (j < I_BPartnerJP_Columns.length) {
                    j_Column = I_BPartnerJP_Columns[j];
                    if (i_Column.getColumnName().equals(j_Column.getColumnName())) {
                        importValue = importBPartner.get_Value(j_Column.getColumnName());
                        if (importValue == null) break;
                        if (importValue instanceof BigDecimal) {
                            BigDecimal bigDecimal_Value = (BigDecimal)importValue;
                            if (bigDecimal_Value.compareTo(Env.ZERO) == 0) {
                                break;
                            }
                        } else {
                            Integer p_key;
                            if (j_Column.getAD_Reference_ID() == 10) {
                                String string_Value = (String)importValue;
                                if (Util.isEmpty((String)string_Value)) break;
                                updateBPartnerLocation.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                                break;
                            }
                            if (j_Column.getColumnName().endsWith("_ID") && (p_key = (Integer)importValue) <= 0) break;
                        }
                        updateBPartnerLocation.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        updateBPartnerLocation.setIsActive(importBPartner.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)updateBPartnerLocation, 40);
        updateBPartnerLocation.saveEx(this.get_TrxName());
    }

    private int createNewUser(X_I_BPartnerJP importBPartner, int C_BPartner_ID) {
        String email;
        MUser user = new MUser(this.getCtx(), 0, this.get_TrxName());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)user, 30);
        boolean isEMailLogin = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false, (int)this.getAD_Client_ID());
        if (isEMailLogin && !Util.isEmpty((String)importBPartner.getPassword()) && Util.isEmpty((String)importBPartner.getEMail())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"EMail")};
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            return 0;
        }
        if (!Util.isEmpty((String)importBPartner.getEMail()) && (email = importBPartner.getEMail()).indexOf("@") == -1) {
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"EMail"));
            return 0;
        }
        user.setName(importBPartner.getContactName());
        user.setC_BPartner_ID(C_BPartner_ID);
        if (importBPartner.getJP_Corporation_ID() > 0) {
            user.set_ValueNoCheck("JP_Corporation_ID", (Object)importBPartner.getJP_Corporation_ID());
        }
        if (!Util.isEmpty((String)importBPartner.getJP_User_Value())) {
            user.setValue(importBPartner.getJP_User_Value());
        }
        if (!Util.isEmpty((String)importBPartner.getEMail())) {
            user.setEMail(importBPartner.getEMail());
        }
        if (!Util.isEmpty((String)importBPartner.getContactDescription())) {
            user.setDescription(importBPartner.getContactDescription());
        }
        if (!Util.isEmpty((String)importBPartner.getComments())) {
            user.setComments(importBPartner.getComments());
        }
        if (!Util.isEmpty((String)importBPartner.getJP_User_Phone())) {
            user.setPhone(importBPartner.getJP_User_Phone());
        }
        if (!Util.isEmpty((String)importBPartner.getJP_User_Phone2())) {
            user.setPhone2(importBPartner.getJP_User_Phone2());
        }
        if (importBPartner.getJP_User_Greeting_ID() > 0) {
            user.setC_Greeting_ID(importBPartner.getJP_User_Greeting_ID());
        }
        if (!Util.isEmpty((String)importBPartner.getTitle())) {
            user.setTitle(importBPartner.getTitle());
        }
        if (importBPartner.getBirthday() != null) {
            user.setBirthday(importBPartner.getBirthday());
        }
        if (importBPartner.getPassword() != null) {
            user.setPassword(importBPartner.getPassword());
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)user, 40);
        try {
            user.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID") + " -> " + e.toString());
            return 0;
        }
        importBPartner.setAD_User_ID(user.getAD_User_ID());
        if (importBPartner.getR_InterestArea_ID() > 0) {
            this.createContactInterest(importBPartner, user.getAD_User_ID());
        }
        return user.getAD_User_ID();
    }

    private boolean updateUser(X_I_BPartnerJP importBPartner, int C_BPartner_ID) {
        MUser user = new MUser(this.getCtx(), importBPartner.getAD_User_ID(), this.get_TrxName());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)user, 30);
        if (user.getC_BPartner_ID() == 0) {
            user.setC_BPartner_ID(C_BPartner_ID);
            if (importBPartner.getJP_Corporation_ID() > 0) {
                user.set_ValueNoCheck("JP_Corporation_ID", (Object)importBPartner.getJP_Corporation_ID());
            }
        }
        if (!Util.isEmpty((String)importBPartner.getContactDescription())) {
            user.setDescription(importBPartner.getContactDescription());
        }
        if (!Util.isEmpty((String)importBPartner.getComments())) {
            user.setComments(importBPartner.getComments());
        }
        if (!Util.isEmpty((String)importBPartner.getJP_User_Phone())) {
            user.setPhone(importBPartner.getJP_User_Phone());
        }
        if (!Util.isEmpty((String)importBPartner.getJP_User_Phone2())) {
            user.setPhone2(importBPartner.getJP_User_Phone2());
        }
        if (importBPartner.getJP_User_Greeting_ID() > 0) {
            user.setC_Greeting_ID(importBPartner.getJP_User_Greeting_ID());
        }
        if (!Util.isEmpty((String)importBPartner.getTitle())) {
            user.setTitle(importBPartner.getTitle());
        }
        if (importBPartner.getBirthday() != null) {
            user.setBirthday(importBPartner.getBirthday());
        }
        if (importBPartner.getPassword() != null) {
            user.setPassword(importBPartner.getPassword());
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)user, 40);
        try {
            user.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importBPartner.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID") + " -> " + e.toString());
            return false;
        }
        if (importBPartner.getR_InterestArea_ID() > 0) {
            this.createContactInterest(importBPartner, user.getAD_User_ID());
        }
        return true;
    }

    private void createContactInterest(X_I_BPartnerJP importBPartner, int AD_User_ID) {
        MContactInterest ci = MContactInterest.get((Properties)this.getCtx(), (int)importBPartner.getR_InterestArea_ID(), (int)AD_User_ID, (boolean)true, (String)this.get_TrxName());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)ci, 30);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importBPartner, (PO)ci, 40);
        ci.saveEx(this.get_TrxName());
    }

    private MBPartnerLocation getMBPartnerLocation(int C_BPartner_ID, String JP_BPartner_Location_Name) throws Exception {
        if (C_BPartner_ID == 0 || Util.isEmpty((String)JP_BPartner_Location_Name)) {
            return null;
        }
        MBPartnerLocation[] bpLocations = MBPartnerLocation.getForBPartner((Properties)this.getCtx(), (int)C_BPartner_ID, (String)this.get_TrxName());
        int i = 0;
        while (i < bpLocations.length) {
            if (bpLocations[i].getName().equals(JP_BPartner_Location_Name)) {
                return bpLocations[i];
            }
            ++i;
        }
        return null;
    }

    private MUser getMUser(X_I_BPartnerJP importBPartner) {
        int C_BPartner_ID = importBPartner.getC_BPartner_ID();
        if (C_BPartner_ID == 0) {
            return null;
        }
        MUser[] users = MUser.getOfBPartner((Properties)this.getCtx(), (int)C_BPartner_ID, (String)this.get_TrxName());
        int i = 0;
        while (i < users.length) {
            if (importBPartner.getContactName().equals(users[i].getName())) {
                if (!Util.isEmpty((String)users[i].getEMail()) && importBPartner.getEMail().equals(users[i].getEMail())) {
                    return users[i];
                }
                if (!Util.isEmpty((String)users[i].getValue()) && importBPartner.getJP_User_Value().equals(users[i].getValue())) {
                    return users[i];
                }
            }
            ++i;
        }
        return null;
    }

    private void setSalesRep_ID(X_I_BPartnerJP importBPartner, MBPartner m_BPartner) {
        String JP_SalesRep_EMail = importBPartner.getJP_SalesRep_EMail();
        int[] AD_User_IDs = PO.getAllIDs((String)"AD_User", (String)("EMail='" + JP_SalesRep_EMail + "'" + " AND (AD_Client_ID=" + this.p_AD_Client_ID + " OR AD_Client_ID=0) "), (String)this.get_TrxName());
        MUser m_SalesRep = null;
        if (AD_User_IDs != null) {
            int i = 0;
            while (i < AD_User_IDs.length) {
                m_SalesRep = new MUser(this.getCtx(), AD_User_IDs[i], this.get_TrxName());
                if (m_SalesRep.getAD_Client_ID() == this.p_AD_Client_ID && m_SalesRep.getAD_Org_ID() == 0) break;
                ++i;
            }
        }
        if (m_SalesRep != null) {
            m_BPartner.setSalesRep_ID(m_SalesRep.getAD_User_ID());
        } else {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_SalesRep_EMail");
            if (Util.isEmpty((String)importBPartner.getI_ErrorMsg())) {
                importBPartner.setI_ErrorMsg(msg);
            } else {
                importBPartner.setI_ErrorMsg(String.valueOf(importBPartner.getI_ErrorMsg()) + " : " + msg);
            }
        }
    }
}

