/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MJournal;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class GLJournalBulkComplete
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private String p_DocStatus = "DR";
    private int p_AD_User_ID = 0;
    private Timestamp p_Created_From = null;
    private Timestamp p_Created_To = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                Calendar cal;
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                    if (this.p_DateAcct_To != null) {
                        cal = Calendar.getInstance();
                        cal.setTimeInMillis(this.p_DateAcct_To.getTime());
                        cal.add(5, 1);
                        this.p_DateAcct_To = new Timestamp(cal.getTimeInMillis());
                    }
                } else if (name.equals("DocStatus")) {
                    this.p_DocStatus = para[i].getParameterAsString();
                } else if (name.equals("AD_User_ID")) {
                    this.p_AD_User_ID = para[i].getParameterAsInt();
                } else if (name.equals("Created")) {
                    this.p_Created_From = (Timestamp)para[i].getParameter();
                    this.p_Created_To = (Timestamp)para[i].getParameter_To();
                    if (this.p_Created_To != null) {
                        cal = Calendar.getInstance();
                        cal.setTimeInMillis(this.p_Created_To.getTime());
                        cal.add(5, 1);
                        this.p_Created_To = new Timestamp(cal.getTimeInMillis());
                    }
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder whereClause = new StringBuilder("AD_Client_ID = ? AND Processed = 'N' AND DocStatus = '" + this.p_DocStatus + "'");
        ArrayList<Comparable<Integer>> docListParams = new ArrayList<Comparable<Integer>>();
        docListParams.add(Integer.valueOf(this.p_AD_Client_ID));
        if (this.p_AD_Org_ID != 0) {
            whereClause.append(" AND AD_Org_ID = ? ");
            docListParams.add(Integer.valueOf(this.p_AD_Org_ID));
        }
        if (this.p_DateAcct_From != null) {
            whereClause.append(" AND DateAcct >= ? ");
            docListParams.add(this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            whereClause.append(" AND DateAcct <= ? ");
            docListParams.add(this.p_DateAcct_To);
        }
        if (this.p_AD_User_ID != 0) {
            whereClause.append(" AND CreatedBy = ? ");
            docListParams.add(Integer.valueOf(this.p_AD_User_ID));
        }
        if (this.p_Created_From != null) {
            whereClause.append(" AND Created >= ? ");
            docListParams.add(this.p_Created_From);
        }
        if (this.p_Created_To != null) {
            whereClause.append(" AND Created <= ? ");
            docListParams.add(this.p_Created_To);
        }
        List list = new Query(this.getCtx(), "GL_Journal", whereClause.toString(), this.get_TrxName()).setParameters(docListParams).list();
        MJournal[] gldoc = list.toArray(new MJournal[list.size()]);
        IProcessUI processMonitor = Env.getProcessUI((Properties)this.getCtx());
        int success = 0;
        int failure = 0;
        int i = 0;
        while (i < gldoc.length) {
            MJournal mj = gldoc[i];
            boolean isOK = mj.processIt("CO");
            if (isOK) {
                ++success;
            } else {
                ++failure;
            }
            String msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"DocumentNo")) + " : " + mj.getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"DocStatus") + " : " + mj.getDocStatus();
            this.addBufferLog(0, null, null, msg, 224, mj.get_ID());
            if (processMonitor != null) {
                processMonitor.statusUpdate(msg);
            } else {
                processMonitor = Env.getProcessUI((Properties)this.getCtx());
            }
            ++i;
        }
        return "Success = " + success + "    Failure" + " = " + failure;
    }
}

