/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.process.AbstractContractProcess;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class DefaultContractProcessCreateDerivativeInvoice
extends AbstractContractProcess {
    ArrayList<MOrderLine> overQtyOrderedLineList = new ArrayList();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MContractAcct contractAcct;
        super.doIt();
        int JP_ContractProcPeriod_ID = 0;
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
            JP_ContractProcPeriod_ID = this.getJP_ContractProctPeriod_ID();
        }
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC") && JP_ContractProcPeriod_ID == 0) {
            String descriptionMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID");
            this.createContractLogDetail("ZZ", null, null, descriptionMsg);
            return "";
        }
        MContractProcPeriod orderProcPeriod = this.getBaseDocContractProcPeriodFromDerivativeDocContractProcPeriod(JP_ContractProcPeriod_ID);
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC") && orderProcPeriod == null) {
            String descriptionMsg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractProcPeriod_ID");
            this.createContractLogDetail("ZZ", null, null, descriptionMsg);
            return "";
        }
        int JP_Contract_Acct_ID = this.m_ContractContent.getJP_Contract_Acct_ID();
        if (JP_Contract_Acct_ID > 0 && (contractAcct = MContractAcct.get(this.getCtx(), JP_Contract_Acct_ID)).isPostingContractAcctJP() && contractAcct.isPostingRecognitionDocJP() && contractAcct.getJP_RecogToInvoicePolicy() != null && !contractAcct.getJP_RecogToInvoicePolicy().equals("NO")) {
            String descriptionMsg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_RecogToInvoicePolicy")});
            this.createContractLogDetail("ZZ", null, null, descriptionMsg);
            return "";
        }
        int C_DocTypeShipment_ID = this.m_ContractContent.getJP_BaseDocDocType().getC_DocTypeShipment_ID();
        if (C_DocTypeShipment_ID > 0) {
            MDocType io_DocType = MDocType.get((Properties)this.getCtx(), (int)C_DocTypeShipment_ID);
            if (io_DocType.get_ValueAsBoolean("IsCreateInvoiceJP")) {
                String msg1 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocTypeForShipmentOfBaseDocDocType");
                String msg2 = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BaseDocDocType_ID"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")});
                this.createContractLogDetail("ZZ", null, null, String.valueOf(msg1) + " : " + msg2);
                return "";
            }
        } else {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + "  " + Msg.getElement((Properties)this.getCtx(), (String)"C_DocTypeShipment_ID");
            this.createContractLogDetail("ZZ", null, null, msg);
            return "";
        }
        MOrder[] orders = this.m_ContractContent.getOrderByContractPeriod(this.getCtx(), orderProcPeriod.getJP_ContractProcPeriod_ID(), this.get_TrxName());
        int i = 0;
        while (i < orders.length) {
            block42: {
                MInvoice invoice;
                block40: {
                    block44: {
                        block45: {
                            boolean isCreateDocLine;
                            MOrderLine[] orderLines;
                            block43: {
                                block41: {
                                    if (orders[i].getDocStatus().equals("CO")) break block41;
                                    this.createContractLogDetail("B7", null, (PO)orders[i], null);
                                    break block42;
                                }
                                orderLines = orders[i].getLines(true, "");
                                isCreateDocLine = false;
                                int j = 0;
                                while (j < orderLines.length) {
                                    if (this.isCreateInvoiceLine(orderLines[j], JP_ContractProcPeriod_ID, false)) {
                                        isCreateDocLine = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (isCreateDocLine) break block43;
                                if (this.overQtyOrderedLineList.size() > 0) {
                                    for (MOrderLine oLine : this.overQtyOrderedLineList) {
                                        this.createContractLogDetail("W2", null, (PO)oLine, null);
                                    }
                                } else {
                                    this.createContractLogDetail("B2", null, (PO)orders[i], null);
                                }
                                break block42;
                            }
                            isCreateDocLine = false;
                            invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                            PO.copyValues((PO)orders[i], (PO)invoice);
                            if (orders[i].getBill_BPartner_ID() > 0) {
                                invoice.setC_BPartner_ID(orders[i].getBill_BPartner_ID());
                            }
                            if (orders[i].getBill_Location_ID() > 0) {
                                invoice.setC_BPartner_Location_ID(orders[i].getBill_Location_ID());
                            }
                            if (orders[i].getBill_User_ID() > 0) {
                                invoice.setAD_User_ID(orders[i].getBill_User_ID());
                            }
                            invoice.setC_Order_ID(orders[i].getC_Order_ID());
                            invoice.setProcessed(false);
                            invoice.setDocStatus("DR");
                            invoice.setAD_Org_ID(this.m_ContractContent.getAD_Org_ID());
                            invoice.setAD_OrgTrx_ID(this.m_ContractContent.getAD_OrgTrx_ID());
                            invoice.setDateInvoiced(this.getDateInvoiced());
                            invoice.setDocumentNo("");
                            invoice.setC_DocTypeTarget_ID(orders[i].getC_DocTypeTarget().getC_DocTypeInvoice_ID());
                            invoice.setDateAcct(this.getDateAcct());
                            try {
                                invoice.saveEx(this.get_TrxName());
                            }
                            catch (AdempiereException e) {
                                this.createContractLogDetail("Z1", null, null, e.getMessage());
                                throw e;
                            }
                            orders[i].set_TrxName(this.get_TrxName());
                            isCreateDocLine = false;
                            int j = 0;
                            while (j < orderLines.length) {
                                if (this.isCreateInvoiceLine(orderLines[j], JP_ContractProcPeriod_ID, true)) {
                                    int JP_ContractLine_ID = orderLines[j].get_ValueAsInt("JP_ContractLine_ID");
                                    MContractLine contractLine = MContractLine.get(this.getCtx(), JP_ContractLine_ID);
                                    MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
                                    PO.copyValues((PO)orderLines[j], (PO)iLine);
                                    iLine.setC_OrderLine_ID(orderLines[j].getC_OrderLine_ID());
                                    iLine.setProcessed(false);
                                    iLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
                                    iLine.setAD_Org_ID(invoice.getAD_Org_ID());
                                    iLine.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
                                    iLine.setQtyEntered(contractLine.getQtyInvoiced());
                                    if (iLine.getM_Product_ID() > 0) {
                                        iLine.setC_UOM_ID(MProduct.get((Properties)this.getCtx(), (int)iLine.getM_Product_ID()).getC_UOM_ID());
                                    } else {
                                        iLine.setC_UOM_ID(MUOM.getDefault_UOM_ID((Properties)this.getCtx()));
                                    }
                                    iLine.setQtyInvoiced(contractLine.getQtyInvoiced());
                                    iLine.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
                                    try {
                                        iLine.saveEx(this.get_TrxName());
                                    }
                                    catch (AdempiereException e) {
                                        this.createContractLogDetail("Z1", null, (PO)invoice, e.getMessage());
                                        throw e;
                                    }
                                    isCreateDocLine = true;
                                }
                                ++j;
                            }
                            if (!isCreateDocLine) break block44;
                            String docAction = this.getDocAction();
                            if (Util.isEmpty((String)docAction)) break block45;
                            if (!invoice.processIt(docAction)) {
                                this.createContractLogDetail("Z2", null, (PO)invoice, invoice.getProcessMsg());
                                throw new AdempiereException(invoice.getProcessMsg());
                            }
                            if (!docAction.equals("CO")) {
                                invoice.setDocAction("CO");
                                try {
                                    invoice.saveEx(this.get_TrxName());
                                    break block40;
                                }
                                catch (AdempiereException e) {
                                    this.createContractLogDetail("Z1", null, (PO)invoice, e.getMessage());
                                    throw e;
                                }
                            }
                            break block40;
                        }
                        invoice.setDocAction("CO");
                        try {
                            invoice.saveEx(this.get_TrxName());
                            break block40;
                        }
                        catch (AdempiereException e) {
                            this.createContractLogDetail("Z1", null, (PO)invoice, e.getMessage());
                            throw e;
                        }
                    }
                    invoice.deleteEx(true, this.get_TrxName());
                    this.createContractLogDetail("B2", null, (PO)orders[i], null);
                    break block42;
                }
                this.createContractLogDetail("A1", null, (PO)invoice, null);
            }
            ++i;
        }
        return "";
    }

    private boolean isCreateInvoiceLine(MOrderLine orderLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        MContractProcPeriod process_Period;
        MContractProcPeriod contractLine_Period;
        MContractProcPeriod lump_ContractProcPeriod;
        int JP_ContractLine_ID = orderLine.get_ValueAsInt("JP_ContractLine_ID");
        if (JP_ContractLine_ID == 0) {
            return false;
        }
        MContractLine contractLine = MContractLine.get(this.getCtx(), JP_ContractLine_ID);
        if (contractLine.getJP_ContractProcess_Inv_ID() != this.getJP_ContractProcess_ID()) {
            return false;
        }
        MContractProcPeriod processPeriod = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
        if (contractLine.getJP_ContractCalender_Inv_ID() != processPeriod.getJP_ContractCalender_ID()) {
            return false;
        }
        if (!contractLine.isCreateDocLineJP()) {
            if (isCreateLog) {
                this.createContractLogDetail("B3", contractLine, null, null);
            }
            return false;
        }
        if (contractLine.getQtyInvoiced().compareTo(Env.ZERO) == 0) {
            if (isCreateLog) {
                this.createContractLogDetail("B8", contractLine, null, null);
            }
            return false;
        }
        MInvoiceLine[] iLines = contractLine.getInvoiceLineByContractPeriod(this.getCtx(), JP_ContractProcPeriod_ID, this.get_TrxName());
        if (iLines != null && iLines.length > 0) {
            if (isCreateLog) {
                this.createContractLogDetail("B1", contractLine, (PO)iLines[0], null);
            }
            return false;
        }
        if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("LP") && !(lump_ContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_Inv_ID())).isContainedBaseDocContractProcPeriod(JP_ContractProcPeriod_ID)) {
            if (isCreateLog) {
                this.createContractLogDetail("B4", contractLine, null, null);
            }
            return false;
        }
        if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PS") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
            contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_Inv_ID());
            process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
            if (contractLine_Period.getStartDate().compareTo(process_Period.getStartDate()) > 0) {
                if (isCreateLog) {
                    this.createContractLogDetail("B5", contractLine, null, Msg.getElement((Properties)this.getCtx(), (String)"JP_ProcPeriod_Start_Inv_ID"));
                }
                return false;
            }
        }
        if (contractLine.getJP_DerivativeDocPolicy_Inv().equals("PE") || contractLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
            contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_Inv_ID());
            process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
            if (contractLine_Period.getEndDate().compareTo(process_Period.getEndDate()) < 0) {
                if (isCreateLog) {
                    this.createContractLogDetail("B5", contractLine, null, "JP_ProcPeriod_End_Iv_ID");
                }
                return false;
            }
        }
        BigDecimal qtyInvoiced = contractLine.getQtyInvoiced();
        BigDecimal qtyToInvoice = orderLine.getQtyOrdered().subtract(orderLine.getQtyInvoiced());
        if (qtyToInvoice.compareTo(qtyInvoiced) < 0) {
            if (isCreateLog) {
                this.createContractLogDetail("W2", contractLine, (PO)orderLine, null);
            } else {
                this.overQtyOrderedLineList.add(orderLine);
            }
            return false;
        }
        return true;
    }
}

