/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class DefaultBankDataImport
extends SvrProcess {
    private static final int INDEX_HEADER_JP_BankDataType_Header = 0;
    private static final int INDEX_HEADER_JP_BankDataClassification = 1;
    private static final int INDEX_HEADER_JP_BankDataCodeType = 2;
    private static final int INDEX_HEADER_JP_RequesterCode = 3;
    private static final int INDEX_HEADER_JP_RequesterName = 4;
    private static final int INDEX_HEADER_PayDate = 5;
    private static final int INDEX_HEADER_RoutingNo = 6;
    private static final int INDEX_HEADER_JP_BankName_kana = 7;
    private static final int INDEX_HEADER_JP_BranchCode = 8;
    private static final int INDEX_HEADER_JP_BranchName_Kana = 9;
    private static final int INDEX_HEADER_JP_BankAccountType = 10;
    private static final int INDEX_HEADER_AccountNo = 11;
    private static final int INDEX_LINE_JP_BankDataType_Line = 0;
    private static final int INDEX_LINE_RoutingNo = 1;
    private static final int INDEX_LINE_JP_BankName_Kana = 2;
    private static final int INDEX_LINE_JP_BranchCode = 3;
    private static final int INDEX_LINE_JP_BranchName_Kana = 4;
    private static final int INDEX_LINE_JP_ClearingHouse = 5;
    private static final int INDEX_LINE_JP_BankAccountType = 6;
    private static final int INDEX_LINE_AccountNo = 7;
    private static final int INDEX_LINE_JP_A_Name_Kana = 8;
    private static final int INDEX_LINE_StmtAmt = 9;
    private static final int INDEX_LINE_JP_BankDataNewCode = 10;
    private static final int INDEX_LINE_JP_BankDataCustomerCode1 = 11;
    private static final int INDEX_LINE_JP_BankDataCustomerCode2 = 12;
    private static final int INDEX_FOOTER_JP_BankDataType_Footer = 0;
    private static final int INDEX_FOOTER_NumLines = 1;
    private static final int INDEX_FOOTER_TotalAmt = 2;
    private static final int NUMBER_HEADER_Columns = 12;
    private static final int NUMBER_LINE_Columns = 13;
    private static final int NUMBER_FOOTER_Columns = 3;
    private static final int HEADER_JP_BankDataType_Header = 1;
    private static final int HEADER_JP_BankDataClassification = 2;
    private static final int HEADER_JP_BankDataCodeType = 1;
    private static final int HEADER_JP_RequesterCode = 10;
    private static final int HEADER_JP_RequesterName = 40;
    private static final int HEADER_PayDate = 4;
    private static final int HEADER_RoutingNo = 4;
    private static final int HEADER_JP_BankName_kana = 15;
    private static final int HEADER_JP_BranchCode = 3;
    private static final int HEADER_JP_BranchName_Kana = 15;
    private static final int HEADER_JP_BankAccountType = 1;
    private static final int HEADER_AccountNo = 7;
    private static final int LINE_JP_BankDataType_Line = 1;
    private static final int LINE_RoutingNo = 4;
    private static final int LINE_JP_BankName_Kana = 15;
    private static final int LINE_JP_BranchCode = 3;
    private static final int LINE_JP_BranchName_Kana = 15;
    private static final int LINE_JP_ClearingHouse = 4;
    private static final int LINE_JP_BankAccountType = 1;
    private static final int LINE_AccountNo = 7;
    private static final int LINE_JP_A_Name_Kana = 30;
    private static final int LINE_StmtAmt = 10;
    private static final int LINE_JP_BankDataNewCode = 1;
    private static final int LINE_JP_BankDataCustomerCode1 = 10;
    private static final int LINE_JP_BankDataCustomerCode2 = 10;
    private static final int FOOTER_JP_BankDataType_Footer = 1;
    private static final int FOOTER_NumLines = 6;
    private static final int FOOTER_TotalAmt = 12;
    private static final int START_POSITION_HEADER_JP_BankDataType_Header = 0;
    private static final int START_POSITION_HEADER_JP_BankDataClassification = 1;
    private static final int START_POSITION_HEADER_JP_BankDataCodeType = 3;
    private static final int START_POSITION_HEADER_JP_RequesterCode = 4;
    private static final int START_POSITION_HEADER_JP_RequesterName = 14;
    private static final int START_POSITION_HEADER_PayDate = 54;
    private static final int START_POSITION_HEADER_RoutingNo = 58;
    private static final int START_POSITION_HEADER_JP_BankName_Kana = 62;
    private static final int START_POSITION_HEADER_JP_BranchCode = 77;
    private static final int START_POSITION_HEADER_JP_BranchName_Kana = 80;
    private static final int START_POSITION_HEADER_JP_BankAccountType = 95;
    private static final int START_POSITION_HEADER_AccountNo = 96;
    private static final int END_POSITION_HEADER_JP_BankDataType_Header = 1;
    private static final int END_POSITION_HEADER_JP_BankDataClassification = 3;
    private static final int END_POSITION_HEADER_JP_BankDataCodeType = 4;
    private static final int END_POSITION_HEADER_JP_RequesterCode = 14;
    private static final int END_POSITION_HEADER_JP_RequesterName = 54;
    private static final int END_POSITION_HEADER_PayDate = 58;
    private static final int END_POSITION_HEADER_RoutingNo = 62;
    private static final int END_POSITION_HEADER_JP_BankName_Kana = 77;
    private static final int END_POSITION_HEADER_JP_BranchCode = 80;
    private static final int END_POSITION_HEADER_JP_BranchName_Kana = 95;
    private static final int END_POSITION_HEADER_JP_BankAccountType = 96;
    private static final int END_POSITION_HEADER_AccountNo = 103;
    private static final int START_POSITION_LINE_JP_BankDataType_Line = 0;
    private static final int START_POSITION_LINE_RoutingNo = 1;
    private static final int START_POSITION_LINE_JP_BankName_Kana = 5;
    private static final int START_POSITION_LINE_JP_BranchCode = 20;
    private static final int START_POSITION_LINE_JP_BranchName_Kana = 23;
    private static final int START_POSITION_LINE_JP_ClearingHouse = 38;
    private static final int START_POSITION_LINE_JP_BankAccountType = 42;
    private static final int START_POSITION_LINE_AccountNo = 43;
    private static final int START_POSITION_LINE_JP_A_Name_Kana = 50;
    private static final int START_POSITION_LINE_StmtAmt = 80;
    private static final int START_POSITION_LINE_JP_BankDataNewCode = 90;
    private static final int START_POSITION_LINE_JP_BankDataCustomerCode1 = 91;
    private static final int START_POSITION_LINE_JP_BankDataCustomerCode2 = 101;
    private static final int END_POSITION_LINE_JP_BankDataType_Line = 1;
    private static final int END_POSITION_LINE_RoutingNo = 5;
    private static final int END_POSITION_LINE_JP_BankName_Kana = 20;
    private static final int END_POSITION_LINE_JP_BranchCode = 23;
    private static final int END_POSITION_LINE_JP_BranchName_Kana = 38;
    private static final int END_POSITION_LINE_JP_ClearingHouse = 42;
    private static final int END_POSITION_LINE_JP_BankAccountType = 43;
    private static final int END_POSITION_LINE_AccountNo = 50;
    private static final int END_POSITION_LINE_JP_A_Name_Kana = 80;
    private static final int END_POSITION_LINE_StmtAmt = 90;
    private static final int END_POSITION_LINE_JP_BankDataNewCode = 91;
    private static final int END_POSITION_LINE_JP_BankDataCustomerCode1 = 101;
    private static final int END_POSITION_LINE_JP_BankDataCustomerCode2 = 111;
    private static final int START_POSITION_FOOTER_JP_BankDataType_Footer = 0;
    private static final int START_POSITION_FOOTER_NumLines = 1;
    private static final int START_POSITION_FOOTER_TotalAmt = 7;
    private static final int END_POSITION_FOOTER_JP_BankDataType_Footer = 1;
    private static final int END_POSITION_FOOTER_NumLines = 7;
    private static final int END_POSITION_FOOTER_TotalAmt = 19;
    private static final String DATADIFF_Header = "1";
    private static final String DATADIFF_Line = "2";
    private static final String DATADIFF_Trailer = "8";
    private int p_AD_Client_ID = 0;
    private int p_JP_BankData_ID = 0;
    private MBankData m_BankData = null;
    private String p_BankDataFile = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (!name.equals("")) {
                if (name.equals("JP_BankDataFile")) {
                    this.p_BankDataFile = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter :" + name);
                }
            }
            this.p_JP_BankData_ID = this.getRecord_ID();
            this.m_BankData = new MBankData(this.getCtx(), this.p_JP_BankData_ID, this.get_TrxName());
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        StringBuffer err = new StringBuffer();
        if (this.p_BankDataFile == null) return Msg.getMsg((Properties)this.getCtx(), (String)"File invalid");
        if (this.p_BankDataFile.length() == 0) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"File invalid");
        }
        try {
            File file = new File(this.p_BankDataFile);
            if (file.isDirectory()) {
                err.append("Path is not a file. - " + file.getAbsolutePath());
                this.log.log(Level.SEVERE, err.toString());
                return Msg.getMsg((Properties)this.getCtx(), (String)"Path is not a file");
            }
            if (!file.exists()) {
                err.append("No file in the folder. - " + file.getAbsolutePath());
                this.log.log(Level.SEVERE, err.toString());
                return Msg.getMsg((Properties)this.getCtx(), (String)"No file in the folder");
            }
            FileInputStream fs = null;
            InputStreamReader isr = null;
            try (BufferedReader br = null;){
                try {
                    fs = new FileInputStream(file);
                    isr = new InputStreamReader((InputStream)fs, "UTF8");
                    br = new BufferedReader(isr);
                    StringBuilder sql = null;
                    int lineNo = 10;
                    int no = 0;
                    String tmplinedata = br.readLine();
                    while (true) {
                        if (tmplinedata == null) {
                            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + " : WPayImportProcess()";
                        }
                        String str = tmplinedata;
                        String dataDiff = str.substring(0, 1);
                        if (dataDiff.equals(DATADIFF_Header)) {
                            String[] header = new String[]{str.substring(0, 1), str.substring(1, 3), str.substring(3, 4), str.substring(4, 14), str.substring(14, 54), str.substring(54, 58), str.substring(58, 62), str.substring(62, 77), str.substring(77, 80), str.substring(80, 95), str.substring(95, 96), str.substring(96, 103)};
                            sql = new StringBuilder("UPDATE JP_BankData ").append("SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.p_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID, 0),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, SysDate),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, SysDate),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" JP_BankDataType_Header = '").append(header[0]).append("',").append(" JP_BankDataClassification = '").append(header[1]).append("',").append(" JP_BankDataCodeType = '").append(header[2]).append("',").append(" JP_RequesterCode = '").append(header[3]).append("',").append(" JP_RequesterName = '").append(header[4]).append("',").append(" PayDate = TO_DATE('" + this.m_BankData.getStatementDate().toString().substring(0, 4) + header[5]).append("','YYYYMMDD'),").append(" RoutingNo = '").append(header[6]).append("',").append(" JP_BankName_Kana = '").append(header[7]).append("',").append(" JP_BranchCode = '").append(header[8]).append("',").append(" JP_BranchName_Kana = '").append(header[9]).append("',").append(" JP_BankAccountType = '").append(header[10]).append("',").append(" AccountNo = '").append(header[11]).append("' ").append("WHERE JP_BankData_ID =").append(this.p_JP_BankData_ID);
                            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Reset=" + no);
                            }
                        } else if (dataDiff.equals(DATADIFF_Line)) {
                            String[] line = new String[]{str.substring(0, 1), str.substring(1, 5), str.substring(5, 20), str.substring(20, 23), str.substring(23, 38), str.substring(38, 42), str.substring(42, 43), str.substring(43, 50), str.substring(50, 80), str.substring(80, 90), str.substring(90, 91), str.substring(91, 101), str.substring(101, 111)};
                            sql = new StringBuilder("INSERT INTO JP_BankDataLine ").append(" (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, ").append(" JP_BankDataType_Line, RoutingNo, JP_BankName_Kana, JP_BranchCode, JP_BranchName_Kana, JP_ClearingHouse, ").append(" JP_BankAccountType, AccountNo, JP_A_Name_Kana, StmtAmt, TrxAmt,").append(" Line, JP_BankData_ID, JP_BankDataLine_ID, JP_BankDataLine_UU, StatementLineDate,DateAcct, ValutaDate ) ").append(" VALUES (").append(this.p_AD_Client_ID).append(",").append(this.m_BankData.getAD_Org_ID()).append(",").append(" 'Y',").append(" SysDate,").append(" COALESCE((SELECT CreatedBy FROM JP_BankData WHERE JP_BankData_ID = ").append(this.p_JP_BankData_ID).append("), 0),").append(" SysDate,").append(" COALESCE((SELECT UpdatedBy FROM JP_BankData WHERE JP_BankData_ID = ").append(this.p_JP_BankData_ID).append("), 0),").append(" '").append(line[0]).append("',").append(" '").append(line[1]).append("',").append(" '").append(line[2]).append("',").append(" '").append(line[3]).append("',").append(" '").append(line[4]).append("',").append(" '").append(line[5]).append("',").append(" '").append(line[6]).append("',").append(" '").append(line[7]).append("',").append(" '").append(line[8]).append("',").append(" ").append(line[9]).append(",").append(" ").append(line[9]).append(",").append(" ").append(lineNo).append(",").append(" ").append(this.p_JP_BankData_ID).append(",").append(" ").append(DB.getNextID((int)this.p_AD_Client_ID, (String)"JP_BankDataLine", (String)this.get_TrxName())).append(",").append(" generate_uuid(), ").append(" ").append("TO_DATE('").append(this.m_BankData.getStatementDate().toString().substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS'),").append(" ").append("TO_DATE('").append(this.m_BankData.getDateAcct().toString().substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS'),").append(" ").append("TO_DATE('").append(this.m_BankData.getDateAcct().toString().substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS')").append(");");
                            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Reset=" + no);
                            }
                            lineNo += 10;
                        } else if (dataDiff.equals(DATADIFF_Trailer)) {
                            String[] footer = new String[]{str.substring(0, 1), str.substring(1, 7), str.substring(7, 19)};
                            sql = new StringBuilder("UPDATE JP_BankData ").append("SET").append(" JP_BankDataType_Footer = '").append(footer[0]).append("',").append(" NumLines = '").append(footer[1]).append("',").append(" TotalAmt = '").append(footer[2]).append("'").append(" WHERE JP_BankData_ID =").append(this.p_JP_BankData_ID);
                            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Reset=" + no);
                            }
                        }
                        tmplinedata = br.readLine();
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    String string = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + e.toString();
                    br.close();
                    return string;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + e.toString();
        }
    }
}

