/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.PO;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class CreateInvoiceLineFromContractLine
extends SvrProcess {
    int record_ID = 0;
    MContractContent m_ContractContent = null;

    protected void prepare() {
        this.record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.record_ID == 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError"));
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.record_ID, this.get_TrxName());
        MInvoiceLine[] iLines = invoice.getLines();
        if (iLines.length > 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_DocLineCreated"));
        }
        int JP_ContractContent_ID = invoice.get_ValueAsInt("JP_ContractContent_ID");
        if (JP_ContractContent_ID <= 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_ContractContent_ID"));
        }
        this.m_ContractContent = MContractContent.get(this.getCtx(), JP_ContractContent_ID);
        int JP_ContractProcPeriod_ID = invoice.get_ValueAsInt("JP_ContractProcPeriod_ID");
        MContractLine[] m_lines = this.m_ContractContent.getLines();
        int i = 0;
        while (i < m_lines.length) {
            if (JP_ContractProcPeriod_ID <= 0 || this.isCreateDocLine(m_lines[i], JP_ContractProcPeriod_ID, true)) {
                MInvoiceLine iline = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
                PO.copyValues((PO)m_lines[i], (PO)iline);
                iline.setProcessed(false);
                iline.setC_Invoice_ID(invoice.getC_Invoice_ID());
                iline.setAD_Org_ID(invoice.getAD_Org_ID());
                iline.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
                iline.setQtyInvoiced(m_lines[i].getQtyOrdered());
                iline.set_ValueNoCheck("JP_ContractLine_ID", (Object)m_lines[i].getJP_ContractLine_ID());
                if (this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
                    iline.set_ValueOfColumn("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
                }
                iline.saveEx(this.get_TrxName());
            }
            ++i;
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private boolean isCreateDocLine(MContractLine contractLine, int JP_ContractProcPeriod_ID, boolean isCreateLog) {
        if (!contractLine.isCreateDocLineJP()) {
            return false;
        }
        if (!this.m_ContractContent.getParent().getJP_ContractType().equals("PDC")) {
            return true;
        }
        if (contractLine.getJP_BaseDocLinePolicy() != null) {
            MContractProcPeriod contractLine_Period;
            MContractProcPeriod lump_ContractProcPeriod;
            if (contractLine.getJP_BaseDocLinePolicy().equals("LP") && !(lump_ContractProcPeriod = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Lump_ID())).isContainedBaseDocContractProcPeriod(JP_ContractProcPeriod_ID)) {
                return false;
            }
            if (contractLine.getJP_BaseDocLinePolicy().equals("PS") || contractLine.getJP_BaseDocLinePolicy().equals("PB")) {
                contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_Start_ID());
                MContractProcPeriod process_Period = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period.getStartDate().compareTo(process_Period.getStartDate()) > 0) {
                    return false;
                }
            }
            if (contractLine.getJP_BaseDocLinePolicy().equals("PE") || contractLine.getJP_BaseDocLinePolicy().equals("PB")) {
                contractLine_Period = MContractProcPeriod.get(this.getCtx(), contractLine.getJP_ProcPeriod_End_ID());
                MContractProcPeriod process_ContractProcPeriod = MContractProcPeriod.get(this.getCtx(), JP_ContractProcPeriod_ID);
                if (contractLine_Period.getEndDate().compareTo(process_ContractProcPeriod.getEndDate()) < 0) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

