/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

public class CreateEstimationFromInvoice
extends SvrProcess {
    private int p_C_DocType_ID = 0;
    private String p_DocAction = null;
    private int p_M_Warehouse_ID = 0;
    private int p_C_Invoice_ID = 0;
    private MInvoice invoice = null;

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        MInvoiceLine[] invoiceLines = this.invoice.getLines();
        MEstimation estimation = new MEstimation(this.getCtx(), 0, this.get_TrxName());
        MBPartner bpartner = new MBPartner(this.getCtx(), this.invoice.getC_BPartner_ID(), this.get_TrxName());
        PO.copyValues((PO)this.invoice, (PO)estimation);
        estimation.setAD_Org_ID(this.invoice.getAD_Org_ID());
        estimation.setDocumentNo(this.invoice.getDocumentNo());
        estimation.setJP_EstimationDate(this.invoice.getDateInvoiced());
        estimation.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        estimation.setC_DocType_ID(this.p_C_DocType_ID);
        estimation.setDocStatus("DR");
        estimation.setDocAction("CO");
        estimation.setM_Warehouse_ID(this.p_M_Warehouse_ID);
        if (this.invoice.getC_Order_ID() != 0) {
            MOrder order = new MOrder(this.getCtx(), this.invoice.getC_Order_ID(), this.get_TrxName());
            estimation.setInvoiceRule(order.getInvoiceRule());
            estimation.setDeliveryRule(order.getDeliveryRule());
            estimation.setFreightCostRule(order.getFreightCostRule());
            estimation.setDeliveryViaRule(order.getDeliveryViaRule());
            estimation.setPriorityRule(order.getPriorityRule());
            estimation.setDateOrdered(order.getDateOrdered());
            estimation.setDatePromised(order.getDatePromised());
        } else {
            if (bpartner.getInvoiceRule() != null) {
                estimation.setInvoiceRule(bpartner.getInvoiceRule());
            } else {
                estimation.setInvoiceRule("I");
            }
            if (bpartner.getDeliveryRule() != null) {
                estimation.setDeliveryRule(bpartner.getDeliveryRule());
            } else {
                estimation.setDeliveryRule("A");
            }
            if (bpartner.getFreightCostRule() != null) {
                estimation.setFreightCostRule(bpartner.getFreightCostRule());
            } else {
                estimation.setFreightCostRule("I");
            }
            if (bpartner.getDeliveryViaRule() != null) {
                estimation.setDeliveryViaRule(bpartner.getDeliveryViaRule());
            } else {
                estimation.setDeliveryViaRule("P");
            }
            estimation.setDateOrdered(this.invoice.getDateInvoiced());
            estimation.setDatePromised(this.invoice.getDateInvoiced());
            estimation.setPriorityRule("5");
        }
        estimation.setC_Invoice_ID(this.p_C_Invoice_ID);
        estimation.saveEx(this.get_TrxName());
        int i = 0;
        while (i < invoiceLines.length) {
            MEstimationLine estimationLines = new MEstimationLine(estimation);
            PO.copyValues((PO)invoiceLines[i], (PO)estimationLines);
            estimationLines.setAD_Org_ID(this.invoice.getAD_Org_ID());
            estimationLines.setC_BPartner_ID(this.invoice.getC_BPartner_ID());
            estimationLines.setC_BPartner_Location_ID(this.invoice.getC_BPartner_Location_ID());
            estimationLines.setDateInvoiced(this.invoice.getDateInvoiced());
            estimationLines.setM_Warehouse_ID(this.p_M_Warehouse_ID);
            estimationLines.setQtyOrdered(invoiceLines[i].getQtyInvoiced());
            estimationLines.saveEx(this.get_TrxName());
            ++i;
        }
        if (invoiceLines.length > 0 && this.p_DocAction != null) {
            estimation = new MEstimation(this.getCtx(), estimation.getJP_Estimation_ID(), this.get_TrxName());
            if (!estimation.processIt(this.p_DocAction)) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError"));
            }
            estimation.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, estimation.getDocumentInfo(), estimation.get_Table_ID(), estimation.getJP_Estimation_ID());
        return this.invoice.getDocumentInfo();
    }
}

