/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateEstimationFromInOut
extends SvrProcess {
    private int p_M_InOut_ID = 0;
    private int p_C_DocType_ID = 0;
    private String p_DocAction = null;
    private MInOut inout = null;

    protected void prepare() {
        this.p_M_InOut_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.inout = new MInOut(this.getCtx(), this.p_M_InOut_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        MInOutLine[] inoutLines = this.inout.getLines();
        MOrder order = new MOrder(this.getCtx(), this.inout.getC_Order_ID(), this.get_TrxName());
        MEstimation estimation = new MEstimation(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.inout, (PO)estimation);
        estimation.setAD_Org_ID(this.inout.getAD_Org_ID());
        estimation.setDocumentNo(this.inout.getDocumentNo());
        estimation.setJP_EstimationDate(this.inout.getMovementDate());
        estimation.setDocAction("CO");
        estimation.setDocStatus("DR");
        estimation.setVersion(Env.ONE);
        estimation.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        estimation.setC_DocType_ID(this.p_C_DocType_ID);
        estimation.setC_Currency_ID(order.getC_Currency_ID());
        estimation.setPaymentRule(order.getPaymentRule());
        estimation.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
        estimation.setInvoiceRule(order.getInvoiceRule());
        estimation.setTotalLines(Env.ZERO);
        estimation.setGrandTotal(Env.ZERO);
        estimation.setM_PriceList_ID(order.getM_PriceList_ID());
        estimation.setIsTaxIncluded(order.isTaxIncluded());
        estimation.setIsPriviledgedRate(order.isPriviledgedRate());
        estimation.setDatePromised(order.getDatePromised());
        estimation.setM_InOut_ID(this.p_M_InOut_ID);
        estimation.saveEx(this.get_TrxName());
        int i = 0;
        while (i < inoutLines.length) {
            MEstimationLine estLine = new MEstimationLine(estimation);
            PO.copyValues((PO)inoutLines[i], (PO)estLine);
            I_C_OrderLine ol = inoutLines[i].getC_OrderLine();
            estLine.setAD_Org_ID(ol.getAD_Org_ID());
            estLine.setM_Warehouse_ID(ol.getM_Warehouse_ID());
            estLine.setQtyEntered(inoutLines[i].getQtyEntered());
            estLine.setQtyOrdered(inoutLines[i].getMovementQty());
            estLine.setQtyReserved(Env.ZERO);
            estLine.setQtyDelivered(Env.ZERO);
            estLine.setQtyInvoiced(Env.ZERO);
            estLine.setQtyLostSales(Env.ZERO);
            estLine.setC_Currency_ID(ol.getC_Currency_ID());
            estLine.setPriceEntered(ol.getPriceEntered());
            estLine.setPriceActual(ol.getPriceActual());
            estLine.setPriceList(ol.getPriceList());
            estLine.setPriceLimit(ol.getPriceLimit());
            estLine.setFreightAmt(ol.getFreightAmt());
            estLine.setLineNetAmt(estLine.getQtyOrdered().multiply(estLine.getPriceActual()));
            estLine.setC_Tax_ID(ol.getC_Tax_ID());
            estLine.saveEx(this.get_TrxName());
            ++i;
        }
        if (inoutLines.length > 0 && this.p_DocAction != null) {
            if (!estimation.processIt(this.p_DocAction)) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError"));
            }
            estimation.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, estimation.getDocumentInfo(), estimation.get_Table_ID(), estimation.getJP_Estimation_ID());
        return estimation.getDocumentInfo();
    }
}

