/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MBillLine;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class CreateEstimationFromBill
extends SvrProcess {
    private int p_JP_Bill_ID = 0;
    private String p_DocAction = null;
    private int p_C_DocTypeTarget_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private MBill bill = null;

    protected void prepare() {
        this.p_JP_Bill_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocTypeTarget_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.bill = new MBill(this.getCtx(), this.p_JP_Bill_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        MEstimation estimation = this.createEstimation();
        this.createOfEstimationLine(estimation);
        if (this.p_DocAction != null) {
            estimation = new MEstimation(this.getCtx(), estimation.getJP_Estimation_ID(), this.get_TrxName());
            if (!estimation.processIt(this.p_DocAction)) {
                throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessRunError"));
            }
            estimation.saveEx(this.get_TrxName());
        }
        this.addBufferLog(0, null, null, estimation.getDocumentInfo(), estimation.get_Table_ID(), estimation.getJP_Estimation_ID());
        return estimation.getDocumentInfo();
    }

    private MEstimation createEstimation() throws Exception {
        MEstimation estimation = new MEstimation(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)this.bill, (PO)estimation);
        estimation.setAD_Org_ID(this.bill.getAD_Org_ID());
        estimation.setC_Currency_ID(this.bill.getC_Currency_ID());
        estimation.setDocStatus("DR");
        estimation.setDocAction("CO");
        estimation.setJP_EstimationDate(this.bill.getJPDateBilled());
        estimation.setVersion(Env.ONE);
        estimation.setC_DocTypeTarget_ID(this.p_C_DocTypeTarget_ID);
        estimation.setDateOrdered(this.bill.getJPCutOffDate());
        estimation.setDatePromised(this.bill.getJPCutOffDate());
        estimation.setDocumentNo(this.bill.getDocumentNo());
        MBPartner partner = new MBPartner(this.getCtx(), this.bill.getC_BPartner_ID(), this.get_TrxName());
        estimation.setIsDiscountPrinted(partner.isDiscountPrinted());
        MBillLine[] bLines = this.bill.getLines();
        if (bLines.length > 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), bLines[0].getC_Invoice_ID(), this.get_TrxName());
            estimation.setM_PriceList_ID(invoice.getM_PriceList_ID());
            if (invoice.getC_Order_ID() != 0) {
                MOrder order = new MOrder(this.getCtx(), invoice.getC_Order_ID(), this.get_TrxName());
                estimation.setInvoiceRule(order.getInvoiceRule());
                estimation.setDeliveryRule(order.getDeliveryRule());
                estimation.setFreightCostRule(order.getFreightCostRule());
                estimation.setDeliveryViaRule(order.getDeliveryViaRule());
                estimation.setPriorityRule(order.getPriorityRule());
            } else if (invoice.getC_Order_ID() == 0) {
                this.setEstimationFromPartnerOrDefaultValue(estimation, partner);
                estimation.setPriorityRule("5");
            }
        }
        estimation.setM_Warehouse_ID(this.p_M_Warehouse_ID);
        MPriceList priceList = new MPriceList(this.getCtx(), estimation.getM_PriceList_ID(), this.get_TrxName());
        estimation.setIsTaxIncluded(priceList.isTaxIncluded());
        estimation.setSendEMail(partner.isSendEMail());
        estimation.setJP_Bill_ID(this.bill.getJP_Bill_ID());
        estimation.saveEx(this.get_TrxName());
        return estimation;
    }

    private void setEstimationFromPartnerOrDefaultValue(MEstimation estimation, MBPartner partner) {
        if (partner.getInvoiceRule() != null) {
            estimation.setInvoiceRule(partner.getInvoiceRule());
        } else {
            estimation.setInvoiceRule("I");
        }
        if (partner.getDeliveryRule() != null) {
            estimation.setDeliveryRule(partner.getDeliveryRule());
        } else {
            estimation.setDeliveryRule("F");
        }
        if (partner.getFreightCostRule() != null) {
            estimation.setFreightCostRule(partner.getFreightCostRule());
        } else {
            estimation.setFreightCostRule("I");
        }
        if (partner.getDeliveryViaRule() != null) {
            estimation.setDeliveryViaRule(partner.getDeliveryViaRule());
        } else {
            estimation.setDeliveryViaRule("P");
        }
    }

    private void createOfEstimationLine(MEstimation estimation) {
        int lineCounter = 0;
        MBillLine[] mBillLineArray = this.bill.getLines();
        int n = mBillLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBillLine billLine = mBillLineArray[n2];
            MInvoice invoice = new MInvoice(this.getCtx(), billLine.getC_Invoice_ID(), this.get_TrxName());
            MInvoiceLine[] mInvoiceLineArray = invoice.getLines();
            int n3 = mInvoiceLineArray.length;
            int n4 = 0;
            while (n4 < n3) {
                MInvoiceLine iLine = mInvoiceLineArray[n4];
                MEstimationLine estLine = new MEstimationLine(estimation);
                PO.copyValues((PO)iLine, (PO)estLine);
                estLine.setDateInvoiced(billLine.getDateInvoiced());
                if (invoice.getDateOrdered() == null) {
                    estLine.setDateOrdered(estimation.getDateOrdered());
                } else {
                    estLine.setDateOrdered(invoice.getDateOrdered());
                }
                if (iLine.getC_OrderLine_ID() > 0) {
                    estLine.setDatePromised(iLine.getC_OrderLine().getDatePromised());
                    estLine.setLink_OrderLine_ID(iLine.getC_OrderLine_ID());
                } else {
                    estLine.setDatePromised(estimation.getDatePromised());
                }
                if (iLine.getM_InOutLine_ID() > 0) {
                    estLine.setDateDelivered(iLine.getM_InOutLine().getM_InOut().getMovementDate());
                    String inOutDocInfo = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"M_InOut_ID", (boolean)true)) + " : " + iLine.getM_InOutLine().getM_InOut().getDocumentNo() + " - " + Msg.getElement((Properties)this.getCtx(), (String)"Line") + " : " + iLine.getM_InOutLine().getLine();
                    if (Util.isEmpty((String)estLine.getDescription())) {
                        estLine.setDescription(inOutDocInfo);
                    } else {
                        estLine.setDescription(String.valueOf(estLine.getDescription()) + " " + inOutDocInfo);
                    }
                }
                estLine.setM_Warehouse_ID(estimation.getM_Warehouse_ID());
                estLine.setQtyEntered(iLine.getQtyEntered());
                estLine.setQtyOrdered(iLine.getQtyInvoiced());
                estLine.setQtyDelivered(Env.ZERO);
                estLine.setQtyInvoiced(Env.ZERO);
                estLine.setQtyReserved(Env.ZERO);
                estLine.setFreightAmt(Env.ZERO);
                estLine.setQtyLostSales(Env.ZERO);
                estLine.setPriceEntered(iLine.getPriceEntered());
                estLine.setPriceList(iLine.getPriceList());
                estLine.setPriceActual(iLine.getPriceActual());
                estLine.setPriceLimit(iLine.getPriceLimit());
                estLine.setLineNetAmt(iLine.getLineNetAmt());
                estLine.setC_Charge_ID(iLine.getC_Charge_ID());
                estLine.setC_Tax_ID(iLine.getC_Tax_ID());
                estLine.setLine(++lineCounter * 10);
                estLine.saveEx(this.get_TrxName());
                ++n4;
            }
            ++n2;
        }
    }
}

