/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CreateBankStatementFromPaymentBatch
extends SvrProcess {
    private int C_PaymentBatch_ID = 0;
    private String p_DocAction = null;
    private Timestamp p_StatementDate = null;

    protected void prepare() {
        this.C_PaymentBatch_ID = this.getProcessInfo().getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("StatementDate")) {
                    this.p_StatementDate = para[i].getParameterAsTimestamp();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MBankStatement bankStatement;
        StringBuilder sql;
        ResultSet rs;
        CPreparedStatement pstmt;
        int count;
        MPaymentBatch paymentBatch;
        block12: {
            if (this.p_StatementDate == null) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"StatementDate");
            }
            paymentBatch = new MPaymentBatch(this.getCtx(), this.C_PaymentBatch_ID, this.get_TrxName());
            if (paymentBatch.get_ColumnIndex("JP_BankStatement_ID") != -1 && paymentBatch.get_ValueAsInt("JP_BankStatement_ID") > 0) {
                return Msg.getMsg((Properties)this.getCtx(), (String)"JP_PaymentBatchWrittenBS");
            }
            count = 0;
            pstmt = null;
            rs = null;
            sql = new StringBuilder("SELECT p.C_Payment_ID, p.C_BankAccount_ID, p.PayAmt").append(" FROM C_Payment p").append(" WHERE p.C_PaymentBatch_ID = ? AND p.IsReconciled = 'N' ").append(" ORDER BY p.DocumentNo").append(";");
            boolean isHeaderExists = false;
            int C_BankAccount_ID = 0;
            bankStatement = null;
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setInt(1, this.C_PaymentBatch_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(3).compareTo(Env.ZERO) == 0) continue;
                if (!isHeaderExists) {
                    C_BankAccount_ID = rs.getInt(2);
                    bankStatement = new MBankStatement(this.getCtx(), 0, this.get_TrxName());
                    MBankAccount bankAccount = MBankAccount.get((Properties)this.getCtx(), (int)C_BankAccount_ID);
                    bankStatement.setC_BankAccount_ID(bankAccount.getC_BankAccount_ID());
                    bankStatement.setBeginningBalance(bankAccount.getCurrentBalance());
                    bankStatement.setAD_Org_ID(paymentBatch.getAD_Org_ID());
                    bankStatement.setDocAction("CO");
                    bankStatement.setDocStatus("DR");
                    bankStatement.setStatementDate(this.p_StatementDate);
                    bankStatement.setDateAcct(this.p_StatementDate);
                    bankStatement.setName(String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_PaymentBatch_ID")) + " : " + paymentBatch.getDocumentNo());
                    bankStatement.setIsManual(false);
                    bankStatement.saveEx(this.get_TrxName());
                    isHeaderExists = true;
                } else if (C_BankAccount_ID != rs.getInt(2)) {
                    this.log.log(Level.SEVERE, "Illigal Bank Account : " + rs.getInt(2));
                    continue;
                }
                MPayment payment = new MPayment(this.getCtx(), rs.getInt(1), this.get_TrxName());
                MBankStatementLine bankStatementLine = new MBankStatementLine(bankStatement);
                bankStatementLine.setStatementLineDate(this.p_StatementDate);
                bankStatementLine.setPayment(payment);
                bankStatementLine.saveEx(this.get_TrxName());
                ++count;
            }
            if (count != 0) break block12;
            String string = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NoPaymentNeedToWriteBS");
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        try {
            try {
                bankStatement.processIt(this.p_DocAction);
                bankStatement.saveEx(this.get_TrxName());
                this.addBufferLog(0, null, null, bankStatement.getDocumentInfo(), bankStatement.get_Table_ID(), bankStatement.getC_BankStatement_ID());
                if (paymentBatch.get_ColumnIndex("JP_BankStatement_ID") != -1) {
                    paymentBatch.set_ValueNoCheck("JP_BankStatement_ID", (Object)bankStatement.getC_BankStatement_ID());
                    paymentBatch.saveEx(this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"JP_RegistrationQty")) + " : " + String.valueOf(count);
    }
}

