/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class CollateMigrationDataWithMD
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private Timestamp p_DateDoc_From = null;
    private Timestamp p_DateDoc_To = null;
    private boolean p_IsNonCollationOnly = true;
    private IProcessUI processMonitor = null;
    private String message = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateDoc")) {
                this.p_DateDoc_From = para[i].getParameterAsTimestamp();
                this.p_DateDoc_To = para[i].getParameter_ToAsTimestamp();
            } else if (name.equals("IsNonCollationOnlyJP")) {
                this.p_IsNonCollationOnly = para[i].getParameterAsBoolean();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Invoice_DocumentNo");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        StringBuilder sql = new StringBuilder("UPDATE JP_DataMigrationLine i ").append("SET JP_DataMigration_Invoice_ID=(SELECT MAX(JP_DataMigration_ID) FROM JP_DataMigration p").append(" WHERE i.JP_Invoice_DocumentNo=p.DocumentNo AND i.AD_Client_ID=p.AD_Client_ID) ").append(" FROM JP_DataMigration dm ").append(" WHERE i.JP_DataMigration_ID = dm.JP_DataMigration_ID AND dm.DateDoc >= ? AND dm.DateDoc <= ? AND i.AD_Client_ID=? AND i.JP_Invoice_DocumentNo IS NOT NULL ");
        if (this.p_IsNonCollationOnly) {
            sql.append(" AND i.JP_DataMigration_Invoice_ID IS NULL ");
        }
        CPreparedStatement pstmt = null;
        Object rs = null;
        int no = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setTimestamp(1, this.p_DateDoc_From);
                pstmt.setTimestamp(2, this.p_DateDoc_To);
                pstmt.setInt(3, this.p_AD_Client_ID);
                no = pstmt.executeUpdate();
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + e.toString() + " : " + sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Payment_DocumentNo");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        sql = new StringBuilder("UPDATE JP_DataMigrationLine i ").append("SET JP_DataMigration_Payment_ID=(SELECT MAX(JP_DataMigration_ID) FROM JP_DataMigration p").append(" WHERE i.JP_Payment_DocumentNo=p.DocumentNo AND i.AD_Client_ID=p.AD_Client_ID) ").append(" FROM JP_DataMigration dm ").append(" WHERE i.JP_DataMigration_ID = dm.JP_DataMigration_ID AND dm.DateDoc >= ? AND dm.DateDoc <= ? AND i.AD_Client_ID=? AND i.JP_Payment_DocumentNo IS NOT NULL ");
        if (this.p_IsNonCollationOnly) {
            sql.append(" AND i.JP_DataMigration_Payment_ID IS NULL ");
        }
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                pstmt.setTimestamp(1, this.p_DateDoc_From);
                pstmt.setTimestamp(2, this.p_DateDoc_To);
                pstmt.setInt(3, this.p_AD_Client_ID);
                no += pstmt.executeUpdate();
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + e.toString() + " : " + sql);
            }
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Success")) + " " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords") + " : " + no;
    }
}

