/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBankData;
import jpiere.base.plugin.org.adempiere.model.MBankDataSchema;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class CallBankDataImport
extends SvrProcess {
    MBankDataSchema m_BankDataSchema = null;
    MBankData m_BankData = null;
    int Record_ID = 0;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            this.m_BankData = new MBankData(this.getCtx(), this.Record_ID, null);
            this.m_BankDataSchema = new MBankDataSchema(this.getCtx(), this.m_BankData.getJP_BankDataSchema_ID(), null);
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    protected String doIt() throws Exception {
        block10: {
            ProcessInfo pi = new ProcessInfo("Title", 0, this.getTable_ID(), this.Record_ID);
            if (Util.isEmpty((String)this.m_BankDataSchema.getJP_BankDataImportClass())) {
                pi.setClassName("jpiere.base.plugin.org.adempiere.process.DefaultBankDataImport");
            } else {
                pi.setClassName(this.m_BankDataSchema.getJP_BankDataImportClass());
            }
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
            pi.setParameter(this.getParameter());
            boolean isOK = ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)Env.getProcessUI((Properties)this.getCtx()));
            if (isOK) {
                this.m_BankData.setJP_Processing1("Y");
                this.m_BankData.setJP_ProcessedTime1(new Timestamp(System.currentTimeMillis()));
                String sql = "SELECT SUM(StmtAmt), SUM(TrxAmt), SUM(ChargeAmt), SUM(InterestAmt) From JP_BankDataLine WHERE JP_BankData_ID = ?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.m_BankData.getJP_BankData_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_BankData.setStmtAmt(rs.getBigDecimal(1));
                            this.m_BankData.setTrxAmt(rs.getBigDecimal(2));
                            this.m_BankData.setChargeAmt(rs.getBigDecimal(3));
                            this.m_BankData.setInterestAmt(rs.getBigDecimal(4));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            } else {
                throw new AdempiereException(pi.getSummary());
            }
        }
        this.m_BankData.saveEx(this.get_TrxName());
        return "";
    }
}

