/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContract;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractCalenderList;
import jpiere.base.plugin.org.adempiere.model.MContractCalenderRef;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractContentT;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractLineT;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcessList;
import jpiere.base.plugin.org.adempiere.model.MContractProcessRef;
import jpiere.base.plugin.org.adempiere.model.MContractT;
import org.compiere.model.MOrgInfo;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public abstract class AbstractCreateContractFromTemplate
extends SvrProcess {
    protected MContract m_Contract = null;
    protected MContractContent m_ContractContent = null;
    protected MContractT m_ContractTemplate = null;
    protected MContractContentT[] m_ContractContentTemplates = null;
    protected String p_JP_ContractTabLevel = null;
    protected static final String JP_ContractTabLevel_Document = "CD";
    protected static final String JP_ContractTabLevel_Content = "CC";
    int Record_ID = 0;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            ProcessInfoParameter[] para = this.getParameter();
            int i = 0;
            while (i < para.length) {
                String name = para[i].getParameterName();
                if (para[i].getParameter() != null) {
                    if (name.equals("JP_ContractTabLevel")) {
                        this.p_JP_ContractTabLevel = para[i].getParameterAsString();
                    } else {
                        this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                    }
                }
                ++i;
            }
            if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Document)) {
                this.m_Contract = new MContract(this.getCtx(), this.Record_ID, this.get_TrxName());
                this.m_ContractTemplate = new MContractT(this.getCtx(), this.m_Contract.getJP_ContractT_ID(), this.get_TrxName());
                this.m_ContractContentTemplates = this.m_ContractTemplate.getContractContentTemplates();
            } else if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Content)) {
                this.m_ContractContent = new MContractContent(this.getCtx(), this.Record_ID, this.get_TrxName());
                this.m_Contract = this.m_ContractContent.getParent();
            }
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    protected String doIt() throws Exception {
        if (this.m_Contract.getJP_ContractType().equals("GLC")) {
            throw new Exception("JP_GeneralContractContent");
        }
        if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Document)) {
            this.createContractContent();
        } else if (this.p_JP_ContractTabLevel.equals(JP_ContractTabLevel_Content)) {
            this.createContractLine(this.m_ContractContent, MContractContentT.get(this.getCtx(), this.m_ContractContent.getJP_ContractContentT_ID()));
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    protected void createContractContent() throws Exception {
        MContractContent[] m_ContractContents = this.m_Contract.getContractContents();
        if (m_ContractContents.length > 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractContentCreated"));
        }
        int i = 0;
        while (i < this.m_ContractContentTemplates.length) {
            MContractProcPeriod period;
            MContractCalender calender;
            MContractProcessRef contractProcessRef;
            MContractProcessList[] contractProcessLists;
            int JP_ContractProcessRef_ID;
            MContractCalenderRef contractCalenderRef;
            MContractCalenderList[] contractCalenderLists;
            MContractContent contractContent = new MContractContent(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)this.m_ContractContentTemplates[i], (PO)contractContent);
            contractContent.setAD_Org_ID(this.m_Contract.getAD_Org_ID());
            contractContent.setAD_OrgTrx_ID(this.m_Contract.getAD_OrgTrx_ID());
            contractContent.setJP_Contract_ID(this.m_Contract.get_ID());
            contractContent.setJP_ContractContentT_ID(this.m_ContractContentTemplates[i].get_ID());
            contractContent.setJP_Contract_Acct_ID(this.m_ContractContentTemplates[i].getJP_Contract_Acct_ID());
            contractContent.setDateDoc(this.m_Contract.getDateDoc());
            contractContent.setDateAcct(this.m_Contract.getDateAcct());
            LocalDateTime datePromisedLocal = this.m_Contract.getDateAcct().toLocalDateTime();
            datePromisedLocal = datePromisedLocal.plusDays(this.m_ContractContentTemplates[i].getDeliveryTime_Promised());
            contractContent.setDatePromised(Timestamp.valueOf(datePromisedLocal));
            contractContent.setDateInvoiced(this.m_Contract.getDateAcct());
            int JP_ContractCalenderRef_ID = this.m_ContractContentTemplates[i].getJP_ContractCalenderRef_ID();
            if (JP_ContractCalenderRef_ID > 0 && (contractCalenderLists = (contractCalenderRef = MContractCalenderRef.get(this.getCtx(), JP_ContractCalenderRef_ID)).getContractCalenderList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contractContent.setJP_ContractCalender_ID(contractCalenderLists[0].getJP_ContractCalender_ID());
            }
            if ((JP_ContractProcessRef_ID = this.m_ContractContentTemplates[i].getJP_ContractProcessRef_ID()) > 0 && (contractProcessLists = (contractProcessRef = MContractProcessRef.get(this.getCtx(), JP_ContractProcessRef_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contractContent.setJP_ContractProcess_ID(contractProcessLists[0].getJP_ContractProcess_ID());
            }
            if (this.m_ContractContentTemplates[i].getJP_ContractProcPOffset() == 0) {
                contractContent.setJP_ContractProcDate_From(this.m_Contract.getJP_ContractPeriodDate_From());
            } else if (contractContent.getJP_ContractCalender_ID() > 0) {
                calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), this.m_Contract.getJP_ContractPeriodDate_From(), null, this.m_ContractContentTemplates[i].getJP_ContractProcPOffset());
                contractContent.setJP_ContractProcDate_From(period.getStartDate());
            }
            if (this.m_ContractContentTemplates[i].getJP_ContractProcPeriodNum() == 0) {
                contractContent.setJP_ContractProcDate_To(this.m_Contract.getJP_ContractPeriodDate_To());
            } else if (contractContent.getJP_ContractCalender_ID() > 0) {
                calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
                period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, this.m_ContractContentTemplates[i].getJP_ContractProcPeriodNum());
                if (this.m_Contract.getJP_ContractPeriodDate_To() == null) {
                    contractContent.setJP_ContractProcDate_To(period.getEndDate());
                } else if (this.m_Contract.getJP_ContractPeriodDate_To().compareTo(period.getEndDate()) >= 0) {
                    contractContent.setJP_ContractProcDate_To(period.getEndDate());
                } else {
                    contractContent.setJP_ContractProcDate_To(this.m_Contract.getJP_ContractPeriodDate_To());
                }
            }
            if (this.m_ContractContentTemplates[i].getC_BPartner_ID() == 0) {
                contractContent.setC_BPartner_ID(this.m_Contract.getC_BPartner_ID());
                contractContent.setC_BPartner_Location_ID(this.m_Contract.getC_BPartner_Location_ID());
                contractContent.setAD_User_ID(this.m_Contract.getAD_User_ID());
            }
            contractContent.setTotalLines(Env.ZERO);
            contractContent.setDocStatus("DR");
            contractContent.setDocAction("CO");
            contractContent.setJP_ContractProcStatus("UN");
            if (contractContent.getM_Warehouse_ID() == 0) {
                contractContent.setM_Warehouse_ID(MOrgInfo.get(null, (int)contractContent.getAD_Org_ID(), (String)this.get_TrxName()).getM_Warehouse_ID());
            }
            contractContent.setC_Currency_ID(contractContent.getM_PriceList().getC_Currency_ID());
            contractContent.saveEx(this.get_TrxName());
            this.createContractLine(contractContent, this.m_ContractContentTemplates[i]);
            ++i;
        }
    }

    protected void createContractLine(MContractContent contractContent, MContractContentT template) throws Exception {
        MContractLine[] m_ContractLine = contractContent.getLines();
        if (m_ContractLine.length > 0) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ContractContentLineCreated"));
        }
        MContractLineT[] m_ContractLineTemplates = template.getContractLineTemplates();
        int i = 0;
        while (i < m_ContractLineTemplates.length) {
            MContractProcessRef contractProcessRef;
            MContractProcessList[] contractProcessLists;
            int JP_ContractProcRef_Inv_ID;
            MContractProcessRef contractProcessRef2;
            MContractProcessList[] contractProcessLists2;
            int JP_ContractProcRef_InOut_ID;
            MContractCalenderRef contractCalenderRef;
            MContractCalenderList[] contractCalenderLists;
            int JP_ContractCalRef_Inv_ID;
            MContractCalenderRef contractCalenderRef2;
            MContractCalenderList[] contractCalenderLists2;
            int JP_ContractCalRef_InOut_ID;
            MContractLine contrctLine = new MContractLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)m_ContractLineTemplates[i], (PO)contrctLine);
            contrctLine.setAD_Org_ID(contractContent.getAD_Org_ID());
            contrctLine.setAD_OrgTrx_ID(contractContent.getAD_OrgTrx_ID());
            contrctLine.setDateOrdered(contractContent.getDateOrdered());
            LocalDateTime datePromisedLocal = contractContent.getDateAcct().toLocalDateTime();
            datePromisedLocal = datePromisedLocal.plusDays(m_ContractLineTemplates[i].getDeliveryTime_Promised());
            contrctLine.setDatePromised(Timestamp.valueOf(datePromisedLocal));
            contrctLine.setDatePromised(contractContent.getDatePromised());
            contrctLine.setJP_ContractContent_ID(contractContent.getJP_ContractContent_ID());
            contrctLine.setJP_ContractLineT_ID(m_ContractLineTemplates[i].getJP_ContractLineT_ID());
            if (contrctLine.getJP_BaseDocLinePolicy() != null) {
                MContractProcPeriod period;
                MContractCalender calender;
                int processPeriodOffset;
                MContractLineT lineTemplate;
                if (contrctLine.getJP_BaseDocLinePolicy().equals("LP")) {
                    lineTemplate = MContractLineT.get(this.getCtx(), contrctLine.getJP_ContractLineT_ID());
                    processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Lump();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_Lump_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
                if (contrctLine.getJP_BaseDocLinePolicy().equals("PS") || contrctLine.getJP_BaseDocLinePolicy().equals("PB")) {
                    lineTemplate = MContractLineT.get(this.getCtx(), contrctLine.getJP_ContractLineT_ID());
                    processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Start();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_Start_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
                if (contrctLine.getJP_BaseDocLinePolicy().equals("PE") || contrctLine.getJP_BaseDocLinePolicy().equals("PB")) {
                    lineTemplate = MContractLineT.get(this.getCtx(), contrctLine.getJP_ContractLineT_ID());
                    processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_End();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contractContent.getJP_ContractCalender_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_End_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
            }
            if ((JP_ContractCalRef_InOut_ID = m_ContractLineTemplates[i].getJP_ContractCalRef_InOut_ID()) > 0 && !Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && (contractCalenderLists2 = (contractCalenderRef2 = MContractCalenderRef.get(this.getCtx(), JP_ContractCalRef_InOut_ID)).getContractCalenderList(this.getCtx(), true, this.get_TrxName())).length == 1 && (contractContent.getJP_CreateDerivativeDocPolicy().equals("IO") || contractContent.getJP_CreateDerivativeDocPolicy().equals("BT"))) {
                MContractProcPeriod period;
                MContractCalender calender;
                int processPeriodOffset;
                contrctLine.setJP_ContractCalender_InOut_ID(contractCalenderLists2[0].getJP_ContractCalender_ID());
                MContractLineT lineTemplate = MContractLineT.get(this.getCtx(), m_ContractLineTemplates[i].getJP_ContractLineT_ID());
                if (contrctLine.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
                    processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Lump_InOut();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contrctLine.getJP_ContractCalender_InOut_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_Lump_InOut_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
                if (contrctLine.getJP_DerivativeDocPolicy_InOut().equals("PS") || contrctLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                    processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Start_InOut();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contrctLine.getJP_ContractCalender_InOut_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_Start_InOut_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
                if (contrctLine.getJP_DerivativeDocPolicy_InOut().equals("PE") || contrctLine.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
                    processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_End_InOut();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contrctLine.getJP_ContractCalender_InOut_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_End_InOut_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
            }
            if ((JP_ContractCalRef_Inv_ID = m_ContractLineTemplates[i].getJP_ContractCalRef_Inv_ID()) > 0 && !Util.isEmpty((String)contractContent.getJP_CreateDerivativeDocPolicy()) && (contractCalenderLists = (contractCalenderRef = MContractCalenderRef.get(this.getCtx(), JP_ContractCalRef_Inv_ID)).getContractCalenderList(this.getCtx(), true, this.get_TrxName())).length == 1 && (contractContent.getJP_CreateDerivativeDocPolicy().equals("IV") || contractContent.getJP_CreateDerivativeDocPolicy().equals("BT"))) {
                MContractProcPeriod period;
                MContractCalender calender;
                contrctLine.setJP_ContractCalender_Inv_ID(contractCalenderLists[0].getJP_ContractCalender_ID());
                MContractLineT lineTemplate = MContractLineT.get(this.getCtx(), m_ContractLineTemplates[i].getJP_ContractLineT_ID());
                if (contrctLine.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
                    int processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Lump_Inv();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contrctLine.getJP_ContractCalender_Inv_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_Lump_Inv_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
                if (contrctLine.getJP_DerivativeDocPolicy_Inv().equals("PS") || contrctLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                    int processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_Start_Inv();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contrctLine.getJP_ContractCalender_Inv_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_Start_Inv_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
                if (contrctLine.getJP_DerivativeDocPolicy_Inv().equals("PE") || contrctLine.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
                    int processPeriodOffset = lineTemplate.getJP_ProcPeriodOffs_End_Inv();
                    processPeriodOffset = processPeriodOffset > 0 ? ++processPeriodOffset : --processPeriodOffset;
                    calender = MContractCalender.get(this.getCtx(), contrctLine.getJP_ContractCalender_Inv_ID());
                    period = calender.getContractProcessPeriod(this.getCtx(), contractContent.getJP_ContractProcDate_From(), null, processPeriodOffset);
                    if (period != null) {
                        contrctLine.setJP_ProcPeriod_End_Inv_ID(period.getJP_ContractProcPeriod_ID());
                    }
                }
            }
            if ((JP_ContractProcRef_InOut_ID = m_ContractLineTemplates[i].getJP_ContractProcRef_InOut_ID()) > 0 && (contractProcessLists2 = (contractProcessRef2 = MContractProcessRef.get(this.getCtx(), JP_ContractProcRef_InOut_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contrctLine.setJP_ContractProcess_InOut_ID(contractProcessLists2[0].getJP_ContractProcess_ID());
            }
            if ((JP_ContractProcRef_Inv_ID = m_ContractLineTemplates[i].getJP_ContractProcRef_Inv_ID()) > 0 && (contractProcessLists = (contractProcessRef = MContractProcessRef.get(this.getCtx(), JP_ContractProcRef_Inv_ID)).getContractProcessList(this.getCtx(), true, this.get_TrxName())).length == 1) {
                contrctLine.setJP_ContractProcess_Inv_ID(contractProcessLists[0].getJP_ContractProcess_ID());
            }
            contrctLine.saveEx(this.get_TrxName());
            ++i;
        }
    }
}

