/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractCalender;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractLine;
import jpiere.base.plugin.org.adempiere.model.MContractLog;
import jpiere.base.plugin.org.adempiere.model.MContractLogDetail;
import jpiere.base.plugin.org.adempiere.model.MContractProcPeriod;
import jpiere.base.plugin.org.adempiere.model.MContractProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MColumn;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public abstract class AbstractContractProcess
extends SvrProcess {
    protected int Record_ID = 0;
    protected MContractContent m_ContractContent = null;
    protected MContractLog m_ContractLog = null;
    protected String p_JP_ContractProcessUnit = null;
    protected int p_JP_ContractCalender_ID = 0;
    protected int p_JP_ContractProcPeriodG_ID = 0;
    protected int p_JP_ContractProcPeriod_ID = 0;
    protected String p_JP_ContractProcessValue = null;
    protected Timestamp p_DateAcct = null;
    protected Timestamp p_DateDoc = null;
    protected Timestamp p_DateOrdered = null;
    protected Timestamp p_DatePromised = null;
    protected Timestamp p_DateInvoiced = null;
    protected String p_DocAction = null;
    protected int p_AD_Org_ID = 0;
    protected int p_JP_ContractCategory_ID = 0;
    protected int p_C_DocType_ID = 0;
    protected String p_DocBaseType = null;
    protected boolean p_IsCreateBaseDocJP = false;
    protected boolean p_IsRecordCommitJP = false;
    protected String p_JP_ContractProcessTraceLevel = null;
    protected int p_JP_ContractProcess_ID = 0;
    protected IProcessUI processUI = null;
    public static final String JP_ContractProcessUnit_ContractProcessPeriod = "CPP";
    public static final String JP_ContractProcessUnit_ContractProcessValueofContractProcessPeriod = "CPV";
    public static final String JP_ContractProcessUnit_AccountDate = "DAT";
    public static final String JP_ContractProcessUnit_DocumentDate = "DDT";
    public static final String JP_ContractProcessUnit_ContractProcessPeriodGroup = "GPP";
    public static final String JP_ContractProcessUnit_ContractProcessValueofContractProcessPeriodGroup = "GPV";
    public static final String JP_ContractProcessUnit_PerContractContent = "PCC";
    private int Reference_ContractLogMsg = 0;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            this.m_ContractContent = new MContractContent(this.getCtx(), this.Record_ID, this.get_TrxName());
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_ContractProcessUnit")) {
                    this.p_JP_ContractProcessUnit = para[i].getParameterAsString();
                } else if (name.equals("JP_ContractCalender_ID")) {
                    this.p_JP_ContractCalender_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractProcPeriodG_ID")) {
                    this.p_JP_ContractProcPeriodG_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractProcPeriod_ID")) {
                    this.p_JP_ContractProcPeriod_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractProcessValue")) {
                    this.p_JP_ContractProcessValue = para[i].getParameterAsString();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateDoc")) {
                    this.p_DateDoc = para[i].getParameterAsTimestamp();
                } else if (name.equals("DatePromised")) {
                    this.p_DatePromised = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateOrdered")) {
                    this.p_DateOrdered = para[i].getParameterAsTimestamp();
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced = para[i].getParameterAsTimestamp();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = para[i].getParameterAsString();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("JP_ContractCategory_ID")) {
                    this.p_JP_ContractCategory_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocBaseType")) {
                    this.p_DocBaseType = para[i].getParameterAsString();
                } else if (name.equals("IsCreateBaseDocJP")) {
                    this.p_IsCreateBaseDocJP = para[i].getParameterAsBoolean();
                } else if (name.equals("IsRecordCommitJP")) {
                    this.p_IsRecordCommitJP = para[i].getParameterAsBoolean();
                } else if (name.equals("JP_ContractProcessTraceLevel")) {
                    this.p_JP_ContractProcessTraceLevel = para[i].getParameterAsString();
                } else if (name.equals("JP_ContractLog")) {
                    this.m_ContractLog = (MContractLog)para[i].getParameter();
                } else if (name.equals("JP_ContractProcess_ID")) {
                    this.p_JP_ContractProcess_ID = para[i].getParameterAsInt();
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        return null;
    }

    protected Timestamp getDateDoc() {
        if (this.p_DateDoc != null) {
            return this.p_DateDoc;
        }
        if (this.p_JP_ContractProcPeriod_ID > 0) {
            return MContractProcPeriod.get(this.getCtx(), this.p_JP_ContractProcPeriod_ID).getDateDoc();
        }
        return this.m_ContractContent.getDateDoc();
    }

    protected Timestamp getDateAcct() {
        if (this.p_DateAcct != null) {
            return this.p_DateAcct;
        }
        if (this.p_JP_ContractProcPeriod_ID > 0) {
            return MContractProcPeriod.get(this.getCtx(), this.p_JP_ContractProcPeriod_ID).getDateAcct();
        }
        return this.m_ContractContent.getDateAcct();
    }

    protected Timestamp getDateOrdered() {
        if (this.p_DateOrdered != null) {
            return this.p_DateOrdered;
        }
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("STC") && this.p_JP_ContractProcessUnit.equals(JP_ContractProcessUnit_PerContractContent) && (this.m_ContractContent.getDocBaseType().equals("SOO") || this.m_ContractContent.getDocBaseType().equals("POO"))) {
            return this.m_ContractContent.getDateOrdered();
        }
        if (this.p_DateDoc != null) {
            return this.p_DateDoc;
        }
        if (this.p_JP_ContractProcPeriod_ID > 0) {
            return MContractProcPeriod.get(this.getCtx(), this.p_JP_ContractProcPeriod_ID).getDateDoc();
        }
        return this.m_ContractContent.getDateOrdered();
    }

    protected Timestamp getDateInvoiced() {
        if (this.p_DateInvoiced != null) {
            return this.p_DateInvoiced;
        }
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("STC") && this.p_JP_ContractProcessUnit.equals(JP_ContractProcessUnit_PerContractContent) && (this.m_ContractContent.getDocBaseType().equals("API") || this.m_ContractContent.getDocBaseType().equals("ARI"))) {
            return this.m_ContractContent.getDateInvoiced();
        }
        if (this.p_DateDoc != null) {
            return this.p_DateDoc;
        }
        if (this.p_JP_ContractProcPeriod_ID > 0) {
            return MContractProcPeriod.get(this.getCtx(), this.p_JP_ContractProcPeriod_ID).getDateDoc();
        }
        return this.m_ContractContent.getDateInvoiced();
    }

    protected Timestamp getOrderHeaderDatePromised(Timestamp dateFrom) {
        if (this.p_DatePromised != null) {
            return this.p_DatePromised;
        }
        if (dateFrom != null) {
            LocalDateTime dateAcctLocal = dateFrom.toLocalDateTime();
            dateAcctLocal = dateAcctLocal.plusDays(this.m_ContractContent.getDeliveryTime_Promised());
            return Timestamp.valueOf(dateAcctLocal);
        }
        if (this.getDateAcct() != null) {
            LocalDateTime dateAcctLocal = this.getDateAcct().toLocalDateTime();
            dateAcctLocal = dateAcctLocal.plusDays(this.m_ContractContent.getDeliveryTime_Promised());
            return Timestamp.valueOf(dateAcctLocal);
        }
        if (this.getDateDoc() != null) {
            LocalDateTime dateAcctLocal = this.getDateDoc().toLocalDateTime();
            dateAcctLocal = dateAcctLocal.plusDays(this.m_ContractContent.getDeliveryTime_Promised());
            return Timestamp.valueOf(dateAcctLocal);
        }
        return null;
    }

    protected Timestamp getOrderLineDatePromised(MContractLine m_Contractline) {
        if (this.m_ContractContent.getParent().getJP_ContractType().equals("STC") && this.p_JP_ContractProcessUnit.equals(JP_ContractProcessUnit_PerContractContent) && (this.m_ContractContent.getDocBaseType().equals("SOO") || this.m_ContractContent.getDocBaseType().equals("POO")) && m_Contractline != null && m_Contractline.getDatePromised() != null) {
            return m_Contractline.getDatePromised();
        }
        if (m_Contractline != null) {
            LocalDateTime dateAcctLocal = this.getDateAcct().toLocalDateTime();
            dateAcctLocal = dateAcctLocal.plusDays(m_Contractline.getDeliveryTime_Promised());
            return Timestamp.valueOf(dateAcctLocal);
        }
        if (this.p_DatePromised != null) {
            return this.p_DatePromised;
        }
        return null;
    }

    protected String getDocAction() {
        MContractProcess contractProcess;
        if (!Util.isEmpty((String)this.p_DocAction)) {
            return this.p_DocAction;
        }
        if (this.m_ContractContent.getJP_ContractProcess_ID() > 0 && !Util.isEmpty((String)(contractProcess = MContractProcess.get(this.getCtx(), this.m_ContractContent.getJP_ContractProcess_ID())).getDocAction())) {
            return contractProcess.getDocAction();
        }
        return null;
    }

    protected int getJP_ContractProctPeriod_ID() {
        if (this.p_JP_ContractProcPeriod_ID > 0) {
            return this.p_JP_ContractProcPeriod_ID;
        }
        if (this.p_JP_ContractCalender_ID > 0) {
            MContractCalender cal = MContractCalender.get(this.getCtx(), this.p_JP_ContractCalender_ID);
            MContractProcPeriod period = cal.getContractProcessPeriod(this.getCtx(), this.getDateAcct());
            return period.getJP_ContractProcPeriod_ID();
        }
        if ((this.p_DocBaseType.equals("SOO") || this.p_DocBaseType.equals("POO")) && this.m_ContractContent != null && this.m_ContractContent.getJP_ContractCalender_ID() > 0) {
            MContractCalender cal = MContractCalender.get(this.getCtx(), this.m_ContractContent.getJP_ContractCalender_ID());
            MContractProcPeriod period = cal.getContractProcessPeriod(this.getCtx(), this.getDateAcct());
            return period.getJP_ContractProcPeriod_ID();
        }
        return 0;
    }

    protected MContractProcPeriod getBaseDocContractProcPeriodFromDerivativeDocContractProcPeriod(int Derivative_ContractProcPeriod_ID) {
        MContractCalender calender = MContractCalender.get(this.getCtx(), this.m_ContractContent.getJP_ContractCalender_ID());
        if (calender == null) {
            return null;
        }
        MContractProcPeriod derivativeDocContractProcPeriod = MContractProcPeriod.get(this.getCtx(), Derivative_ContractProcPeriod_ID);
        if (derivativeDocContractProcPeriod == null) {
            return null;
        }
        return calender.getContractProcessPeriod(this.getCtx(), derivativeDocContractProcPeriod.getStartDate(), derivativeDocContractProcPeriod.getEndDate());
    }

    protected int getJP_ContractProcess_ID() {
        return this.p_JP_ContractProcess_ID;
    }

    protected void updateContractProcStatus() {
        if (this.p_IsCreateBaseDocJP && this.m_ContractContent.getJP_ContractProcStatus().equals("UN")) {
            this.m_ContractContent.setJP_ContractProcStatus("IP");
            this.m_ContractContent.saveEx(this.get_TrxName());
        }
    }

    protected void createContractLogDetail(String ContractLogMsg, MContractLine ContractLine, PO po, String descriptionMsg) {
        if (this.p_JP_ContractProcessTraceLevel.equals("NON")) {
            if (this.Reference_ContractLogMsg == 0) {
                MTable JP_ContractLogDetail = MTable.get((Properties)this.getCtx(), (String)"JP_ContractLogDetail");
                MColumn[] columns = JP_ContractLogDetail.getColumns(false);
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].getColumnName().equals("JP_ContractLogMsg")) {
                        int AD_Reference_Value_ID;
                        this.Reference_ContractLogMsg = AD_Reference_Value_ID = columns[i].getAD_Reference_Value_ID();
                        break;
                    }
                    ++i;
                }
            }
            String logMsg = MRefList.getListName((Properties)this.getCtx(), (int)this.Reference_ContractLogMsg, (String)ContractLogMsg);
            if (po != null) {
                if (po instanceof DocAction) {
                    DocAction doc = (DocAction)po;
                    this.addBufferLog(0, null, null, String.valueOf(logMsg) + " ---> " + Msg.getMsg((Properties)this.getCtx(), (String)"DocumentNo") + " : " + doc.getDocumentNo(), po.get_Table_ID(), po.get_ID());
                } else {
                    this.addBufferLog(0, null, null, logMsg, po.get_Table_ID(), po.get_ID());
                }
            } else if (Util.isEmpty((String)descriptionMsg)) {
                this.addLog(String.valueOf(logMsg) + " - " + ContractLine.toString());
            } else {
                this.addLog(String.valueOf(logMsg) + " - " + descriptionMsg);
            }
            return;
        }
        String TraceLevel = "FIN";
        if (ContractLogMsg.equals("A1")) {
            ++this.m_ContractLog.createDocNum;
            DocAction doc = (DocAction)po;
            this.addBufferLog(0, null, null, String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"DocumentNo")) + " : " + doc.getDocumentNo(), po.get_Table_ID(), po.get_ID());
            TraceLevel = "FIN";
            if (this.processUI != null) {
                this.processUI.statusUpdate(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_CreateDocNum")) + " : " + this.m_ContractLog.createDocNum);
            }
        } else if (ContractLogMsg.equals("B1") || ContractLogMsg.equals("B7")) {
            if (ContractLine == null) {
                ++this.m_ContractLog.confirmNum;
                ++this.m_ContractLog.skipContractContentNum;
            } else {
                ++this.m_ContractLog.confirmNum;
                ++this.m_ContractLog.skipContractLineNum;
            }
            TraceLevel = "TBC";
        } else if (ContractLogMsg.equals("B2")) {
            ++this.m_ContractLog.confirmNum;
            ++this.m_ContractLog.skipContractContentNum;
            TraceLevel = "TBC";
        } else if (ContractLogMsg.equals("B3") || ContractLogMsg.equals("B4") || ContractLogMsg.equals("B5") || ContractLogMsg.equals("B6") || ContractLogMsg.equals("B8") || ContractLogMsg.equals("B9")) {
            TraceLevel = "FIN";
        } else if (ContractLogMsg.equals("C1") || ContractLogMsg.equals("C2") || ContractLogMsg.equals("C3")) {
            TraceLevel = "FIN";
        } else if (ContractLogMsg.equals("W1")) {
            ++this.m_ContractLog.warnNum;
            TraceLevel = "WAR";
        } else if (ContractLogMsg.equals("W2")) {
            ++this.m_ContractLog.warnNum;
            TraceLevel = "WAR";
        } else if (ContractLogMsg.equals("W9")) {
            ++this.m_ContractLog.warnNum;
            TraceLevel = "WAR";
        } else if (ContractLogMsg.equals("Z1") || ContractLogMsg.equals("Z2") || ContractLogMsg.equals("ZZ")) {
            ++this.m_ContractLog.errorNum;
            TraceLevel = "ERR";
        }
        if (!this.p_JP_ContractProcessTraceLevel.equals("FIN") && (this.p_JP_ContractProcessTraceLevel.equals("TBC") ? TraceLevel.equals("FIN") : (this.p_JP_ContractProcessTraceLevel.equals("WAR") ? TraceLevel.equals("FIN") || TraceLevel.equals("TBC") : this.p_JP_ContractProcessTraceLevel.equals("ERR") && (TraceLevel.equals("FIN") || TraceLevel.equals("TBC") || TraceLevel.equals("WAR"))))) {
            return;
        }
        MContractLogDetail logDetail = new MContractLogDetail(this.getCtx(), 0, this.m_ContractLog.get_TrxName());
        logDetail.setJP_ContractLog_ID(this.m_ContractLog.getJP_ContractLog_ID());
        logDetail.setJP_ContractLogMsg(ContractLogMsg);
        if (descriptionMsg != null) {
            logDetail.setDescription(descriptionMsg);
        }
        logDetail.setJP_Contract_ID(this.m_ContractContent.getJP_Contract_ID());
        logDetail.setJP_ContractContent_ID(this.m_ContractContent.getJP_ContractContent_ID());
        if (ContractLine != null) {
            logDetail.setJP_ContractLine_ID(ContractLine.getJP_ContractLine_ID());
        }
        logDetail.setJP_ContractProcPeriod_ID(this.getJP_ContractProctPeriod_ID());
        logDetail.setJP_ContractProcess_ID(this.getJP_ContractProcess_ID());
        logDetail.setJP_ContractProcessTraceLevel(TraceLevel);
        if (po == null) {
            logDetail.saveEx(this.m_ContractLog.get_TrxName());
            return;
        }
        logDetail.set_ValueNoCheck("AD_Table_ID", po.get_Table_ID());
        logDetail.set_ValueNoCheck("Record_ID", po.get_ID());
        if (po.get_TableName().equals("C_Order")) {
            MOrder order = (MOrder)po;
            logDetail.setC_Order_ID(order.getC_Order_ID());
        } else if (po.get_TableName().equals("C_OrderLine")) {
            MOrderLine orderLine = (MOrderLine)po;
            logDetail.setC_Order_ID(orderLine.getC_Order_ID());
            logDetail.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
        } else if (po.get_TableName().equals("M_InOut")) {
            MInOut inout = (MInOut)po;
            logDetail.setC_Order_ID(inout.getC_Order_ID());
            logDetail.setM_InOut_ID(inout.getM_InOut_ID());
        } else if (po.get_TableName().equals("M_InOutLine")) {
            MInOutLine ioLine = (MInOutLine)po;
            logDetail.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
            logDetail.setM_InOut_ID(ioLine.getM_InOut_ID());
            logDetail.setM_InOutLine_ID(ioLine.getM_InOutLine_ID());
        } else if (po.get_TableName().equals("C_Invoice")) {
            MInvoice invoice = (MInvoice)po;
            logDetail.setC_Order_ID(invoice.getC_Order_ID());
            logDetail.setC_Invoice_ID(invoice.getC_Invoice_ID());
        } else if (po.get_TableName().equals("C_InvoiceLine")) {
            MInvoiceLine invoiceLine = (MInvoiceLine)po;
            logDetail.setC_OrderLine_ID(invoiceLine.getC_OrderLine_ID());
            logDetail.setC_Invoice_ID(invoiceLine.getC_Invoice_ID());
            logDetail.setC_InvoiceLine_ID(invoiceLine.getC_Invoice_ID());
        }
        logDetail.saveEx(this.m_ContractLog.get_TrxName());
    }
}

