/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_RecognitionTax;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRecognitionTax
extends X_JP_RecognitionTax {
    private static final long serialVersionUID = -5560880305482497098L;
    private static CLogger s_log = CLogger.getCLogger(MRecognitionTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MRecognitionTax get(MRecognitionLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MRecognitionTax retValue = null;
        if (line == null || line.getJP_Recognition_ID() == 0) {
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            if (!line.isDescription()) {
                s_log.warning("C_Tax_ID=0");
            }
            return null;
        }
        retValue = (MRecognitionTax)new Query(line.getCtx(), "JP_RecognitionTax", "JP_Recognition_ID=? AND C_Tax_ID=?", trxName).setParameters(new Object[]{line.getJP_Recognition_ID(), C_Tax_ID}).firstOnly();
        if (retValue != null) {
            retValue.set_TrxName(trxName);
            retValue.setPrecision(precision);
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("(old=" + oldTax + ") " + retValue);
            }
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MRecognitionTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setJP_Recognition_ID(line.getJP_Recognition_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("(new) " + retValue);
        }
        return retValue;
    }

    public MRecognitionTax(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MRecognitionTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = new Integer(precision);
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get((Properties)this.getCtx(), (int)this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        boolean documentLevel = this.getTax().isDocumentLevel();
        MTax tax = this.getTax();
        String sql = "SELECT il.LineNetAmt, COALESCE(il.TaxAmt,0), i.IsSOTrx FROM JP_RecognitionLine il INNER JOIN JP_Recognition i ON (il.JP_Recognition_ID=i.JP_Recognition_ID) WHERE il.JP_Recognition_ID=? AND il.C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getJP_Recognition_ID());
                pstmt.setInt(2, this.getC_Tax_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal baseAmt = rs.getBigDecimal(1);
                    taxBaseAmt = taxBaseAmt.add(baseAmt);
                    BigDecimal amt = rs.getBigDecimal(2);
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    boolean isSOTrx = "Y".equals(rs.getString(3));
                    if (documentLevel || amt.signum() == 0 || isSOTrx) {
                        amt = documentLevel || baseAmt.signum() == 0 ? Env.ZERO : tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision());
                    }
                    taxAmt = taxAmt.add(amt);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (documentLevel || taxAmt.signum() == 0) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecognitionTax[");
        sb.append("JP_Recognition_ID=").append(this.getJP_Recognition_ID()).append(",C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(",Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

