/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionTax;
import jpiere.base.plugin.org.adempiere.model.X_JP_RecognitionLine;
import jpiere.base.plugin.util.JPiereUtil;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRMALine;
import org.compiere.model.MRole;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRecognitionLine
extends X_JP_RecognitionLine {
    private static final long serialVersionUID = -6174490999732876285L;
    private static CLogger s_log = CLogger.getCLogger(MRecognitionLine.class);
    private MTax m_tax = null;
    private static CCache<Integer, MRecognitionLine> s_cache = new CCache("JP_RecognitionLine", 20);
    private int m_M_PriceList_ID = 0;
    private Timestamp m_DateInvoiced = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_BPartner_Location_ID = 0;
    private boolean m_IsSOTrx = true;
    private boolean m_priceSet = false;
    private MProduct m_product = null;
    private MCharge m_charge = null;
    private String m_name = null;
    private Integer m_precision = null;
    private MProductPricing m_productPricing = null;
    private MRecognition m_parent = null;

    public static MRecognitionLine getOfInOutLine(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        String whereClause = "M_InOutLine_ID=?";
        List list = new Query(sLine.getCtx(), "JP_RecognitionLine", "M_InOutLine_ID=?", sLine.get_TrxName()).setParameters(new Object[]{sLine.getM_InOutLine_ID()}).list();
        MRecognitionLine retValue = null;
        if (list.size() > 0) {
            retValue = (MRecognitionLine)list.get(0);
            if (list.size() > 1) {
                s_log.warning("More than one C_InvoiceLine of " + sLine);
            }
        }
        return retValue;
    }

    public static MRecognitionLine getOfInOutLineFromMatchInv(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        String whereClause = "C_InvoiceLine_ID IN (SELECT C_InvoiceLine_ID FROM M_MatchInv WHERE M_InOutLine_ID=?)";
        List list = new Query(sLine.getCtx(), "JP_RecognitionLine", "C_InvoiceLine_ID IN (SELECT C_InvoiceLine_ID FROM M_MatchInv WHERE M_InOutLine_ID=?)", sLine.get_TrxName()).setParameters(new Object[]{sLine.getM_InOutLine_ID()}).list();
        MRecognitionLine retValue = null;
        if (list.size() > 0) {
            retValue = (MRecognitionLine)list.get(0);
            if (list.size() > 1) {
                s_log.warning("More than one C_InvoiceLine of " + sLine);
            }
        }
        return retValue;
    }

    public MRecognitionLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        super(ctx, C_InvoiceLine_ID, trxName);
        if (C_InvoiceLine_ID == 0) {
            this.setIsDescription(false);
            this.setIsPrinted(true);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setTaxAmt(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.setQtyInvoiced(Env.ZERO);
        }
    }

    public MRecognitionLine(MRecognition recognition) {
        this(recognition.getCtx(), 0, recognition.get_TrxName());
        if (recognition.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(recognition.getAD_Client_ID(), recognition.getAD_Org_ID());
        this.setJP_Recognition_ID(recognition.getJP_Recognition_ID());
        this.setRecognition(recognition);
    }

    public MRecognitionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MRecognitionLine get(Properties ctx, int JP_RecognitionLine_ID) {
        Integer ii = new Integer(JP_RecognitionLine_ID);
        MRecognitionLine retValue = (MRecognitionLine)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MRecognitionLine(ctx, JP_RecognitionLine_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_RecognitionLine_ID, (Object)retValue);
        }
        return retValue;
    }

    public void setRecognition(MRecognition recognition) {
        this.m_parent = recognition;
        this.m_M_PriceList_ID = recognition.getM_PriceList_ID();
        this.m_DateInvoiced = recognition.getDateInvoiced();
        this.m_C_BPartner_ID = recognition.getC_BPartner_ID();
        this.m_C_BPartner_Location_ID = recognition.getC_BPartner_Location_ID();
        this.m_IsSOTrx = recognition.isSOTrx();
        this.m_precision = new Integer(recognition.getPrecision());
    }

    public MRecognition getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MRecognition(this.getCtx(), this.getJP_Recognition_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setIsDescription(oLine.isDescription());
        this.setDescription(oLine.getDescription());
        if (oLine.getM_Product_ID() == 0) {
            this.setC_Charge_ID(oLine.getC_Charge_ID());
        }
        this.setM_Product_ID(oLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
        this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        this.setPriceEntered(oLine.getPriceEntered());
        this.setPriceActual(oLine.getPriceActual());
        this.setPriceLimit(oLine.getPriceLimit());
        this.setPriceList(oLine.getPriceList());
        this.setC_Tax_ID(oLine.getC_Tax_ID());
        this.setLineNetAmt(oLine.getLineNetAmt());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
    }

    public void setRecogLine(MInOutLine sLine) {
        int C_OrderLine_ID;
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        this.setM_RMALine_ID(sLine.getM_RMALine_ID());
        this.setLine(sLine.getLine());
        this.setIsDescription(sLine.isDescription());
        this.setDescription(sLine.getDescription());
        this.setM_Product_ID(sLine.getM_Product_ID());
        if (sLine.sameOrderLineUOM() || this.getProduct() == null) {
            this.setC_UOM_ID(sLine.getC_UOM_ID());
        } else {
            this.setC_UOM_ID(this.getProduct().getC_UOM_ID());
        }
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        if (this.getM_Product_ID() == 0) {
            this.setC_Charge_ID(sLine.getC_Charge_ID());
        }
        if ((C_OrderLine_ID = sLine.getC_OrderLine_ID()) != 0) {
            MOrderLine oLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.get_TrxName());
            this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
            if (sLine.sameOrderLineUOM()) {
                this.setPriceEntered(oLine.getPriceEntered());
            } else {
                this.setPriceEntered(oLine.getPriceActual());
            }
            this.setPriceActual(oLine.getPriceActual());
            this.setPriceLimit(oLine.getPriceLimit());
            this.setPriceList(oLine.getPriceList());
            this.setC_Tax_ID(oLine.getC_Tax_ID());
            this.setLineNetAmt(oLine.getLineNetAmt());
            this.setC_Project_ID(oLine.getC_Project_ID());
        } else if (sLine.getM_RMALine_ID() != 0) {
            MRMALine rmaLine = new MRMALine(this.getCtx(), sLine.getM_RMALine_ID(), this.get_TrxName());
            this.setPrice();
            this.setPrice(rmaLine.getAmt());
            this.setC_Tax_ID(rmaLine.getC_Tax_ID());
            this.setLineNetAmt(rmaLine.getLineNetAmt());
        } else {
            this.setPrice();
            this.setTax();
        }
        this.setC_Project_ID(sLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(sLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(sLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(sLine.getC_Activity_ID());
        this.setC_Campaign_ID(sLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(sLine.getAD_OrgTrx_ID());
        this.setUser1_ID(sLine.getUser1_ID());
        this.setUser2_ID(sLine.getUser2_ID());
        this.setJP_ContractLine_ID(sLine.get_ValueAsInt("JP_ContractLine_ID"));
        this.setJP_ContractProcPeriod_ID(sLine.get_ValueAsInt("JP_ContractProcPeriod_ID"));
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", new Integer(0));
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            this.setRecognition(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            throw new IllegalStateException("setPrice - PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID, this.m_C_BPartner_ID);
    }

    public void setPrice(int M_PriceList_ID, int C_BPartner_ID) {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        }
        this.m_productPricing = new MProductPricing(this.getM_Product_ID(), C_BPartner_ID, this.getQtyInvoiced(), this.m_IsSOTrx);
        this.m_productPricing.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPricing.setPriceDate(this.m_DateInvoiced);
        this.setPriceActual(this.m_productPricing.getPriceStd());
        this.setPriceList(this.m_productPricing.getPriceList());
        this.setPriceLimit(this.m_productPricing.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyInvoiced()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyInvoiced().divide(this.getQtyEntered(), 6, 4)));
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPricing.getC_UOM_ID());
        }
        this.m_priceSet = true;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    @Override
    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public boolean setTax() {
        if (this.isDescription()) {
            return true;
        }
        int M_Warehouse_ID = Env.getContextAsInt((Properties)this.getCtx(), (String)"#M_Warehouse_ID");
        int C_Tax_ID = Tax.get((Properties)this.getCtx(), (int)this.getM_Product_ID(), (int)this.getC_Charge_ID(), (Timestamp)this.m_DateInvoiced, (Timestamp)this.m_DateInvoiced, (int)this.getAD_Org_ID(), (int)M_Warehouse_ID, (int)this.m_C_BPartner_Location_ID, (int)this.m_C_BPartner_Location_ID, (boolean)this.m_IsSOTrx, (String)this.get_TrxName());
        if (C_Tax_ID == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(C_Tax_ID);
        return true;
    }

    public void setTaxAmt() {
        BigDecimal TaxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        MTax tax = MTax.get((Properties)this.getCtx(), (int)this.getC_Tax_ID());
        if (tax.isDocumentLevel() && this.m_IsSOTrx) {
            return;
        }
        TaxAmt = tax.calculateTax(this.getLineNetAmt(), this.isTaxIncluded(), this.getPrecision());
        if (this.isTaxIncluded()) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(TaxAmt));
        }
        super.setTaxAmt(TaxAmt);
    }

    public void setLineNetAmt() {
        BigDecimal bd = this.getPriceActual().multiply(this.getQtyInvoiced());
        boolean documentLevel = this.getTax().isDocumentLevel();
        if (this.isTaxIncluded() && !documentLevel) {
            BigDecimal taxStdAmt = Env.ZERO;
            BigDecimal taxThisAmt = Env.ZERO;
            MTax invoiceTax = this.getTax();
            MTax stdTax = null;
            if (this.getProduct() == null) {
                if (this.getCharge() != null) {
                    stdTax = new MTax(this.getCtx(), ((MTaxCategory)this.getCharge().getC_TaxCategory()).getDefaultTax().getC_Tax_ID(), this.get_TrxName());
                }
            } else {
                stdTax = new MTax(this.getCtx(), ((MTaxCategory)this.getProduct().getC_TaxCategory()).getDefaultTax().getC_Tax_ID(), this.get_TrxName());
            }
            if (stdTax != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("stdTax rate is " + stdTax.getRate());
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("invoiceTax rate is " + invoiceTax.getRate());
                }
                taxThisAmt = taxThisAmt.add(invoiceTax.calculateTax(bd, this.isTaxIncluded(), this.getPrecision()));
                taxStdAmt = taxStdAmt.add(stdTax.calculateTax(bd, this.isTaxIncluded(), this.getPrecision()));
                bd = bd.subtract(taxStdAmt).add(taxThisAmt);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Price List includes Tax and Tax Changed on Invoice Line: New Tax Amt: " + taxThisAmt + " Standard Tax Amt: " + taxStdAmt + " Line Net Amt: " + bd);
                }
            }
        }
        int precision = this.getPrecision();
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, 4);
        }
        super.setLineNetAmt(bd);
    }

    public MCharge getCharge() {
        if (this.m_charge == null && this.getC_Charge_ID() != 0) {
            this.m_charge = MCharge.get((Properties)this.getCtx(), (int)this.getC_Charge_ID());
        }
        return this.m_charge;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get((Properties)this.getCtx(), (int)this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public void setQty(int Qty) {
        this.setQty(new BigDecimal(Qty));
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setQtyInvoiced(this.getQtyEntered());
        this.setJP_QtyRecognized(this.getQtyInvoiced());
        this.setJP_TargetQtyRecognized(this.getQtyInvoiced());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyInvoiced(BigDecimal QtyInvoiced) {
        MProduct product = this.getProduct();
        if (QtyInvoiced != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyInvoiced = QtyInvoiced.setScale(precision, 4);
        }
        super.setQtyInvoiced(QtyInvoiced);
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get((Properties)this.getCtx(), (int)M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    @Override
    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecotnitionLine[").append(this.get_ID()).append(",").append(this.getLine()).append(",QtyInvoiced=").append(this.getQtyInvoiced()).append(",LineNetAmt=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    public String getName() {
        block8: {
            if (this.m_name == null) {
                String sql = "SELECT COALESCE (p.Name, c.Name) FROM JP_RecognitionLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge C ON (il.C_Charge_ID=c.C_Charge_ID) WHERE JP_RecognitionLine_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.getJP_Recognition_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_name = rs.getString(1);
                        }
                        if (this.m_name == null) {
                            this.m_name = "??";
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getName", (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        return this.m_name;
    }

    public void setName(String tempName) {
        this.m_name = tempName;
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN JP_Recognition x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.JP_Recognition_ID=?";
        int i = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getJP_Recognition_ID());
        if (i < 0) {
            this.log.warning("getPrecision = " + i + " - set to 2");
            i = 2;
        }
        this.m_precision = new Integer(i);
        return this.m_precision;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_ID FROM JP_Recognition WHERE JP_Recognition_ID=?", (int)this.getJP_Recognition_ID());
        }
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)this.m_M_PriceList_ID, (String)this.get_TrxName());
        return pl.isTaxIncluded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean beforeSave(boolean newRecord) {
        ProcessInfo pInfo;
        int C_UOM_ID;
        block63: {
            BigDecimal targetQtyRecognized;
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            BigDecimal qtyRecognized;
            block64: {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("New=" + newRecord);
                }
                if (newRecord && this.getParent().isComplete()) {
                    this.log.saveError("ParentComplete", Msg.getMsg((Properties)this.getCtx(), (String)"JP_RecognitionLine_ID"));
                    return false;
                }
                if (!newRecord && !this.is_ValueChanged("QtyInvoiced") && !this.is_ValueChanged("QtyEntered") && !this.is_ValueChanged("M_InOutLine_ID")) break block63;
                this.setJP_QtyRecognized(this.getQtyInvoiced());
                if (!newRecord) break block64;
                if (this.getJP_RecogLine_SplitFrom_ID() <= 0 && this.getJP_TargetQtyRecognized().signum() == 0) {
                    if (this.getJP_TargetQtyRecognized().signum() == 0 && this.getM_InOutLine_ID() > 0) {
                        block60: {
                            qtyRecognized = Env.ZERO;
                            sql = "SELECT SUM(rl.QtyInvoiced) FROM JP_RecognitionLine rl INNER JOIN JP_Recognition r ON (rl.JP_Recognition_ID = r.JP_Recognition_ID) WHERE rl.M_InOutLine_ID=? AND r.DocStatus NOT IN ('VO','VE') ";
                            pstmt = null;
                            rs = null;
                            try {
                                try {
                                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                                    pstmt.setInt(1, this.getM_InOutLine_ID());
                                    rs = pstmt.executeQuery();
                                    if (rs.next()) {
                                        qtyRecognized = rs.getBigDecimal(1);
                                    }
                                }
                                catch (SQLException e) {
                                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                                    DB.close((ResultSet)rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                    break block60;
                                }
                            }
                            catch (Throwable throwable) {
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                throw throwable;
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        if (qtyRecognized == null) {
                            qtyRecognized = Env.ZERO;
                        }
                        targetQtyRecognized = this.getM_InOutLine().getMovementQty().subtract(qtyRecognized);
                        this.setJP_TargetQtyRecognized(targetQtyRecognized);
                        break block63;
                    } else {
                        this.setJP_TargetQtyRecognized(Env.ZERO);
                    }
                }
                break block63;
            }
            if (this.is_ValueChanged("M_InOutLine_ID") && this.getM_InOutLine_ID() > 0) {
                block62: {
                    qtyRecognized = Env.ZERO;
                    sql = "SELECT SUM(rl.QtyInvoiced) FROM JP_RecognitionLine rl INNER JOIN JP_Recognition r ON (rl.JP_Recognition_ID = r.JP_Recognition_ID) WHERE rl.M_InOutLine_ID=? AND r.DocStatus NOT IN ('VO','VE') ";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql.toString(), null);
                            pstmt.setInt(1, this.getM_InOutLine_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                qtyRecognized = rs.getBigDecimal(1);
                            }
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block62;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                targetQtyRecognized = this.getM_InOutLine().getMovementQty().subtract(qtyRecognized);
                this.setJP_TargetQtyRecognized(targetQtyRecognized);
            } else if (this.is_ValueChanged("M_InOutLine_ID") && this.getM_InOutLine_ID() == 0) {
                this.setQty(Env.ZERO);
            }
            if (this.getJP_TargetQtyRecognized().signum() != 0) {
                if (this.getJP_TargetQtyRecognized().signum() != this.getJP_QtyRecognized().signum()) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_TargetQtyRecognized"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_QtyRecognized")}));
                    return false;
                }
                if (this.getJP_QtyRecognized().abs().compareTo(this.getJP_TargetQtyRecognized().abs()) > 0) {
                    this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_TargetQtyRecognized"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_QtyRecognized")}));
                    return false;
                }
            }
        }
        this.setRecognition(this.getParent());
        if (this.getC_Charge_ID() != 0) {
            if (this.getM_Product_ID() != 0) {
                this.setM_Product_ID(0);
            }
        } else {
            boolean enforce;
            if (!this.m_priceSet && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            boolean bl = enforce = this.m_IsSOTrx && this.getParent().getM_PriceList().isEnforcePriceLimit();
            if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                enforce = false;
            }
            if (enforce && this.getPriceLimit() != Env.ZERO && this.getPriceActual().compareTo(this.getPriceLimit()) < 0) {
                this.log.saveError("UnderLimitPrice", "PriceEntered=" + this.getPriceEntered() + ", PriceLimit=" + this.getPriceLimit());
                return false;
            }
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM JP_RecognitionLine WHERE JP_Recognition_ID=?";
            int ii = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getJP_Recognition_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID((Properties)this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyInvoiced")) {
            this.setQtyInvoiced(this.getQtyInvoiced());
        }
        this.setLineNetAmt();
        if (this.m_IsSOTrx || this.getTaxAmt().compareTo(Env.ZERO) == 0) {
            this.setTaxAmt();
        }
        if (this.getParent().getC_DocTypeTarget().isChargeOrProductMandatory() && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0 && (this.getPriceEntered().signum() != 0 || this.getQtyEntered().signum() != 0)) {
            this.log.saveError("FillMandatory", Msg.translate((Properties)this.getCtx(), (String)"ChargeOrProductMandatory"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("LineNetAmt") || this.is_ValueChanged("C_Tax_ID")) {
            BigDecimal taxAmt = Env.ZERO;
            MTax m_tax = MTax.get((Properties)Env.getCtx(), (int)this.getC_Tax_ID());
            if (m_tax != null) {
                MCharge charge;
                IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
                boolean isTaxIncluded = this.isTaxIncluded();
                if (this.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)this.getC_Charge_ID())).isSameTax()) {
                    isTaxIncluded = charge.isTaxIncluded();
                }
                taxAmt = taxCalculater != null ? taxCalculater.calculateTax(m_tax, this.getLineNetAmt(), isTaxIncluded, MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getParent().getC_Currency_ID()), JPiereTaxProvider.getRoundingMode(this.getParent().getC_BPartner_ID(), this.getParent().isSOTrx(), m_tax.getC_TaxProvider())) : m_tax.calculateTax(this.getLineNetAmt(), isTaxIncluded, MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getParent().getC_Currency_ID()));
                if (isTaxIncluded) {
                    this.set_ValueNoCheck("JP_TaxBaseAmt", this.getLineNetAmt().subtract(taxAmt));
                } else {
                    this.set_ValueNoCheck("JP_TaxBaseAmt", this.getLineNetAmt());
                }
                this.set_ValueOfColumn("JP_TaxAmt", taxAmt);
            }
        }
        if (newRecord || !newRecord && this.is_ValueChanged("M_Product_ID")) {
            if (this.getM_Product_ID() == 0) {
                this.setJP_ProductExplodeBOM_ID(0);
            } else if (this.getM_InOutLine_ID() > 0) {
                MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                if (iol.get_Value("JP_ProductExplodeBOM_ID") != null) {
                    if (this.getM_Product_ID() != iol.getM_Product_ID()) {
                        String msg0 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_InOutLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                        String msg1 = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID")) + " - " + Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID");
                        this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Different", (Object[])new Object[]{msg0, msg1}));
                        return false;
                    }
                    this.setJP_ProductExplodeBOM_ID(iol.get_ValueAsInt("JP_ProductExplodeBOM_ID"));
                } else {
                    this.setJP_ProductExplodeBOM_ID(0);
                }
            }
        }
        if (!newRecord) {
            if (!this.is_ValueChanged("QtyInvoiced")) return true;
        }
        if ((pInfo = Env.getProcessInfo((Properties)Env.getCtx())) == null && this.getC_OrderLine_ID() > 0) {
            BigDecimal qtyInvoiced = this.getQtyInvoiced();
            MOrderLine oline = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            BigDecimal qtyRecognized = (BigDecimal)oline.get_Value("JP_QtyRecognized");
            BigDecimal qtyOrdered = oline.getQtyOrdered();
            BigDecimal qtyToRecognize = qtyOrdered.subtract(qtyRecognized);
            if (qtyOrdered.signum() >= 0) {
                if (qtyInvoiced.compareTo(qtyToRecognize) <= 0) return true;
                try {
                    FDialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Over_QtyRecognized_Possibility")) + " : " + oline.getParent().getDocumentNo() + " - " + oline.getLine()));
                    return true;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            if (qtyInvoiced.compareTo(qtyToRecognize) >= 0) return true;
            try {
                FDialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Over_QtyRecognized_Possibility")) + " : " + oline.getParent().getDocumentNo() + " - " + oline.getLine()));
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        if (pInfo != null) return true;
        if (this.getM_RMALine_ID() <= 0) return true;
        BigDecimal qtyInvoiced = this.getQtyInvoiced();
        MRMALine rmaline = new MRMALine(this.getCtx(), this.getM_RMALine_ID(), this.get_TrxName());
        BigDecimal qtyRecognized = (BigDecimal)rmaline.get_Value("JP_QtyRecognized");
        BigDecimal qtyRMA = rmaline.getQty();
        BigDecimal qtyToRecognize = qtyRMA.subtract(qtyRecognized);
        if (qtyRMA.signum() >= 0) {
            if (qtyInvoiced.compareTo(qtyToRecognize) <= 0) return true;
            try {
                FDialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Over_QtyRecognized_Possibility")) + " : " + rmaline.getParent().getDocumentNo() + " - " + rmaline.getLine()));
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        if (qtyInvoiced.compareTo(qtyToRecognize) >= 0) return true;
        try {
            FDialog.info((int)0, null, (String)"JP_ToBeConfirmed", (String)(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Over_QtyRecognized_Possibility")) + " : " + rmaline.getParent().getDocumentNo() + " - " + rmaline.getLine()));
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected boolean updateInvoiceTax(boolean oldTax) {
        MRecognitionTax tax = MRecognitionTax.get(this, this.getPrecision(), oldTax, this.get_TrxName());
        if (tax != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(this.get_TrxName()) : !tax.is_new() && !tax.delete(false, this.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.getParent().isProcessed()) {
            return success;
        }
        if (newRecord || this.is_ValueChanged("C_Tax_ID") || this.is_ValueChanged("LineNetAmt")) {
            MTax m_tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
            IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
            MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
            if (taxCalculater == null) {
                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
            }
            success = taxCalculater.recalculateTax(provider, this, newRecord);
            if (!success) {
                return false;
            }
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        MTax m_tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
        MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
        if (taxCalculater == null) {
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
        }
        return taxCalculater.recalculateTax(provider, this, false);
    }

    public void setRMALine(MRMALine rmaLine) {
        if (!this.getParent().isCreditMemo()) {
            throw new AdempiereException("InvoiceNotCreditMemo");
        }
        this.setAD_Org_ID(rmaLine.getAD_Org_ID());
        this.setM_RMALine_ID(rmaLine.getM_RMALine_ID());
        this.setDescription(rmaLine.getDescription());
        this.setLine(rmaLine.getLine());
        this.setC_Charge_ID(rmaLine.getC_Charge_ID());
        this.setM_Product_ID(rmaLine.getM_Product_ID());
        this.setC_UOM_ID(rmaLine.getC_UOM_ID());
        this.setC_Tax_ID(rmaLine.getC_Tax_ID());
        this.setPrice(rmaLine.getAmt());
        BigDecimal qty = rmaLine.getQty();
        if (rmaLine.getQtyInvoiced() != null) {
            qty = qty.subtract(rmaLine.getQtyInvoiced());
        }
        this.setQty(qty);
        this.setLineNetAmt();
        this.setTaxAmt();
        this.setLineTotalAmt(rmaLine.getLineNetAmt());
        this.setC_Project_ID(rmaLine.getC_Project_ID());
        this.setC_Activity_ID(rmaLine.getC_Activity_ID());
        this.setC_Campaign_ID(rmaLine.getC_Campaign_ID());
    }

    public void clearParent() {
        this.m_parent = null;
    }
}

