/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.DocOptions;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MInvoiceJP
extends MInvoice
implements DocOptions {
    public MInvoiceJP(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
    }

    public MInvoiceJP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoiceJP(MOrder order, int C_DocTypeTarget_ID, Timestamp invoiceDate) {
        super(order, C_DocTypeTarget_ID, invoiceDate);
    }

    public MInvoiceJP(MInOut ship, Timestamp invoiceDate) {
        super(ship, invoiceDate);
    }

    public MInvoiceJP(MInvoiceBatch batch, MInvoiceBatchLine line) {
        super(batch, line);
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "CO";
            options[index++] = "PR";
            options[index++] = "VO";
            return index;
        }
        return index;
    }

    public boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_InvoiceLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? " + where;
        int count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MInvoiceLine[] lines = this.getLines(where);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)line.getM_Product_ID());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(product.getName());
                }
                int lineNo = line.getLine();
                boolean isRemain = MSysConfig.getBooleanValue((String)"JP_REMAIN_EXPLODE_PRODUCT_LINE", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
                boolean isFirstLine = true;
                int JP_ProductExplodeBOM_ID = line.getM_Product_ID();
                MProductBOM[] mProductBOMArray = MProductBOM.getBOMLines((MProduct)product);
                int n = mProductBOMArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MProductBOM bom = mProductBOMArray[n2];
                    if (isRemain || !isFirstLine) {
                        MInvoiceLine newLine = new MInvoiceLine((MInvoice)this);
                        newLine.setLine(++lineNo);
                        newLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", (Object)JP_ProductExplodeBOM_ID);
                        newLine.setM_Product_ID(bom.getM_ProductBOM_ID(), true);
                        newLine.setQty(line.getQtyInvoiced().multiply(bom.getBOMQty()));
                        if (bom.getDescription() != null) {
                            newLine.setDescription(bom.getDescription());
                        }
                        newLine.setPrice();
                        newLine.save(this.get_TrxName());
                    } else {
                        line.set_ValueNoCheck("JP_ProductExplodeBOM_ID", (Object)JP_ProductExplodeBOM_ID);
                        line.setM_Product_ID(bom.getM_ProductBOM_ID(), true);
                        line.setM_AttributeSetInstance_ID(0);
                        line.setPrice(Env.ZERO);
                        line.setPriceLimit(Env.ZERO);
                        line.setPriceList(Env.ZERO);
                        line.setLineNetAmt(Env.ZERO);
                        line.setQty(line.getQtyInvoiced().multiply(bom.getBOMQty()));
                        String description = line.getDescription();
                        if (bom.getDescription() != null) {
                            line.setDescription(String.valueOf(description) + " : " + bom.getDescription());
                        }
                        line.setPrice();
                        line.save(this.get_TrxName());
                        isFirstLine = false;
                    }
                    ++n2;
                }
                if (isRemain) {
                    line.set_ValueNoCheck("JP_ProductExplodeBOM_ID", (Object)line.getM_Product_ID());
                    line.setM_Product_ID(0);
                    line.setM_AttributeSetInstance_ID(0);
                    line.setPrice(Env.ZERO);
                    line.setPriceLimit(Env.ZERO);
                    line.setPriceList(Env.ZERO);
                    line.setLineNetAmt(Env.ZERO);
                    String description = product.getName();
                    if (product.getDescription() != null) {
                        description = String.valueOf(description) + " " + product.getDescription();
                    }
                    if (line.getDescription() != null) {
                        description = String.valueOf(description) + " " + line.getDescription();
                    }
                    line.setDescription(description);
                    line.save(this.get_TrxName());
                }
                ++i;
            }
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    private MInvoiceLine[] getLines(String whereClause) {
        String whereClauseFinal = "C_Invoice_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = String.valueOf(whereClauseFinal) + whereClause;
        }
        List list = new Query(this.getCtx(), "C_InvoiceLine", whereClauseFinal, this.get_TrxName()).setParameters(new Object[]{this.getC_Invoice_ID()}).setOrderBy("Line").list();
        return list.toArray(new MInvoiceLine[list.size()]);
    }
}

