/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import jpiere.base.plugin.org.adempiere.model.X_JP_EstimationTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MEstimationTax
extends X_JP_EstimationTax {
    private Integer m_precision = null;

    public MEstimationTax(Properties ctx, int JP_EstimationTax_ID, String trxName) {
        super(ctx, JP_EstimationTax_ID, trxName);
    }

    public MEstimationTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MEstimationTax get(MEstimationLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MEstimationTax retValue;
        block13: {
            retValue = null;
            if (line == null || line.getJP_Estimation_ID() == 0) {
                return null;
            }
            int C_Tax_ID = line.getC_Tax_ID();
            boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
            if (isOldTax) {
                Object old = line.get_ValueOld("C_Tax_ID");
                if (old == null) {
                    return null;
                }
                C_Tax_ID = (Integer)old;
            }
            if (C_Tax_ID == 0) {
                if (!line.isDescription()) {
                    // empty if block
                }
                return null;
            }
            String sql = "SELECT * FROM JP_EstimationTax WHERE JP_Estimation_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, line.getJP_Estimation_ID());
                    pstmt.setInt(2, C_Tax_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MEstimationTax(line.getCtx(), rs, trxName);
                    }
                }
                catch (Exception exception) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MEstimationTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setJP_Estimation_ID(line.getJP_Estimation_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        return retValue;
    }

    protected void setPrecision(int precision) {
        this.m_precision = new Integer(precision);
    }
}

