/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.MEstimation;
import jpiere.base.plugin.org.adempiere.model.X_JP_EstimationLine;
import jpiere.base.plugin.util.JPiereUtil;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.ProductNotOnPriceListException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MEstimationLine
extends X_JP_EstimationLine {
    protected MEstimation m_parent = null;
    protected int m_M_PriceList_ID = 0;
    protected boolean m_IsSOTrx = true;
    protected MProductPricing m_productPrice = null;
    protected MTax m_tax = null;
    protected Integer m_precision = null;
    protected MProduct m_product = null;
    protected MCharge m_charge = null;

    public MEstimationLine(Properties ctx, int JP_EstimationLine_ID, String trxName) {
        super(ctx, JP_EstimationLine_ID, trxName);
    }

    public MEstimationLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MEstimationLine(MEstimation estimation) {
        this(estimation.getCtx(), 0, estimation.get_TrxName());
        if (estimation.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setJP_Estimation_ID(estimation.getJP_Estimation_ID());
        this.setEstimation(estimation);
    }

    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        if (this.getC_BPartner_ID() == 0 || this.getC_BPartner_Location_ID() == 0 || this.getM_Warehouse_ID() == 0 || this.getC_Currency_ID() == 0) {
            this.setEstimation(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo(this.getParent());
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        } else {
            boolean enforce;
            if (this.m_productPrice == null && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            if (this.m_productPrice == null) {
                this.getProductPricing(this.m_M_PriceList_ID);
            }
            boolean bl = enforce = this.m_IsSOTrx && this.getParent().getM_PriceList().isEnforcePriceLimit();
            if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                enforce = false;
            }
            if (enforce && this.getPriceLimit() != Env.ZERO && this.getPriceActual().compareTo(this.getPriceLimit()) < 0) {
                this.log.saveError("UnderLimitPrice", "PriceEntered=" + this.getPriceEntered() + ", PriceLimit=" + this.getPriceLimit());
                return false;
            }
            if (!this.m_productPrice.isCalculated()) {
                throw new ProductNotOnPriceListException((IProductPricing)this.m_productPrice, this.getLine());
            }
        }
        if (this.getC_UOM_ID() == 0 && (this.getM_Product_ID() != 0 || this.getPriceEntered().compareTo(Env.ZERO) != 0 || this.getC_Charge_ID() != 0) && (C_UOM_ID = MUOM.getDefault_UOM_ID((Properties)this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyOrdered")) {
            this.setQtyOrdered(this.getQtyOrdered());
        }
        if (newRecord || this.is_ValueChanged("LineNetAmt") || this.is_ValueChanged("C_Tax_ID")) {
            BigDecimal taxAmt = Env.ZERO;
            MTax m_tax = MTax.get((Properties)Env.getCtx(), (int)this.getC_Tax_ID());
            if (m_tax != null) {
                MCharge charge;
                IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
                boolean isTaxIncluded = this.isTaxIncluded();
                if (this.getC_Charge_ID() != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)this.getC_Charge_ID())).isSameTax()) {
                    isTaxIncluded = charge.isTaxIncluded();
                }
                taxAmt = taxCalculater != null ? taxCalculater.calculateTax(m_tax, this.getLineNetAmt(), isTaxIncluded, MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getParent().getC_Currency_ID()), JPiereTaxProvider.getRoundingMode(this.getParent().getC_BPartner_ID(), this.getParent().isSOTrx(), m_tax.getC_TaxProvider())) : m_tax.calculateTax(this.getLineNetAmt(), isTaxIncluded, MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getParent().getC_Currency_ID()));
                if (isTaxIncluded) {
                    this.set_ValueNoCheck("JP_TaxBaseAmt", this.getLineNetAmt().subtract(taxAmt));
                } else {
                    this.set_ValueNoCheck("JP_TaxBaseAmt", this.getLineNetAmt());
                }
                this.set_ValueOfColumn("JP_TaxAmt", taxAmt);
            }
        }
        if (this.getM_Product_ID() > 0 && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("C_UOM_ID"))) {
            MUOMConversion[] UOMConversions = MUOMConversion.getProductConversions((Properties)this.getCtx(), (int)this.getM_Product_ID());
            boolean isOK = false;
            int i = 0;
            while (i < UOMConversions.length) {
                if (this.getC_UOM_ID() == UOMConversions[i].getC_UOM_ID()) {
                    isOK = true;
                    break;
                }
                if (this.getC_UOM_ID() == UOMConversions[i].getC_UOM_To_ID()) {
                    isOK = true;
                    break;
                }
                ++i;
            }
            if (!isOK) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"NoUOMConversion"));
                return false;
            }
        }
        String config = MSysConfig.getValue((String)"JPIERE_SET_COST_TO_ORDER-LINE", (String)"NO", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (this.getM_Product_ID() != 0 && !config.equals("NO") && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("QtyOrdered") || this.is_ValueChanged("JP_ScheduledCost"))) {
            BigDecimal cost = this.getJP_ScheduledCost();
            if (newRecord && cost.compareTo(Env.ZERO) == 0 || !newRecord && this.is_ValueChanged("M_Product_ID") && !this.is_ValueChanged("JP_ScheduledCost")) {
                if (config.equals("BT")) {
                    this.setScheduledCost();
                } else if (config.equals("SO") && this.getParent().isSOTrx()) {
                    this.setScheduledCost();
                } else if (config.equals("PO") && !this.getParent().isSOTrx()) {
                    this.setScheduledCost();
                }
                cost = this.getJP_ScheduledCost();
            }
            if (config.equals("BT")) {
                this.setJP_ScheduledCostLineAmt(cost.multiply(this.getQtyOrdered()));
            } else if (config.equals("SO") && this.getParent().isSOTrx()) {
                this.setJP_ScheduledCostLineAmt(cost.multiply(this.getQtyOrdered()));
            } else if (config.equals("PO") && !this.getParent().isSOTrx()) {
                this.setJP_ScheduledCostLineAmt(cost.multiply(this.getQtyOrdered()));
            }
        } else if (this.getM_Product_ID() == 0) {
            this.setJP_ScheduledCost(Env.ZERO);
            this.setJP_ScheduledCostLineAmt(Env.ZERO);
        }
        if (this.getParent().getC_DocTypeTarget().isChargeOrProductMandatory() && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0 && this.getPriceEntered().signum() != 0) {
            this.log.saveError("FillMandatory", Msg.translate((Properties)this.getCtx(), (String)"ChargeOrProductMandatory"));
            return false;
        }
        if (this.getJP_LocatorFrom_ID() != 0 && (newRecord || this.is_ValueChanged("JP_LocatorFrom_ID"))) {
            MLocator fromLocator = MLocator.get((Properties)this.getCtx(), (int)this.getJP_LocatorFrom_ID());
            MOrgInfo fromLocatorOrgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)fromLocator.getAD_Org_ID(), (String)this.get_TrxName());
            MOrgInfo lineOrgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)this.getAD_Org_ID(), (String)this.get_TrxName());
            if (fromLocatorOrgInfo.get_ValueAsInt("JP_Corporation_ID") != lineOrgInfo.get_ValueAsInt("JP_Corporation_ID")) {
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMForDiffCorp"));
                return false;
            }
            MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getParent().getJP_DocTypeSO_ID());
            int JP_DocTypeMM_ID = docType.get_ValueAsInt("JP_DocTypeMM_ID");
            if (JP_DocTypeMM_ID > 0 && (this.getJP_LocatorFrom_ID() != 0 || this.getJP_LocatorTo_ID() != 0)) {
                if (this.getJP_LocatorFrom_ID() > 0 && this.getJP_LocatorTo_ID() == 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_PleaseInputToField")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_LocatorTo_ID"));
                    return false;
                }
                if (this.getJP_LocatorFrom_ID() == 0 && this.getJP_LocatorTo_ID() > 0) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_PleaseInputToField")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_LocatorFrom_ID"));
                    return false;
                }
                if (this.getJP_LocatorFrom_ID() == this.getJP_LocatorTo_ID()) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_SameLocatorMM"));
                    return false;
                }
                if (!MLocator.get((Properties)this.getCtx(), (int)this.getJP_LocatorFrom_ID()).get_Value("JP_PhysicalWarehouse_ID").equals(MLocator.get((Properties)this.getCtx(), (int)this.getJP_LocatorTo_ID()).get_Value("JP_PhysicalWarehouse_ID"))) {
                    this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMforDiffPhyWH"));
                    return false;
                }
            } else if (this.getJP_LocatorFrom_ID() != 0 || this.getJP_LocatorTo_ID() != 0) {
                this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_CanNotCreateMMforDocType"));
                return false;
            }
        }
        return true;
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new IllegalStateException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " - M_PriceList_ID=" + M_PriceList_ID);
        }
        this.getProductPricing(M_PriceList_ID);
        this.setPriceActual(this.m_productPrice.getPriceStd());
        this.setPriceList(this.m_productPrice.getPriceList());
        this.setPriceLimit(this.m_productPrice.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyOrdered()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyOrdered().divide(this.getQtyEntered(), 12, 4)));
        }
        this.setDiscount(this.m_productPrice.getDiscount());
        this.setC_UOM_ID(this.m_productPrice.getC_UOM_ID());
    }

    protected MProductPricing getProductPricing(int M_PriceList_ID) {
        this.m_productPrice = new MProductPricing(this.getM_Product_ID(), this.getC_BPartner_ID(), this.getQtyOrdered(), this.m_IsSOTrx);
        this.m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPrice.setPriceDate(this.getDateOrdered());
        this.m_productPrice.calculatePrice();
        return this.m_productPrice;
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    public void setQtyOrdered(BigDecimal QtyOrdered) {
        MProduct product = this.getProduct();
        if (QtyOrdered != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, 4);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    private void setScheduledCost() {
        MAcctSchema as = MAcctSchema.get((Properties)Env.getCtx(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID"));
        BigDecimal cost = this.getProductCosts(as, this.getAD_Org_ID(), true);
        this.setJP_ScheduledCost(cost);
    }

    private BigDecimal getProductCosts(MAcctSchema as, int AD_Org_ID, boolean zeroCostsOK) {
        ProductCost pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        pc.setQty(Env.ONE);
        String costingMethod = null;
        BigDecimal costs = pc.getProductCosts(as, AD_Org_ID, costingMethod, 0, zeroCostsOK);
        if (costs != null) {
            return costs;
        }
        return Env.ZERO;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        String sql;
        int no;
        if (!success) {
            return success;
        }
        if (this.getParent().isProcessed()) {
            return success;
        }
        if (newRecord || this.is_ValueChanged("C_Tax_ID") || this.is_ValueChanged("LineNetAmt")) {
            MTax m_tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
            IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
            MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
            if (taxCalculater == null) {
                throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
            }
            success = taxCalculater.recalculateTax(provider, this, newRecord);
            if (!success) {
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("JP_ScheduledCost") && (no = DB.executeUpdate((String)(sql = "UPDATE JP_Estimation i SET JP_ScheduledCostTotalLines = (SELECT COALESCE(SUM(JP_ScheduledCostLineAmt),0) FROM JP_EstimationLine il WHERE i.JP_Estimation_ID=il.JP_Estimation_ID)WHERE JP_Estimation_ID=?"), (Object[])new Object[]{new Integer(this.getJP_Estimation_ID())}, (boolean)false, (String)this.get_TrxName(), (int)0)) != 1) {
            this.log.warning("(1) #" + no);
            return false;
        }
        return success;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getS_ResourceAssignment_ID() != 0) {
            MResourceAssignment ra = new MResourceAssignment(this.getCtx(), this.getS_ResourceAssignment_ID(), this.get_TrxName());
            ra.delete(true);
        }
        MTax m_tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
        MTaxProvider provider = new MTaxProvider(m_tax.getCtx(), m_tax.getC_TaxProvider_ID(), m_tax.get_TrxName());
        if (taxCalculater == null) {
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TaxNoProvider"));
        }
        return taxCalculater.recalculateTax(provider, this, false);
    }

    public MEstimation getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MEstimation(this.getCtx(), this.getJP_Estimation_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_PriceList_ID FROM JP_Estimation WHERE JP_Estimation_ID=?", (int)this.getJP_Estimation_ID());
        }
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)this.m_M_PriceList_ID, (String)this.get_TrxName());
        return pl.isTaxIncluded();
    }

    public void setHeaderInfo(MEstimation estimation) {
        this.m_parent = estimation;
        this.m_precision = new Integer(estimation.getPrecision());
        this.m_M_PriceList_ID = estimation.getM_PriceList_ID();
        this.m_IsSOTrx = estimation.isSOTrx();
    }

    public int getPrecision() {
        MCurrency cur;
        if (this.m_precision != null) {
            return this.m_precision;
        }
        if (this.getC_Currency_ID() == 0) {
            this.setEstimation(this.getParent());
            if (this.m_precision != null) {
                return this.m_precision;
            }
        }
        if (this.getC_Currency_ID() != 0 && (cur = MCurrency.get((Properties)this.getCtx(), (int)this.getC_Currency_ID())).get_ID() != 0) {
            this.m_precision = new Integer(cur.getStdPrecision());
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN JP_Estimation x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.JP_Estimation_ID=?";
        int i = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getJP_Estimation_ID());
        this.m_precision = new Integer(i);
        return this.m_precision;
    }

    public void setEstimation(MEstimation estimation) {
        this.setClientOrg(estimation);
        this.setC_BPartner_ID(estimation.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(estimation.getC_BPartner_Location_ID());
        this.setM_Warehouse_ID(estimation.getM_Warehouse_ID());
        this.setDateOrdered(estimation.getDateOrdered());
        this.setDatePromised(estimation.getDatePromised());
        this.setC_Currency_ID(estimation.getC_Currency_ID());
        this.setHeaderInfo(estimation);
    }

    public void clearParent() {
        this.m_parent = null;
    }
}

