/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MBill;
import jpiere.base.plugin.org.adempiere.model.MEstimationLine;
import jpiere.base.plugin.org.adempiere.model.MEstimationTax;
import jpiere.base.plugin.org.adempiere.model.X_JP_Estimation;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MQuery;
import org.compiere.model.MRMA;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MEstimation
extends X_JP_Estimation
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7588955558162632796L;
    protected MEstimationLine[] m_lines = null;
    protected MEstimationTax[] m_taxes = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    boolean JP_ESTIMATION_ORDER_AMT_CHECK = false;
    boolean JP_ESTIMATION_INVOICE_AMT_CHECK = false;
    boolean JP_ESTIMATION_BILL_AMT_CHECK = false;
    boolean JP_ESTIMATION_PAYMENT_AMT_CHECK = false;
    boolean JP_ESTIMATION_RMA_AMT_CHECK = false;

    public MEstimation(Properties ctx, int JP_Estimation_ID, String trxName) {
        super(ctx, JP_Estimation_ID, trxName);
    }

    public MEstimation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        int m_docid = this.getJP_Estimation_ID();
        MQuery query = new MQuery("JP_Estimation");
        query.addRestriction("JP_Estimation_ID", "=", (Object)new Integer(m_docid));
        int AD_PrintFormat_ID = this.getC_DocTypeTarget().getAD_PrintFormat_ID();
        MPrintFormat pf = new MPrintFormat(this.getCtx(), AD_PrintFormat_ID, this.get_TrxName());
        PrintInfo info = new PrintInfo("0", 0, 0, 0);
        ReportEngine re = new ReportEngine(this.getCtx(), pf, query, info);
        if (pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID());
            pi.setRecord_ID(this.getJP_Estimation_ID());
            pi.setIsBatch(true);
            ServerProcessCtl.process((ProcessInfo)pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MEstimationLine[] lines = this.getLines();
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        String msg = this.amountConsistencyCheck();
        if (!Util.isEmpty((String)msg)) {
            this.m_processMsg = msg;
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.approveIt();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            if (this.getDateAcct().before(this.getDateOrdered())) {
                this.setDateAcct(this.getDateOrdered());
                MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && this.getProcessedOn().signum() == 0 && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_Estimation_ID(), (String)this.get_TrxName());
        this.setPosted(true);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        return false;
    }

    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getJP_Estimation_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public MEstimationLine[] getLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("JP_Estimation_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "JP_EstimationLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        for (MEstimationLine ol : list) {
            ol.setHeaderInfo(this);
        }
        return list.toArray(new MEstimationLine[list.size()]);
    }

    public MEstimationLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            MEstimation.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MEstimationLine[] getLines() {
        return this.getLines(false, null);
    }

    public MEstimationTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        List list = new Query(this.getCtx(), "JP_EstimationTax", "JP_Estimation_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MEstimationTax[list.size()]);
        return this.m_taxes;
    }

    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("C_DocTypeTarget_ID")) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (newRecord || this.is_ValueChanged("JP_DocTypeSO_ID")) {
            if (this.getJP_DocTypeSO_ID() == 0) {
                this.setOrderType("SO");
            } else {
                MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getJP_DocTypeSO_ID());
                this.setOrderType(dt.getDocSubTypeSO());
            }
        }
        if (newRecord && this.getC_BPartner_ID() > 0 || this.is_ValueChanged("C_BPartner_ID") && this.getC_BPartner_ID() > 0) {
            MBPartner bp = MBPartner.get((Properties)this.getCtx(), (int)this.getC_BPartner_ID());
            if (Util.isEmpty((String)this.getJP_BP_Name())) {
                this.setJP_BP_Name(bp.getName2());
            }
            if (Util.isEmpty((String)this.getJP_BP_Address())) {
                int C_BPartner_Location_ID = this.getC_BPartner_Location_ID();
                if (C_BPartner_Location_ID == 0) {
                    MBPartnerLocation[] bpLocations = bp.getLocations(false);
                    int i = 0;
                    while (i < bpLocations.length) {
                        if (bpLocations[i].isActive()) {
                            C_BPartner_Location_ID = bpLocations[i].getC_BPartner_Location_ID();
                        }
                        ++i;
                    }
                }
                if (C_BPartner_Location_ID > 0) {
                    MBPartnerLocation bpLocation = new MBPartnerLocation(this.getCtx(), C_BPartner_Location_ID, this.get_TrxName());
                    MLocation loc = bpLocation.getLocation(false);
                    MCountry country = MCountry.get((Properties)this.getCtx(), (int)loc.getC_Country_ID());
                    String postal = loc.getPostal();
                    if (!Util.isEmpty((String)postal)) {
                        String postalAdd = loc.getPostal_Add();
                        if (!Util.isEmpty((String)postalAdd)) {
                            postal = country.getCountryCode().equals("JP") ? "\u3012" + postal + "-" + postalAdd : String.valueOf(postal) + "-" + postalAdd;
                        } else if (country.getCountryCode().equals("JP")) {
                            postal = "\u3012" + postal + "-0000";
                        }
                        this.setJP_BP_Address(String.valueOf(postal) + " " + loc.getAddress1() + loc.getAddress2());
                    } else {
                        this.setJP_BP_Address(String.valueOf(loc.getAddress1()) + loc.getAddress2());
                    }
                }
            }
            if (Util.isEmpty((String)this.getJP_BP_User_Name())) {
                MUser[] users = MUser.getOfBPartner((Properties)this.getCtx(), (int)bp.getC_BPartner_ID(), (String)this.get_TrxName());
                int i = 0;
                while (i < users.length) {
                    if (users[i].isActive()) {
                        this.setJP_BP_User_Name(users[i].getName());
                        break;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID") || this.is_ValueChanged("DateOrdered") || this.is_ValueChanged("DatePromised") || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("M_Shipper_ID") || this.is_ValueChanged("C_Currency_ID")) {
            MEstimationLine[] lines;
            MEstimationLine[] mEstimationLineArray = lines = this.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MEstimationLine line = mEstimationLineArray[n2];
                if (this.is_ValueChanged("AD_Org_ID")) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
                if (this.is_ValueChanged("C_BPartner_ID")) {
                    line.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (this.is_ValueChanged("C_BPartner_Location_ID")) {
                    line.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                }
                if (this.is_ValueChanged("DateOrdered")) {
                    line.setDateOrdered(this.getDateOrdered());
                }
                if (this.is_ValueChanged("DatePromised")) {
                    line.setDatePromised(this.getDatePromised());
                }
                if (this.is_ValueChanged("M_Warehouse_ID")) {
                    line.setM_Warehouse_ID(this.getM_Warehouse_ID());
                }
                if (this.is_ValueChanged("M_Shipper_ID")) {
                    line.setM_Shipper_ID(this.getM_Shipper_ID());
                }
                if (this.is_ValueChanged("C_Currency_ID")) {
                    line.setC_Currency_ID(this.getC_Currency_ID());
                }
                line.saveEx();
                ++n2;
            }
        }
        return true;
    }

    public int copyLinesFrom(MEstimation otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MEstimationLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MEstimationLine line = new MEstimationLine(this);
            PO.copyValues((PO)fromLines[i], (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            line.setJP_Estimation_ID(this.getJP_Estimation_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setEstimation(this);
            line.set_ValueNoCheck("JP_EstimationLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            index = 0;
            options[index++] = "CL";
            options[index++] = "VO";
            options[index++] = "RE";
            return index;
        }
        if (docStatus.equals("DR")) {
            index = 0;
            options[index++] = "PR";
            options[index++] = "VO";
            options[index++] = "CO";
            return index;
        }
        return index;
    }

    public String amountConsistencyCheck() {
        MRMA rma;
        MPayment payment;
        MBill bill;
        MInvoice invoice;
        MOrder order;
        if (this.getRef_Order_ID() > 0) {
            this.JP_ESTIMATION_ORDER_AMT_CHECK = MSysConfig.getBooleanValue((String)"JP_ESTIMATION_ORDER_AMT_CHECK", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        }
        if (this.getC_Invoice_ID() > 0) {
            this.JP_ESTIMATION_INVOICE_AMT_CHECK = MSysConfig.getBooleanValue((String)"JP_ESTIMATION_INVOICE_AMT_CHECK", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        }
        if (this.getJP_Bill_ID() > 0) {
            this.JP_ESTIMATION_BILL_AMT_CHECK = MSysConfig.getBooleanValue((String)"JP_ESTIMATION_BILL_AMT_CHECK", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        }
        if (this.getC_Payment_ID() > 0) {
            this.JP_ESTIMATION_PAYMENT_AMT_CHECK = MSysConfig.getBooleanValue((String)"JP_ESTIMATION_PAYMENT_AMT_CHECK", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        }
        if (this.getM_RMA_ID() > 0) {
            this.JP_ESTIMATION_RMA_AMT_CHECK = MSysConfig.getBooleanValue((String)"JP_ESTIMATION_RMA_AMT_CHECK", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        }
        if (this.JP_ESTIMATION_ORDER_AMT_CHECK && (order = new MOrder(this.getCtx(), this.getRef_Order_ID(), this.get_TrxName())).getGrandTotal().compareTo(this.getGrandTotal()) != 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_EstimationAmountConsistencyError")) + " : " + order.getDocumentInfo();
        }
        if (this.JP_ESTIMATION_INVOICE_AMT_CHECK && (invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName())).getGrandTotal().compareTo(this.getGrandTotal()) != 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_EstimationAmountConsistencyError")) + " : " + invoice.getDocumentInfo();
        }
        if (this.JP_ESTIMATION_BILL_AMT_CHECK && (bill = new MBill(this.getCtx(), this.getJP_Bill_ID(), this.get_TrxName())).getGrandTotal().compareTo(this.getGrandTotal()) != 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_EstimationAmountConsistencyError")) + " : " + bill.getDocumentInfo();
        }
        if (this.JP_ESTIMATION_PAYMENT_AMT_CHECK && (payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName())).getPayAmt().compareTo(this.getGrandTotal()) != 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_EstimationAmountConsistencyError")) + " : " + payment.getDocumentInfo();
        }
        if (this.JP_ESTIMATION_RMA_AMT_CHECK && (rma = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName())).getAmt().compareTo(this.getTotalLines()) != 0) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_EstimationAmountConsistencyError")) + " : " + rma.getDocumentInfo();
        }
        return "";
    }
}

