/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.X_JP_DeliveryDays;
import org.compiere.model.I_C_BPartner_Location;
import org.compiere.model.I_C_Location;
import org.compiere.model.MClientInfo;
import org.compiere.model.MInOut;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MSalesRegion;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDeliveryDays
extends X_JP_DeliveryDays {
    static MDeliveryDays[] m_deliveryDays = null;

    public MDeliveryDays(Properties ctx, int JP_DeliveryDays_ID, String trxName) {
        super(ctx, JP_DeliveryDays_ID, trxName);
    }

    public MDeliveryDays(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        return super.beforeSave(newRecord);
    }

    public static int getDeliveryDays(int M_Warehouse_ID, int C_SalesRegion_ID) {
        if (m_deliveryDays == null) {
            StringBuilder whereClauseFinal = new StringBuilder("AD_Client_ID=? ");
            List list = new Query(Env.getCtx(), "JP_DeliveryDays", whereClauseFinal.toString(), null).setParameters(new Object[]{Env.getAD_Client_ID((Properties)Env.getCtx())}).setOrderBy("M_Warehouse_ID,C_SalesRegion_ID").list();
            m_deliveryDays = list.toArray(new MDeliveryDays[list.size()]);
        }
        int i = 0;
        while (i < m_deliveryDays.length) {
            if (m_deliveryDays[i].getM_Warehouse_ID() == M_Warehouse_ID && m_deliveryDays[i].getC_SalesRegion_ID() == C_SalesRegion_ID) {
                return m_deliveryDays[i].getDeliveryDays();
            }
            ++i;
        }
        return -1;
    }

    public static Timestamp getInvoiceDate(MInOut io, boolean isHolidayNotInspection, String DateColumn) {
        Timestamp dateInvoiced = null;
        dateInvoiced = (Timestamp)io.get_Value(DateColumn);
        if (dateInvoiced == null) {
            return io.getDateAcct();
        }
        int deliveryDays = MSysConfig.getIntValue((String)"JP_DEFAULT_INSPECTION_DAYS", (int)0, (int)io.getAD_Client_ID(), (int)io.getAD_Org_ID());
        I_C_BPartner_Location bpl = null;
        bpl = io.getDropShip_Location_ID() == 0 ? io.getC_BPartner_Location() : io.getDropShip_Location();
        I_C_Location location = bpl.getC_Location();
        if (bpl.getC_SalesRegion_ID() > 0) {
            MSalesRegion salesRegion = new MSalesRegion(io.getCtx(), bpl.getC_SalesRegion_ID(), io.get_TrxName());
            int dd = MDeliveryDays.getDeliveryDays(io.getM_Warehouse_ID(), salesRegion.getC_SalesRegion_ID());
            if (dd > -1) {
                deliveryDays = dd;
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateInvoiced.getTime());
        if (isHolidayNotInspection) {
            int i = 0;
            do {
                dateInvoiced = new Timestamp(cal.getTimeInMillis());
                if (MDeliveryDays.isNonBusinessDay(io.getAD_Client_ID(), io.getAD_Org_ID(), location == null ? 0 : location.getC_Country_ID(), dateInvoiced)) {
                    cal.add(5, 1);
                } else {
                    if (i != 0) {
                        --deliveryDays;
                    }
                    if (deliveryDays > 0) {
                        cal.add(5, 1);
                    }
                }
                ++i;
            } while (deliveryDays > 0);
        } else {
            cal.add(5, deliveryDays);
            dateInvoiced = new Timestamp(cal.getTimeInMillis());
        }
        return dateInvoiced;
    }

    public static boolean isNonBusinessDay(int AD_Client_ID, int AD_Org_ID, int C_Country_ID, Timestamp date) {
        boolean isNonBusinessDay;
        block8: {
            MClientInfo clientInfo;
            MOrgInfo orgInfo = MOrgInfo.get((Properties)Env.getCtx(), (int)AD_Org_ID, null);
            int C_Calendar_ID = orgInfo.getC_Calendar_ID();
            if (C_Calendar_ID == 0 && (C_Calendar_ID = (clientInfo = MClientInfo.get((Properties)Env.getCtx(), (int)AD_Client_ID, null)).getC_Calendar_ID()) == 0) {
                return false;
            }
            StringBuilder sql = new StringBuilder("SELECT Date1 FROM C_NonBusinessDay");
            sql.append(" WHERE AD_Client_ID=? AND C_Calendar_ID=? AND AD_Org_ID IN (0,?) AND (C_Country_ID is null or C_Country_ID = ?) AND Date1=? ");
            isNonBusinessDay = false;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), null);
                pstmt.setInt(1, AD_Client_ID);
                pstmt.setInt(2, C_Calendar_ID);
                pstmt.setInt(3, AD_Org_ID);
                pstmt.setInt(4, C_Country_ID);
                pstmt.setTimestamp(5, date);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return true;
                }
            }
            catch (Exception e) {
                isNonBusinessDay = false;
                break block8;
            }
            finally {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return isNonBusinessDay;
    }
}

