/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractContentT;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractLineT;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.ProductNotOnPriceListException;
import org.compiere.model.MCurrency;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MContractLineT
extends X_JP_ContractLineT {
    protected MContractContentT m_parent = null;
    protected Integer m_precision = null;
    protected int m_M_PriceList_ID = 0;
    protected boolean m_IsSOTrx = true;
    protected MProductPricing m_productPrice = null;
    private static CCache<Integer, MContractLineT> s_cache = new CCache("JP_ContractLineT", 20);

    public MContractLineT(Properties ctx, int JP_ContractLineT_ID, String trxName) {
        super(ctx, JP_ContractLineT_ID, trxName);
    }

    public MContractLineT(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MContractContentT getParent() {
        if (this.m_parent == null && this.getJP_ContractContentT_ID() > 0) {
            this.m_parent = new MContractContentT(this.getCtx(), this.getJP_ContractContentT_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getJP_ContractContentT_ID() > 0 || this.getJP_ContractContentT_ID() > 0 && this.is_ValueChanged("JP_ContractContentT_ID")) {
            this.setJP_ContractType(this.getParent().getJP_ContractType());
            this.setDocBaseType(this.getParent().getDocBaseType());
            this.setJP_CreateDerivativeDocPolicy(this.getParent().getJP_CreateDerivativeDocPolicy());
            this.setOrderType(this.getParent().getOrderType());
            this.setM_PriceList_ID(this.getParent().getM_PriceList_ID());
            this.setIsSOTrx(this.getParent().isSOTrx());
            this.setC_Currency_ID(this.getParent().getC_Currency_ID());
            this.setIsTaxIncluded(this.getParent().isTaxIncluded());
        }
        if (Util.isEmpty((String)this.getJP_ContractType())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractType")};
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            return false;
        }
        if (Util.isEmpty((String)this.getDocBaseType())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"DocBaseType")};
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            return false;
        }
        if (newRecord && this.getJP_ContractContentT_ID() == 0 || this.is_ValueChanged("DocBaseType") && this.getJP_ContractContentT_ID() == 0 || this.is_ValueChanged("JP_CreateDerivativeDocPolicy") && this.getJP_ContractContentT_ID() == 0) {
            if (this.getDocBaseType().equals("POO") || this.getDocBaseType().equals("SOO")) {
                if (!(this.getJP_CreateDerivativeDocPolicy() == null || this.getJP_CreateDerivativeDocPolicy().equals("MA") || this.getOrderType().equals("SO") || this.getOrderType().equals("OB") || this.getOrderType().equals("ON"))) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BaseDocDocType_ID") + "  :  " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_BaseDocDocType_CreateDerivativeDocPolicy"));
                    return false;
                }
            } else {
                this.setOrderType("--");
            }
        }
        if (newRecord && this.getJP_ContractContentT_ID() == 0 || this.is_ValueChanged("JP_CreateDerivativeDocPolicy") && this.getJP_ContractContentT_ID() == 0) {
            if (this.getJP_ContractType().equals("PDC") && (this.getDocBaseType().equals("SOO") || this.getDocBaseType().equals("POO"))) {
                if (Util.isEmpty((String)this.getJP_CreateDerivativeDocPolicy())) {
                    Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")};
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
                    return false;
                }
                if (!(!this.getDocBaseType().equals("POO") && !this.getDocBaseType().equals("SOO") || this.getJP_CreateDerivativeDocPolicy().equals("MA") || this.getOrderType().equals("SO") || this.getOrderType().equals("OB") || this.getOrderType().equals("ON"))) {
                    this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"MA") + "  :  " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_BaseDocDocType_CreateDerivativeDocPolicy"));
                    return false;
                }
            } else {
                this.setJP_CreateDerivativeDocPolicy(null);
            }
        }
        if (this.getJP_ContractType().equals("PDC") && (newRecord || this.is_ValueChanged("JP_BaseDocLinePolicy") || this.is_ValueChanged("JP_ProcPeriodOffs_Lump") || this.is_ValueChanged("JP_ProcPeriodOffs_Start") || this.is_ValueChanged("JP_ProcPeriodOffs_End") || this.is_ValueChanged("JP_DerivativeDocPolicy_InOut") || this.is_ValueChanged("JP_ContractCalRef_InOut_ID") || this.is_ValueChanged("JP_ContractProcRef_InOut_ID") || this.is_ValueChanged("JP_ProcPeriodOffs_Lump_InOut") || this.is_ValueChanged("JP_ProcPeriodOffs_Start_InOut") || this.is_ValueChanged("JP_ProcPeriodOffs_End_InOut") || this.is_ValueChanged("JP_DerivativeDocPolicy_Inv") || this.is_ValueChanged("JP_ContractCalRef_Inv_ID") || this.is_ValueChanged("JP_ContractProcRef_Inv_ID") || this.is_ValueChanged("JP_ProcPeriodOffs_Lump_Inv") || this.is_ValueChanged("JP_ProcPeriodOffs_Start_Inv") || this.is_ValueChanged("JP_ProcPeriodOffs_End_Inv") || this.is_ValueChanged("QtyEntered") || this.is_ValueChanged("QtyOrdered") || this.is_ValueChanged("MovementQty") || this.is_ValueChanged("QtyInvoiced")) && !this.beforeSavePeriodContractCheck(newRecord)) {
            return false;
        }
        if (this.getJP_ContractType().equals("STC")) {
            this.setNullCreateBaseDocLineInfo();
            this.setNullCreateDerivativeInOutInfo();
            this.setNullCreateDerivativeInvoiceInfo();
        }
        if (this.getC_BPartner_ID() == 0 || this.getC_BPartner_Location_ID() == 0) {
            this.setContentTemplateInfo();
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo();
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() > 0) {
            boolean enforce;
            if (this.m_productPrice == null && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            if (this.m_productPrice == null) {
                this.getProductPricing(this.m_M_PriceList_ID);
            }
            boolean bl = enforce = this.m_IsSOTrx && this.getM_PriceList().isEnforcePriceLimit();
            if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                enforce = false;
            }
            if (enforce && this.getPriceLimit() != Env.ZERO && this.getPriceActual().compareTo(this.getPriceLimit()) < 0) {
                this.log.saveError("UnderLimitPrice", "PriceEntered=" + this.getPriceEntered() + ", PriceLimit=" + this.getPriceLimit());
                return false;
            }
            if (!this.m_productPrice.isCalculated()) {
                throw new ProductNotOnPriceListException((IProductPricing)this.m_productPrice, this.getLine());
            }
        }
        return true;
    }

    public void setContentTemplateInfo() {
        this.m_parent = this.getParent();
        if (this.m_parent != null) {
            this.setC_BPartner_ID(this.m_parent.getC_BPartner_ID());
            this.setC_BPartner_Location_ID(this.m_parent.getC_BPartner_Location_ID());
        }
        this.setHeaderInfo();
    }

    public void setHeaderInfo() {
        this.m_parent = this.getParent();
        if (this.m_parent == null) {
            this.m_precision = new Integer(MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID()));
            this.m_M_PriceList_ID = this.getM_PriceList_ID();
            this.m_IsSOTrx = this.isSOTrx();
        } else {
            this.m_precision = new Integer(this.m_parent.getPrecision());
            this.m_M_PriceList_ID = this.m_parent.getM_PriceList_ID();
            this.m_IsSOTrx = this.m_parent.isSOTrx();
        }
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new IllegalStateException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " - M_PriceList_ID=" + M_PriceList_ID);
        }
        this.getProductPricing(M_PriceList_ID);
        this.setPriceActual(this.m_productPrice.getPriceStd());
        this.setPriceList(this.m_productPrice.getPriceList());
        this.setPriceLimit(this.m_productPrice.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyOrdered()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyOrdered().divide(this.getQtyEntered(), 12, 4)));
        }
        this.setDiscount(this.m_productPrice.getDiscount());
        this.setC_UOM_ID(this.m_productPrice.getC_UOM_ID());
    }

    protected MProductPricing getProductPricing(int M_PriceList_ID) {
        this.m_productPrice = new MProductPricing(this.getM_Product_ID(), this.getC_BPartner_ID(), this.getQtyOrdered(), this.m_IsSOTrx, this.get_TrxName());
        this.m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPrice.calculatePrice();
        return this.m_productPrice;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        String sql;
        int no;
        if (!success) {
            return success;
        }
        if ((newRecord || this.is_ValueChanged("LineNetAmt")) && this.getJP_ContractContentT_ID() > 0 && (no = DB.executeUpdate((String)(sql = "UPDATE JP_ContractContentT cct SET TotalLines = (SELECT COALESCE(SUM(LineNetAmt),0) FROM JP_ContractLineT clt WHERE cct.JP_ContractContentT_ID=clt.JP_ContractContentT_ID)WHERE JP_ContractContenTt_ID=?"), (Object[])new Object[]{new Integer(this.getJP_ContractContentT_ID())}, (boolean)false, (String)this.get_TrxName(), (int)0)) != 1) {
            this.log.warning("(1) #" + no);
            return false;
        }
        return success;
    }

    public static MContractLineT get(Properties ctx, int JP_ContractLineT_ID) {
        Integer ii = new Integer(JP_ContractLineT_ID);
        MContractLineT retValue = (MContractLineT)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContractLineT(ctx, JP_ContractLineT_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_ContractLineT_ID, (Object)retValue);
        }
        return retValue;
    }

    private boolean beforeSavePeriodContractCheck(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_CreateDerivativeDocPolicy())) {
            if (this.getOrderType().equals("SO")) {
                Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_CreateDerivativeDocPolicy")};
                String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
                this.log.saveError("Error", msg);
                return false;
            }
            if (!this.checkCreateBaseDocLineInfo(newRecord)) {
                return false;
            }
            this.setNullCreateDerivativeInOutInfo();
            this.setNullCreateDerivativeInvoiceInfo();
        } else if (this.getJP_CreateDerivativeDocPolicy().equals("MA")) {
            if (!this.checkCreateBaseDocLineInfo(newRecord)) {
                return false;
            }
            this.setNullCreateDerivativeInOutInfo();
            this.setNullCreateDerivativeInvoiceInfo();
        } else if (this.getJP_CreateDerivativeDocPolicy().equals("BT")) {
            this.setNullCreateBaseDocLineInfo();
            if (!this.checkCreateDerivativeInOutInfo(newRecord)) {
                return false;
            }
            if (!this.checkCreateDerivativeInvoiceInfo(newRecord)) {
                return false;
            }
            if (!(this.getJP_DerivativeDocPolicy_InOut().equals("LP") && this.getJP_DerivativeDocPolicy_Inv().equals("LP") || this.getJP_DerivativeDocPolicy_InOut().equals("LP") && this.getJP_DerivativeDocPolicy_Inv().equals("PB") || this.getJP_DerivativeDocPolicy_InOut().equals("PB") && this.getJP_DerivativeDocPolicy_Inv().equals("LP") || this.getJP_DerivativeDocPolicy_InOut().equals("PB") && this.getJP_DerivativeDocPolicy_Inv().equals("PB") || this.getJP_DerivativeDocPolicy_InOut().equals("PS") && this.getJP_DerivativeDocPolicy_Inv().equals("PS") || this.getJP_DerivativeDocPolicy_InOut().equals("PE") && this.getJP_DerivativeDocPolicy_Inv().equals("PE") || this.getJP_DerivativeDocPolicy_InOut().equals("DD") && this.getJP_DerivativeDocPolicy_Inv().equals("DD"))) {
                this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_InOut"), Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_Inv")}));
                return false;
            }
        } else if (this.getJP_CreateDerivativeDocPolicy().equals("IO")) {
            this.setNullCreateBaseDocLineInfo();
            if (!this.checkCreateDerivativeInOutInfo(newRecord)) {
                return false;
            }
            this.setNullCreateDerivativeInvoiceInfo();
        } else if (this.getJP_CreateDerivativeDocPolicy().equals("IV")) {
            this.setNullCreateBaseDocLineInfo();
            this.setNullCreateDerivativeInOutInfo();
            if (!this.checkCreateDerivativeInvoiceInfo(newRecord)) {
                return false;
            }
        } else {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractDerivativeDocPolicy_ID")};
            String msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_InCaseOfPeriodContract")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs);
            this.log.saveError("Error", msg);
            return false;
        }
        return true;
    }

    private void setNullCreateBaseDocLineInfo() {
        this.setJP_BaseDocLinePolicy(null);
        this.setJP_ProcPeriodOffs_Lump(0);
        this.setJP_ProcPeriodOffs_Start(0);
        this.setJP_ProcPeriodOffs_End(0);
    }

    private void setNullCreateDerivativeInOutInfo() {
        this.setJP_DerivativeDocPolicy_InOut(null);
        this.setJP_ContractCalRef_InOut_ID(0);
        this.setJP_ContractProcRef_InOut_ID(0);
        this.setJP_ProcPeriodOffs_Lump_InOut(0);
        this.setJP_ProcPeriodOffs_Start_InOut(0);
        this.setJP_ProcPeriodOffs_End_InOut(0);
    }

    private void setNullCreateDerivativeInvoiceInfo() {
        this.setJP_DerivativeDocPolicy_Inv(null);
        this.setJP_ContractCalRef_Inv_ID(0);
        this.setJP_ContractProcRef_Inv_ID(0);
        this.setJP_ProcPeriodOffs_Lump_Inv(0);
        this.setJP_ProcPeriodOffs_Start_Inv(0);
        this.setJP_ProcPeriodOffs_End_Inv(0);
    }

    private boolean checkCreateBaseDocLineInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_BaseDocLinePolicy())) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_BaseDocLinePolicy")}));
            return false;
        }
        if (this.getJP_BaseDocLinePolicy().equals("LP")) {
            this.setJP_ProcPeriodOffs_Start(0);
            this.setJP_ProcPeriodOffs_End(0);
        } else if (this.getJP_BaseDocLinePolicy().equals("PS")) {
            this.setJP_ProcPeriodOffs_Lump(0);
            this.setJP_ProcPeriodOffs_End(0);
        } else if (this.getJP_BaseDocLinePolicy().equals("PE")) {
            this.setJP_ProcPeriodOffs_Lump(0);
            this.setJP_ProcPeriodOffs_Start(0);
        } else if (this.getJP_BaseDocLinePolicy().equals("PB")) {
            this.setJP_ProcPeriodOffs_Lump(0);
            if (this.getJP_ProcPeriodOffs_Start() > this.getJP_ProcPeriodOffs_End()) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriodOffs_Start") + " > " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriodOffs_End"));
                return false;
            }
        } else if (this.getJP_BaseDocLinePolicy().equals("DD")) {
            this.setJP_ProcPeriodOffs_Lump(0);
            this.setJP_ProcPeriodOffs_Start(0);
            this.setJP_ProcPeriodOffs_End(0);
        }
        return true;
    }

    private boolean checkCreateDerivativeInOutInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_DerivativeDocPolicy_InOut())) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_InOut")}));
            return false;
        }
        if (this.getJP_ContractCalRef_InOut_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalRef_InOut_ID")}));
            return false;
        }
        if (this.getJP_ContractProcRef_InOut_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcRef_InOut_ID")}));
            return false;
        }
        if (this.getMovementQty().signum() != 0 && this.getQtyOrdered().signum() != this.getMovementQty().signum()) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        if (this.getMovementQty().abs().compareTo(this.getQtyOrdered().abs()) > 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"MovementQty"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        if (this.getJP_DerivativeDocPolicy_InOut().equals("LP")) {
            this.setJP_ProcPeriodOffs_Start_InOut(0);
            this.setJP_ProcPeriodOffs_End_InOut(0);
        } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PS")) {
            this.setJP_ProcPeriodOffs_Lump_InOut(0);
            this.setJP_ProcPeriodOffs_End_InOut(0);
        } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PE")) {
            this.setJP_ProcPeriodOffs_Lump_InOut(0);
            this.setJP_ProcPeriodOffs_Start_InOut(0);
        } else if (this.getJP_DerivativeDocPolicy_InOut().equals("PB")) {
            this.setJP_ProcPeriodOffs_Lump_InOut(0);
            if (this.getJP_ProcPeriodOffs_Start_InOut() > this.getJP_ProcPeriodOffs_End_InOut()) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriodOffs_Start_InOut") + " > " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriodOffs_End_InOut"));
                return false;
            }
        } else {
            this.setJP_ProcPeriodOffs_Lump_InOut(0);
            this.setJP_ProcPeriodOffs_Start_InOut(0);
            this.setJP_ProcPeriodOffs_End_InOut(0);
        }
        return true;
    }

    private boolean checkCreateDerivativeInvoiceInfo(boolean newRecord) {
        if (Util.isEmpty((String)this.getJP_DerivativeDocPolicy_Inv())) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_DerivativeDocPolicy_In\uff56")}));
            return false;
        }
        if (this.getJP_ContractCalRef_Inv_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractCalRef_Inv_ID")}));
            return false;
        }
        if (this.getJP_ContractProcRef_Inv_ID() == 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"JP_ContractProcRef_Inv_ID")}));
            return false;
        }
        if (this.getQtyOrdered().signum() != 0 && this.getQtyOrdered().signum() != this.getQtyInvoiced().signum()) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        if (this.getQtyInvoiced().abs().compareTo(this.getQtyOrdered().abs()) > 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"JP_Inconsistency", (Object[])new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"QtyInvoiced"), Msg.getElement((Properties)Env.getCtx(), (String)"QtyOrdered")}));
            return false;
        }
        if (this.getJP_DerivativeDocPolicy_Inv().equals("LP")) {
            this.setJP_ProcPeriodOffs_Start_Inv(0);
            this.setJP_ProcPeriodOffs_End_Inv(0);
        } else if (this.getJP_DerivativeDocPolicy_Inv().equals("PS")) {
            this.setJP_ProcPeriodOffs_Lump_Inv(0);
            this.setJP_ProcPeriodOffs_End_Inv(0);
        } else if (this.getJP_DerivativeDocPolicy_Inv().equals("PE")) {
            this.setJP_ProcPeriodOffs_Lump_Inv(0);
            this.setJP_ProcPeriodOffs_Start_Inv(0);
        } else if (this.getJP_DerivativeDocPolicy_Inv().equals("PB")) {
            this.setJP_ProcPeriodOffs_Lump_Inv(0);
            if (this.getJP_ProcPeriodOffs_Start_Inv() > this.getJP_ProcPeriodOffs_End_Inv()) {
                this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriodOffs_Start_Inv") + " > " + Msg.getElement((Properties)Env.getCtx(), (String)"JP_ProcPeriodOffs_End_Inv"));
                return false;
            }
        } else {
            this.setJP_ProcPeriodOffs_Lump_Inv(0);
            this.setJP_ProcPeriodOffs_Start_Inv(0);
            this.setJP_ProcPeriodOffs_End_Inv(0);
        }
        return true;
    }
}

