/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Properties;
import jpiere.base.plugin.org.adempiere.model.X_JP_ContractCancelTerm;
import org.compiere.util.CCache;
import org.compiere.util.Msg;

public class MContractCancelTerm
extends X_JP_ContractCancelTerm {
    private static CCache<Integer, MContractCancelTerm> s_cache = new CCache("JP_ContractCancelTerm", 20);

    public MContractCancelTerm(Properties ctx, int JP_ContractCancelTerm_ID, String trxName) {
        super(ctx, JP_ContractCancelTerm_ID, trxName);
    }

    public MContractCancelTerm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || this.is_ValueChanged("JP_Day") || this.is_ValueChanged("IsDueFixed")) && this.isDueFixed() && (this.getJP_Day() > 31 || this.getJP_Day() <= 0)) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Day"));
            return false;
        }
        return true;
    }

    public static MContractCancelTerm get(Properties ctx, int JP_ContractCancelTerm_ID) {
        Integer ii = new Integer(JP_ContractCancelTerm_ID);
        MContractCancelTerm retValue = (MContractCancelTerm)s_cache.get((Object)ii);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MContractCancelTerm(ctx, JP_ContractCancelTerm_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)JP_ContractCancelTerm_ID, (Object)retValue);
        }
        return retValue;
    }

    public Timestamp calculateCancelDeadLine(Timestamp JP_ContractPeriodDate_To) {
        return this.calculateCancelDeadLine(JP_ContractPeriodDate_To.toLocalDateTime());
    }

    public Timestamp calculateCancelDeadLine(LocalDateTime JP_ContractPeriodDate_To) {
        if (this.isDueFixed()) {
            JP_ContractPeriodDate_To = JP_ContractPeriodDate_To.minusYears(this.getJP_Year()).minusMonths(this.getJP_Month());
            if (this.getJP_Day() == 31) {
                return Timestamp.valueOf(JP_ContractPeriodDate_To.plusMonths(1L).withDayOfMonth(1).minusDays(1L));
            }
            if (this.getJP_Day() == 0) {
                return Timestamp.valueOf(JP_ContractPeriodDate_To);
            }
            return Timestamp.valueOf(JP_ContractPeriodDate_To.withDayOfMonth(this.getJP_Day()));
        }
        return Timestamp.valueOf(JP_ContractPeriodDate_To.minusYears(this.getJP_Year()).minusMonths(this.getJP_Month()).minusDays(this.getJP_Day()));
    }
}

